/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.MemberStatus$Down$;
import org.apache.pekko.cluster.MemberStatus$Exiting$;
import org.apache.pekko.cluster.MemberStatus$Joining$;
import org.apache.pekko.cluster.MemberStatus$Leaving$;
import org.apache.pekko.cluster.MemberStatus$WeaklyUp$;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.Reachability$;
import org.apache.pekko.cluster.Reachability$Terminated$;
import org.apache.pekko.cluster.Reachability$Unreachable$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sbr.DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$;
import org.apache.pekko.cluster.sbr.DowningStrategy$AcquireLeaseAndDownUnreachable$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownAll$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownIndirectlyConnected$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownReachable$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownSelfQuarantinedByRemote$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownUnreachable$;
import org.apache.pekko.cluster.sbr.DowningStrategy$ReverseDownIndirectlyConnected$;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.SortedSetOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@InternalApi
public abstract class DowningStrategy {
    private final String selfDc;
    private final UniqueAddress selfUniqueAddress;
    private scala.collection.immutable.Set<UniqueAddress> _unreachable;
    private Reachability _reachability;
    private scala.collection.immutable.Set<Address> _seenBy;
    private SortedSet<Member> _allMembers;

    public DowningStrategy(String selfDc, UniqueAddress selfUniqueAddress) {
        this.selfDc = selfDc;
        this.selfUniqueAddress = selfUniqueAddress;
        this._unreachable = Predef$.MODULE$.Set().empty();
        this._reachability = Reachability$.MODULE$.empty();
        this._seenBy = Predef$.MODULE$.Set().empty();
        this._allMembers = (SortedSet)SortedSet$.MODULE$.empty(this.ordering());
    }

    public String selfDc() {
        return this.selfDc;
    }

    @InternalStableApi
    public scala.collection.immutable.Set<UniqueAddress> unreachable() {
        return this._unreachable;
    }

    public boolean unreachable(Member m) {
        return this._unreachable.apply((Object)m.uniqueAddress());
    }

    public Ordering<Member> ordering() {
        return Member$.MODULE$.ordering();
    }

    public abstract Option<String> role();

    public SortedSet<Member> joining() {
        return (SortedSet)this._allMembers.filter((Function1 & Serializable)m -> {
            MemberStatus memberStatus = m.status();
            MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
            if (memberStatus == null) {
                if (memberStatus$Joining$ == null) return true;
            } else if (memberStatus.equals(memberStatus$Joining$)) return true;
            MemberStatus memberStatus2 = m.status();
            MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
            if (memberStatus2 != null) {
                if (!memberStatus2.equals(memberStatus$WeaklyUp$)) return false;
                return true;
            }
            if (memberStatus$WeaklyUp$ == null) return true;
            return false;
        });
    }

    @InternalStableApi
    public SortedSet<Member> allMembersInDC() {
        return this._allMembers;
    }

    @InternalStableApi
    public SortedSet<Member> members() {
        return this.members(false, false);
    }

    public SortedSet<Member> members(boolean includingPossiblyUp, boolean excludingPossiblyExiting) {
        return (SortedSet)this._allMembers.filterNot((Function1 & Serializable)m -> {
            if (!includingPossiblyUp) {
                MemberStatus memberStatus = m.status();
                MemberStatus$Joining$ memberStatus$Joining$ = MemberStatus$Joining$.MODULE$;
                if (memberStatus == null) {
                    if (memberStatus$Joining$ == null) return true;
                } else if (memberStatus.equals(memberStatus$Joining$)) return true;
            }
            if (!includingPossiblyUp) {
                MemberStatus memberStatus = m.status();
                MemberStatus$WeaklyUp$ memberStatus$WeaklyUp$ = MemberStatus$WeaklyUp$.MODULE$;
                if (memberStatus == null) {
                    if (memberStatus$WeaklyUp$ == null) return true;
                } else if (memberStatus.equals(memberStatus$WeaklyUp$)) return true;
            }
            if (excludingPossiblyExiting) {
                MemberStatus memberStatus = m.status();
                MemberStatus$Leaving$ memberStatus$Leaving$ = MemberStatus$Leaving$.MODULE$;
                if (memberStatus == null) {
                    if (memberStatus$Leaving$ == null) return true;
                } else if (memberStatus.equals(memberStatus$Leaving$)) return true;
            }
            MemberStatus memberStatus = m.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (memberStatus == null) {
                if (memberStatus$Down$ == null) return true;
            } else if (memberStatus.equals(memberStatus$Down$)) return true;
            MemberStatus memberStatus2 = m.status();
            MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
            if (memberStatus2 != null) {
                if (!memberStatus2.equals(memberStatus$Exiting$)) return false;
                return true;
            }
            if (memberStatus$Exiting$ == null) return true;
            return false;
        });
    }

    public SortedSet<Member> membersWithRole() {
        return this.membersWithRole(false, false);
    }

    public SortedSet<Member> membersWithRole(boolean includingPossiblyUp, boolean excludingPossiblyExiting) {
        Option<String> option = this.role();
        if (None$.MODULE$.equals(option)) {
            return this.members(includingPossiblyUp, excludingPossiblyExiting);
        }
        if (option instanceof Some) {
            String r = (String)((Some)option).value();
            return (SortedSet)this.members(includingPossiblyUp, excludingPossiblyExiting).filter((Function1 & Serializable)_$1 -> _$1.hasRole(r));
        }
        throw new MatchError(option);
    }

    public SortedSet<Member> reachableMembers() {
        return this.reachableMembers(false, false);
    }

    public SortedSet<Member> reachableMembers(boolean includingPossiblyUp, boolean excludingPossiblyExiting) {
        SortedSet<Member> mbrs = this.members(includingPossiblyUp, excludingPossiblyExiting);
        if (this.unreachable().isEmpty()) {
            return mbrs;
        }
        return (SortedSet)mbrs.filter((Function1 & Serializable)m -> !this.unreachable((Member)m));
    }

    public SortedSet<Member> reachableMembersWithRole() {
        return this.reachableMembersWithRole(false, false);
    }

    public SortedSet<Member> reachableMembersWithRole(boolean includingPossiblyUp, boolean excludingPossiblyExiting) {
        Option<String> option = this.role();
        if (None$.MODULE$.equals(option)) {
            return this.reachableMembers(includingPossiblyUp, excludingPossiblyExiting);
        }
        if (option instanceof Some) {
            String r = (String)((Some)option).value();
            return (SortedSet)this.reachableMembers(includingPossiblyUp, excludingPossiblyExiting).filter((Function1 & Serializable)_$2 -> _$2.hasRole(r));
        }
        throw new MatchError(option);
    }

    public SortedSet<Member> unreachableMembers() {
        return this.unreachableMembers(false, false);
    }

    public SortedSet<Member> unreachableMembers(boolean includingPossiblyUp, boolean excludingPossiblyExiting) {
        if (this.unreachable().isEmpty()) {
            return (SortedSet)SortedSet$.MODULE$.empty(Member$.MODULE$.ordering());
        }
        return (SortedSet)this.members(includingPossiblyUp, excludingPossiblyExiting).filter((Function1 & Serializable)m -> this.unreachable((Member)m));
    }

    public SortedSet<Member> unreachableMembersWithRole() {
        return this.unreachableMembersWithRole(false, false);
    }

    public SortedSet<Member> unreachableMembersWithRole(boolean includingPossiblyUp, boolean excludingPossiblyExiting) {
        Option<String> option = this.role();
        if (None$.MODULE$.equals(option)) {
            return this.unreachableMembers(includingPossiblyUp, excludingPossiblyExiting);
        }
        if (option instanceof Some) {
            String r = (String)((Some)option).value();
            return (SortedSet)this.unreachableMembers(includingPossiblyUp, excludingPossiblyExiting).filter((Function1 & Serializable)_$3 -> _$3.hasRole(r));
        }
        throw new MatchError(option);
    }

    public void addUnreachable(Member m) {
        String string = m.dataCenter();
        String string2 = this.selfDc();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
        this.add(m);
        this._unreachable = (scala.collection.immutable.Set)this._unreachable.$plus((Object)m.uniqueAddress());
    }

    public void addReachable(Member m) {
        String string = m.dataCenter();
        String string2 = this.selfDc();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
        this.add(m);
        this._unreachable = (scala.collection.immutable.Set)this._unreachable.$minus((Object)m.uniqueAddress());
    }

    public void add(Member m) {
        String string = m.dataCenter();
        String string2 = this.selfDc();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
        this.removeFromAllMembers(m);
        this._allMembers = (SortedSet)this._allMembers.$plus((Object)m);
    }

    public void remove(Member m) {
        String string = m.dataCenter();
        String string2 = this.selfDc();
        Predef$.MODULE$.require(!(string != null ? !string.equals(string2) : string2 != null));
        this.removeFromAllMembers(m);
        this._unreachable = (scala.collection.immutable.Set)this._unreachable.$minus((Object)m.uniqueAddress());
    }

    private void removeFromAllMembers(Member m) {
        if (this.ordering() == Member$.MODULE$.ordering()) {
            this._allMembers = (SortedSet)this._allMembers.$minus((Object)m);
            return;
        }
        this._allMembers = (SortedSet)this._allMembers.filterNot((Function1 & Serializable)_$4 -> {
            UniqueAddress uniqueAddress = _$4.uniqueAddress();
            UniqueAddress uniqueAddress2 = m.uniqueAddress();
            return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
        });
    }

    @InternalStableApi
    public Reachability reachability() {
        return this._reachability;
    }

    private boolean isInSelfDc(UniqueAddress node) {
        return this._allMembers.exists((Function1 & Serializable)m -> {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = node;
            if (uniqueAddress == null) {
                if (uniqueAddress2 != null) {
                    return false;
                }
            } else if (!((Object)uniqueAddress).equals(uniqueAddress2)) return false;
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (string == null) {
                if (string2 == null) return true;
                return false;
            } else {
                if (!string.equals(string2)) return false;
                return true;
            }
        });
    }

    public void setReachability(Reachability r) {
        this._reachability = r.filterRecords((Function1<Reachability.Record, Object>)(Function1 & Serializable)record -> {
            Reachability.ReachabilityStatus reachabilityStatus = record.status();
            Reachability$Unreachable$ reachability$Unreachable$ = Reachability$Unreachable$.MODULE$;
            if (reachabilityStatus == null ? reachability$Unreachable$ != null : !reachabilityStatus.equals(reachability$Unreachable$)) {
                Reachability.ReachabilityStatus reachabilityStatus2 = record.status();
                Reachability$Terminated$ reachability$Terminated$ = Reachability$Terminated$.MODULE$;
                if (reachabilityStatus2 == null) {
                    if (reachability$Terminated$ != null) {
                        return false;
                    }
                } else if (!reachabilityStatus2.equals(reachability$Terminated$)) return false;
            }
            if (!this.isInSelfDc(record.observer())) return false;
            if (!this.isInSelfDc(record.subject())) return false;
            return true;
        });
    }

    public scala.collection.immutable.Set<Address> seenBy() {
        return this._seenBy;
    }

    public void setSeenBy(scala.collection.immutable.Set<Address> s) {
        this._seenBy = s;
    }

    public scala.collection.immutable.Set<UniqueAddress> indirectlyConnected() {
        return (scala.collection.immutable.Set)this.indirectlyConnectedFromIntersectionOfObserversAndSubjects().union(this.indirectlyConnectedFromSeenCurrentGossip());
    }

    private scala.collection.immutable.Set<UniqueAddress> indirectlyConnectedFromIntersectionOfObserversAndSubjects() {
        scala.collection.immutable.Set<UniqueAddress> observers = this.reachability().allObservers();
        return (scala.collection.immutable.Set)observers.intersect(this.reachability().allUnreachableOrTerminated());
    }

    private scala.collection.immutable.Set<UniqueAddress> indirectlyConnectedFromSeenCurrentGossip() {
        return ((IterableOnceOps)this.reachability().records().flatMap((Function1 & Serializable)r -> {
            if (this.seenBy().apply((Object)r.subject().address())) {
                return package$.MODULE$.Nil().$colon$colon((Object)r.subject()).$colon$colon((Object)r.observer());
            }
            return package$.MODULE$.Nil();
        })).toSet();
    }

    public boolean hasIndirectlyConnected() {
        return this.indirectlyConnected().nonEmpty();
    }

    public scala.collection.immutable.Set<UniqueAddress> unreachableButNotIndirectlyConnected() {
        return (scala.collection.immutable.Set)this.unreachable().diff(this.indirectlyConnected());
    }

    public scala.collection.immutable.Set<UniqueAddress> nodesToDown(Decision decision) {
        Decision decision2;
        SortedSet downable;
        block14: {
            block13: {
                block12: {
                    block11: {
                        downable = (SortedSet)((SortedSetOps)((SetOps)this.members().filterNot((Function1 & Serializable)m -> {
                            MemberStatus memberStatus = m.status();
                            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
                            if (memberStatus == null) {
                                if (memberStatus$Down$ == null) return true;
                            } else if (memberStatus.equals(memberStatus$Down$)) return true;
                            MemberStatus memberStatus2 = m.status();
                            MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
                            if (memberStatus2 != null) {
                                if (!memberStatus2.equals(memberStatus$Exiting$)) return false;
                                return true;
                            }
                            if (memberStatus$Exiting$ == null) return true;
                            return false;
                        })).union(this.joining())).map((Function1 & Serializable)_$5 -> _$5.uniqueAddress(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                        decision2 = decision;
                        if (DowningStrategy$DownUnreachable$.MODULE$.equals(decision2)) break block11;
                        if (!(decision2 instanceof AcquireLeaseAndDownUnreachable)) break block12;
                        AcquireLeaseAndDownUnreachable acquireLeaseAndDownUnreachable = DowningStrategy$AcquireLeaseAndDownUnreachable$.MODULE$.unapply((AcquireLeaseAndDownUnreachable)decision2);
                        FiniteDuration finiteDuration = acquireLeaseAndDownUnreachable._1();
                    }
                    return (scala.collection.immutable.Set)downable.intersect(this.unreachable());
                }
                if (DowningStrategy$DownReachable$.MODULE$.equals(decision2)) {
                    return (scala.collection.immutable.Set)downable.diff(this.unreachable());
                }
                if (DowningStrategy$DownAll$.MODULE$.equals(decision2)) {
                    return downable;
                }
                if (DowningStrategy$DownIndirectlyConnected$.MODULE$.equals(decision2)) break block13;
                if (!(decision2 instanceof AcquireLeaseAndDownIndirectlyConnected)) break block14;
                AcquireLeaseAndDownIndirectlyConnected acquireLeaseAndDownIndirectlyConnected = DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$.MODULE$.unapply((AcquireLeaseAndDownIndirectlyConnected)decision2);
                FiniteDuration finiteDuration = acquireLeaseAndDownIndirectlyConnected._1();
            }
            return (scala.collection.immutable.Set)downable.intersect((Set)this.indirectlyConnected().union(this.additionalNodesToDownWhenIndirectlyConnected((scala.collection.immutable.Set<UniqueAddress>)downable)));
        }
        if (DowningStrategy$ReverseDownIndirectlyConnected$.MODULE$.equals(decision2)) {
            return (scala.collection.immutable.Set)downable.intersect(this.indirectlyConnected()).union((Set)downable.diff(this.unreachable()));
        }
        if (DowningStrategy$DownSelfQuarantinedByRemote$.MODULE$.equals(decision2)) {
            if (downable.contains((Object)this.selfUniqueAddress)) {
                return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.selfUniqueAddress}));
            }
            return Predef$.MODULE$.Set().empty();
        }
        throw new MatchError((Object)decision2);
    }

    public Decision nodesToDown$default$1() {
        return this.decide();
    }

    private scala.collection.immutable.Set<UniqueAddress> additionalNodesToDownWhenIndirectlyConnected(scala.collection.immutable.Set<UniqueAddress> downable) {
        scala.collection.immutable.Set<UniqueAddress> set;
        if (this.unreachableButNotIndirectlyConnected().isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        scala.collection.immutable.Set<UniqueAddress> originalUnreachable = this._unreachable;
        Reachability originalReachability = this._reachability;
        try {
            scala.collection.immutable.Set<UniqueAddress> intersectionOfObserversAndSubjects = this.indirectlyConnectedFromIntersectionOfObserversAndSubjects();
            scala.collection.immutable.Set<UniqueAddress> haveSeenCurrentGossip = this.indirectlyConnectedFromSeenCurrentGossip();
            this._reachability = this.reachability().filterRecords((Function1<Reachability.Record, Object>)(Function1 & Serializable)r -> !(!downable.contains((Object)r.observer()) || !downable.contains((Object)r.subject()) || intersectionOfObserversAndSubjects.apply((Object)r.observer()) && intersectionOfObserversAndSubjects.apply((Object)r.subject()) || haveSeenCurrentGossip.apply((Object)r.observer()) && haveSeenCurrentGossip.apply((Object)r.subject())));
            this._unreachable = this.reachability().allUnreachableOrTerminated();
            Decision additionalDecision = this.decide();
            if (additionalDecision.isIndirectlyConnected()) {
                throw new IllegalStateException(new StringBuilder(43).append("SBR double ").append(additionalDecision).append(" decision, downing all instead. ").append(new StringBuilder(52).append("originalReachability: [").append(originalReachability).append("], filtered reachability [").append(this.reachability()).append("], ").toString()).append(new StringBuilder(41).append("still indirectlyConnected: [").append(this.indirectlyConnected()).append("], seenBy: [").append(this.seenBy()).append("]").toString()).toString());
            }
            set = this.nodesToDown(additionalDecision);
        }
        finally {
            this._unreachable = originalUnreachable;
            this._reachability = originalReachability;
        }
        return set;
    }

    public boolean isAllUnreachableDownOrExiting() {
        return this._unreachable.isEmpty() || this.unreachableMembers().forall((Function1 & Serializable)m -> {
            MemberStatus memberStatus = m.status();
            MemberStatus$Down$ memberStatus$Down$ = MemberStatus$Down$.MODULE$;
            if (memberStatus == null) {
                if (memberStatus$Down$ == null) return true;
            } else if (memberStatus.equals(memberStatus$Down$)) return true;
            MemberStatus memberStatus2 = m.status();
            MemberStatus$Exiting$ memberStatus$Exiting$ = MemberStatus$Exiting$.MODULE$;
            if (memberStatus2 != null) {
                if (!memberStatus2.equals(memberStatus$Exiting$)) return false;
                return true;
            }
            if (memberStatus$Exiting$ == null) return true;
            return false;
        });
    }

    public Decision reverseDecision(AcquireLeaseDecision decision) {
        Mirror.Singleton singleton;
        AcquireLeaseDecision acquireLeaseDecision = decision;
        if (acquireLeaseDecision instanceof AcquireLeaseAndDownUnreachable) {
            AcquireLeaseAndDownUnreachable acquireLeaseAndDownUnreachable = DowningStrategy$AcquireLeaseAndDownUnreachable$.MODULE$.unapply((AcquireLeaseAndDownUnreachable)acquireLeaseDecision);
            FiniteDuration finiteDuration = acquireLeaseAndDownUnreachable._1();
            singleton = DowningStrategy$DownReachable$.MODULE$;
        } else if (acquireLeaseDecision instanceof AcquireLeaseAndDownIndirectlyConnected) {
            AcquireLeaseAndDownIndirectlyConnected acquireLeaseAndDownIndirectlyConnected = DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$.MODULE$.unapply((AcquireLeaseAndDownIndirectlyConnected)acquireLeaseDecision);
            FiniteDuration finiteDuration = acquireLeaseAndDownIndirectlyConnected._1();
            singleton = DowningStrategy$ReverseDownIndirectlyConnected$.MODULE$;
        } else {
            throw new MatchError((Object)acquireLeaseDecision);
        }
        return singleton;
    }

    public abstract Decision decide();

    public Option<Lease> lease() {
        return None$.MODULE$;
    }

    public static final class AcquireLeaseAndDownIndirectlyConnected
    implements AcquireLeaseDecision,
    Product,
    Serializable {
        private final FiniteDuration acquireDelay;

        public static AcquireLeaseAndDownIndirectlyConnected apply(FiniteDuration finiteDuration) {
            return DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$.MODULE$.apply(finiteDuration);
        }

        public static AcquireLeaseAndDownIndirectlyConnected fromProduct(Product product) {
            return DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$.MODULE$.fromProduct(product);
        }

        public static AcquireLeaseAndDownIndirectlyConnected unapply(AcquireLeaseAndDownIndirectlyConnected acquireLeaseAndDownIndirectlyConnected) {
            return DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$.MODULE$.unapply(acquireLeaseAndDownIndirectlyConnected);
        }

        public AcquireLeaseAndDownIndirectlyConnected(FiniteDuration acquireDelay) {
            this.acquireDelay = acquireDelay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AcquireLeaseAndDownIndirectlyConnected)) return false;
            AcquireLeaseAndDownIndirectlyConnected acquireLeaseAndDownIndirectlyConnected = (AcquireLeaseAndDownIndirectlyConnected)object;
            FiniteDuration finiteDuration = this.acquireDelay();
            FiniteDuration finiteDuration2 = acquireLeaseAndDownIndirectlyConnected.acquireDelay();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AcquireLeaseAndDownIndirectlyConnected;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AcquireLeaseAndDownIndirectlyConnected";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "acquireDelay";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration acquireDelay() {
            return this.acquireDelay;
        }

        @Override
        public boolean isIndirectlyConnected() {
            return true;
        }

        public AcquireLeaseAndDownIndirectlyConnected copy(FiniteDuration acquireDelay) {
            return new AcquireLeaseAndDownIndirectlyConnected(acquireDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.acquireDelay();
        }

        public FiniteDuration _1() {
            return this.acquireDelay();
        }
    }

    public static final class AcquireLeaseAndDownUnreachable
    implements AcquireLeaseDecision,
    Product,
    Serializable {
        private final FiniteDuration acquireDelay;

        public static AcquireLeaseAndDownUnreachable apply(FiniteDuration finiteDuration) {
            return DowningStrategy$AcquireLeaseAndDownUnreachable$.MODULE$.apply(finiteDuration);
        }

        public static AcquireLeaseAndDownUnreachable fromProduct(Product product) {
            return DowningStrategy$AcquireLeaseAndDownUnreachable$.MODULE$.fromProduct(product);
        }

        public static AcquireLeaseAndDownUnreachable unapply(AcquireLeaseAndDownUnreachable acquireLeaseAndDownUnreachable) {
            return DowningStrategy$AcquireLeaseAndDownUnreachable$.MODULE$.unapply(acquireLeaseAndDownUnreachable);
        }

        public AcquireLeaseAndDownUnreachable(FiniteDuration acquireDelay) {
            this.acquireDelay = acquireDelay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AcquireLeaseAndDownUnreachable)) return false;
            AcquireLeaseAndDownUnreachable acquireLeaseAndDownUnreachable = (AcquireLeaseAndDownUnreachable)object;
            FiniteDuration finiteDuration = this.acquireDelay();
            FiniteDuration finiteDuration2 = acquireLeaseAndDownUnreachable.acquireDelay();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AcquireLeaseAndDownUnreachable;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "AcquireLeaseAndDownUnreachable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "acquireDelay";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration acquireDelay() {
            return this.acquireDelay;
        }

        @Override
        public boolean isIndirectlyConnected() {
            return false;
        }

        public AcquireLeaseAndDownUnreachable copy(FiniteDuration acquireDelay) {
            return new AcquireLeaseAndDownUnreachable(acquireDelay);
        }

        public FiniteDuration copy$default$1() {
            return this.acquireDelay();
        }

        public FiniteDuration _1() {
            return this.acquireDelay();
        }
    }

    public static interface AcquireLeaseDecision
    extends Decision {
        public FiniteDuration acquireDelay();
    }

    public static interface Decision {
        public boolean isIndirectlyConnected();
    }
}

