/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$;
import org.apache.pekko.cluster.sbr.DowningStrategy$AcquireLeaseAndDownUnreachable$;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.SortedSet;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class LeaseMajority
extends DowningStrategy {
    private final Option role;
    private final FiniteDuration acquireLeaseDelayForMinority;
    private final FiniteDuration releaseAfter;
    private final Option lease;

    public LeaseMajority(String selfDc, Option<String> role, Lease _lease, FiniteDuration acquireLeaseDelayForMinority, FiniteDuration releaseAfter, UniqueAddress selfUniqueAddress) {
        this.role = role;
        this.acquireLeaseDelayForMinority = acquireLeaseDelayForMinority;
        this.releaseAfter = releaseAfter;
        super(selfDc, selfUniqueAddress);
        this.lease = Some$.MODULE$.apply((Object)_lease);
    }

    private String selfDc$accessor() {
        return super.selfDc();
    }

    @Override
    public Option<String> role() {
        return this.role;
    }

    public FiniteDuration releaseAfter() {
        return this.releaseAfter;
    }

    @Override
    public Option<Lease> lease() {
        return this.lease;
    }

    @Override
    public DowningStrategy.Decision decide() {
        return (DowningStrategy.Decision)(this.hasIndirectlyConnected() ? DowningStrategy$AcquireLeaseAndDownIndirectlyConnected$.MODULE$.apply(Duration$.MODULE$.Zero()) : DowningStrategy$AcquireLeaseAndDownUnreachable$.MODULE$.apply(this.acquireLeaseDelay()));
    }

    private FiniteDuration acquireLeaseDelay() {
        if (this.isInMinority()) {
            return this.acquireLeaseDelayForMinority;
        }
        return Duration$.MODULE$.Zero();
    }

    private boolean isInMinority() {
        int membersSize;
        SortedSet<Member> ms = this.membersWithRole();
        if (ms.isEmpty()) {
            return false;
        }
        int unreachableSize = this.unreachableMembersWithRole().size();
        if (unreachableSize * 2 == (membersSize = ms.size())) {
            return this.unreachable((Member)ms.head());
        }
        return unreachableSize * 2 >= membersSize;
    }
}

