/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Stash;
import org.apache.pekko.actor.StashSupport;
import org.apache.pekko.actor.TimerSchedulerImpl;
import org.apache.pekko.actor.Timers;
import org.apache.pekko.actor.UnrestrictedStash;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.ClusterEvent$LeaderChanged$;
import org.apache.pekko.cluster.ClusterEvent$MemberDowned$;
import org.apache.pekko.cluster.ClusterEvent$MemberExited$;
import org.apache.pekko.cluster.ClusterEvent$MemberJoined$;
import org.apache.pekko.cluster.ClusterEvent$MemberLeft$;
import org.apache.pekko.cluster.ClusterEvent$MemberRemoved$;
import org.apache.pekko.cluster.ClusterEvent$MemberUp$;
import org.apache.pekko.cluster.ClusterEvent$MemberWeaklyUp$;
import org.apache.pekko.cluster.ClusterEvent$ReachabilityChanged$;
import org.apache.pekko.cluster.ClusterEvent$ReachableDataCenter$;
import org.apache.pekko.cluster.ClusterEvent$ReachableMember$;
import org.apache.pekko.cluster.ClusterEvent$SeenChanged$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableDataCenter$;
import org.apache.pekko.cluster.ClusterEvent$UnreachableMember$;
import org.apache.pekko.cluster.ClusterLogMarker$;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.Reachability;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.UniqueAddress$;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownAll$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownSelfQuarantinedByRemote$;
import org.apache.pekko.cluster.sbr.LeaseMajority;
import org.apache.pekko.cluster.sbr.SplitBrainResolver;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$AcquireLease$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$AcquireLeaseResult$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReachabilityChangedStats$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReleaseLeaseCondition$NoLease$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReleaseLeaseCondition$WhenMembersRemoved$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReleaseLeaseCondition$WhenTimeElapsed$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$ReleaseLeaseResult$;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$Tick$;
import org.apache.pekko.cluster.sbr.SplitBrainResolverSettings;
import org.apache.pekko.cluster.sbr.StaticQuorum;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.event.DiagnosticMarkerBusLoggingAdapter;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.remote.artery.ThisActorSystemQuarantinedEvent;
import org.apache.pekko.remote.artery.ThisActorSystemQuarantinedEvent$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

@InternalApi
public abstract class SplitBrainResolverBase
implements Actor,
StashSupport,
UnrestrictedStash,
Stash,
Timers {
    private ActorContext context;
    private ActorRef self;
    private Vector org$apache$pekko$actor$StashSupport$$theStash;
    private int org$apache$pekko$actor$StashSupport$$capacity;
    private DequeBasedMessageQueueSemantics mailbox;
    private TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers;
    private final FiniteDuration stableAfter;
    private final DowningStrategy _strategy;
    private final DiagnosticMarkerBusLoggingAdapter log;
    private final SplitBrainResolverSettings settings;
    private boolean leader;
    private boolean selfMemberAdded;
    private Deadline stableDeadline;
    private SplitBrainResolver.ReachabilityChangedStats reachabilityChangedStats;
    public SplitBrainResolver.ReleaseLeaseCondition org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
    private Set<String> unreachableDataCenters;

    public SplitBrainResolverBase(FiniteDuration stableAfter, DowningStrategy _strategy) {
        this.stableAfter = stableAfter;
        this._strategy = _strategy;
        Actor.$init$((Actor)this);
        StashSupport.$init$((StashSupport)this);
        Timers.$init$((Timers)this);
        this.log = Logging$.MODULE$.withMarker((Actor)this);
        this.settings = new SplitBrainResolverSettings(this.context().system().settings().config());
        this.timers().startTimerWithFixedDelay((Object)SplitBrainResolver$Tick$.MODULE$, (Object)SplitBrainResolver$Tick$.MODULE$, this.tickInterval());
        this.leader = false;
        this.selfMemberAdded = false;
        this.resetStableDeadline();
        this.reachabilityChangedStats = SplitBrainResolver$ReachabilityChangedStats$.MODULE$.apply(System.nanoTime(), System.nanoTime(), 0L);
        this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
        this.unreachableDataCenters = Predef$.MODULE$.Set().empty();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public Vector org$apache$pekko$actor$StashSupport$$theStash() {
        return this.org$apache$pekko$actor$StashSupport$$theStash;
    }

    public int org$apache$pekko$actor$StashSupport$$capacity() {
        return this.org$apache$pekko$actor$StashSupport$$capacity;
    }

    public DequeBasedMessageQueueSemantics mailbox() {
        return this.mailbox;
    }

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector x$1) {
        this.org$apache$pekko$actor$StashSupport$$theStash = x$1;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int x$0) {
        this.org$apache$pekko$actor$StashSupport$$capacity = x$0;
    }

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics x$0) {
        this.mailbox = x$0;
    }

    public TimerSchedulerImpl org$apache$pekko$actor$Timers$$_timers() {
        return this.org$apache$pekko$actor$Timers$$_timers;
    }

    public void org$apache$pekko$actor$Timers$_setter_$org$apache$pekko$actor$Timers$$_timers_$eq(TimerSchedulerImpl x$0) {
        this.org$apache$pekko$actor$Timers$$_timers = x$0;
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$preRestart(Throwable reason, Option message) {
        Actor.preRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$UnrestrictedStash$$super$postStop() {
        Actor.postStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPreRestart(Throwable reason, Option message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, (Option)message);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    public /* synthetic */ void org$apache$pekko$actor$Timers$$super$aroundReceive(PartialFunction receive, Object msg) {
        Actor.aroundReceive$((Actor)this, (PartialFunction)receive, (Object)msg);
    }

    public DiagnosticMarkerBusLoggingAdapter log() {
        return this.log;
    }

    @InternalStableApi
    public DowningStrategy strategy() {
        return this._strategy;
    }

    @InternalStableApi
    public abstract UniqueAddress selfUniqueAddress();

    public abstract String selfDc();

    public abstract void down(UniqueAddress var1, DowningStrategy.Decision var2);

    public FiniteDuration downAllWhenUnstable() {
        return this.settings.DownAllWhenUnstable();
    }

    public FiniteDuration org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseAfter() {
        DowningStrategy downingStrategy = this.strategy();
        if (downingStrategy instanceof LeaseMajority) {
            LeaseMajority lm = (LeaseMajority)downingStrategy;
            return lm.releaseAfter();
        }
        DowningStrategy other = downingStrategy;
        throw new IllegalStateException(new StringBuilder(51).append("Unexpected use of releaseLeaseAfter for strategy [").append(other.getClass().getName()).append("]").toString());
    }

    public FiniteDuration tickInterval() {
        return new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
    }

    public boolean leader() {
        return this.leader;
    }

    public void leader_$eq(boolean x$1) {
        this.leader = x$1;
    }

    public boolean selfMemberAdded() {
        return this.selfMemberAdded;
    }

    public void selfMemberAdded_$eq(boolean x$1) {
        this.selfMemberAdded = x$1;
    }

    private ExecutionContext internalDispatcher() {
        return ((ExtendedActorSystem)this.context().system()).dispatchers().internalDispatcher();
    }

    public Deadline newStableDeadline() {
        return Deadline$.MODULE$.now().$plus(this.stableAfter);
    }

    public Deadline stableDeadline() {
        return this.stableDeadline;
    }

    public void stableDeadline_$eq(Deadline x$1) {
        this.stableDeadline = x$1;
    }

    public void resetStableDeadline() {
        this.stableDeadline_$eq(this.newStableDeadline());
    }

    private void resetReachabilityChangedStats() {
        long now = System.nanoTime();
        this.reachabilityChangedStats = SplitBrainResolver$ReachabilityChangedStats$.MODULE$.apply(now, now, 0L);
    }

    private void resetReachabilityChangedStatsIfAllUnreachableDowned() {
        if (!this.reachabilityChangedStats.isEmpty() && this.strategy().isAllUnreachableDownOrExiting()) {
            this.log().debug("SBR resetting reachability stats, after all unreachable healed, downed or removed");
            this.resetReachabilityChangedStats();
            return;
        }
    }

    public void mutateMemberInfo(boolean resetStable, Function0<BoxedUnit> f) {
        int unreachableBefore = this.strategy().unreachable().size();
        f.apply$mcV$sp();
        int unreachableAfter = this.strategy().unreachable().size();
        if (resetStable) {
            if (this.isResponsible()) {
                if (unreachableBefore == 0 && unreachableAfter > 0) {
                    this.log().info("SBR found unreachable members, waiting for stable-after = {} ms before taking downing decision. Now {} unreachable members found. Downing decision will not be made before {}.", (Object)BoxesRunTime.boxToLong((long)this.stableAfter.toMillis()), (Object)BoxesRunTime.boxToInteger((int)unreachableAfter), (Object)this.earliestTimeOfDecision$1());
                } else if (unreachableBefore > 0 && unreachableAfter == 0) {
                    this.log().info("SBR found all unreachable members healed during stable-after period, no downing decision necessary for now.");
                } else if (unreachableAfter > 0) {
                    this.log().info("SBR found unreachable members changed during stable-after period. Resetting timer. Now {} unreachable members found. Downing decision will not be made before {}.", (Object)BoxesRunTime.boxToInteger((int)unreachableAfter), (Object)this.earliestTimeOfDecision$1());
                }
            }
            this.log().debug("SBR reset stable deadline when members/unreachable changed");
            this.resetStableDeadline();
            return;
        }
    }

    public void mutateResponsibilityInfo(Function0<BoxedUnit> f) {
        boolean responsibleBefore = this.isResponsible();
        f.apply$mcV$sp();
        boolean responsibleAfter = this.isResponsible();
        if (!responsibleBefore && responsibleAfter) {
            this.log().info("This node is now the leader responsible for taking SBR decisions among the reachable nodes (more leaders may exist).");
        } else if (responsibleBefore && !responsibleAfter) {
            this.log().info("This node is not the leader any more and not responsible for taking SBR decisions.");
        }
        if (this.leader() && !this.selfMemberAdded()) {
            this.log().debug("This node is leader but !selfMemberAdded.");
            return;
        }
    }

    public void postStop() {
        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
        SplitBrainResolver$ReleaseLeaseCondition$NoLease$ splitBrainResolver$ReleaseLeaseCondition$NoLease$ = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
        if (releaseLeaseCondition == null ? splitBrainResolver$ReleaseLeaseCondition$NoLease$ != null : !releaseLeaseCondition.equals(splitBrainResolver$ReleaseLeaseCondition$NoLease$)) {
            this.log().info("SBR is stopped and owns the lease. The lease will not be released until after the lease heartbeat-timeout.");
        }
        UnrestrictedStash.postStop$((UnrestrictedStash)this);
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ SplitBrainResolverBase $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ClusterEvent.SeenChanged) {
                    Set<Address> set;
                    ClusterEvent.SeenChanged seenChanged = ClusterEvent$SeenChanged$.MODULE$.unapply((ClusterEvent.SeenChanged)object);
                    boolean bl = seenChanged._1();
                    Set<Address> seenBy = set = seenChanged._2();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    Member member;
                    ClusterEvent.MemberJoined memberJoined = ClusterEvent$MemberJoined$.MODULE$.unapply((ClusterEvent.MemberJoined)object);
                    Member m = member = memberJoined._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    Member member;
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = ClusterEvent$MemberWeaklyUp$.MODULE$.unapply((ClusterEvent.MemberWeaklyUp)object);
                    Member m = member = memberWeaklyUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent$MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberLeft) {
                    Member member;
                    ClusterEvent.MemberLeft memberLeft = ClusterEvent$MemberLeft$.MODULE$.unapply((ClusterEvent.MemberLeft)object);
                    Member m = member = memberLeft._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    Member member;
                    ClusterEvent.MemberExited memberExited = ClusterEvent$MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)object);
                    Member m = member = memberExited._1();
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberDowned) {
                    Member member;
                    ClusterEvent.MemberDowned memberDowned = ClusterEvent$MemberDowned$.MODULE$.unapply((ClusterEvent.MemberDowned)object);
                    Member m = member = memberDowned._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ReachabilityChanged) {
                    Reachability reachability;
                    ClusterEvent.ReachabilityChanged reachabilityChanged = ClusterEvent$ReachabilityChanged$.MODULE$.unapply((ClusterEvent.ReachabilityChanged)object);
                    Reachability r = reachability = reachabilityChanged._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableDataCenter) {
                    String string;
                    ClusterEvent.UnreachableDataCenter unreachableDataCenter = ClusterEvent$UnreachableDataCenter$.MODULE$.unapply((ClusterEvent.UnreachableDataCenter)object);
                    String dc = string = unreachableDataCenter._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableDataCenter) {
                    String string;
                    ClusterEvent.ReachableDataCenter reachableDataCenter = ClusterEvent$ReachableDataCenter$.MODULE$.unapply((ClusterEvent.ReachableDataCenter)object);
                    String dc = string = reachableDataCenter._1();
                    return true;
                }
                if (object instanceof ClusterEvent.LeaderChanged) {
                    Option<Address> option;
                    ClusterEvent.LeaderChanged leaderChanged = ClusterEvent$LeaderChanged$.MODULE$.unapply((ClusterEvent.LeaderChanged)object);
                    Option<Address> leaderOption = option = leaderChanged._1();
                    return true;
                }
                if (object instanceof SplitBrainResolver.ReleaseLeaseResult) {
                    boolean bl;
                    SplitBrainResolver.ReleaseLeaseResult releaseLeaseResult = SplitBrainResolver$ReleaseLeaseResult$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseResult)object);
                    boolean released = bl = releaseLeaseResult._1();
                    return true;
                }
                if (SplitBrainResolver$Tick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ThisActorSystemQuarantinedEvent) {
                    org.apache.pekko.remote.UniqueAddress uniqueAddress;
                    ThisActorSystemQuarantinedEvent thisActorSystemQuarantinedEvent = ThisActorSystemQuarantinedEvent$.MODULE$.unapply((ThisActorSystemQuarantinedEvent)object);
                    org.apache.pekko.remote.UniqueAddress uniqueAddress2 = thisActorSystemQuarantinedEvent._1();
                    org.apache.pekko.remote.UniqueAddress remote = uniqueAddress = thisActorSystemQuarantinedEvent._2();
                    return true;
                }
                return object instanceof ClusterEvent.ClusterDomainEvent;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ClusterEvent.SeenChanged) {
                    Set<Address> set;
                    ClusterEvent.SeenChanged seenChanged = ClusterEvent$SeenChanged$.MODULE$.unapply((ClusterEvent.SeenChanged)object);
                    boolean bl = seenChanged._1();
                    Set<Address> seenBy = set = seenChanged._2();
                    this.$outer.seenChanged(seenBy);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    Member member;
                    ClusterEvent.MemberJoined memberJoined = ClusterEvent$MemberJoined$.MODULE$.unapply((ClusterEvent.MemberJoined)object);
                    Member m = member = memberJoined._1();
                    this.$outer.addJoining(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    Member member;
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = ClusterEvent$MemberWeaklyUp$.MODULE$.unapply((ClusterEvent.MemberWeaklyUp)object);
                    Member m = member = memberWeaklyUp._1();
                    this.$outer.addWeaklyUp(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent$MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    this.$outer.addUp(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberLeft) {
                    Member member;
                    ClusterEvent.MemberLeft memberLeft = ClusterEvent$MemberLeft$.MODULE$.unapply((ClusterEvent.MemberLeft)object);
                    Member m = member = memberLeft._1();
                    this.$outer.leaving(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    Member member;
                    ClusterEvent.MemberExited memberExited = ClusterEvent$MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)object);
                    Member m = member = memberExited._1();
                    this.$outer.exited(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent$UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    this.$outer.unreachableMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberDowned) {
                    Member member;
                    ClusterEvent.MemberDowned memberDowned = ClusterEvent$MemberDowned$.MODULE$.unapply((ClusterEvent.MemberDowned)object);
                    Member m = member = memberDowned._1();
                    this.$outer.unreachableMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent$ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    this.$outer.reachableMember(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ReachabilityChanged) {
                    Reachability reachability;
                    ClusterEvent.ReachabilityChanged reachabilityChanged = ClusterEvent$ReachabilityChanged$.MODULE$.unapply((ClusterEvent.ReachabilityChanged)object);
                    Reachability r = reachability = reachabilityChanged._1();
                    this.$outer.reachabilityChanged(r);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent$MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    this.$outer.remove(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.UnreachableDataCenter) {
                    String string;
                    ClusterEvent.UnreachableDataCenter unreachableDataCenter = ClusterEvent$UnreachableDataCenter$.MODULE$.unapply((ClusterEvent.UnreachableDataCenter)object);
                    String dc = string = unreachableDataCenter._1();
                    this.$outer.unreachableDataCenter(dc);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ReachableDataCenter) {
                    String string;
                    ClusterEvent.ReachableDataCenter reachableDataCenter = ClusterEvent$ReachableDataCenter$.MODULE$.unapply((ClusterEvent.ReachableDataCenter)object);
                    String dc = string = reachableDataCenter._1();
                    this.$outer.reachableDataCenter(dc);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.LeaderChanged) {
                    Option<Address> option;
                    ClusterEvent.LeaderChanged leaderChanged = ClusterEvent$LeaderChanged$.MODULE$.unapply((ClusterEvent.LeaderChanged)object);
                    Option<Address> leaderOption = option = leaderChanged._1();
                    this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$leaderChanged(leaderOption);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof SplitBrainResolver.ReleaseLeaseResult) {
                    boolean bl;
                    SplitBrainResolver.ReleaseLeaseResult releaseLeaseResult = SplitBrainResolver$ReleaseLeaseResult$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseResult)object);
                    boolean released = bl = releaseLeaseResult._1();
                    this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseResult(released);
                    return BoxedUnit.UNIT;
                }
                if (SplitBrainResolver$Tick$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$tick();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ThisActorSystemQuarantinedEvent) {
                    org.apache.pekko.remote.UniqueAddress uniqueAddress;
                    ThisActorSystemQuarantinedEvent thisActorSystemQuarantinedEvent = ThisActorSystemQuarantinedEvent$.MODULE$.unapply((ThisActorSystemQuarantinedEvent)object);
                    org.apache.pekko.remote.UniqueAddress uniqueAddress2 = thisActorSystemQuarantinedEvent._1();
                    org.apache.pekko.remote.UniqueAddress remote = uniqueAddress = thisActorSystemQuarantinedEvent._2();
                    this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$thisActorSystemWasQuarantined(remote);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ClusterDomainEvent) {
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$leaderChanged(Option<Address> leaderOption) {
        this.mutateResponsibilityInfo((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.leader_$eq(leaderOption.contains((Object)this.selfUniqueAddress().address())));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$tick() {
        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition;
        block13: {
            DowningStrategy.Decision decision;
            block14: {
                if (this.reachabilityChangedStats.changeCount() > 0L) {
                    long now = System.nanoTime();
                    FiniteDuration durationSinceLatestChange = new package.DurationLong(package$.MODULE$.DurationLong(now - this.reachabilityChangedStats.latestChangeTimestamp())).nanos();
                    FiniteDuration durationSinceFirstChange = new package.DurationLong(package$.MODULE$.DurationLong(now - this.reachabilityChangedStats.firstChangeTimestamp())).nanos();
                    boolean downAllWhenUnstableEnabled = this.downAllWhenUnstable().$greater((Object)Duration$.MODULE$.Zero());
                    if (downAllWhenUnstableEnabled && durationSinceFirstChange.$greater((Object)this.stableAfter.$plus(this.downAllWhenUnstable()))) {
                        this.log().warning(ClusterLogMarker$.MODULE$.sbrInstability(), "SBR detected instability and will down all nodes: {}", (Object)this.reachabilityChangedStats);
                        this.actOnDecision(DowningStrategy$DownAll$.MODULE$);
                    } else if (!downAllWhenUnstableEnabled && durationSinceLatestChange.$greater((Object)this.stableAfter.$times(2L))) {
                        this.log().debug("SBR no reachability changes within {} ms, resetting stats", (Object)BoxesRunTime.boxToLong((long)this.stableAfter.$times(2L).toMillis()));
                        this.resetReachabilityChangedStats();
                    }
                }
                if (!this.isResponsible() || !this.strategy().unreachable().nonEmpty() || !this.stableDeadline().isOverdue()) break block13;
                decision = this.strategy().decide();
                if (!(decision instanceof DowningStrategy.AcquireLeaseDecision)) break block14;
                DowningStrategy.AcquireLeaseDecision decision2 = (DowningStrategy.AcquireLeaseDecision)decision;
                Option<Lease> option = this.strategy().lease();
                if (option instanceof Some) {
                    Lease lease = (Lease)((Some)option).value();
                    if (lease.checkLease()) {
                        this.log().info(ClusterLogMarker$.MODULE$.sbrLeaseAcquired(decision2), "SBR has acquired lease for decision [{}]", (Object)decision2);
                        this.actOnDecision(decision2);
                        break block13;
                    } else {
                        FiniteDuration finiteDuration = decision2.acquireDelay();
                        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
                        if (!(finiteDuration != null ? !finiteDuration.equals(finiteDuration2) : finiteDuration2 != null)) {
                            this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$acquireLease();
                        } else {
                            this.log().debug("SBR delayed attempt to acquire lease for [{} ms]", (Object)BoxesRunTime.boxToLong((long)decision2.acquireDelay().toMillis()));
                            this.timers().startSingleTimer((Object)SplitBrainResolver$AcquireLease$.MODULE$, (Object)SplitBrainResolver$AcquireLease$.MODULE$, decision2.acquireDelay());
                        }
                        this.context().become(this.waitingForLease(decision2));
                    }
                    break block13;
                } else {
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException("Unexpected lease decision although lease is not configured");
                    }
                    throw new MatchError(option);
                }
            }
            DowningStrategy.Decision decision3 = decision;
            this.actOnDecision(decision3);
        }
        if (!((releaseLeaseCondition = this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition) instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed)) {
            return;
        }
        SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed whenTimeElapsed = SplitBrainResolver$ReleaseLeaseCondition$WhenTimeElapsed$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed)releaseLeaseCondition);
        Deadline deadline = whenTimeElapsed._1();
        Deadline deadline2 = deadline;
        if (deadline2.isOverdue()) {
            this.releaseLease();
            return;
        }
    }

    public void org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$thisActorSystemWasQuarantined(org.apache.pekko.remote.UniqueAddress remoteUnique) {
        UniqueAddress remote = UniqueAddress$.MODULE$.apply(remoteUnique.address(), remoteUnique.uid());
        if (((Cluster)Cluster$.MODULE$.apply(this.context().system())).state().members().exists((Function1 & Serializable)m -> {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = remote;
            return !(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null);
        })) {
            this.actOnDecision(DowningStrategy$DownSelfQuarantinedByRemote$.MODULE$);
            return;
        }
        this.log().debug("Remote [{}] quarantined this system but is not part of cluster, ignoring", (Object)remote);
    }

    public void org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$acquireLease() {
        this.log().debug("SBR trying to acquire lease");
        ExecutionContext ec = this.internalDispatcher();
        this.strategy().lease().foreach((Function1 & Serializable)_$2 -> org.apache.pekko.pattern.package$.MODULE$.pipe(_$2.acquire().recover((PartialFunction)new Serializable(this){
            private final /* synthetic */ SplitBrainResolverBase $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable t = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable t = throwable = x;
                this.$outer.log().error(t, "SBR acquire of lease failed");
                return BoxesRunTime.boxToBoolean((boolean)false);
            }
        }, ec).map((Function1 & Serializable)holdingLease -> SplitBrainResolver$AcquireLeaseResult$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)holdingLease)), ec), ec).pipeTo(this.self(), this.self()));
    }

    public PartialFunction<Object, BoxedUnit> waitingForLease(DowningStrategy.AcquireLeaseDecision decision) {
        return new Serializable(decision, this){
            private final DowningStrategy.AcquireLeaseDecision decision$1;
            private final /* synthetic */ SplitBrainResolverBase $outer;
            {
                this.decision$1 = decision$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (SplitBrainResolver$AcquireLease$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof SplitBrainResolver.AcquireLeaseResult) {
                    boolean bl;
                    SplitBrainResolver.AcquireLeaseResult acquireLeaseResult = SplitBrainResolver$AcquireLeaseResult$.MODULE$.unapply((SplitBrainResolver.AcquireLeaseResult)object);
                    boolean holdingLease = bl = acquireLeaseResult._1();
                    return true;
                }
                if (object instanceof SplitBrainResolver.ReleaseLeaseResult) {
                    SplitBrainResolver.ReleaseLeaseResult releaseLeaseResult = SplitBrainResolver$ReleaseLeaseResult$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseResult)object);
                    boolean bl = releaseLeaseResult._1();
                    return true;
                }
                if (SplitBrainResolver$Tick$.MODULE$.equals(object)) {
                    return true;
                }
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                block5: {
                    Object object;
                    block7: {
                        block6: {
                            block4: {
                                object = x;
                                if (!SplitBrainResolver$AcquireLease$.MODULE$.equals(object)) break block4;
                                this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$acquireLease();
                                break block5;
                            }
                            if (!(object instanceof SplitBrainResolver.AcquireLeaseResult)) break block6;
                            SplitBrainResolver.AcquireLeaseResult acquireLeaseResult = SplitBrainResolver$AcquireLeaseResult$.MODULE$.unapply((SplitBrainResolver.AcquireLeaseResult)object);
                            boolean bl = acquireLeaseResult._1();
                            boolean holdingLease = bl;
                            if (holdingLease) {
                                Product product;
                                this.$outer.log().info(ClusterLogMarker$.MODULE$.sbrLeaseAcquired(this.decision$1), "SBR acquired lease for decision [{}]", (Object)this.decision$1);
                                Set<UniqueAddress> downedNodes = this.$outer.actOnDecision(this.decision$1);
                                SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
                                if (releaseLeaseCondition instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved) {
                                    Set<UniqueAddress> set;
                                    SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved whenMembersRemoved = SplitBrainResolver$ReleaseLeaseCondition$WhenMembersRemoved$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved)releaseLeaseCondition);
                                    Set<UniqueAddress> nodes = set = whenMembersRemoved._1();
                                    product = SplitBrainResolver$ReleaseLeaseCondition$WhenMembersRemoved$.MODULE$.apply((Set<UniqueAddress>)((Set)nodes.union(downedNodes)));
                                } else {
                                    product = downedNodes.isEmpty() ? SplitBrainResolver$ReleaseLeaseCondition$WhenTimeElapsed$.MODULE$.apply(Deadline$.MODULE$.now().$plus(this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseAfter())) : SplitBrainResolver$ReleaseLeaseCondition$WhenMembersRemoved$.MODULE$.apply(downedNodes);
                                }
                                this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = product;
                            } else {
                                DowningStrategy.Decision reverseDecision = this.$outer.strategy().reverseDecision(this.decision$1);
                                this.$outer.log().info(ClusterLogMarker$.MODULE$.sbrLeaseDenied(reverseDecision), "SBR couldn't acquire lease, reverse decision [{}] to [{}]", (Object)this.decision$1, (Object)reverseDecision);
                                this.$outer.actOnDecision(reverseDecision);
                                this.$outer.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
                            }
                            this.$outer.unstashAll();
                            this.$outer.context().become(this.$outer.receive());
                            break block5;
                        }
                        if (!(object instanceof SplitBrainResolver.ReleaseLeaseResult)) break block7;
                        SplitBrainResolver.ReleaseLeaseResult releaseLeaseResult = SplitBrainResolver$ReleaseLeaseResult$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseResult)object);
                        boolean bl = releaseLeaseResult._1();
                        break block5;
                    }
                    if (SplitBrainResolver$Tick$.MODULE$.equals(object)) break block5;
                    this.$outer.stash();
                }
                return BoxedUnit.UNIT;
            }
        };
    }

    public void org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseResult(boolean released) {
        SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
        if (releaseLeaseCondition instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed) {
            Deadline deadline;
            SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed whenTimeElapsed = SplitBrainResolver$ReleaseLeaseCondition$WhenTimeElapsed$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseCondition.WhenTimeElapsed)releaseLeaseCondition);
            Deadline deadline2 = deadline = whenTimeElapsed._1();
            if (released && deadline2.isOverdue()) {
                this.log().info(ClusterLogMarker$.MODULE$.sbrLeaseReleased(), "SBR released lease.");
                this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
                return;
            }
            return;
        }
    }

    public Set<UniqueAddress> actOnDecision(DowningStrategy.Decision decision) {
        Set<UniqueAddress> set;
        try {
            set = this.strategy().nodesToDown(decision);
        }
        catch (IllegalStateException e) {
            this.log().warning(e.getMessage());
            set = this.strategy().nodesToDown(DowningStrategy$DownAll$.MODULE$);
        }
        Set<UniqueAddress> nodesToDown = set;
        this.observeDecision(decision, nodesToDown, this.unreachableDataCenters);
        if (nodesToDown.nonEmpty()) {
            boolean downMyself = nodesToDown.contains((Object)this.selfUniqueAddress());
            nodesToDown.foreach((Function1)(JProcedure1 & Serializable)uniqueAddress -> {
                UniqueAddress uniqueAddress2 = uniqueAddress;
                UniqueAddress uniqueAddress3 = this.selfUniqueAddress();
                if (uniqueAddress2 == null ? uniqueAddress3 != null : !((Object)uniqueAddress2).equals(uniqueAddress3)) {
                    this.down((UniqueAddress)uniqueAddress, decision);
                    return;
                }
            });
            if (downMyself) {
                this.down(this.selfUniqueAddress(), decision);
            }
            this.resetReachabilityChangedStats();
            this.resetStableDeadline();
        }
        return nodesToDown;
    }

    @InternalStableApi
    public void observeDecision(DowningStrategy.Decision decision, Set<UniqueAddress> nodesToDown, Set<String> unreachableDataCenters) {
        boolean downMyself = nodesToDown.contains((Object)this.selfUniqueAddress());
        String indirectlyConnectedLogMessage = decision.isIndirectlyConnected() ? new StringBuilder(25).append(", indirectly connected [").append(this.strategy().indirectlyConnected().mkString(", ")).append("]").toString() : "";
        String unreachableDataCentersLogMessage = unreachableDataCenters.nonEmpty() ? new StringBuilder(20).append(", unreachable DCs [").append(unreachableDataCenters.mkString(", ")).append("]").toString() : "";
        this.log().warning(ClusterLogMarker$.MODULE$.sbrDowning(decision), new StringBuilder(38).append("SBR took decision ").append(decision).append(" and is downing [").append(((IterableOnceOps)nodesToDown.map((Function1 & Serializable)_$3 -> _$3.address())).mkString(", ")).append("]").append(downMyself ? " including myself" : "").append(", ").append(new StringBuilder(28).append("[").append(this.strategy().unreachable().size()).append("] unreachable of [").append(this.strategy().members().size()).append("] members").toString()).append(indirectlyConnectedLogMessage).append(new StringBuilder(52).append(", all members in DC [").append(this.strategy().allMembersInDC().mkString(", ")).append("], full reachability status: [").append(this.strategy().reachability()).append("]").toString()).append(unreachableDataCentersLogMessage).toString());
    }

    public boolean isResponsible() {
        return this.leader() && this.selfMemberAdded();
    }

    public void unreachableMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) {
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log().debug("SBR unreachableMember [{}]", (Object)m);
                this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    this.strategy().addUnreachable(m);
                    this.updateReachabilityChangedStats();
                    this.resetReachabilityChangedStatsIfAllUnreachableDowned();
                    if (!this.reachabilityChangedStats.isEmpty()) {
                        this.log().debug("SBR noticed {}", (Object)this.reachabilityChangedStats);
                        return;
                    }
                });
                return;
            }
        }
    }

    public void reachableMember(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (uniqueAddress == null ? uniqueAddress2 != null : !((Object)uniqueAddress).equals(uniqueAddress2)) {
            String string = m.dataCenter();
            String string2 = this.selfDc();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.log().debug("SBR reachableMember [{}]", (Object)m);
                this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    this.strategy().addReachable(m);
                    this.updateReachabilityChangedStats();
                    this.resetReachabilityChangedStatsIfAllUnreachableDowned();
                    if (!this.reachabilityChangedStats.isEmpty()) {
                        this.log().debug("SBR noticed {}", (Object)this.reachabilityChangedStats);
                        return;
                    }
                });
                return;
            }
        }
    }

    public void reachabilityChanged(Reachability r) {
        this.strategy().setReachability(r);
    }

    private void updateReachabilityChangedStats() {
        long now = System.nanoTime();
        if (this.reachabilityChangedStats.changeCount() == 0L) {
            this.reachabilityChangedStats = SplitBrainResolver$ReachabilityChangedStats$.MODULE$.apply(now, now, 1L);
            return;
        }
        SplitBrainResolver.ReachabilityChangedStats reachabilityChangedStats = this.reachabilityChangedStats;
        long l = this.reachabilityChangedStats.changeCount() + 1L;
        long l2 = reachabilityChangedStats.copy$default$1();
        this.reachabilityChangedStats = reachabilityChangedStats.copy(l2, now, l);
    }

    public void unreachableDataCenter(String dc) {
        this.unreachableDataCenters = (Set)this.unreachableDataCenters.$plus((Object)dc);
        this.log().warning("Data center [{}] observed as unreachable. Note that nodes in other data center will not be downed by SBR in this data center [{}]", (Object)dc, (Object)this.selfDc());
    }

    public void reachableDataCenter(String dc) {
        this.unreachableDataCenters = (Set)this.unreachableDataCenters.$minus((Object)dc);
        this.log().info("Data center [{}] observed as reachable again", (Object)dc);
    }

    public void seenChanged(Set<Address> seenBy) {
        this.strategy().setSeenBy(seenBy);
    }

    public void addUp(Member m) {
        String string = this.selfDc();
        String string2 = m.dataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().debug("SBR add Up [{}]", (Object)m);
            this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                this.strategy().add(m);
                UniqueAddress uniqueAddress = m.uniqueAddress();
                UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
                if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                    this.mutateResponsibilityInfo((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.selfMemberAdded_$eq(true));
                    return;
                }
            });
            DowningStrategy downingStrategy = this.strategy();
            if (downingStrategy instanceof StaticQuorum) {
                StaticQuorum s = (StaticQuorum)downingStrategy;
                if (s.isTooManyMembers()) {
                    this.log().warning("The cluster size is [{}] and static-quorum.quorum-size is [{}]. You should not add more than [{}] (static-quorum.size * 2 - 1) members to the cluster. If the exceeded cluster size remains when a SBR decision is needed it will down all nodes.", (Object)BoxesRunTime.boxToInteger((int)s.membersWithRole().size()), (Object)BoxesRunTime.boxToInteger((int)s.quorumSize()), (Object)BoxesRunTime.boxToInteger((int)(s.quorumSize() * 2 - 1)));
                    return;
                }
                return;
            }
            return;
        }
    }

    public void leaving(Member m) {
        String string = this.selfDc();
        String string2 = m.dataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().debug("SBR leaving [{}]", (Object)m);
            this.mutateMemberInfo(false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.strategy().add(m));
            return;
        }
    }

    public void exited(Member m) {
        String string = this.selfDc();
        String string2 = m.dataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().debug("SBR exited [{}]", (Object)m);
            this.mutateMemberInfo(true, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.strategy().add(m));
            return;
        }
    }

    public void addJoining(Member m) {
        String string = this.selfDc();
        String string2 = m.dataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().debug("SBR add Joining/WeaklyUp [{}]", (Object)m);
            this.strategy().add(m);
            return;
        }
    }

    public void addWeaklyUp(Member m) {
        UniqueAddress uniqueAddress = m.uniqueAddress();
        UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
        if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
            this.mutateResponsibilityInfo((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.selfMemberAdded_$eq(true));
        }
        this.addJoining(m);
    }

    public void remove(Member m) {
        String string = this.selfDc();
        String string2 = m.dataCenter();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            UniqueAddress uniqueAddress = m.uniqueAddress();
            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
            if (!(uniqueAddress != null ? !((Object)uniqueAddress).equals(uniqueAddress2) : uniqueAddress2 != null)) {
                this.context().stop(this.self());
                return;
            }
            this.mutateMemberInfo(false, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                SplitBrainResolver.ReleaseLeaseCondition other;
                SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved whenMembersRemoved;
                Set<UniqueAddress> set;
                Set<UniqueAddress> downedNodes;
                Set remainingDownedNodes;
                this.log().debug("SBR remove [{}]", (Object)m);
                this.strategy().remove(m);
                this.resetReachabilityChangedStatsIfAllUnreachableDowned();
                SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
                this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition = releaseLeaseCondition instanceof SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved ? (SplitBrainResolver.ReleaseLeaseCondition)((remainingDownedNodes = (Set)(downedNodes = (set = (whenMembersRemoved = SplitBrainResolver$ReleaseLeaseCondition$WhenMembersRemoved$.MODULE$.unapply((SplitBrainResolver.ReleaseLeaseCondition.WhenMembersRemoved)releaseLeaseCondition))._1())).$minus((Object)m.uniqueAddress())).isEmpty() ? SplitBrainResolver$ReleaseLeaseCondition$WhenTimeElapsed$.MODULE$.apply(Deadline$.MODULE$.now().$plus(this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseAfter())) : SplitBrainResolver$ReleaseLeaseCondition$WhenMembersRemoved$.MODULE$.apply((Set<UniqueAddress>)remainingDownedNodes)) : (other = releaseLeaseCondition);
            });
            return;
        }
    }

    private void releaseLease() {
        ExecutionContext ec = this.internalDispatcher();
        this.strategy().lease().foreach((Function1)(JProcedure1 & Serializable)l -> {
            SplitBrainResolver.ReleaseLeaseCondition releaseLeaseCondition = this.org$apache$pekko$cluster$sbr$SplitBrainResolverBase$$releaseLeaseCondition;
            SplitBrainResolver$ReleaseLeaseCondition$NoLease$ splitBrainResolver$ReleaseLeaseCondition$NoLease$ = SplitBrainResolver$ReleaseLeaseCondition$NoLease$.MODULE$;
            if (releaseLeaseCondition == null ? splitBrainResolver$ReleaseLeaseCondition$NoLease$ != null : !releaseLeaseCondition.equals(splitBrainResolver$ReleaseLeaseCondition$NoLease$)) {
                this.log().debug("SBR releasing lease");
                org.apache.pekko.pattern.package$.MODULE$.pipe(l.release().recover((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return true;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        return BoxesRunTime.boxToBoolean((boolean)false);
                    }
                }, ec).map((Function1 & Serializable)released -> SplitBrainResolver$ReleaseLeaseResult$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)released)), ec), ec).pipeTo(this.self(), this.self());
                return;
            }
        });
    }

    private final String earliestTimeOfDecision$1() {
        return Instant.now().plus(this.stableAfter.toMillis(), ChronoUnit.MILLIS).toString();
    }
}

