/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.DowningProvider;
import org.apache.pekko.cluster.sbr.DownAllNodes;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.KeepMajority;
import org.apache.pekko.cluster.sbr.KeepOldest;
import org.apache.pekko.cluster.sbr.KeepOldestSettings;
import org.apache.pekko.cluster.sbr.LeaseMajority;
import org.apache.pekko.cluster.sbr.LeaseMajoritySettings;
import org.apache.pekko.cluster.sbr.SplitBrainResolver$;
import org.apache.pekko.cluster.sbr.SplitBrainResolverSettings;
import org.apache.pekko.cluster.sbr.StaticQuorum;
import org.apache.pekko.cluster.sbr.StaticQuorumSettings;
import org.apache.pekko.coordination.lease.scaladsl.Lease;
import org.apache.pekko.coordination.lease.scaladsl.LeaseProvider;
import org.apache.pekko.coordination.lease.scaladsl.LeaseProvider$;
import scala.MatchError;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public final class SplitBrainResolverProvider
extends DowningProvider {
    private final ActorSystem system;
    private final SplitBrainResolverSettings settings;

    public SplitBrainResolverProvider(ActorSystem system) {
        this.system = system;
        this.settings = new SplitBrainResolverSettings(system.settings().config());
    }

    @Override
    public FiniteDuration downRemovalMargin() {
        FiniteDuration drm;
        FiniteDuration finiteDuration = drm = ((Cluster)Cluster$.MODULE$.apply(this.system)).settings().DownRemovalMargin();
        FiniteDuration finiteDuration2 = Duration$.MODULE$.Zero();
        if (finiteDuration == null ? finiteDuration2 != null : !finiteDuration.equals(finiteDuration2)) {
            return drm;
        }
        return this.settings.DowningStableAfter();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<Props> downingActorProps() {
        DowningStrategy downingStrategy;
        block7: {
            Cluster cluster = (Cluster)Cluster$.MODULE$.apply(this.system);
            String selfDc = cluster.selfDataCenter();
            String string = this.settings.DowningStrategy();
            switch (string == null ? 0 : string.hashCode()) {
                case -1642658489: {
                    if (!"keep-oldest".equals(string)) break;
                    KeepOldestSettings s = this.settings.keepOldestSettings();
                    downingStrategy = new KeepOldest(selfDc, s.downIfAlone(), s.role(), cluster.selfUniqueAddress());
                    break block7;
                }
                case -1566599576: {
                    if (!"lease-majority".equals(string)) break;
                    LeaseMajoritySettings s = this.settings.leaseMajoritySettings();
                    String leaseOwnerName = cluster.selfUniqueAddress().address().hostPort();
                    String leaseName = s.safeLeaseName(this.system.name());
                    Lease lease = ((LeaseProvider)LeaseProvider$.MODULE$.apply(this.system)).getLease(leaseName, s.leaseImplementation(), leaseOwnerName);
                    downingStrategy = new LeaseMajority(selfDc, s.role(), lease, s.acquireLeaseDelayForMinority(), s.releaseAfter(), cluster.selfUniqueAddress());
                    break block7;
                }
                case -849301474: {
                    if (!"static-quorum".equals(string)) break;
                    StaticQuorumSettings s = this.settings.staticQuorumSettings();
                    downingStrategy = new StaticQuorum(selfDc, s.size(), s.role(), cluster.selfUniqueAddress());
                    break block7;
                }
                case 1425928694: {
                    if (!"down-all".equals(string)) break;
                    downingStrategy = new DownAllNodes(selfDc, cluster.selfUniqueAddress());
                    break block7;
                }
                case 1770871197: {
                    if (!"keep-majority".equals(string)) break;
                    downingStrategy = new KeepMajority(selfDc, this.settings.keepMajorityRole(), cluster.selfUniqueAddress());
                    break block7;
                }
            }
            throw new MatchError((Object)string);
        }
        DowningStrategy downingStrategy2 = downingStrategy;
        return Some$.MODULE$.apply((Object)SplitBrainResolver$.MODULE$.props(this.settings.DowningStableAfter(), downingStrategy2));
    }
}

