/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sbr;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.sbr.DowningStrategy;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownAll$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownIndirectlyConnected$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownReachable$;
import org.apache.pekko.cluster.sbr.DowningStrategy$DownUnreachable$;
import scala.Option;

@InternalApi
public final class StaticQuorum
extends DowningStrategy {
    private final int quorumSize;
    private final Option role;

    public StaticQuorum(String selfDc, int quorumSize, Option<String> role, UniqueAddress selfUniqueAddress) {
        this.quorumSize = quorumSize;
        this.role = role;
        super(selfDc, selfUniqueAddress);
    }

    private String selfDc$accessor() {
        return super.selfDc();
    }

    public int quorumSize() {
        return this.quorumSize;
    }

    @Override
    public Option<String> role() {
        return this.role;
    }

    @Override
    public DowningStrategy.Decision decide() {
        if (this.isTooManyMembers()) {
            return DowningStrategy$DownAll$.MODULE$;
        }
        if (this.hasIndirectlyConnected()) {
            return DowningStrategy$DownIndirectlyConnected$.MODULE$;
        }
        return (DowningStrategy.Decision)(this.membersWithRole().size() - this.unreachableMembersWithRole().size() >= this.quorumSize() ? DowningStrategy$DownUnreachable$.MODULE$ : DowningStrategy$DownReachable$.MODULE$);
    }

    public boolean isTooManyMembers() {
        return this.membersWithRole().size() > this.quorumSize() * 2 - 1;
    }
}

