/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery.kubernetes;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.NoSuchElementException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.discovery.kubernetes.JsonFormat$;
import org.apache.pekko.discovery.kubernetes.KubernetesApiServiceDiscovery$;
import org.apache.pekko.discovery.kubernetes.PodList;
import org.apache.pekko.discovery.kubernetes.Settings;
import org.apache.pekko.discovery.kubernetes.Settings$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpExt;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpMethod;
import org.apache.pekko.http.scaladsl.model.HttpProtocol;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpRequest$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.RequestEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Authorization;
import org.apache.pekko.http.scaladsl.model.headers.HttpCredentials;
import org.apache.pekko.http.scaladsl.model.headers.OAuth2BearerToken;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshal$;
import org.apache.pekko.http.scaladsl.unmarshalling.Unmarshaller$;
import org.apache.pekko.pki.kubernetes.PemManagersProvider$;
import org.apache.pekko.stream.Materializer$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tUq!\u0002\u000f\u001e\u0011\u0003Ac!\u0002\u0016\u001e\u0011\u0003Y\u0003\"\u0002\u001a\u0002\t\u0003\u0019\u0004B\u0002\u001b\u0002\t\u0003iRG\u0002\u0003r\u0003\u0001\u0011\b\"CA\u0005\t\t\u0005\t\u0015!\u0003U\u0011\u0019\u0011D\u0001\"\u0001\u0002\f\u0019)!&\b\u0001\u0002\u0014!Q\u0011QD\u0004\u0003\u0002\u0003\u0006Y!a\b\t\rI:A\u0011AA\u0016\u0011%\t\u0019d\u0002b\u0001\n\u0013\t)\u0004\u0003\u0005\u0002F\u001d\u0001\u000b\u0011BA\u001c\u0011%\t9e\u0002b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002R\u001d\u0001\u000b\u0011BA&\u0011%\t\u0019f\u0002b\u0001\n\u0013\t)\u0006\u0003\u0005\u0002d\u001d\u0001\u000b\u0011BA,\u0011%\t)g\u0002b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002~\u001d\u0001\u000b\u0011BA5\u0011%\tyh\u0002b\u0001\n\u0013\t\t\t\u0003\u0005\u0002\n\u001e\u0001\u000b\u0011BAB\u0011\u001d\tYi\u0002C!\u0003\u001bC\u0011\"a/\b\u0005\u0004%I!!0\t\u000f\u0005}v\u0001)A\u0005)\"A\u0001m\u0002b\u0001\n\u0013\ti\fC\u0004\u0002B\u001e\u0001\u000b\u0011\u0002+\t\u000f\u0005\rw\u0001\"\u0003\u0002F\"9\u0011qZ\u0004\u0005\n\u0005E\u0007bBA|\u000f\u0011%\u0011\u0011`\u0001\u001e\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018\t]5TKJ4\u0018nY3ESN\u001cwN^3ss*\u0011adH\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(B\u0001\u0011\"\u0003%!\u0017n]2pm\u0016\u0014\u0018P\u0003\u0002#G\u0005)\u0001/Z6l_*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0001\"!K\u0001\u000e\u0003u\u0011QdS;cKJtW\r^3t\u0003BL7+\u001a:wS\u000e,G)[:d_Z,'/_\n\u0003\u00031\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)\u0003\u001d!\u0018M]4fiN$rA\u000e&P?\u0006\u001c\u0007\u000eE\u00028yyj\u0011\u0001\u000f\u0006\u0003si\n\u0011\"[7nkR\f'\r\\3\u000b\u0005mr\u0013AC2pY2,7\r^5p]&\u0011Q\b\u000f\u0002\u0004'\u0016\f\bCA H\u001d\t\u0001UI\u0004\u0002B\t:\u0011!iQ\u0007\u0002G%\u0011!eI\u0005\u0003A\u0005J!AR\u0010\u0002!M+'O^5dK\u0012K7oY8wKJL\u0018B\u0001%J\u00059\u0011Vm]8mm\u0016$G+\u0019:hKRT!AR\u0010\t\u000b-\u001b\u0001\u0019\u0001'\u0002\u000fA|G\rT5tiB\u0011\u0011&T\u0005\u0003\u001dv\u0011q\u0001U8e\u0019&\u001cH\u000fC\u0003Q\u0007\u0001\u0007\u0011+\u0001\u0005q_J$h*Y7f!\ri#\u000bV\u0005\u0003':\u0012aa\u00149uS>t\u0007CA+]\u001d\t1&\f\u0005\u0002X]5\t\u0001L\u0003\u0002ZO\u00051AH]8pizJ!a\u0017\u0018\u0002\rA\u0013X\rZ3g\u0013\tifL\u0001\u0004TiJLgn\u001a\u0006\u00037:BQ\u0001Y\u0002A\u0002Q\u000bA\u0002]8e\u001d\u0006lWm\u001d9bG\u0016DQAY\u0002A\u0002Q\u000b\u0011\u0002]8e\t>l\u0017-\u001b8\t\u000b\u0011\u001c\u0001\u0019A3\u0002\u000bI\fw/\u00139\u0011\u000552\u0017BA4/\u0005\u001d\u0011un\u001c7fC:DQ![\u0002A\u0002E\u000bQbY8oi\u0006Lg.\u001a:OC6,\u0007FA\u0002l!\taw.D\u0001n\u0015\tq\u0017%\u0001\u0006b]:|G/\u0019;j_:L!\u0001]7\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0002\u0017\u0017V\u0014WM\u001d8fi\u0016\u001c\u0018\t]5Fq\u000e,\u0007\u000f^5p]N\u0019Aa\u001d?\u0011\u0005QLhBA;x\u001d\t9f/C\u00010\u0013\tAh&A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(\u0001\u0005*v]RLW.Z#yG\u0016\u0004H/[8o\u0015\tAh\u0006E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011aB2p]R\u0014x\u000e\u001c\u0006\u0004\u0003\u0007q\u0013\u0001B;uS2L1!a\u0002\u007f\u00051qun\u0015;bG.$&/Y2f\u0003\ri7o\u001a\u000b\u0005\u0003\u001b\t\t\u0002E\u0002\u0002\u0010\u0011i\u0011!\u0001\u0005\u0007\u0003\u00131\u0001\u0019\u0001+\u0014\u0007\u001d\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"A\u0010\n\u0007\u0005mqD\u0001\tTKJ4\u0018nY3ESN\u001cwN^3ss\u000611/_:uK6\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003K\t\u0013!B1di>\u0014\u0018\u0002BA\u0015\u0003G\u00111\"Q2u_J\u001c\u0016p\u001d;f[R\u0011\u0011Q\u0006\u000b\u0005\u0003_\t\t\u0004\u0005\u0002*\u000f!9\u0011QD\u0005A\u0004\u0005}\u0011\u0001\u00025uiB,\"!a\u000e\u0011\t\u0005e\u0012\u0011I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005A1oY1mC\u0012\u001cHNC\u0002\u00024\u0005JA!a\u0011\u0002<\t9\u0001\n\u001e;q\u000bb$\u0018!\u00025uiB\u0004\u0013\u0001C:fiRLgnZ:\u0016\u0005\u0005-\u0003cA\u0015\u0002N%\u0019\u0011qJ\u000f\u0003\u0011M+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u00071|w-\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u0005\nQ!\u001a<f]RLA!!\u0019\u0002\\\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00027pO\u0002\n!b]:m\u0007>tG/\u001a=u+\t\tI\u0007\u0005\u0003\u0002l\u0005eTBAA7\u0015\u0011\ty'!\u001d\u0002\u0007M\u001cHN\u0003\u0003\u0002t\u0005U\u0014a\u00018fi*\u0011\u0011qO\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003w\niG\u0001\u0006T'2\u001buN\u001c;fqR\f1b]:m\u0007>tG/\u001a=uA\u0005\u00012\r\\5f]R\u001c6\u000f\\\"p]R,\u0007\u0010^\u000b\u0003\u0003\u0007\u0003B!!\u000f\u0002\u0006&!\u0011qQA\u001e\u0005YAE\u000f\u001e9t\u0007>tg.Z2uS>t7i\u001c8uKb$\u0018!E2mS\u0016tGoU:m\u0007>tG/\u001a=uA\u00051An\\8lkB$b!a$\u0002\"\u0006-\u0006CBAI\u0003/\u000bY*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013\u0018\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u001a\u0006M%A\u0002$viV\u0014X\rE\u0002@\u0003;K1!a(J\u0005!\u0011Vm]8mm\u0016$\u0007bBAR)\u0001\u0007\u0011QU\u0001\u0006cV,'/\u001f\t\u0005\u0003/\t9+C\u0002\u0002*~\u0011a\u0001T8pWV\u0004\bbBAW)\u0001\u0007\u0011qV\u0001\u000fe\u0016\u001cx\u000e\u001c<f)&lWm\\;u!\u0011\t\t,a.\u000e\u0005\u0005M&\u0002BA[\u0003'\u000b\u0001\u0002Z;sCRLwN\\\u0005\u0005\u0003s\u000b\u0019L\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u0011\u0005\u0004\u0018\u000eV8lK:,\u0012\u0001V\u0001\nCBLGk\\6f]\u0002\nQ\u0002]8e\u001d\u0006lWm\u001d9bG\u0016\u0004\u0013a\u0007:fC\u0012\u001cuN\u001c4jOZ\u000b'O\u0012:p[\u001aKG.Z:zgR,W\u000eF\u0003R\u0003\u000f\fY\r\u0003\u0004\u0002Jf\u0001\r\u0001V\u0001\u0005a\u0006$\b\u000e\u0003\u0004\u0002Nf\u0001\r\u0001V\u0001\u0005]\u0006lW-\u0001\bpaRLwN\u001c+p\rV$XO]3\u0016\t\u0005M\u00171\u001c\u000b\u0007\u0003+\fi/a=\u0011\r\u0005E\u0015qSAl!\u0011\tI.a7\r\u0001\u00119\u0011Q\u001c\u000eC\u0002\u0005}'!\u0001+\u0012\t\u0005\u0005\u0018q\u001d\t\u0004[\u0005\r\u0018bAAs]\t9aj\u001c;iS:<\u0007cA\u0017\u0002j&\u0019\u00111\u001e\u0018\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002pj\u0001\r!!=\u0002\r=\u0004H/[8o!\u0011i#+a6\t\r\u0005U(\u00041\u0001U\u0003\u001d1\u0017-\u001b7Ng\u001e\f!\u0002]8e%\u0016\fX/Z:u)!\tYP!\u0003\u0003\u000e\tE\u0001\u0003B\u0017S\u0003{\u0004B!a@\u0003\u00065\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\tY$A\u0003n_\u0012,G.\u0003\u0003\u0003\b\t\u0005!a\u0003%uiB\u0014V-];fgRDaAa\u0003\u001c\u0001\u0004!\u0016!\u0002;pW\u0016t\u0007B\u0002B\b7\u0001\u0007A+A\u0005oC6,7\u000f]1dK\"1!1C\u000eA\u0002Q\u000bQ\u0002\\1cK2\u001cV\r\\3di>\u0014\b")
public class KubernetesApiServiceDiscovery
extends ServiceDiscovery {
    private final ActorSystem system;
    private final HttpExt http;
    private final Settings settings;
    private final LoggingAdapter log;
    private final SSLContext sslContext;
    private final HttpsConnectionContext clientSslContext;
    private final String apiToken;
    private final String podNamespace;

    private HttpExt http() {
        return this.http;
    }

    private Settings settings() {
        return this.settings;
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private SSLContext sslContext() {
        return this.sslContext;
    }

    private HttpsConnectionContext clientSslContext() {
        return this.clientSslContext;
    }

    public Future<ServiceDiscovery.Resolved> lookup(Lookup query, FiniteDuration resolveTimeout) {
        String labelSelector = this.settings().podLabelSelector(query.serviceName());
        this.log().info("Querying for pods with label selector: [{}]. Namespace: [{}]. Port: [{}]", (Object)labelSelector, (Object)this.podNamespace(), (Object)query.portName());
        return this.optionToFuture(this.podRequest(this.apiToken(), this.podNamespace(), labelSelector), new StringBuilder(76).append("Unable to form request; check Kubernetes environment (expecting env vars ").append(this.settings().apiServiceHostEnvName()).append(", ").append(this.settings().apiServicePortEnvName()).append(")").toString()).flatMap((Function1 & Serializable & scala.Serializable)request -> this.http().singleRequest(request, this.clientSslContext(), this.http().singleRequest$default$3(), this.http().singleRequest$default$4()).flatMap((Function1 & Serializable & scala.Serializable)response -> response.entity().toStrict(resolveTimeout, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).flatMap((Function1 & Serializable & scala.Serializable)entity -> {
            Future future;
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            StatusCode statusCode2 = statusCode;
            if (!(success != null ? !success.equals(statusCode2) : statusCode2 != null)) {
                this.log().debug("Kubernetes API entity: [{}]", (Object)entity.data().utf8String());
                Future unmarshalled = Unmarshal$.MODULE$.apply(entity).to(JsonFormat$.MODULE$.sprayJsonUnmarshaller(JsonFormat$.MODULE$.podListFormat()), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system));
                unmarshalled.failed().foreach((Function1 & Serializable & scala.Serializable)t -> {
                    KubernetesApiServiceDiscovery.$anonfun$lookup$4(this, response, entity, t);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)$this.system.dispatcher());
                future = unmarshalled;
            } else {
                StatusCodes.ClientError clientError = StatusCodes$.MODULE$.Forbidden();
                StatusCode statusCode3 = statusCode;
                if (!(clientError != null ? !clientError.equals(statusCode3) : statusCode3 != null)) {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable & scala.Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$5(this, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException("Forbidden when communicating with the Kubernetes API. Check RBAC settings."));
                } else {
                    Unmarshal$.MODULE$.apply(entity).to(Unmarshaller$.MODULE$.stringUnmarshaller(), (ExecutionContext)$this.system.dispatcher(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)$this.system)).foreach((Function1 & Serializable & scala.Serializable)body -> {
                        KubernetesApiServiceDiscovery.$anonfun$lookup$6(this, statusCode, body);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)$this.system.dispatcher());
                    future = Future$.MODULE$.failed((Throwable)new KubernetesApiException(new StringBuilder(36).append("Non-200 from Kubernetes API server: ").append(statusCode).toString()));
                }
            }
            return future.map((Function1 & Serializable & scala.Serializable)podList -> {
                scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget> addresses;
                block0: {
                    addresses = KubernetesApiServiceDiscovery$.MODULE$.targets((PodList)podList, (Option<String>)query.portName(), this.podNamespace(), this.settings().podDomain(), this.settings().rawIp(), this.settings().containerName());
                    if (!addresses.isEmpty() || !podList.items().nonEmpty() || !this.log().isInfoEnabled()) break block0;
                    Set containerPortNames = ((TraversableOnce)((GenericTraversableTemplate)((TraversableLike)((TraversableLike)podList.items().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.spec()), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> x$5.containers(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> Option$.MODULE$.option2Iterable(x$6.ports()), Seq$.MODULE$.canBuildFrom())).flatten((Function1)Predef$.MODULE$.$conforms())).toSet();
                    this.log().info("No targets found from pod list. Is the correct port name configured? Current configuration: [{}]. Ports on pods: [{}]", (Object)query.portName(), (Object)containerPortNames);
                }
                return ServiceDiscovery.Resolved$.MODULE$.apply(query.serviceName(), addresses);
            }, (ExecutionContext)$this.system.dispatcher());
        }, (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)$this.system.dispatcher()), (ExecutionContext)this.system.dispatcher());
    }

    private String apiToken() {
        return this.apiToken;
    }

    private String podNamespace() {
        return this.podNamespace;
    }

    private Option<String> readConfigVarFromFilesystem(String path, String name) {
        Path file = Paths.get(path, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            Some some;
            try {
                some = new Some((Object)new String(Files.readAllBytes(file), "utf-8"));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().error(e, "Error reading {} from {}", (Object)name, (Object)path);
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }
        this.log().warning("Unable to read {} from {} because it doesn't exist.", (Object)name, (Object)path);
        return None$.MODULE$;
    }

    private <T> Future<T> optionToFuture(Option<T> option, String failMsg) {
        return (Future)option.fold((Function0 & Serializable & scala.Serializable)() -> Future$.MODULE$.failed((Throwable)new NoSuchElementException(failMsg)), (Function1 & Serializable & scala.Serializable)result -> Future$.MODULE$.successful(result));
    }

    private Option<HttpRequest> podRequest(String token, String namespace, String labelSelector) {
        return package$.MODULE$.env().get((Object)this.settings().apiServiceHostEnvName()).flatMap((Function1 & Serializable & scala.Serializable)host -> package$.MODULE$.env().get((Object)this.settings().apiServicePortEnvName()).flatMap((Function1 & Serializable & scala.Serializable)portStr -> Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(portStr)).toInt()).toOption().map((Function1 & Serializable & scala.Serializable)port -> KubernetesApiServiceDiscovery.$anonfun$podRequest$4(namespace, labelSelector, host, token, BoxesRunTime.unboxToInt((Object)port)))));
    }

    public static final /* synthetic */ void $anonfun$lookup$4(KubernetesApiServiceDiscovery $this, HttpResponse response$1, HttpEntity.Strict entity$1, Throwable t) {
        $this.log().warning("Failed to unmarshal Kubernetes API response.  Status code: [{}]; Response body: [{}]. Ex: [{}]", (Object)response$1.status().value(), (Object)entity$1, (Object)t.getMessage());
    }

    public static final /* synthetic */ void $anonfun$lookup$5(KubernetesApiServiceDiscovery $this, String body) {
        $this.log().warning("Forbidden to communicate with Kubernetes API server; check RBAC settings. Response: [{}]", (Object)body);
    }

    public static final /* synthetic */ void $anonfun$lookup$6(KubernetesApiServiceDiscovery $this, StatusCode x1$1, String body) {
        $this.log().warning("Non-200 when communicating with Kubernetes API server. Status code: [{}]. Response body: [{}]", (Object)x1$1, (Object)body);
    }

    public static final /* synthetic */ HttpRequest $anonfun$podRequest$4(String namespace$1, String labelSelector$1, String host$1, String token$1, int port) {
        Uri uri;
        Uri.Path path = Uri.Path$.Empty$.MODULE$.$div("api").$div("v1").$div("namespaces").$div(namespace$1).$div("pods");
        Uri.Query query = Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelSelector"), (Object)labelSelector$1)}));
        String x$1 = "https";
        String x$2 = host$1;
        int x$3 = port;
        String x$4 = Uri$.MODULE$.from$default$2();
        String x$5 = Uri$.MODULE$.from$default$5();
        Option x$6 = Uri$.MODULE$.from$default$6();
        Option x$7 = Uri$.MODULE$.from$default$7();
        Uri.ParsingMode x$8 = Uri$.MODULE$.from$default$8();
        Uri x$9 = uri = Uri$.MODULE$.from(x$1, x$4, x$2, x$3, x$5, x$6, x$7, x$8).withPath(path).withQuery(query);
        scala.collection.immutable.Seq x$10 = (scala.collection.immutable.Seq)new .colon.colon((Object)new Authorization((HttpCredentials)new OAuth2BearerToken(token$1)), (List)Nil$.MODULE$);
        HttpMethod x$11 = HttpRequest$.MODULE$.apply$default$1();
        RequestEntity x$12 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$13 = HttpRequest$.MODULE$.apply$default$5();
        return HttpRequest$.MODULE$.apply(x$11, x$9, x$10, x$12, x$13);
    }

    public KubernetesApiServiceDiscovery(ActorSystem system) {
        this.system = system;
        this.http = Http$.MODULE$.apply((ClassicActorSystemProvider)system);
        this.settings = (Settings)Settings$.MODULE$.apply(system);
        this.log = Logging$.MODULE$.apply(system, (Object)this.getClass(), LogSource$.MODULE$.fromClass());
        Iterable certificates = PemManagersProvider$.MODULE$.loadCertificates(this.settings().apiCaPath());
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null);
        factory.init(keyStore, (char[])Array$.MODULE$.empty(ClassTag$.MODULE$.Char()));
        KeyManager[] km = factory.getKeyManagers();
        TrustManager[] tm = PemManagersProvider$.MODULE$.buildTrustManagers(certificates);
        SecureRandom random = new SecureRandom();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(km, tm, random);
        this.sslContext = sslContext;
        this.clientSslContext = ConnectionContext$.MODULE$.httpsClient(this.sslContext());
        this.log().debug("Settings {}", (Object)this.settings());
        this.apiToken = (String)this.readConfigVarFromFilesystem(this.settings().apiTokenPath(), "api-token").getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.podNamespace = (String)this.settings().podNamespace().orElse((Function0 & Serializable & scala.Serializable)() -> this.readConfigVarFromFilesystem(this.settings().podNamespacePath(), "pod-namespace")).getOrElse((Function0 & Serializable & scala.Serializable)() -> "default");
    }

    public static class KubernetesApiException
    extends RuntimeException
    implements NoStackTrace {
        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public KubernetesApiException(String msg) {
            super(msg);
            NoStackTrace.$init$((NoStackTrace)this);
        }
    }
}

