/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery.dns;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.discovery.ServiceDiscovery$Resolved$;
import org.apache.pekko.discovery.ServiceDiscovery$ResolvedTarget$;
import org.apache.pekko.discovery.dns.DnsServiceDiscovery$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Dns$;
import org.apache.pekko.io.DnsExt;
import org.apache.pekko.io.IO$;
import org.apache.pekko.io.SimpleDnsCache;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Srv$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.AsyncDnsManager;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005mu!\u0002\f\u0018\u0011\u0013\u0011c!\u0002\u0013\u0018\u0011\u0013)\u0003\"\u0002\u0017\u0002\t\u0003i\u0003\"\u0002\u0018\u0002\t\u0003yc!\u0002\u0013\u0018\u0001mi\u0006\u0002\u00032\u0005\u0005\u0003\u0005\u000b\u0011B2\t\u000b1\"A\u0011A5\t\u000f1$!\u0019!C\u0005[\"1A\u000f\u0002Q\u0001\n9Dq\u0001\u0007\u0003C\u0002\u0013%Q\u000f\u0003\u0004z\t\u0001\u0006IA\u001e\u0005\u0007u\u0012!\taF>\t\u000fq$\u0001\u0019!C\u0005{\"I\u0011\u0011\u0003\u0003A\u0002\u0013%\u00111\u0003\u0005\b\u0003?!\u0001\u0015)\u0003\u007f\u0011%\t\t\u0003\u0002b\u0001\n\u0017\t\u0019\u0003\u0003\u0005\u00022\u0011\u0001\u000b\u0011BA\u0013\u0011\u001d\t\u0019\u0004\u0002C\u0005\u0003kAq!a\u000f\u0005\t\u0003\ni\u0004C\u0004\u0002h\u0011!I!!\u001b\t\u000f\u0005ED\u0001\"\u0003\u0002t!9\u0011\u0011\u0013\u0003\u0005\n\u0005M\u0015a\u0005#ogN+'O^5dK\u0012K7oY8wKJL(B\u0001\r\u001a\u0003\r!gn\u001d\u0006\u00035m\t\u0011\u0002Z5tG>4XM]=\u000b\u0005qi\u0012!\u00029fW.|'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002$\u00035\tqCA\nE]N\u001cVM\u001d<jG\u0016$\u0015n]2pm\u0016\u0014\u0018p\u0005\u0002\u0002MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0002)M\u0014hOU3d_J$7\u000fV8SKN|GN^3e)\r\u0001D(\u0013\t\u0003cer!AM\u001c\u000f\u0005M2dB\u0001\u001b6\u001b\u0005i\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u000293\u0005\u00012+\u001a:wS\u000e,G)[:d_Z,'/_\u0005\u0003um\u0012\u0001BU3t_24X\r\u001a\u0006\u0003qeAQ!P\u0002A\u0002y\n!b\u001d:w%\u0016\fX/Z:u!\tydI\u0004\u0002A\tB\u0011\u0011\tK\u0007\u0002\u0005*\u00111)I\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015C\u0013A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!\u0012\u0015\t\u000b)\u001b\u0001\u0019A&\u0002\u0011I,7o\u001c7wK\u0012\u0004\"\u0001T*\u000f\u00055\u000bV\"\u0001(\u000b\u0005ay%B\u0001)\u001c\u0003\tIw.\u0003\u0002S\u001d\u0006YAI\\:Qe>$xnY8m\u0013\tQDK\u0003\u0002S\u001d\"\u0012\u0011A\u0016\t\u0003/jk\u0011\u0001\u0017\u0006\u00033n\t!\"\u00198o_R\fG/[8o\u0013\tY\u0006LA\u0006J]R,'O\\1m\u0003BL\u0007F\u0001\u0001W'\t!a\f\u0005\u0002`A6\t\u0011$\u0003\u0002b3\t\u00012+\u001a:wS\u000e,G)[:d_Z,'/_\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\\\u0012!B1di>\u0014\u0018B\u00015f\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n)\tQ7\u000e\u0005\u0002$\t!)!M\u0002a\u0001G\u0006\u0019An\\4\u0016\u00039\u0004\"a\u001c:\u000e\u0003AT!!]\u000e\u0002\u000b\u00154XM\u001c;\n\u0005M\u0004(A\u0004'pO\u001eLgnZ!eCB$XM]\u0001\u0005Y><\u0007%F\u0001w!\t!w/\u0003\u0002yK\nA\u0011i\u0019;peJ+g-\u0001\u0003e]N\u0004\u0013!D5oSRL\u0017\r\\5{K\u0012s7\u000fF\u0001w\u00035\t7/\u001f8d\t:\u001c8)Y2iKV\ta\u0010E\u0003\u0000\u0003\u000b\tI!\u0004\u0002\u0002\u0002)\u0019\u00111A\u000e\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000f\t\tAA\u0005PaRLwN\u001c,bYB!\u00111BA\u0007\u001b\u0005y\u0015bAA\b\u001f\nq1+[7qY\u0016$en]\"bG\",\u0017!E1ts:\u001cGI\\:DC\u000eDWm\u0018\u0013fcR!\u0011QCA\u000e!\r9\u0013qC\u0005\u0004\u00033A#\u0001B+oSRD\u0001\"!\b\u000e\u0003\u0003\u0005\rA`\u0001\u0004q\u0012\n\u0014AD1ts:\u001cGI\\:DC\u000eDW\rI\u0001\u0003K\u000e,\"!!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b\u001c\u0003!!\u0017n\u001d9bi\u000eD\u0017\u0002BA\u0018\u0003S\u0011\u0011#T3tg\u0006<W\rR5ta\u0006$8\r[3s\u0003\r)7\rI\u0001\u000eG2,\u0017M\\%q'R\u0014\u0018N\\4\u0015\u0007y\n9\u0004\u0003\u0004\u0002:E\u0001\rAP\u0001\tSB\u001cFO]5oO\u00061An\\8lkB$b!a\u0010\u0002P\u0005]\u0003CBA!\u0003\u000f\nY%\u0004\u0002\u0002D)\u0019\u0011Q\t\u0015\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002J\u0005\r#A\u0002$viV\u0014X\rE\u0002\u0002Ner!aX\u001c\t\u000f\u0005m\"\u00031\u0001\u0002RA\u0019q,a\u0015\n\u0007\u0005U\u0013D\u0001\u0004M_>\\W\u000f\u001d\u0005\b\u00033\u0012\u0002\u0019AA.\u00039\u0011Xm]8mm\u0016$\u0016.\\3pkR\u0004B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019%\u0001\u0005ekJ\fG/[8o\u0013\u0011\t)'a\u0018\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006IAn\\8lkB\u001c&O\u001e\u000b\u0007\u0003W\ni'a\u001c\u0011\u000b\u0005\u0005\u0013q\t\u0019\t\u000f\u0005m2\u00031\u0001\u0002R!9\u0011\u0011L\nA\u0002\u0005m\u0013\u0001E2p]Z,'\u000f\u001e+p)&lWm\\;u)\u0011\t)(!$\u0011\u000f\u001d\n9(a\u001f\u0002@%\u0019\u0011\u0011\u0010\u0015\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004B!! \u0002\b:!\u0011qPAB\u001d\r\t\u0015\u0011Q\u0005\u0002S%\u0019\u0011Q\u0011\u0015\u0002\u000fA\f7m[1hK&!\u0011\u0011RAF\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u0006\"Bq!a$\u0015\u0001\u0004\tY&A\u0004uS6,w.\u001e;\u0002\u00111|wn[;q\u0013B$b!a\u0010\u0002\u0016\u0006]\u0005bBA\u001e+\u0001\u0007\u0011\u0011\u000b\u0005\b\u00033*\u0002\u0019AA.Q\t!a\u000b")
@InternalApi
public class DnsServiceDiscovery
extends ServiceDiscovery {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final ActorRef dns;
    private SimpleDnsCache asyncDnsCache;
    private final MessageDispatcher ec;

    public static ServiceDiscovery.Resolved srvRecordsToResolved(String srvRequest, DnsProtocol.Resolved resolved) {
        return DnsServiceDiscovery$.MODULE$.srvRecordsToResolved(srvRequest, resolved);
    }

    private LoggingAdapter log() {
        return this.log;
    }

    private ActorRef dns() {
        return this.dns;
    }

    public ActorRef initializeDns() {
        String string = this.system.settings().config().getString("pekko.io.dns.resolver");
        String string2 = "async-dns";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log().debug("using system resolver as it is set to async-dns");
            return IO$.MODULE$.apply((ExtensionId)Dns$.MODULE$, (ActorSystem)this.system);
        }
        this.log().debug("system resolver is not async-dns. Loading isolated resolver");
        return ((DnsExt)Dns$.MODULE$.apply((ActorSystem)this.system)).loadAsyncDns("SD-DNS");
    }

    private SimpleDnsCache asyncDnsCache() {
        return this.asyncDnsCache;
    }

    private void asyncDnsCache_$eq(SimpleDnsCache x$1) {
        this.asyncDnsCache = x$1;
    }

    private MessageDispatcher ec() {
        return this.ec;
    }

    public String org$apache$pekko$discovery$dns$DnsServiceDiscovery$$cleanIpString(String ipString) {
        if (ipString.startsWith("/")) {
            return StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(ipString));
        }
        return ipString;
    }

    @Override
    public Future<ServiceDiscovery.Resolved> lookup(Lookup lookup, FiniteDuration resolveTimeout) {
        if (lookup.portName().isDefined() && lookup.protocol().isDefined()) {
            return this.lookupSrv(lookup, resolveTimeout);
        }
        return this.lookupIp(lookup, resolveTimeout);
    }

    private Future<ServiceDiscovery.Resolved> lookupSrv(Lookup lookup, FiniteDuration resolveTimeout) {
        String srvRequest = new StringBuilder(4).append("_").append(lookup.portName().get()).append("._").append(lookup.protocol().get()).append(".").append(lookup.serviceName()).toString();
        this.log().debug("Lookup [{}] translated to SRV query [{}] as contains portName and protocol", (Object)lookup, (Object)srvRequest);
        DnsProtocol$Srv$ mode = DnsProtocol$Srv$.MODULE$;
        SimpleDnsCache simpleDnsCache = this.asyncDnsCache();
        SimpleDnsCache simpleDnsCache2 = (SimpleDnsCache)OptionVal.Some$.MODULE$.unapply((Object)simpleDnsCache);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)simpleDnsCache2)) {
            SimpleDnsCache cache = (SimpleDnsCache)OptionVal$.MODULE$.get$extension((Object)simpleDnsCache2);
            Option option = cache.get(new Tuple2((Object)srvRequest, (Object)mode));
            if (option instanceof Some) {
                Some some = (Some)option;
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)some.value();
                this.log().debug("{} lookup cached: {}", (Object)mode, (Object)resolved);
                return Future$.MODULE$.successful((Object)DnsServiceDiscovery$.MODULE$.srvRecordsToResolved(srvRequest, resolved));
            }
            if (None$.MODULE$.equals(option)) {
                return this.askResolve$1(srvRequest, mode, resolveTimeout);
            }
            throw new MatchError((Object)option);
        }
        OptionVal$.MODULE$.None();
        SimpleDnsCache simpleDnsCache3 = simpleDnsCache;
        if (!(null != null ? !((Object)null).equals(simpleDnsCache3) : simpleDnsCache3 != null)) {
            return this.askResolve$1(srvRequest, mode, resolveTimeout);
        }
        throw new RuntimeException(new StringBuilder(12).append("Unexpected: ").append(new OptionVal((Object)simpleDnsCache)).toString());
    }

    private PartialFunction<Throwable, Future<ServiceDiscovery.Resolved>> convertToTimeout(FiniteDuration timeout) {
        return new Serializable(null, timeout){
            private static final long serialVersionUID = 0L;
            private final FiniteDuration timeout$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof AskTimeoutException) {
                    return (B1)Future$.MODULE$.failed((Throwable)new ServiceDiscovery.DiscoveryTimeoutException(new StringBuilder(35).append("Dns resolve did not respond within ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout$1))).toString()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return throwable instanceof AskTimeoutException;
            }
            {
                this.timeout$1 = timeout$1;
            }
        };
    }

    private Future<ServiceDiscovery.Resolved> lookupIp(Lookup lookup, FiniteDuration resolveTimeout) {
        this.log().debug("Lookup[{}] translated to A/AAAA lookup as does not have portName and protocol", (Object)lookup);
        DnsProtocol.Ip mode = new DnsProtocol.Ip(DnsProtocol.Ip$.MODULE$.apply$default$1(), DnsProtocol.Ip$.MODULE$.apply$default$2());
        SimpleDnsCache simpleDnsCache = this.asyncDnsCache();
        SimpleDnsCache simpleDnsCache2 = (SimpleDnsCache)OptionVal.Some$.MODULE$.unapply((Object)simpleDnsCache);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)simpleDnsCache2)) {
            SimpleDnsCache cache = (SimpleDnsCache)OptionVal$.MODULE$.get$extension((Object)simpleDnsCache2);
            Option option = cache.get(new Tuple2((Object)lookup.serviceName(), (Object)mode));
            if (option instanceof Some) {
                Some some = (Some)option;
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)some.value();
                this.log().debug("{} lookup cached: {}", (Object)mode, (Object)resolved);
                return Future$.MODULE$.successful((Object)this.ipRecordsToResolved$1(resolved, lookup));
            }
            if (None$.MODULE$.equals(option)) {
                return this.askResolve$2(lookup, mode, resolveTimeout);
            }
            throw new MatchError((Object)option);
        }
        OptionVal$.MODULE$.None();
        SimpleDnsCache simpleDnsCache3 = simpleDnsCache;
        if (!(null != null ? !((Object)null).equals(simpleDnsCache3) : simpleDnsCache3 != null)) {
            return this.askResolve$2(lookup, mode, resolveTimeout);
        }
        throw new RuntimeException(new StringBuilder(12).append("Unexpected: ").append(new OptionVal((Object)simpleDnsCache)).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(DnsServiceDiscovery $this, Try x0$1) {
        boolean bl = false;
        Success success = null;
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Object cache = success.value();
            if (cache instanceof SimpleDnsCache) {
                SimpleDnsCache simpleDnsCache = (SimpleDnsCache)cache;
                $this.asyncDnsCache_$eq((SimpleDnsCache)OptionVal.Some$.MODULE$.apply((Object)simpleDnsCache));
                return;
            }
        }
        if (bl) {
            Object other = success.value();
            $this.log().error("Expected AsyncDnsCache but got [{}]", (Object)other.getClass().getName());
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            $this.log().error(e, "Couldn't retrieve DNS cache: {}");
            return;
        }
        throw new MatchError((Object)try_);
    }

    private final Future askResolve$1(String srvRequest$1, DnsProtocol$Srv$ mode$1, FiniteDuration resolveTimeout$1) {
        ActorRef qual$1 = package$.MODULE$.ask(this.dns());
        DnsProtocol.Resolve x$1 = new DnsProtocol.Resolve(srvRequest$1, (DnsProtocol.RequestType)mode$1);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(resolveTimeout$1);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).map((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof DnsProtocol.Resolved) {
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)object;
                this.log().debug("{} lookup result: {}", (Object)mode$1, (Object)resolved);
                return DnsServiceDiscovery$.MODULE$.srvRecordsToResolved(srvRequest$1, resolved);
            }
            this.log().warning("Resolved UNEXPECTED (resolving to Nil): {}", object.getClass());
            return ServiceDiscovery$Resolved$.MODULE$.apply(srvRequest$1, (Seq<ServiceDiscovery.ResolvedTarget>)Nil$.MODULE$);
        }, (ExecutionContext)this.ec()).recoverWith(this.convertToTimeout(resolveTimeout$1), (ExecutionContext)this.ec());
    }

    private final ServiceDiscovery.Resolved ipRecordsToResolved$1(DnsProtocol.Resolved resolved, Lookup lookup$1) {
        Seq addresses = (Seq)resolved.records().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ DnsServiceDiscovery $outer;

            public final <A1 extends ResourceRecord, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof ARecord) {
                    ARecord aRecord = (ARecord)A1;
                    return (B1)ServiceDiscovery$ResolvedTarget$.MODULE$.apply(this.$outer.org$apache$pekko$discovery$dns$DnsServiceDiscovery$$cleanIpString(aRecord.ip().getHostAddress()), (Option<Object>)None$.MODULE$, (Option<InetAddress>)new Some((Object)aRecord.ip()));
                }
                if (A1 instanceof AAAARecord) {
                    AAAARecord aAAARecord = (AAAARecord)A1;
                    return (B1)ServiceDiscovery$ResolvedTarget$.MODULE$.apply(this.$outer.org$apache$pekko$discovery$dns$DnsServiceDiscovery$$cleanIpString(aAAARecord.ip().getHostAddress()), (Option<Object>)None$.MODULE$, (Option<InetAddress>)new Some((Object)aAAARecord.ip()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ResourceRecord x1) {
                ResourceRecord resourceRecord = x1;
                if (resourceRecord instanceof ARecord) {
                    return true;
                }
                return resourceRecord instanceof AAAARecord;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return ServiceDiscovery$Resolved$.MODULE$.apply(lookup$1.serviceName(), (Seq<ServiceDiscovery.ResolvedTarget>)addresses);
    }

    private final Future askResolve$2(Lookup lookup$1, DnsProtocol.Ip mode$2, FiniteDuration resolveTimeout$2) {
        ActorRef qual$1 = package$.MODULE$.ask(this.dns());
        DnsProtocol.Resolve x$1 = new DnsProtocol.Resolve(lookup$1.serviceName(), (DnsProtocol.RequestType)mode$2);
        Timeout x$2 = Timeout$.MODULE$.durationToTimeout(resolveTimeout$2);
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        return AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).map((Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof DnsProtocol.Resolved) {
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)object;
                this.log().debug("{} lookup result: {}", (Object)mode$2, (Object)resolved);
                return this.ipRecordsToResolved$1(resolved, lookup$1);
            }
            this.log().warning("Resolved UNEXPECTED (resolving to Nil): {}", object.getClass());
            return ServiceDiscovery$Resolved$.MODULE$.apply(lookup$1.serviceName(), (Seq<ServiceDiscovery.ResolvedTarget>)Nil$.MODULE$);
        }, (ExecutionContext)this.ec()).recoverWith(this.convertToTimeout(resolveTimeout$2), (ExecutionContext)this.ec());
    }

    public DnsServiceDiscovery(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, DnsServiceDiscovery.class, LogSource$.MODULE$.fromAnyClass());
        this.dns = this.initializeDns();
        OptionVal$.MODULE$.None();
        this.asyncDnsCache = null;
        this.ec = system.dispatchers().internalDispatcher();
        ActorRef qual$1 = package$.MODULE$.ask(this.dns());
        AsyncDnsManager.GetCache$ x$1 = AsyncDnsManager.GetCache$.MODULE$;
        Timeout x$2 = new Timeout(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds());
        ActorRef x$3 = AskableActorRef$.MODULE$.ask$default$3$extension(qual$1, (Object)x$1);
        AskableActorRef$.MODULE$.ask$extension(qual$1, (Object)x$1, x$2, x$3).onComplete((Function1 & Serializable)x0$1 -> {
            DnsServiceDiscovery.$anonfun$new$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, (ExecutionContext)this.ec());
    }
}

