/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.Discovery$;
import org.apache.pekko.discovery.ServiceDiscovery;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class Discovery
implements Extension {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Discovery.class.getDeclaredField("defaultImpl$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Discovery.class.getDeclaredField("_defaultImplMethod$lzy1"));
    public final ExtendedActorSystem org$apache$pekko$discovery$Discovery$$system;
    private final ConcurrentHashMap<String, ServiceDiscovery> implementations;
    private final Function<String, ServiceDiscovery> factory;
    private volatile Object _defaultImplMethod$lzy1;
    private volatile Object defaultImpl$lzy1;

    public static Discovery apply(ActorSystem actorSystem) {
        return Discovery$.MODULE$.apply(actorSystem);
    }

    public static /* synthetic */ Extension apply(ActorSystem actorSystem) {
        return Discovery$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Discovery$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Discovery createExtension(ExtendedActorSystem extendedActorSystem) {
        return Discovery$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Discovery get(ActorSystem actorSystem) {
        return Discovery$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return Discovery$.MODULE$.get(actorSystem);
    }

    public static Discovery get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Discovery$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Discovery$.MODULE$.get(classicActorSystemProvider);
    }

    public static Discovery$ lookup() {
        return Discovery$.MODULE$.lookup();
    }

    public Discovery(ExtendedActorSystem system) {
        this.org$apache$pekko$discovery$Discovery$$system = system;
        this.implementations = new ConcurrentHashMap();
        this.factory = new Function<String, ServiceDiscovery>(this){
            private final /* synthetic */ Discovery $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public ServiceDiscovery apply(String method) {
                return this.$outer.org$apache$pekko$discovery$Discovery$$createServiceDiscovery(method);
            }
        };
    }

    private String _defaultImplMethod() {
        Object object = this._defaultImplMethod$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this._defaultImplMethod$lzyINIT1();
    }

    private Object _defaultImplMethod$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this._defaultImplMethod$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        String string2 = this.org$apache$pekko$discovery$Discovery$$system.settings().config().getString("pekko.discovery.method");
                        if ("<method>".equals(string2)) {
                            throw new IllegalArgumentException("No default service discovery implementation configured in `pekko.discovery.method`. Make sure to configure this setting to your preferred implementation such as 'pekko-dns' in your application.conf (from the pekko-discovery module).");
                        }
                        String method = string2;
                        string = method;
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this._defaultImplMethod$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this._defaultImplMethod$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private ServiceDiscovery defaultImpl() {
        Object object = this.defaultImpl$lzy1;
        if (object instanceof ServiceDiscovery) {
            return (ServiceDiscovery)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ServiceDiscovery)this.defaultImpl$lzyINIT1();
    }

    private Object defaultImpl$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.defaultImpl$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ServiceDiscovery serviceDiscovery = null;
                    try {
                        serviceDiscovery = this.loadServiceDiscovery(this._defaultImplMethod());
                        object2 = serviceDiscovery == null ? LazyVals.NullValue$.MODULE$ : serviceDiscovery;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.defaultImpl$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serviceDiscovery;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ServiceDiscovery discovery() throws IllegalArgumentException {
        return this.defaultImpl();
    }

    public ServiceDiscovery loadServiceDiscovery(String method) {
        return this.implementations.computeIfAbsent(method, this.factory);
    }

    @InternalApi
    public ServiceDiscovery org$apache$pekko$discovery$Discovery$$createServiceDiscovery(String method) {
        String configName;
        Config config = this.org$apache$pekko$discovery$Discovery$$system.settings().config();
        DynamicAccess dynamic = this.org$apache$pekko$discovery$Discovery$$system.dynamicAccess();
        Try instanceTry = this.create$1(dynamic, Discovery.classNameFromConfig$1(config, configName = new StringBuilder(22).append("pekko.discovery.").append(method).append(".class").toString()));
        Try try_ = instanceTry;
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof ClassNotFoundException || throwable instanceof NoSuchMethodException) {
                ReflectiveOperationException e = (ReflectiveOperationException)throwable;
                throw new IllegalArgumentException(new StringBuilder(177).append("Illegal [").append(configName).append("] value or incompatible class! ").append("The implementation class MUST extend org.apache.pekko.discovery.ServiceDiscovery and take an ").append("ExtendedActorSystem as constructor argument.").toString(), e);
            }
            Throwable e = throwable;
            throw e;
        }
        if (try_ instanceof Success) {
            ServiceDiscovery instance = (ServiceDiscovery)((Success)try_).value();
            return instance;
        }
        throw new MatchError((Object)try_);
    }

    private static final String classNameFromConfig$1(Config config$1, String path) {
        if (config$1.hasPath(path)) {
            return config$1.getString(path);
        }
        throw new IllegalArgumentException(new StringBuilder(86).append(path).append(" must point to a FQN of a `org.apache.pekko.discovery.ServiceDiscovery` implementation").toString());
    }

    private final Try create$1(DynamicAccess dynamic$1, String clazzName) {
        Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ExtendedActorSystem.class);
        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.org$apache$pekko$discovery$Discovery$$system);
        return dynamic$1.createInstanceFor(clazzName, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ServiceDiscovery.class)).recoverWith((PartialFunction)new Serializable(dynamic$1, clazzName, this){
            private final DynamicAccess dynamic$2;
            private final String clazzName$1;
            private final /* synthetic */ Discovery $outer;
            {
                this.dynamic$2 = dynamic$4;
                this.clazzName$1 = clazzName$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof ClassNotFoundException || throwable instanceof NoSuchMethodException;
                {
                }
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof ClassNotFoundException || throwable instanceof NoSuchMethodException) {
                    Class clazz = (Class)Predef$.MODULE$.ArrowAssoc(ActorSystem.class);
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)clazz, (Object)this.$outer.org$apache$pekko$discovery$Discovery$$system);
                    return this.dynamic$2.createInstanceFor(this.clazzName$1, (Seq)package$.MODULE$.Nil().$colon$colon((Object)tuple2), ClassTag$.MODULE$.apply(ServiceDiscovery.class));
                }
                return function1.apply((Object)x);
            }
        }).recoverWith((PartialFunction)new Serializable(dynamic$1, clazzName){
            private final DynamicAccess dynamic$3;
            private final String clazzName$2;
            {
                this.dynamic$3 = dynamic$5;
                this.clazzName$2 = clazzName$4;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof ClassNotFoundException || throwable instanceof NoSuchMethodException;
                {
                }
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof ClassNotFoundException || throwable instanceof NoSuchMethodException) {
                    return this.dynamic$3.createInstanceFor(this.clazzName$2, (Seq)package$.MODULE$.Nil(), ClassTag$.MODULE$.apply(ServiceDiscovery.class));
                }
                return function1.apply((Object)x);
            }
        });
    }
}

