/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery;

import java.io.Serializable;
import org.apache.pekko.discovery.Lookup;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class Lookup$
implements Product,
Serializable,
Mirror.Singleton {
    private static final Regex SrvQuery;
    private static final Regex DomainName;
    public static final Lookup$ MODULE$;

    private Lookup$() {
    }

    static {
        MODULE$ = new Lookup$();
        SrvQuery = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^_(.+?)\\._(.+?)\\.(.+?)$"));
        DomainName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^((?![0-9-])[A-Za-z0-9-]{1,63}(?<!-))((\\.(?![0-9-])[A-Za-z0-9-]{1,63}(?<!-)))*$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Lookup$.class);
    }

    public int hashCode() {
        return -2013227622;
    }

    public String toString() {
        return "Lookup";
    }

    public boolean canEqual(Object that) {
        return that instanceof Lookup$;
    }

    public int productArity() {
        return 0;
    }

    public String productPrefix() {
        return "Lookup";
    }

    public Object productElement(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Lookup apply(String serviceName) {
        return new Lookup(serviceName, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Lookup apply(String serviceName, Option<String> portName, Option<String> protocol) {
        return new Lookup(serviceName, portName, protocol);
    }

    public Lookup create(String serviceName) {
        return new Lookup(serviceName, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
    }

    public Lookup parseSrv(String str) {
        List list;
        Option option;
        String string = str;
        if (string != null && !(option = SrvQuery.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(3) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String string4 = (String)list.apply(2);
            String portName = string2;
            String protocol = string3;
            String serviceName = string4;
            if (this.validDomainName(serviceName)) {
                return this.apply(serviceName).withPortName(portName).withProtocol(protocol);
            }
        }
        if (string == null) {
            throw new NullPointerException("Unable to create Lookup from passed SRV string. Passed value is 'null'");
        }
        throw new IllegalArgumentException(new StringBuilder(64).append("Unable to create Lookup from passed SRV string, invalid format: ").append(str).toString());
    }

    public boolean isValidSrv(String srv) {
        List list;
        Option option;
        String string = srv;
        if (string != null && !(option = SrvQuery.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(3) == 0) {
            String string2;
            String string3 = (String)list.apply(0);
            String string4 = (String)list.apply(1);
            String serviceName = string2 = (String)list.apply(2);
            return this.validDomainName(serviceName);
        }
        return false;
    }

    private boolean validDomainName(String name) {
        return DomainName.pattern().asPredicate().test(name);
    }
}

