/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery;

import java.util.Optional;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.discovery.Lookup$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.deriving.Mirror;

public final class Lookup
implements NoSerializationVerificationNeeded {
    private final String serviceName;
    private final Option portName;
    private final Option protocol;

    public static Lookup apply(String string) {
        return Lookup$.MODULE$.apply(string);
    }

    public static Lookup apply(String string, Option<String> option, Option<String> option2) {
        return Lookup$.MODULE$.apply(string, option, option2);
    }

    public static boolean canEqual(Object object) {
        return Lookup$.MODULE$.canEqual(object);
    }

    public static Lookup create(String string) {
        return Lookup$.MODULE$.create(string);
    }

    public static Mirror.Singleton fromProduct(Product product) {
        return Lookup$.MODULE$.fromProduct(product);
    }

    public static boolean isValidSrv(String string) {
        return Lookup$.MODULE$.isValidSrv(string);
    }

    public static Lookup parseSrv(String string) {
        return Lookup$.MODULE$.parseSrv(string);
    }

    public static int productArity() {
        return Lookup$.MODULE$.productArity();
    }

    public static Object productElement(int n) {
        return Lookup$.MODULE$.productElement(n);
    }

    public static String productElementName(int n) {
        return Lookup$.MODULE$.productElementName(n);
    }

    public static Iterator<String> productElementNames() {
        return Lookup$.MODULE$.productElementNames();
    }

    public static Iterator<Object> productIterator() {
        return Lookup$.MODULE$.productIterator();
    }

    public static String productPrefix() {
        return Lookup$.MODULE$.productPrefix();
    }

    public Lookup(String serviceName, Option<String> portName, Option<String> protocol) {
        this.serviceName = serviceName;
        this.portName = portName;
        this.protocol = protocol;
        Predef$.MODULE$.require(serviceName != null, Lookup::$init$$$anonfun$1);
        Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(serviceName.trim())), Lookup::$init$$$anonfun$2);
    }

    public String serviceName() {
        return this.serviceName;
    }

    public Option<String> portName() {
        return this.portName;
    }

    public Option<String> protocol() {
        return this.protocol;
    }

    public Lookup withPortName(String value) {
        Some some = Some$.MODULE$.apply((Object)value);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$3();
        return this.copy(string, (Option<String>)some, option);
    }

    public Lookup withProtocol(String value) {
        Some some = Some$.MODULE$.apply((Object)value);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        return this.copy(string, option, (Option<String>)some);
    }

    public Optional<String> getPortName() {
        Option option = OptionConverters$.MODULE$.RichOption(this.portName());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    public Optional<String> getProtocol() {
        Option option = OptionConverters$.MODULE$.RichOption(this.protocol());
        return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
    }

    private Lookup copy(String serviceName, Option<String> portName, Option<String> protocol) {
        return new Lookup(serviceName, portName, protocol);
    }

    private String copy$default$1() {
        return this.serviceName();
    }

    private Option<String> copy$default$2() {
        return this.portName();
    }

    private Option<String> copy$default$3() {
        return this.protocol();
    }

    public String toString() {
        return new StringBuilder(10).append("Lookup(").append(this.serviceName()).append(",").append(this.portName()).append(",").append(this.protocol()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof Lookup)) return false;
        Lookup other = (Lookup)object;
        String string = this.serviceName();
        String string2 = other.serviceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<String> option = this.portName();
        Option<String> option2 = other.portName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.protocol();
        Option<String> option4 = other.protocol();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, (Object)this.serviceName());
        result = HashCode$.MODULE$.hash(result, this.portName());
        result = HashCode$.MODULE$.hash(result, this.protocol());
        return result;
    }

    private static final Object $init$$$anonfun$1() {
        return "'serviceName' cannot be null";
    }

    private static final Object $init$$$anonfun$2() {
        return "'serviceName' cannot be empty";
    }
}

