/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery.dns;

import java.io.Serializable;
import java.net.InetAddress;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.discovery.ServiceDiscovery$Resolved$;
import org.apache.pekko.discovery.ServiceDiscovery$ResolvedTarget$;
import org.apache.pekko.discovery.dns.DnsServiceDiscovery$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Dns$;
import org.apache.pekko.io.DnsExt;
import org.apache.pekko.io.IO$;
import org.apache.pekko.io.SimpleDnsCache;
import org.apache.pekko.io.dns.AAAARecord;
import org.apache.pekko.io.dns.ARecord;
import org.apache.pekko.io.dns.DnsProtocol;
import org.apache.pekko.io.dns.DnsProtocol$Srv$;
import org.apache.pekko.io.dns.ResourceRecord;
import org.apache.pekko.io.dns.internal.AsyncDnsManager;
import org.apache.pekko.pattern.AskTimeoutException;
import org.apache.pekko.pattern.AskableActorRef$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.PrettyDuration;
import org.apache.pekko.util.PrettyDuration$;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public class DnsServiceDiscovery
extends ServiceDiscovery {
    private final ExtendedActorSystem system;
    private final LoggingAdapter log;
    private final ActorRef dns;
    private SimpleDnsCache asyncDnsCache;
    private final MessageDispatcher ec;

    public static ServiceDiscovery.Resolved srvRecordsToResolved(String string, DnsProtocol.Resolved resolved) {
        return DnsServiceDiscovery$.MODULE$.srvRecordsToResolved(string, resolved);
    }

    public DnsServiceDiscovery(ExtendedActorSystem system) {
        this.system = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, DnsServiceDiscovery.class, LogSource$.MODULE$.fromAnyClass());
        this.dns = this.initializeDns();
        OptionVal$.MODULE$.None();
        this.asyncDnsCache = null;
        this.ec = system.dispatchers().internalDispatcher();
        ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.dns);
        AskableActorRef$.MODULE$.ask$extension(actorRef, (Object)AsyncDnsManager.GetCache$.MODULE$, Timeout$.MODULE$.apply(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds()), AskableActorRef$.MODULE$.ask$default$3$extension(actorRef, (Object)AsyncDnsManager.GetCache$.MODULE$)).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object object = ((Success)try_).value();
                if (object instanceof SimpleDnsCache) {
                    SimpleDnsCache cache = (SimpleDnsCache)object;
                    this.asyncDnsCache = (SimpleDnsCache)OptionVal.Some$.MODULE$.apply((Object)cache);
                    return;
                }
                Object other = object;
                this.log.error("Expected AsyncDnsCache but got [{}]", (Object)other.getClass().getName());
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.log.error(e, "Couldn't retrieve DNS cache: {}");
                return;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.ec);
    }

    public ActorRef initializeDns() {
        String string = this.system.settings().config().getString("pekko.io.dns.resolver");
        String string2 = "async-dns";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.log.debug("using system resolver as it is set to async-dns");
            return IO$.MODULE$.apply((ExtensionId)Dns$.MODULE$, (ActorSystem)this.system);
        }
        this.log.debug("system resolver is not async-dns. Loading isolated resolver");
        return ((DnsExt)Dns$.MODULE$.apply((ActorSystem)this.system)).loadAsyncDns("SD-DNS");
    }

    public String org$apache$pekko$discovery$dns$DnsServiceDiscovery$$cleanIpString(String ipString) {
        if (ipString.startsWith("/")) {
            return StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(ipString));
        }
        return ipString;
    }

    @Override
    public Future<ServiceDiscovery.Resolved> lookup(Lookup lookup, FiniteDuration resolveTimeout) {
        if (lookup.portName().isDefined() && lookup.protocol().isDefined()) {
            return this.lookupSrv(lookup, resolveTimeout);
        }
        return this.lookupIp(lookup, resolveTimeout);
    }

    private Future<ServiceDiscovery.Resolved> lookupSrv(Lookup lookup, FiniteDuration resolveTimeout) {
        String srvRequest = new StringBuilder(4).append("_").append(lookup.portName().get()).append("._").append(lookup.protocol().get()).append(".").append(lookup.serviceName()).toString();
        this.log.debug("Lookup [{}] translated to SRV query [{}] as contains portName and protocol", (Object)lookup, (Object)srvRequest);
        DnsProtocol$Srv$ mode = DnsProtocol$Srv$.MODULE$;
        SimpleDnsCache simpleDnsCache = this.asyncDnsCache;
        SimpleDnsCache simpleDnsCache2 = (SimpleDnsCache)OptionVal.Some$.MODULE$.unapply((Object)simpleDnsCache);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)simpleDnsCache2)) {
            SimpleDnsCache simpleDnsCache3 = (SimpleDnsCache)OptionVal$.MODULE$.get$extension((Object)simpleDnsCache2);
            SimpleDnsCache cache = simpleDnsCache3;
            Option option = cache.get(Tuple2$.MODULE$.apply((Object)srvRequest, (Object)mode));
            if (option instanceof Some) {
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)((Some)option).value();
                this.log.debug("{} lookup cached: {}", (Object)mode, (Object)resolved);
                return Future$.MODULE$.successful((Object)DnsServiceDiscovery$.MODULE$.srvRecordsToResolved(srvRequest, resolved));
            }
            if (None$.MODULE$.equals(option)) {
                return this.askResolve$1(resolveTimeout, srvRequest, mode);
            }
            throw new MatchError((Object)option);
        }
        OptionVal$.MODULE$.None();
        SimpleDnsCache simpleDnsCache4 = simpleDnsCache;
        if (!(null != null ? !((Object)null).equals(simpleDnsCache4) : simpleDnsCache4 != null)) {
            return this.askResolve$1(resolveTimeout, srvRequest, mode);
        }
        SimpleDnsCache unexpected = simpleDnsCache;
        throw new RuntimeException(new StringBuilder(12).append("Unexpected: ").append(new OptionVal((Object)unexpected)).toString());
    }

    private PartialFunction<Throwable, Future<ServiceDiscovery.Resolved>> convertToTimeout(FiniteDuration timeout) {
        return new Serializable(timeout){
            private final FiniteDuration timeout$1;
            {
                this.timeout$1 = timeout$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return throwable instanceof AskTimeoutException;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof AskTimeoutException) {
                    return Future$.MODULE$.failed((Throwable)new ServiceDiscovery.DiscoveryTimeoutException(new StringBuilder(35).append("Dns resolve did not respond within ").append(PrettyDuration.PrettyPrintableDuration$.MODULE$.pretty$extension(PrettyDuration$.MODULE$.PrettyPrintableDuration((Duration)this.timeout$1))).toString()));
                }
                return function1.apply((Object)x);
            }
        };
    }

    private Future<ServiceDiscovery.Resolved> lookupIp(Lookup lookup, FiniteDuration resolveTimeout) {
        this.log.debug("Lookup[{}] translated to A/AAAA lookup as does not have portName and protocol", (Object)lookup);
        DnsProtocol.Ip mode = DnsProtocol.Ip$.MODULE$.apply(DnsProtocol.Ip$.MODULE$.$lessinit$greater$default$1(), DnsProtocol.Ip$.MODULE$.$lessinit$greater$default$2());
        SimpleDnsCache simpleDnsCache = this.asyncDnsCache;
        SimpleDnsCache simpleDnsCache2 = (SimpleDnsCache)OptionVal.Some$.MODULE$.unapply((Object)simpleDnsCache);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)simpleDnsCache2)) {
            SimpleDnsCache simpleDnsCache3 = (SimpleDnsCache)OptionVal$.MODULE$.get$extension((Object)simpleDnsCache2);
            SimpleDnsCache cache = simpleDnsCache3;
            Option option = cache.get(Tuple2$.MODULE$.apply((Object)lookup.serviceName(), (Object)mode));
            if (option instanceof Some) {
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)((Some)option).value();
                this.log.debug("{} lookup cached: {}", (Object)mode, (Object)resolved);
                return Future$.MODULE$.successful((Object)this.ipRecordsToResolved$1(lookup, resolved));
            }
            if (None$.MODULE$.equals(option)) {
                return this.askResolve$2(lookup, resolveTimeout, mode);
            }
            throw new MatchError((Object)option);
        }
        OptionVal$.MODULE$.None();
        SimpleDnsCache simpleDnsCache4 = simpleDnsCache;
        if (!(null != null ? !((Object)null).equals(simpleDnsCache4) : simpleDnsCache4 != null)) {
            return this.askResolve$2(lookup, resolveTimeout, mode);
        }
        SimpleDnsCache unexpected = simpleDnsCache;
        throw new RuntimeException(new StringBuilder(12).append("Unexpected: ").append(new OptionVal((Object)unexpected)).toString());
    }

    private final Future askResolve$1(FiniteDuration resolveTimeout$1, String srvRequest$1, DnsProtocol$Srv$ mode$1) {
        ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.dns);
        DnsProtocol.Resolve resolve = DnsProtocol.Resolve$.MODULE$.apply(srvRequest$1, (DnsProtocol.RequestType)mode$1);
        return AskableActorRef$.MODULE$.ask$extension(actorRef, (Object)resolve, Timeout$.MODULE$.durationToTimeout(resolveTimeout$1), AskableActorRef$.MODULE$.ask$default$3$extension(actorRef, (Object)resolve)).map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof DnsProtocol.Resolved) {
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)object;
                this.log.debug("{} lookup result: {}", (Object)mode$1, (Object)resolved);
                return DnsServiceDiscovery$.MODULE$.srvRecordsToResolved(srvRequest$1, resolved);
            }
            Object resolved = object;
            this.log.warning("Resolved UNEXPECTED (resolving to Nil): {}", resolved.getClass());
            return ServiceDiscovery$Resolved$.MODULE$.apply(srvRequest$1, (Seq<ServiceDiscovery.ResolvedTarget>)package$.MODULE$.Nil());
        }, (ExecutionContext)this.ec).recoverWith(this.convertToTimeout(resolveTimeout$1), (ExecutionContext)this.ec);
    }

    private final ServiceDiscovery.Resolved ipRecordsToResolved$1(Lookup lookup$1, DnsProtocol.Resolved resolved) {
        Seq addresses = (Seq)resolved.records().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ DnsServiceDiscovery $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(ResourceRecord x) {
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord a = (ARecord)resourceRecord;
                    return true;
                }
                if (resourceRecord instanceof AAAARecord) {
                    AAAARecord a = (AAAARecord)resourceRecord;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(ResourceRecord x, Function1 function1) {
                ResourceRecord resourceRecord = x;
                if (resourceRecord instanceof ARecord) {
                    ARecord a = (ARecord)resourceRecord;
                    return ServiceDiscovery$ResolvedTarget$.MODULE$.apply(this.$outer.org$apache$pekko$discovery$dns$DnsServiceDiscovery$$cleanIpString(a.ip().getHostAddress()), (Option<Object>)None$.MODULE$, (Option<InetAddress>)Some$.MODULE$.apply((Object)a.ip()));
                }
                if (resourceRecord instanceof AAAARecord) {
                    AAAARecord a = (AAAARecord)resourceRecord;
                    return ServiceDiscovery$ResolvedTarget$.MODULE$.apply(this.$outer.org$apache$pekko$discovery$dns$DnsServiceDiscovery$$cleanIpString(a.ip().getHostAddress()), (Option<Object>)None$.MODULE$, (Option<InetAddress>)Some$.MODULE$.apply((Object)a.ip()));
                }
                return function1.apply((Object)x);
            }
        });
        return ServiceDiscovery$Resolved$.MODULE$.apply(lookup$1.serviceName(), (Seq<ServiceDiscovery.ResolvedTarget>)addresses);
    }

    private final Future askResolve$2(Lookup lookup$2, FiniteDuration resolveTimeout$2, DnsProtocol.Ip mode$3) {
        ActorRef actorRef = org.apache.pekko.pattern.package$.MODULE$.ask(this.dns);
        DnsProtocol.Resolve resolve = DnsProtocol.Resolve$.MODULE$.apply(lookup$2.serviceName(), (DnsProtocol.RequestType)mode$3);
        return AskableActorRef$.MODULE$.ask$extension(actorRef, (Object)resolve, Timeout$.MODULE$.durationToTimeout(resolveTimeout$2), AskableActorRef$.MODULE$.ask$default$3$extension(actorRef, (Object)resolve)).map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof DnsProtocol.Resolved) {
                DnsProtocol.Resolved resolved = (DnsProtocol.Resolved)object;
                this.log.debug("{} lookup result: {}", (Object)mode$3, (Object)resolved);
                return this.ipRecordsToResolved$1(lookup$2, resolved);
            }
            Object resolved = object;
            this.log.warning("Resolved UNEXPECTED (resolving to Nil): {}", resolved.getClass());
            return ServiceDiscovery$Resolved$.MODULE$.apply(lookup$2.serviceName(), (Seq<ServiceDiscovery.ResolvedTarget>)package$.MODULE$.Nil());
        }, (ExecutionContext)this.ec).recoverWith(this.convertToTimeout(resolveTimeout$2), (ExecutionContext)this.ec);
    }
}

