/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery;

import java.net.InetAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.Lookup$;
import org.apache.pekko.discovery.ServiceDiscovery$Resolved$;
import org.apache.pekko.discovery.ServiceDiscovery$ResolvedTarget$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.OptionConverters;
import org.apache.pekko.util.OptionConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordering;

public abstract class ServiceDiscovery {
    public abstract Future<Resolved> lookup(Lookup var1, FiniteDuration var2);

    public Future<Resolved> lookup(String serviceName, FiniteDuration resolveTimeout) {
        return this.lookup(Lookup$.MODULE$.apply(serviceName), resolveTimeout);
    }

    public CompletionStage<Resolved> lookup(Lookup query, Duration resolveTimeout) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.lookup(query, FiniteDuration$.MODULE$.apply(resolveTimeout.toMillis(), TimeUnit.MILLISECONDS)));
        return FutureConverters.FutureOps$.MODULE$.asJava$extension(future);
    }

    public CompletionStage<Resolved> lookup(String serviceName, Duration resolveTimeout) {
        return this.lookup(Lookup$.MODULE$.apply(serviceName), resolveTimeout);
    }

    public static final class DiscoveryTimeoutException
    extends RuntimeException {
        public DiscoveryTimeoutException(String reason) {
            super(reason);
        }
    }

    public static final class Resolved
    implements DeadLetterSuppression,
    NoSerializationVerificationNeeded {
        private final String serviceName;
        private final Seq addresses;

        public static Resolved apply(String string, Seq<ResolvedTarget> seq) {
            return ServiceDiscovery$Resolved$.MODULE$.apply(string, seq);
        }

        public static Option<Tuple2<String, Seq<ResolvedTarget>>> unapply(Resolved resolved) {
            return ServiceDiscovery$Resolved$.MODULE$.unapply(resolved);
        }

        public Resolved(String serviceName, Seq<ResolvedTarget> addresses) {
            this.serviceName = serviceName;
            this.addresses = addresses;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public Seq<ResolvedTarget> addresses() {
            return this.addresses;
        }

        public List<ResolvedTarget> getAddresses() {
            return package.JavaConverters$.MODULE$.SeqHasAsJava(this.addresses()).asJava();
        }

        public String toString() {
            return new StringBuilder(11).append("Resolved(").append(this.serviceName()).append(",").append(this.addresses()).append(")").toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof Resolved)) return false;
            Resolved other = (Resolved)object;
            String string = this.serviceName();
            String string2 = other.serviceName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<ResolvedTarget> seq = this.addresses();
            Seq<ResolvedTarget> seq2 = other.addresses();
            if (seq == null) {
                if (seq2 == null) return true;
                return false;
            } else {
                if (!seq.equals(seq2)) return false;
                return true;
            }
        }

        public int hashCode() {
            int result = HashCode$.MODULE$.SEED();
            result = HashCode$.MODULE$.hash(result, (Object)this.serviceName());
            result = HashCode$.MODULE$.hash(result, this.addresses());
            return result;
        }
    }

    public static final class ResolvedTarget
    implements NoSerializationVerificationNeeded {
        private final String host;
        private final Option port;
        private final Option address;

        public static Ordering<ResolvedTarget> addressOrdering() {
            return ServiceDiscovery$ResolvedTarget$.MODULE$.addressOrdering();
        }

        public static ResolvedTarget apply(String string, Option<Object> option, Option<InetAddress> option2) {
            return ServiceDiscovery$ResolvedTarget$.MODULE$.apply(string, option, option2);
        }

        public ResolvedTarget(String host, Option<Object> port, Option<InetAddress> address) {
            this.host = host;
            this.port = port;
            this.address = address;
        }

        public String host() {
            return this.host;
        }

        public Option<Object> port() {
            return this.port;
        }

        public Option<InetAddress> address() {
            return this.address;
        }

        public Optional<Object> getPort() {
            Option option = OptionConverters$.MODULE$.RichOption(this.port());
            return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
        }

        public Optional<InetAddress> getAddress() {
            Option option = OptionConverters$.MODULE$.RichOption(this.address());
            return OptionConverters.RichOption$.MODULE$.toJava$extension(option);
        }

        public String toString() {
            return new StringBuilder(18).append("ResolvedTarget(").append(this.host()).append(",").append(this.port()).append(",").append(this.address()).append(")").toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            Object object = obj;
            if (!(object instanceof ResolvedTarget)) return false;
            ResolvedTarget other = (ResolvedTarget)object;
            String string = this.host();
            String string2 = other.host();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<Object> option = this.port();
            Option<Object> option2 = other.port();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<InetAddress> option3 = this.address();
            Option<InetAddress> option4 = other.address();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public int hashCode() {
            int result = HashCode$.MODULE$.SEED();
            result = HashCode$.MODULE$.hash(result, (Object)this.host());
            result = HashCode$.MODULE$.hash(result, this.port());
            result = HashCode$.MODULE$.hash(result, this.address());
            return result;
        }
    }
}

