/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.discovery.config;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.Lookup;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.discovery.ServiceDiscovery$Resolved$;
import org.apache.pekko.discovery.config.ConfigServicesParser$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;

@InternalApi
public class ConfigServiceDiscovery
extends ServiceDiscovery {
    private final Map<String, ServiceDiscovery.Resolved> resolvedServices;

    public ConfigServiceDiscovery(ExtendedActorSystem system) {
        LoggingAdapter log = Logging$.MODULE$.apply((ActorSystem)system, ConfigServiceDiscovery.class, LogSource$.MODULE$.fromAnyClass());
        this.resolvedServices = ConfigServicesParser$.MODULE$.parse(system.settings().config().getConfig(system.settings().config().getString("pekko.discovery.config.services-path")));
        log.debug("Config discovery serving: {}", this.resolvedServices);
    }

    @Override
    public Future<ServiceDiscovery.Resolved> lookup(Lookup lookup, FiniteDuration resolveTimeout) {
        return Future$.MODULE$.successful(this.resolvedServices.getOrElse((Object)lookup.serviceName(), () -> ConfigServiceDiscovery.lookup$$anonfun$1(lookup)));
    }

    private static final ServiceDiscovery.Resolved lookup$$anonfun$1(Lookup lookup$1) {
        return ServiceDiscovery$Resolved$.MODULE$.apply(lookup$1.serviceName(), (Seq<ServiceDiscovery.ResolvedTarget>)package$.MODULE$.Nil());
    }
}

