/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ddata.DurableStore;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAll$;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAllCompleted$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$WriteBehind$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeletedData$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.DirectByteBufferPool$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import org.lmdbjava.CursorIterator;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r}r!B%K\u0011\u0003)f!B,K\u0011\u0003A\u0006\"B0\u0002\t\u0003\u0001\u0007\"B1\u0002\t\u0003\u0011w!\u0002;\u0002\u0011\u0013+h!B<\u0002\u0011\u0013C\bBB0\u0006\t\u0003\t)\u0001C\u0005\u0002\b\u0015\t\t\u0011\"\u0011\u0002\n!I\u00111D\u0003\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0003K)\u0011\u0011!C\u0001\u0003OA\u0011\"a\r\u0006\u0003\u0003%\t%!\u000e\t\u0013\u0005\rS!!A\u0005\u0002\u0005\u0015\u0003\"CA(\u000b\u0005\u0005I\u0011IA)\u0011%\t\u0019&BA\u0001\n\u0003\n)\u0006C\u0005\u0002X\u0015\t\t\u0011\"\u0003\u0002Z\u00191\u0011\u0011M\u0001G\u0003GB!\"!\u001a\u0010\u0005+\u0007I\u0011AA4\u0011)\t\ti\u0004B\tB\u0003%\u0011\u0011\u000e\u0005\u000b\u0003\u0007{!Q3A\u0005\u0002\u0005\u0015\u0005BCAG\u001f\tE\t\u0015!\u0003\u0002\b\"Q\u0011qR\b\u0003\u0016\u0004%\t!!%\t\u0015\u0005MuB!E!\u0002\u0013\t)\b\u0003\u0006\u0002\u0016>\u0011)\u001a!C\u0001\u0003#C!\"a&\u0010\u0005#\u0005\u000b\u0011BA;\u0011\u0019yv\u0002\"\u0001\u0002\u001a\"I\u0011QU\b\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003c{\u0011\u0013!C\u0001\u0003gC\u0011\"!3\u0010#\u0003%\t!a3\t\u0013\u0005=w\"%A\u0005\u0002\u0005E\u0007\"CAk\u001fE\u0005I\u0011AAi\u0011%\t9aDA\u0001\n\u0003\nI\u0001C\u0005\u0002\u001c=\t\t\u0011\"\u0001\u0002\u001e!I\u0011QE\b\u0002\u0002\u0013\u0005\u0011q\u001b\u0005\n\u0003gy\u0011\u0011!C!\u0003kA\u0011\"a\u0011\u0010\u0003\u0003%\t!a7\t\u0013\u0005=s\"!A\u0005B\u0005E\u0003\"CA*\u001f\u0005\u0005I\u0011IA+\u0011%\tynDA\u0001\n\u0003\n\toB\u0005\u0002f\u0006\t\t\u0011#\u0003\u0002h\u001aI\u0011\u0011M\u0001\u0002\u0002#%\u0011\u0011\u001e\u0005\u0007?\u001e\"\t!a>\t\u0013\u0005Ms%!A\u0005F\u0005U\u0003\"CA}O\u0005\u0005I\u0011QA~\u0011%\u0011)aJA\u0001\n\u0003\u00139\u0001C\u0005\u0002X\u001d\n\t\u0011\"\u0003\u0002Z\u0019)qK\u0013\u0002\u0003\u001a!A!.\fB\u0001B\u0003%1\u000e\u0003\u0004`[\u0011\u0005!q\u0005\u0005\n\u0005[i#\u0019!C\u0001\u0005_A\u0001Ba\u000f.A\u0003%!\u0011\u0007\u0005\n\u0005{i#\u0019!C\u0001\u0005\u007fA\u0001Ba\u0012.A\u0003%!\u0011\t\u0005\n\u0005\u0013j#\u0019!C\u0001\u0005\u0017B\u0001B!\u0019.A\u0003%!Q\n\u0005\n\u0005Gj#\u0019!C\u0001\u0005KB\u0001Ba\u001e.A\u0003%!q\r\u0005\n\u0005sj#\u0019!C\u0001\u0005wB\u0001B!#.A\u0003%!Q\u0010\u0005\n\u0005\u0017k\u0003\u0019!C\u0005\u0005\u001bC\u0011Ba(.\u0001\u0004%IA!)\t\u0011\t-V\u0006)Q\u0005\u0005\u001fCqA!,.\t\u0013\u0011y\u000bC\u0004\u000326\"\tAa-\t\u000f\tUV\u0006\"\u0001\u00038\"I!QX\u0017C\u0002\u0013\u0005!q\u0018\u0005\t\u0005kl\u0003\u0015!\u0003\u0003B\"9!q_\u0017\u0005B\te\bbBB\t[\u0011\u000531\u0003\u0005\b\u0007+iC\u0011AB\f\u0011\u001d\u0019\t#\fC\u0001\u0007/Aqaa\t.\t\u0003\u00199\u0002C\u0004\u0004&5\"\taa\n\t\u000f\ruR\u0006\"\u0001\u0004\u0014\u0005\u0001B*\u001c3c\tV\u0014\u0018M\u00197f'R|'/\u001a\u0006\u0003\u00172\u000bQ\u0001\u001a3bi\u0006T!!\u0014(\u0002\u000f\rdWo\u001d;fe*\u0011q\nU\u0001\u0006a\u0016\\7n\u001c\u0006\u0003#J\u000ba!\u00199bG\",'\"A*\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005Y\u000bQ\"\u0001&\u0003!1kGM\u0019#ve\u0006\u0014G.Z*u_J,7CA\u0001Z!\tQV,D\u0001\\\u0015\u0005a\u0016!B:dC2\f\u0017B\u00010\\\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!V\u0001\u0006aJ|\u0007o\u001d\u000b\u0003G&\u0004\"\u0001Z4\u000e\u0003\u0015T!A\u001a(\u0002\u000b\u0005\u001cGo\u001c:\n\u0005!,'!\u0002)s_B\u001c\b\"\u00026\u0004\u0001\u0004Y\u0017AB2p]\u001aLw\r\u0005\u0002me6\tQN\u0003\u0002k]*\u0011q\u000e]\u0001\tif\u0004Xm]1gK*\t\u0011/A\u0002d_6L!a]7\u0003\r\r{gNZ5h\u0003-9&/\u001b;f\u0005\u0016D\u0017N\u001c3\u0011\u0005Y,Q\"A\u0001\u0003\u0017]\u0013\u0018\u000e^3CK\"Lg\u000eZ\n\u0006\u000beKHp \t\u0003IjL!a_3\u0003+\u0011+\u0017\r\u001a'fiR,'oU;qaJ,7o]5p]B\u0011!,`\u0005\u0003}n\u0013q\u0001\u0015:pIV\u001cG\u000fE\u0002[\u0003\u0003I1!a\u0001\\\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005)\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011\u0001\u00027b]\u001eT!!!\u0006\u0002\t)\fg/Y\u0005\u0005\u00033\tyA\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003?\u00012AWA\u0011\u0013\r\t\u0019c\u0017\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003S\ty\u0003E\u0002[\u0003WI1!!\f\\\u0005\r\te.\u001f\u0005\n\u0003cI\u0011\u0011!a\u0001\u0003?\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u001c!\u0019\tI$a\u0010\u0002*5\u0011\u00111\b\u0006\u0004\u0003{Y\u0016AC2pY2,7\r^5p]&!\u0011\u0011IA\u001e\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0013Q\n\t\u00045\u0006%\u0013bAA&7\n9!i\\8mK\u0006t\u0007\"CA\u0019\u0017\u0005\u0005\t\u0019AA\u0015\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0010\u0003!!xn\u0015;sS:<GCAA\u0006\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0003\u0003BA\u0007\u0003;JA!a\u0018\u0002\u0010\t1qJ\u00196fGR\u0014A\u0001T7eEN!q\"\u0017?\u0000\u0003\r)gN^\u000b\u0003\u0003S\u0002b!a\u001b\u0002r\u0005UTBAA7\u0015\r\tyGU\u0001\tY6$'M[1wC&!\u00111OA7\u0005\r)eN\u001e\t\u0005\u0003o\ni(\u0004\u0002\u0002z)!\u00111PA\n\u0003\rq\u0017n\\\u0005\u0005\u0003\u007f\nIH\u0001\u0006CsR,')\u001e4gKJ\fA!\u001a8wA\u0005\u0011AMY\u000b\u0003\u0003\u000f\u0003b!a\u001b\u0002\n\u0006U\u0014\u0002BAF\u0003[\u00121\u0001\u00122j\u0003\r!'\rI\u0001\nW\u0016L()\u001e4gKJ,\"!!\u001e\u0002\u0015-,\u0017PQ;gM\u0016\u0014\b%A\u0006wC2,XMQ;gM\u0016\u0014\u0018\u0001\u0004<bYV,')\u001e4gKJ\u0004CCCAN\u0003;\u000by*!)\u0002$B\u0011ao\u0004\u0005\b\u0003KB\u0002\u0019AA5\u0011\u001d\t\u0019\t\u0007a\u0001\u0003\u000fCq!a$\u0019\u0001\u0004\t)\bC\u0004\u0002\u0016b\u0001\r!!\u001e\u0002\t\r|\u0007/\u001f\u000b\u000b\u00037\u000bI+a+\u0002.\u0006=\u0006\"CA33A\u0005\t\u0019AA5\u0011%\t\u0019)\u0007I\u0001\u0002\u0004\t9\tC\u0005\u0002\u0010f\u0001\n\u00111\u0001\u0002v!I\u0011QS\r\u0011\u0002\u0003\u0007\u0011QO\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)L\u000b\u0003\u0002j\u0005]6FAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\r7,\u0001\u0006b]:|G/\u0019;j_:LA!a2\u0002>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011Q\u001a\u0016\u0005\u0003\u000f\u000b9,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005M'\u0006BA;\u0003o\u000babY8qs\u0012\"WMZ1vYR$C\u0007\u0006\u0003\u0002*\u0005e\u0007\"CA\u0019A\u0005\u0005\t\u0019AA\u0010)\u0011\t9%!8\t\u0013\u0005E\"%!AA\u0002\u0005%\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0002H\u0005\r\b\"CA\u0019K\u0005\u0005\t\u0019AA\u0015\u0003\u0011aU\u000e\u001a2\u0011\u0005Y<3\u0003B\u0014\u0002l~\u0004b\"!<\u0002t\u0006%\u0014qQA;\u0003k\nY*\u0004\u0002\u0002p*\u0019\u0011\u0011_.\u0002\u000fI,h\u000e^5nK&!\u0011Q_Ax\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u000b\u0003\u0003O\fQ!\u00199qYf$\"\"a'\u0002~\u0006}(\u0011\u0001B\u0002\u0011\u001d\t)G\u000ba\u0001\u0003SBq!a!+\u0001\u0004\t9\tC\u0004\u0002\u0010*\u0002\r!!\u001e\t\u000f\u0005U%\u00061\u0001\u0002v\u00059QO\\1qa2LH\u0003\u0002B\u0005\u0005+\u0001RA\u0017B\u0006\u0005\u001fI1A!\u0004\\\u0005\u0019y\u0005\u000f^5p]BY!L!\u0005\u0002j\u0005\u001d\u0015QOA;\u0013\r\u0011\u0019b\u0017\u0002\u0007)V\u0004H.\u001a\u001b\t\u0013\t]1&!AA\u0002\u0005m\u0015a\u0001=%aM1Q&\u0017B\u000e\u0005C\u00012\u0001\u001aB\u000f\u0013\r\u0011y\"\u001a\u0002\u0006\u0003\u000e$xN\u001d\t\u0004I\n\r\u0012b\u0001B\u0013K\na\u0011i\u0019;pe2{wmZ5oOR!!\u0011\u0006B\u0016!\t1V\u0006C\u0003k_\u0001\u00071.A\u0007tKJL\u0017\r\\5{CRLwN\\\u000b\u0003\u0005c\u0001BAa\r\u000385\u0011!Q\u0007\u0006\u0004\u0005[q\u0015\u0002\u0002B\u001d\u0005k\u0011QbU3sS\u0006d\u0017N_1uS>t\u0017AD:fe&\fG.\u001b>bi&|g\u000eI\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016\u0014XC\u0001B!!\u0011\u0011\u0019Da\u0011\n\t\t\u0015#Q\u0007\u0002\u001d'\u0016\u0014\u0018.\u00197ju\u0016\u0014x+\u001b;i'R\u0014\u0018N\\4NC:Lg-Z:u\u0003-\u0019XM]5bY&TXM\u001d\u0011\u0002\u00115\fg.\u001b4fgR,\"A!\u0014\u0011\t\t=#Q\f\b\u0005\u0005#\u0012I\u0006E\u0002\u0003Tmk!A!\u0016\u000b\u0007\t]C+\u0001\u0004=e>|GOP\u0005\u0004\u00057Z\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\t}#b\u0001B.7\u0006IQ.\u00198jM\u0016\u001cH\u000fI\u0001\u0014oJLG/\u001a\"fQ&tG-\u00138uKJ4\u0018\r\\\u000b\u0003\u0005O\u0002BA!\u001b\u0003t5\u0011!1\u000e\u0006\u0005\u0005[\u0012y'\u0001\u0005ekJ\fG/[8o\u0015\r\u0011\thW\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002\u0002B;\u0005W\u0012aBR5oSR,G)\u001e:bi&|g.\u0001\u000bxe&$XMQ3iS:$\u0017J\u001c;feZ\fG\u000eI\u0001\u0004I&\u0014XC\u0001B?!\u0011\u0011yH!\"\u000e\u0005\t\u0005%\u0002\u0002BB\u0003'\t!![8\n\t\t\u001d%\u0011\u0011\u0002\u0005\r&dW-\u0001\u0003eSJ\u0004\u0013!B0m[\u0012\u0014WC\u0001BH!\u0019\u0011\tJa&\u0003\u001c6\u0011!1\u0013\u0006\u0004\u0005+s\u0015\u0001B;uS2LAA!'\u0003\u0014\nIq\n\u001d;j_:4\u0016\r\u001c\t\u0004\u0005;{aB\u0001,\u0001\u0003%yF.\u001c3c?\u0012*\u0017\u000f\u0006\u0003\u0003$\n%\u0006c\u0001.\u0003&&\u0019!qU.\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003cY\u0014\u0011!a\u0001\u0005\u001f\u000baa\u00187nI\n\u0004\u0013\u0001\u00027nI\n$\"Aa'\u0002\u001f%\u001cHIY%oSRL\u0017\r\\5{K\u0012,\"!a\u0012\u0002+\u0015t7/\u001e:f-\u0006dW/\u001a\"vM\u001a,'oU5{KR!!1\u0015B]\u0011\u001d\u0011Yl\u0010a\u0001\u0003?\tAa]5{K\u00069\u0001/\u001a8eS:<WC\u0001Ba!!\u0011\u0019Ma2\u0003L\n\u001dXB\u0001Bc\u0015\u0011\u0011)*a\u0005\n\t\t%'Q\u0019\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\u0011iM!9\u000f\t\t='Q\u001c\b\u0005\u0005#\u0014YN\u0004\u0003\u0003T\neg\u0002\u0002Bk\u0005/l\u0011\u0001U\u0005\u0003\u001fBK!!\u0014(\n\u0005-c\u0015b\u0001Bp\u0015\u0006\u00191*Z=\n\t\t\r(Q\u001d\u0002\u0006\u0017\u0016L\u0018\n\u001a\u0006\u0004\u0005?T\u0005\u0003\u0002Bu\u0005_t1A\u0016Bv\u0013\r\u0011iOS\u0001\r\tV\u0014\u0018M\u00197f'R|'/Z\u0005\u0005\u0005c\u0014\u0019PA\nEkJ\f'\r\\3ECR\fWI\u001c<fY>\u0004XMC\u0002\u0003n*\u000b\u0001\u0002]3oI&tw\rI\u0001\fa>\u001cHOU3ti\u0006\u0014H\u000f\u0006\u0003\u0003$\nm\bb\u0002B\u007f\u0005\u0002\u0007!q`\u0001\u0007e\u0016\f7o\u001c8\u0011\t\r\u000511\u0002\b\u0005\u0007\u0007\u00199A\u0004\u0003\u0003T\r\u0015\u0011\"\u0001/\n\u0007\r%1,A\u0004qC\u000e\\\u0017mZ3\n\t\r51q\u0002\u0002\n)\"\u0014xn^1cY\u0016T1a!\u0003\\\u0003!\u0001xn\u001d;Ti>\u0004HC\u0001BR\u0003\u001d\u0011XmY3jm\u0016,\"a!\u0007\u0011\t\rm1QD\u0007\u0002[%!1q\u0004B\u000f\u0005\u001d\u0011VmY3jm\u0016\fA!\u001b8ji\u00061\u0011m\u0019;jm\u0016\fQ\u0001\u001a2QkR$\u0002Ba)\u0004*\rU2\u0011\b\u0005\b\u0007W9\u0005\u0019AB\u0017\u0003\t!\b\u0010\u0005\u0004\u0003\u0012\n]5q\u0006\t\u0007\u0003W\u001a\t$!\u001e\n\t\rM\u0012Q\u000e\u0002\u0004)bt\u0007bBB\u001c\u000f\u0002\u0007!1Z\u0001\u0004W\u0016L\bbBB\u001e\u000f\u0002\u0007!q]\u0001\u0005I\u0006$\u0018-A\u0006xe&$XMQ3iS:$\u0007")
public final class LmdbDurableStore
implements Actor,
ActorLogging {
    private final Config config;
    private final Serialization serialization;
    private final SerializerWithStringManifest serializer;
    private final String manifest;
    private final FiniteDuration writeBehindInterval;
    private final File dir;
    private Lmdb _lmdb;
    private final HashMap<String, DurableStore.DurableDataEnvelope> pending;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public static Props props(Config config) {
        return LmdbDurableStore$.MODULE$.props(config);
    }

    public LoggingAdapter log() {
        return ActorLogging.log$((ActorLogging)this);
    }

    public final ActorRef sender() {
        return Actor.sender$((Actor)this);
    }

    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$((Actor)this, receive2, (Object)msg);
    }

    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$((Actor)this);
    }

    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$((Actor)this);
    }

    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$((Actor)this, (Throwable)reason, message);
    }

    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.preStart$((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$((Actor)this, (Throwable)reason, message);
    }

    public void unhandled(Object message) {
        Actor.unhandled$((Actor)this, (Object)message);
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public SerializerWithStringManifest serializer() {
        return this.serializer;
    }

    public String manifest() {
        return this.manifest;
    }

    public FiniteDuration writeBehindInterval() {
        return this.writeBehindInterval;
    }

    public File dir() {
        return this.dir;
    }

    private Lmdb _lmdb() {
        return this._lmdb;
    }

    private void _lmdb_$eq(Lmdb x$1) {
        this._lmdb = x$1;
    }

    public Lmdb org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb() {
        Lmdb lmdb = this._lmdb();
        Lmdb lmdb2 = (Lmdb)OptionVal.Some$.MODULE$.unapply((Object)lmdb);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lmdb2)) {
            Lmdb l = (Lmdb)OptionVal$.MODULE$.get$extension((Object)lmdb2);
            return l;
        }
        long t0 = System.nanoTime();
        this.log().info("Using durable data in LMDB directory [{}]", (Object)this.dir().getCanonicalPath());
        Long mapSize = this.config.getBytes("lmdb.map-size");
        this.dir().mkdirs();
        Env env = Env.create().setMapSize(Predef$.MODULE$.Long2long(mapSize)).setMaxDbs(1).open(this.dir(), new EnvFlags[]{EnvFlags.MDB_NOLOCK});
        Dbi db = env.openDbi("ddata", new DbiFlags[]{DbiFlags.MDB_CREATE});
        ByteBuffer keyBuffer = ByteBuffer.allocateDirect(env.getMaxKeySize());
        ByteBuffer valueBuffer = ByteBuffer.allocateDirect(102400);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Init of LMDB in directory [{}] took [{} ms]", (Object)this.dir().getCanonicalPath(), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
        }
        Lmdb l = new Lmdb((Env<ByteBuffer>)env, (Dbi<ByteBuffer>)db, keyBuffer, valueBuffer);
        this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)l));
        return l;
    }

    public boolean isDbInitialized() {
        return OptionVal$.MODULE$.isDefined$extension((Object)this._lmdb());
    }

    public void ensureValueBufferSize(int size) {
        ByteBuffer valueBuffer = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb().valueBuffer();
        if (valueBuffer.remaining() < size) {
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(valueBuffer);
            Lmdb qual$1 = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            ByteBuffer x$1 = ByteBuffer.allocateDirect(size * 2);
            Env<ByteBuffer> x$2 = qual$1.copy$default$1();
            Dbi<ByteBuffer> x$3 = qual$1.copy$default$2();
            ByteBuffer x$4 = qual$1.copy$default$3();
            this._lmdb_$eq((Lmdb)OptionVal.Some$.MODULE$.apply((Object)qual$1.copy(x$2, x$3, x$4, x$1)));
            return;
        }
    }

    public HashMap<String, DurableStore.DurableDataEnvelope> pending() {
        return this.pending;
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        this.context().become(this.active());
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.writeBehind();
        if (this.isDbInitialized()) {
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> l.db().close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> l.env().close());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.keyBuffer());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.valueBuffer());
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.init();
    }

    public PartialFunction<Object, BoxedUnit> init() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (DurableStore$LoadAll$.MODULE$.equals(A1)) {
                    if (this.$outer.dir().exists() && this.$outer.dir().list().length > 0) {
                        BoxedUnit boxedUnit;
                        Lmdb l = this.$outer.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
                        long t0 = System.nanoTime();
                        Txn tx = l.env().txnRead();
                        try {
                            try {
                                CursorIterator iter = l.db().iterate(tx);
                                try {
                                    IntRef n = IntRef.create((int)0);
                                    DurableStore.LoadData loadData = new DurableStore.LoadData((Map<String, DurableStore.DurableDataEnvelope>)((Iterator)package.JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)iter).asScala()).map((Function1 & Serializable & scala.Serializable)entry -> {
                                        ++n$1.elem;
                                        byte[] keyArray = new byte[((Buffer)entry.key()).remaining()];
                                        ((ByteBuffer)entry.key()).get(keyArray);
                                        String key = new String(keyArray, ByteString$.MODULE$.UTF_8());
                                        byte[] valArray = new byte[((Buffer)entry.val()).remaining()];
                                        ((ByteBuffer)entry.val()).get(valArray);
                                        DurableStore.DurableDataEnvelope envelope = (DurableStore.DurableDataEnvelope)$this.$outer.serializer().fromBinary(valArray, $this.$outer.manifest());
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)envelope);
                                    }).toMap(Predef$.MODULE$.$conforms()));
                                    if (loadData.data().nonEmpty()) {
                                        this.$outer.sender().$bang((Object)loadData, this.$outer.self());
                                    }
                                    this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                                    if (this.$outer.log().isDebugEnabled()) {
                                        this.$outer.log().debug("load all of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)n.elem), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                                    }
                                    this.$outer.context().become(this.$outer.active());
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                finally {
                                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> iter.close());
                                }
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                Option option = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option.isEmpty()) {
                                    Throwable e = (Throwable)option.get();
                                    throw new DurableStore.LoadFailed("failed to load durable distributed-data", e);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> tx.close());
                        }
                        return (B1)boxedUnit;
                    }
                    this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                    this.$outer.context().become(this.$outer.active());
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                return DurableStore$LoadAll$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.pekko.cluster.ddata.LmdbDurableStore$$anonfun$init$1 scala.runtime.IntRef org.lmdbjava.CursorIterator$KeyVal ), $anonfun$applyOrElse$2(org.lmdbjava.CursorIterator ), $anonfun$applyOrElse$3(org.lmdbjava.Txn )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LmdbDurableStore $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DurableStore.Store) {
                    BoxedUnit boxedUnit;
                    DurableStore.Store store = (DurableStore.Store)A1;
                    String key = store.key();
                    DurableStore.DurableDataEnvelope data = store.data();
                    Option<DurableStore.StoreReply> reply = store.reply();
                    try {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Object object;
                        this.$outer.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
                        if (this.$outer.writeBehindInterval().length() == 0L) {
                            OptionVal$.MODULE$.None();
                            this.$outer.dbPut(null, key, data);
                            object = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit2;
                            if (this.$outer.pending().isEmpty()) {
                                Scheduler qual$1 = this.$outer.context().system().scheduler();
                                FiniteDuration x$1 = this.$outer.writeBehindInterval();
                                ActorRef x$2 = this.$outer.self();
                                LmdbDurableStore$WriteBehind$ x$3 = LmdbDurableStore$WriteBehind$.MODULE$;
                                ExecutionContextExecutor x$4 = this.$outer.context().dispatcher();
                                ActorRef x$5 = qual$1.scheduleOnce$default$5(x$1, x$2, (Object)x$3);
                                boxedUnit2 = qual$1.scheduleOnce(x$1, x$2, (Object)x$3, (ExecutionContext)x$4, x$5);
                            } else {
                                boxedUnit2 = BoxedUnit.UNIT;
                            }
                            object = this.$outer.pending().put(key, data);
                        }
                        Option<DurableStore.StoreReply> option = reply;
                        if (option instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option).value()) != null) {
                            Object successMsg = storeReply.successMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            replyTo.$bang(successMsg, this.$outer.self());
                        } else if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                        boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }
                    catch (Throwable throwable) {
                        Some some;
                        DurableStore.StoreReply storeReply;
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) throw throwable;
                        Throwable e = (Throwable)option.get();
                        this.$outer.log().error(e, "failed to store [{}]", (Object)key);
                        Option<DurableStore.StoreReply> option2 = reply;
                        if (option2 instanceof Some && (storeReply = (DurableStore.StoreReply)(some = (Some)option2).value()) != null) {
                            Object failureMsg = storeReply.failureMsg();
                            ActorRef replyTo = storeReply.replyTo();
                            replyTo.$bang(failureMsg, this.$outer.self());
                        } else if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (B1)boxedUnit;
                }
                if (!LmdbDurableStore$WriteBehind$.MODULE$.equals(A1)) return (B1)function1.apply(x1);
                this.$outer.writeBehind();
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                if (object instanceof DurableStore.Store) {
                    return true;
                }
                return LmdbDurableStore$WriteBehind$.MODULE$.equals(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void dbPut(Txn<ByteBuffer> tx, String key, DurableStore.DurableDataEnvelope data) {
        try {
            byte[] value = this.serializer().toBinary((Object)data);
            this.ensureValueBufferSize(value.length);
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().put(key.getBytes(ByteString$.MODULE$.UTF_8())).flip();
            l.valueBuffer().put(value).flip();
            Txn<ByteBuffer> txn = tx;
            Txn txn2 = (Txn)OptionVal.Some$.MODULE$.unapply(txn);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)txn2)) {
                Txn t = (Txn)OptionVal$.MODULE$.get$extension((Object)txn2);
                l.db().put(t, (Object)l.keyBuffer(), (Object)l.valueBuffer(), new PutFlags[0]);
            } else {
                l.db().put((Object)l.keyBuffer(), (Object)l.valueBuffer());
            }
        }
        finally {
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().clear();
            l.valueBuffer().clear();
        }
    }

    public void writeBehind() {
        if (!this.pending().isEmpty()) {
            block9: {
                long t0 = System.nanoTime();
                Txn tx = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb().env().txnWrite();
                try {
                    try {
                        for (Map.Entry<String, DurableStore.DurableDataEnvelope> entry : this.pending().entrySet()) {
                            this.dbPut((Txn<ByteBuffer>)((Txn)OptionVal.Some$.MODULE$.apply((Object)tx)), entry.getKey(), entry.getValue());
                        }
                        tx.commit();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store and commit of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)this.pending().size()), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.log().error(e, "failed to store [{}]", (Object)((TraversableOnce)package.JavaConverters$.MODULE$.asScalaSetConverter(this.pending().keySet()).asScala()).mkString(","));
                            tx.abort();
                            break block9;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.pending().clear();
                }
            }
            return;
        }
    }

    public LmdbDurableStore(Config config) {
        this.config = config;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.serializer = (SerializerWithStringManifest)this.serialization().serializerFor(DurableStore.DurableDataEnvelope.class);
        this.manifest = this.serializer().manifest((Object)new DurableStore.DurableDataEnvelope(Replicator$Internal$DeletedData$.MODULE$));
        String string = config.getString("lmdb.write-behind-interval").toLowerCase();
        this.writeBehindInterval = "off".equals(string) ? Duration$.MODULE$.Zero() : new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("lmdb.write-behind-interval", TimeUnit.MILLISECONDS))).millis();
        String string2 = config.getString("lmdb.dir");
        this.dir = string2.endsWith("ddata") ? new File(new StringBuilder(3).append(string2).append("-").append(this.context().system().name()).append("-").append(this.self().path().parent().name()).append("-").append(((Cluster)Cluster$.MODULE$.apply(this.context().system())).selfAddress().port().get()).toString()) : new File(string2);
        OptionVal$.MODULE$.None();
        this._lmdb = null;
        this.pending = new HashMap();
    }

    private static final class Lmdb
    implements Product,
    scala.Serializable {
        private final Env<ByteBuffer> env;
        private final Dbi<ByteBuffer> db;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;

        public Env<ByteBuffer> env() {
            return this.env;
        }

        public Dbi<ByteBuffer> db() {
            return this.db;
        }

        public ByteBuffer keyBuffer() {
            return this.keyBuffer;
        }

        public ByteBuffer valueBuffer() {
            return this.valueBuffer;
        }

        public Lmdb copy(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            return new Lmdb(env, db, keyBuffer, valueBuffer);
        }

        public Env<ByteBuffer> copy$default$1() {
            return this.env();
        }

        public Dbi<ByteBuffer> copy$default$2() {
            return this.db();
        }

        public ByteBuffer copy$default$3() {
            return this.keyBuffer();
        }

        public ByteBuffer copy$default$4() {
            return this.valueBuffer();
        }

        public String productPrefix() {
            return "Lmdb";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.env();
                }
                case 1: {
                    return this.db();
                }
                case 2: {
                    return this.keyBuffer();
                }
                case 3: {
                    return this.valueBuffer();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Lmdb;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Lmdb)) return false;
            boolean bl = true;
            if (!bl) return false;
            Lmdb lmdb = (Lmdb)x$1;
            Env<ByteBuffer> env = this.env();
            Env<ByteBuffer> env2 = lmdb.env();
            if (env == null) {
                if (env2 != null) {
                    return false;
                }
            } else if (!env.equals(env2)) return false;
            Dbi<ByteBuffer> dbi = this.db();
            Dbi<ByteBuffer> dbi2 = lmdb.db();
            if (dbi == null) {
                if (dbi2 != null) {
                    return false;
                }
            } else if (!dbi.equals(dbi2)) return false;
            ByteBuffer byteBuffer = this.keyBuffer();
            ByteBuffer byteBuffer2 = lmdb.keyBuffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            ByteBuffer byteBuffer3 = this.valueBuffer();
            ByteBuffer byteBuffer4 = lmdb.valueBuffer();
            if (byteBuffer3 == null) {
                if (byteBuffer4 == null) return true;
                return false;
            } else {
                if (!((Object)byteBuffer3).equals(byteBuffer4)) return false;
                return true;
            }
        }

        public Lmdb(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.env = env;
            this.db = db;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
            Product.$init$((Product)this);
        }
    }
}

