/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001E4QAD\b\u0001'eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0006\u0001BC\u0002\u0013\u0005Q\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015y\u0003\u0001\"\u00011\u0011\u001d1\u0004A1A\u0005\n5Baa\u000e\u0001!\u0002\u0013I\u0003b\u0002\u001d\u0001\u0001\u0004%I!\u000f\u0005\b\u0011\u0002\u0001\r\u0011\"\u0003J\u0011\u0019y\u0005\u0001)Q\u0005u!)\u0001\u000b\u0001C\u0001#\")A\r\u0001C\u0001K\")q\r\u0001C\u0001Q\n)\u0002+Y=m_\u0006$7+\u001b>f\u0003\u001e<'/Z4bi>\u0014(B\u0001\t\u0012\u0003\u0015!G-\u0019;b\u0015\t\u00112#A\u0004dYV\u001cH/\u001a:\u000b\u0005Q)\u0012!\u00029fW.|'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\rawnZ\u0002\u0001!\t\u0019c%D\u0001%\u0015\t)3#A\u0003fm\u0016tG/\u0003\u0002(I\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018\u0001\u00057pONK'0Z#yG\u0016,G-\u001b8h!\tY\"&\u0003\u0002,9\t\u0019\u0011J\u001c;\u0002\u00195\f\u0007P\u0012:b[\u0016\u001c\u0016N_3\u0016\u0003%\nQ\"\\1y\rJ\fW.Z*ju\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u00032gQ*\u0004C\u0001\u001a\u0001\u001b\u0005y\u0001\"\u0002\u0011\u0006\u0001\u0004\u0011\u0003\"\u0002\u0015\u0006\u0001\u0004I\u0003\"\u0002\u0017\u0006\u0001\u0004I\u0013!E<be:\u001c\u0016N_3Fq\u000e,W\rZ5oO\u0006\u0011r/\u0019:o'&TX-\u0012=dK\u0016$\u0017N\\4!\u0003=i\u0017\r\u001f)bs2|\u0017\r\u001a\"zi\u0016\u001cX#\u0001\u001e\u0011\tm\u0012U)\u000b\b\u0003y\u0001\u0003\"!\u0010\u000f\u000e\u0003yR!aP\u0011\u0002\rq\u0012xn\u001c;?\u0013\t\tE$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u00131!T1q\u0015\t\tE\u0004\u0005\u0002<\r&\u0011q\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u0002'5\f\u0007\u0010U1zY>\fGMQ=uKN|F%Z9\u0015\u0005)k\u0005CA\u000eL\u0013\taED\u0001\u0003V]&$\bb\u0002(\n\u0003\u0003\u0005\rAO\u0001\u0004q\u0012\n\u0014\u0001E7bqB\u000b\u0017\u0010\\8bI\nKH/Z:!\u0003E)\b\u000fZ1uKB\u000b\u0017\u0010\\8bINK'0\u001a\u000b\u0004\u0015J\u0013\u0007\"B*\f\u0001\u0004!\u0016aA6fsB\u0011Qk\u0018\b\u0003-vs!a\u0016/\u000f\u0005a[fBA-[\u001b\u0005)\u0012B\u0001\u000b\u0016\u0013\t\u00112#\u0003\u0002\u0011#%\u0011alD\u0001\u0004\u0017\u0016L\u0018B\u00011b\u0005\u0015YU-_%e\u0015\tqv\u0002C\u0003d\u0017\u0001\u0007\u0011&\u0001\u0003tSj,\u0017AC4fi6\u000b\u0007pU5{KR\u0011\u0011F\u001a\u0005\u0006'2\u0001\r\u0001V\u0001\u0007e\u0016lwN^3\u0015\u0005)K\u0007\"B*\u000e\u0001\u0004!\u0006F\u0001\u0001l!\taw.D\u0001n\u0015\tq7#\u0001\u0006b]:|G/\u0019;j_:L!\u0001]7\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b")
@InternalApi
public class PayloadSizeAggregator {
    private final LoggingAdapter log;
    private final int logSizeExceeding;
    private final int maxFrameSize;
    private final int warnSizeExceeding;
    private Map<String, Object> maxPayloadBytes;

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    private int warnSizeExceeding() {
        return this.warnSizeExceeding;
    }

    private Map<String, Object> maxPayloadBytes() {
        return this.maxPayloadBytes;
    }

    private void maxPayloadBytes_$eq(Map<String, Object> x$1) {
        this.maxPayloadBytes = x$1;
    }

    public void updatePayloadSize(String key, int size) {
        if (size > 0) {
            Option option = this.maxPayloadBytes().get((Object)key);
            if (option instanceof Some) {
                Some some = (Some)option;
                int max = BoxesRunTime.unboxToInt((Object)some.value());
                if (size > max) {
                    this.maxPayloadBytes_$eq((Map<String, Object>)this.maxPayloadBytes().updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)PayloadSizeAggregator.newMax$1(size))));
                    if (size >= this.logSizeExceeding) {
                        this.logSize$1(size, key);
                        return;
                    }
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.maxPayloadBytes_$eq((Map<String, Object>)this.maxPayloadBytes().updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)PayloadSizeAggregator.newMax$1(size))));
                if (size >= this.logSizeExceeding) {
                    this.logSize$1(size, key);
                    return;
                }
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public int getMaxSize(String key) {
        return BoxesRunTime.unboxToInt((Object)this.maxPayloadBytes().getOrElse((Object)key, (Function0)(JFunction0.mcI.sp & java.io.Serializable & Serializable)() -> 0));
    }

    public void remove(String key) {
        this.maxPayloadBytes_$eq((Map<String, Object>)((Map)this.maxPayloadBytes().$minus((Object)key)));
    }

    private static final int newMax$1(int size$1) {
        return (int)((double)size$1 * 1.1);
    }

    private final void logSize$1(int size$1, String key$1) {
        if (size$1 >= this.warnSizeExceeding()) {
            this.log.warning("Distributed data size for [{}] is [{}] bytes. Close to max remote message payload size.", (Object)key$1, (Object)BoxesRunTime.boxToInteger((int)size$1));
            return;
        }
        this.log.info("Distributed data size for [{}] is [{}] bytes.", (Object)key$1, (Object)BoxesRunTime.boxToInteger((int)size$1));
    }

    public PayloadSizeAggregator(LoggingAdapter log, int logSizeExceeding, int maxFrameSize) {
        this.log = log;
        this.logSizeExceeding = logSizeExceeding;
        this.maxFrameSize = maxFrameSize;
        this.warnSizeExceeding = maxFrameSize * 3 / 4;
        this.maxPayloadBytes = Predef$.MODULE$.Map().empty();
    }
}

