/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.ReplicatedDelta;
import org.apache.pekko.cluster.ddata.ReplicatedDeltaSize;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeltaPropagation$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

@InternalApi
public interface DeltaPropagationSelector {
    public static void $init$(DeltaPropagationSelector $this) {
        $this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount_$eq(0L);
        $this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter_$eq((Map<String, Object>)Predef$.MODULE$.Map().empty());
        $this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq((Map<String, TreeMap<Object, ReplicatedData>>)Predef$.MODULE$.Map().empty());
        $this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode_$eq((Map<String, Map<UniqueAddress, Object>>)Predef$.MODULE$.Map().empty());
        $this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter_$eq(0L);
    }

    public long org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount();

    public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount_$eq(long var1);

    public static long propagationCount$(DeltaPropagationSelector $this) {
        return $this.propagationCount();
    }

    default public long propagationCount() {
        return this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount();
    }

    public Map<String, Object> org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter();

    public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter_$eq(Map<String, Object> var1);

    public Map<String, TreeMap<Object, ReplicatedData>> org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries();

    public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq(Map<String, TreeMap<Object, ReplicatedData>> var1);

    public Map<String, Map<UniqueAddress, Object>> org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode();

    public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode_$eq(Map<String, Map<UniqueAddress, Object>> var1);

    public long org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter();

    public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter_$eq(long var1);

    public int gossipIntervalDivisor();

    public Vector<UniqueAddress> allNodes();

    public Replicator.Internal.DeltaPropagation createDeltaPropagation(Map<String, Tuple3<ReplicatedData, Object, Object>> var1);

    public int maxDeltaSize();

    public static long currentVersion$(DeltaPropagationSelector $this, String key) {
        return $this.currentVersion(key);
    }

    default public long currentVersion(String key) {
        Option option = this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter().get((Object)key);
        if (option instanceof Some) {
            long v = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return v;
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    public static void update$(DeltaPropagationSelector $this, String key, ReplicatedData delta) {
        $this.update(key, delta);
    }

    default public void update(String key, ReplicatedData delta) {
        TreeMap treeMap;
        long l;
        Option option = this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter().get((Object)key);
        if (option instanceof Some) {
            long c = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            l = c + 1L;
        } else if (None$.MODULE$.equals(option)) {
            l = 1L;
        } else {
            throw new MatchError((Object)option);
        }
        long version = l;
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter_$eq((Map<String, Object>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter().updated((Object)key, (Object)BoxesRunTime.boxToLong((long)version))));
        Option option2 = this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries().get((Object)key);
        if (option2 instanceof Some) {
            TreeMap m;
            treeMap = m = (TreeMap)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            treeMap = TreeMap$.MODULE$.empty((Ordering)Ordering.Long$.MODULE$);
        } else {
            throw new MatchError((Object)option2);
        }
        TreeMap deltaEntriesForKey = treeMap;
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq((Map<String, TreeMap<Object, ReplicatedData>>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries().updated((Object)key, (Object)deltaEntriesForKey.updated((Object)BoxesRunTime.boxToLong((long)version), (Object)delta))));
    }

    public static void delete$(DeltaPropagationSelector $this, String key) {
        $this.delete(key);
    }

    default public void delete(String key) {
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq((Map<String, TreeMap<Object, ReplicatedData>>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries().$minus((Object)key)));
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter_$eq((Map<String, Object>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter().$minus((Object)key)));
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode_$eq((Map<String, Map<UniqueAddress, Object>>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode().$minus((Object)key)));
    }

    public static int nodesSliceSize$(DeltaPropagationSelector $this, int allNodesSize) {
        return $this.nodesSliceSize(allNodesSize);
    }

    default public int nodesSliceSize(int allNodesSize) {
        return package$.MODULE$.min(package$.MODULE$.max(allNodesSize / this.gossipIntervalDivisor() + 1, 2), package$.MODULE$.min(allNodesSize, 10));
    }

    public static Map collectPropagations$(DeltaPropagationSelector $this) {
        return $this.collectPropagations();
    }

    default public Map<UniqueAddress, Replicator.Internal.DeltaPropagation> collectPropagations() {
        int i;
        Vector first;
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount_$eq(this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount() + 1L);
        Vector all = this.allNodes();
        if (all.isEmpty()) {
            return Predef$.MODULE$.Map().empty();
        }
        int sliceSize = this.nodesSliceSize(all.size());
        Vector slice = all.size() <= sliceSize ? all : ((first = (Vector)all.slice(i = (int)(this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter() % (long)all.size()), i + sliceSize)).size() == sliceSize ? first : (Vector)first.$plus$plus((IterableOnce)all.take(sliceSize - first.size())));
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter_$eq(this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter() + (long)sliceSize);
        ObjectRef result = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef cache = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        slice.foreach((Function1)(JProcedure1 & Serializable)node -> {
            ObjectRef deltas = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
            this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Map deltaSentToNodeForKey;
                    long j;
                    String key = (String)tuple2._1();
                    TreeMap entries = (TreeMap)tuple2._2();
                    TreeMap<Object, ReplicatedData> deltaEntriesAfterJ = this.deltaEntriesAfter((TreeMap<Object, ReplicatedData>)entries, j = BoxesRunTime.unboxToLong((Object)(deltaSentToNodeForKey = (Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode().getOrElse((Object)key, DeltaPropagationSelector::$anonfun$1)).getOrElse(node, DeltaPropagationSelector::$anonfun$2)));
                    if (deltaEntriesAfterJ.nonEmpty()) {
                        ReplicatedData replicatedData;
                        long fromSeqNr = BoxesRunTime.unboxToLong((Object)deltaEntriesAfterJ.head()._1());
                        long toSeqNr = BoxesRunTime.unboxToLong((Object)deltaEntriesAfterJ.last()._1());
                        Tuple3 cacheKey = Tuple3$.MODULE$.apply((Object)key, (Object)BoxesRunTime.boxToLong((long)fromSeqNr), (Object)BoxesRunTime.boxToLong((long)toSeqNr));
                        Option option = ((Map)cache$1.elem).get((Object)cacheKey);
                        if (None$.MODULE$.equals(option)) {
                            ReplicatedData group = (ReplicatedData)deltaEntriesAfterJ.valuesIterator().reduceLeft((Function2 & Serializable)(d1, d2) -> {
                                ReplicatedData s;
                                ReplicatedData replicatedData = d2;
                                ReplicatedDelta replicatedDelta = Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder();
                                ReplicatedData replicatedData2 = replicatedData;
                                ReplicatedData merged = !(replicatedDelta != null ? !replicatedDelta.equals(replicatedData2) : replicatedData2 != null) ? Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder() : d1.merge((ReplicatedData)d2);
                                ReplicatedData replicatedData3 = merged;
                                if (replicatedData3 instanceof ReplicatedDeltaSize && ((ReplicatedDeltaSize)((Object)(s = (ReplicatedData)((Object)((ReplicatedDeltaSize)((Object)replicatedData3)))))).deltaSize() >= this.maxDeltaSize()) {
                                    return Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder();
                                }
                                return merged;
                            });
                            Map map = (Map)((Map)cache$1.elem).updated((Object)cacheKey, (Object)group);
                            cache$1.elem = map;
                            map = null;
                            replicatedData = group;
                        } else if (option instanceof Some) {
                            ReplicatedData group;
                            replicatedData = group = (ReplicatedData)((Some)option).value();
                        } else {
                            throw new MatchError((Object)option);
                        }
                        ReplicatedData deltaGroup = replicatedData;
                        Map map = (Map)((Map)deltas$1.elem).updated((Object)key, (Object)Tuple3$.MODULE$.apply((Object)deltaGroup, (Object)BoxesRunTime.boxToLong((long)fromSeqNr), (Object)BoxesRunTime.boxToLong((long)toSeqNr)));
                        deltas$1.elem = map;
                        map = null;
                        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode_$eq((Map<String, Map<UniqueAddress, Object>>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode().updated((Object)key, (Object)deltaSentToNodeForKey.updated(node, deltaEntriesAfterJ.lastKey()))));
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            if (((Map)deltas.elem).nonEmpty()) {
                Replicator.Internal.DeltaPropagation deltaPropagation = this.createDeltaPropagation((Map<String, Tuple3<ReplicatedData, Object, Object>>)((Map)deltas.elem));
                Map map = (Map)((Map)result$1.elem).updated(node, (Object)deltaPropagation);
                result$1.elem = map;
                map = null;
                return;
            }
        });
        return (Map)result.elem;
    }

    private TreeMap<Object, ReplicatedData> deltaEntriesAfter(TreeMap<Object, ReplicatedData> entries, long version) {
        TreeMap treeMap = (TreeMap)entries.rangeFrom((Object)BoxesRunTime.boxToLong((long)version));
        TreeMap ntrs = treeMap;
        if (ntrs.isEmpty()) {
            return ntrs;
        }
        TreeMap ntrs2 = treeMap;
        if (BoxesRunTime.unboxToLong((Object)ntrs2.firstKey()) == version) {
            return ntrs2.tail();
        }
        TreeMap ntrs3 = treeMap;
        return ntrs3;
    }

    public static boolean hasDeltaEntries$(DeltaPropagationSelector $this, String key) {
        return $this.hasDeltaEntries(key);
    }

    default public boolean hasDeltaEntries(String key) {
        Option option = this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries().get((Object)key);
        if (option instanceof Some) {
            TreeMap m = (TreeMap)((Some)option).value();
            return m.nonEmpty();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError((Object)option);
    }

    private long findSmallestVersionPropagatedToAllNodes(String key, Vector<UniqueAddress> all) {
        Option option = this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode().get((Object)key);
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        if (option instanceof Some) {
            Map deltaSentToNodeForKey = (Map)((Some)option).value();
            if (deltaSentToNodeForKey.isEmpty()) {
                return 0L;
            }
            if (all.exists((Function1 & Serializable)node -> !deltaSentToNodeForKey.contains(node))) {
                return 0L;
            }
            return BoxesRunTime.unboxToLong((Object)deltaSentToNodeForKey.valuesIterator().min((Ordering)Ordering.Long$.MODULE$));
        }
        throw new MatchError((Object)option);
    }

    public static void cleanupDeltaEntries$(DeltaPropagationSelector $this) {
        $this.cleanupDeltaEntries();
    }

    default public void cleanupDeltaEntries() {
        Vector<UniqueAddress> all = this.allNodes();
        if (all.isEmpty()) {
            this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq((Map<String, TreeMap<Object, ReplicatedData>>)Predef$.MODULE$.Map().empty());
            return;
        }
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq((Map<String, TreeMap<Object, ReplicatedData>>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                TreeMap entries = (TreeMap)tuple2._2();
                long minVersion = this.findSmallestVersionPropagatedToAllNodes(key, all);
                TreeMap<Object, ReplicatedData> deltaEntriesAfterMin = this.deltaEntriesAfter((TreeMap<Object, ReplicatedData>)entries, minVersion);
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, deltaEntriesAfterMin);
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    public static void cleanupRemovedNode$(DeltaPropagationSelector $this, UniqueAddress address) {
        $this.cleanupRemovedNode(address);
    }

    default public void cleanupRemovedNode(UniqueAddress address) {
        this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode_$eq((Map<String, Map<UniqueAddress, Object>>)((Map)this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Map deltaSentToNodeForKey = (Map)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)deltaSentToNodeForKey.$minus((Object)address));
            }
            throw new MatchError((Object)tuple2);
        })));
    }

    private static Map $anonfun$1() {
        return TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private static long $anonfun$2() {
        return 0L;
    }
}

