/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ddata.DistributedData$;
import org.apache.pekko.cluster.ddata.Replicator$;
import org.apache.pekko.cluster.ddata.ReplicatorSettings;
import org.apache.pekko.cluster.ddata.ReplicatorSettings$;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress$;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import scala.None$;
import scala.Option;
import scala.collection.Set;

public class DistributedData
implements Extension {
    private final ExtendedActorSystem system;
    private final ReplicatorSettings settings;
    private final SelfUniqueAddress selfUniqueAddress;
    private final ActorRef replicator;

    public static Extension apply(ActorSystem actorSystem) {
        return DistributedData$.MODULE$.apply(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return DistributedData$.MODULE$.apply(classicActorSystemProvider);
    }

    public static DistributedData createExtension(ExtendedActorSystem extendedActorSystem) {
        return DistributedData$.MODULE$.createExtension(extendedActorSystem);
    }

    public static DistributedData get(ActorSystem actorSystem) {
        return DistributedData$.MODULE$.get(actorSystem);
    }

    public static /* synthetic */ Extension get(ActorSystem actorSystem) {
        return DistributedData$.MODULE$.get(actorSystem);
    }

    public static DistributedData get(ClassicActorSystemProvider classicActorSystemProvider) {
        return DistributedData$.MODULE$.get(classicActorSystemProvider);
    }

    public static /* synthetic */ Extension get(ClassicActorSystemProvider classicActorSystemProvider) {
        return DistributedData$.MODULE$.get(classicActorSystemProvider);
    }

    public static ExtensionId<? extends Extension> lookup() {
        return DistributedData$.MODULE$.lookup();
    }

    public DistributedData(ExtendedActorSystem system) {
        ActorRef actorRef;
        this.system = system;
        this.settings = ReplicatorSettings$.MODULE$.apply((ActorSystem)system);
        this.selfUniqueAddress = SelfUniqueAddress$.MODULE$.apply(((Cluster)Cluster$.MODULE$.apply((ActorSystem)system)).selfUniqueAddress());
        if (this.isTerminated()) {
            LoggingAdapter log = Logging$.MODULE$.apply((ActorSystem)system, DistributedData.class, LogSource$.MODULE$.fromAnyClass());
            if (((Cluster)Cluster$.MODULE$.apply((ActorSystem)system)).isTerminated()) {
                log.warning("Replicator points to dead letters, because Cluster is terminated.");
            } else {
                log.warning("Replicator points to dead letters. Make sure the cluster node has the proper role. Node has roles [{}], Distributed Data is configured for roles [{}].", (Object)((Cluster)Cluster$.MODULE$.apply((ActorSystem)system)).selfRoles().mkString(","), (Object)this.settings.roles().mkString(","));
            }
            actorRef = system.deadLetters();
        } else {
            actorRef = system.systemActorOf(Replicator$.MODULE$.props(this.settings), ReplicatorSettings$.MODULE$.name((ActorSystem)system, (Option<String>)None$.MODULE$));
        }
        this.replicator = actorRef;
    }

    public SelfUniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public ActorRef replicator() {
        return this.replicator;
    }

    public boolean isTerminated() {
        return ((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).isTerminated() || !this.settings.roles().subsetOf((Set)((Cluster)Cluster$.MODULE$.apply((ActorSystem)this.system)).selfRoles());
    }
}

