/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import java.math.BigInteger;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.DeltaReplicatedData;
import org.apache.pekko.cluster.ddata.FastMerge;
import org.apache.pekko.cluster.ddata.GCounter$;
import org.apache.pekko.cluster.ddata.RemovedNodePruning;
import org.apache.pekko.cluster.ddata.ReplicatedDataSerialization;
import org.apache.pekko.cluster.ddata.ReplicatedDelta;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class GCounter
implements DeltaReplicatedData,
ReplicatedDelta,
ReplicatedDataSerialization,
RemovedNodePruning,
FastMerge {
    private static final long serialVersionUID = 1L;
    private FastMerge org$apache$pekko$cluster$ddata$FastMerge$$ancestor;
    private final Map state;
    private final Option delta;

    public static GCounter apply() {
        return GCounter$.MODULE$.apply();
    }

    public static GCounter create() {
        return GCounter$.MODULE$.create();
    }

    public static GCounter empty() {
        return GCounter$.MODULE$.empty();
    }

    public static Option<BigInt> unapply(GCounter gCounter) {
        return GCounter$.MODULE$.unapply(gCounter);
    }

    public static Map<UniqueAddress, BigInt> $lessinit$greater$default$1() {
        return GCounter$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<GCounter> $lessinit$greater$default$2() {
        return GCounter$.MODULE$.$lessinit$greater$default$2();
    }

    public GCounter(Map<UniqueAddress, BigInt> state, Option<GCounter> delta) {
        this.state = state;
        this.delta = delta;
        FastMerge.$init$(this);
    }

    @Override
    public FastMerge org$apache$pekko$cluster$ddata$FastMerge$$ancestor() {
        return this.org$apache$pekko$cluster$ddata$FastMerge$$ancestor;
    }

    @Override
    public void org$apache$pekko$cluster$ddata$FastMerge$$ancestor_$eq(FastMerge x$1) {
        this.org$apache$pekko$cluster$ddata$FastMerge$$ancestor = x$1;
    }

    public Map<UniqueAddress, BigInt> state() {
        return this.state;
    }

    public Option<GCounter> delta() {
        return this.delta;
    }

    public BigInt value() {
        return (BigInt)this.state().values().foldLeft((Object)GCounter$.org$apache$pekko$cluster$ddata$GCounter$$$Zero, (Function2 & Serializable)(acc, v) -> acc.$plus(v));
    }

    public BigInteger getValue() {
        return this.value().bigInteger();
    }

    public GCounter $colon$plus(long n, SelfUniqueAddress node) {
        return this.increment(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public GCounter $plus(long n, Cluster node) {
        return this.increment(node.selfUniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public GCounter increment(SelfUniqueAddress node, long n) {
        return this.increment(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public GCounter increment(Cluster node, long n) {
        return this.increment(node.selfUniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public long increment$default$2() {
        return 1L;
    }

    @InternalApi
    public GCounter increment(UniqueAddress key) {
        return this.increment(key, BigInt$.MODULE$.int2bigInt(1));
    }

    @InternalApi
    public GCounter increment(UniqueAddress key, BigInt n) {
        GCounter gCounter;
        BigInt bigInt;
        Predef$.MODULE$.require(n.$greater$eq((Object)BigInt$.MODULE$.int2bigInt(0)), GCounter::increment$$anonfun$1);
        if (BoxesRunTime.equals((Object)n, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return this;
        }
        Option option = this.state().get((Object)key);
        if (option instanceof Some) {
            BigInt v = (BigInt)((Some)option).value();
            bigInt = v.$plus(n);
        } else if (None$.MODULE$.equals(option)) {
            bigInt = n;
        } else {
            throw new MatchError((Object)option);
        }
        BigInt nextValue = bigInt;
        Option<GCounter> option2 = this.delta();
        if (None$.MODULE$.equals(option2)) {
            Object[] objectArray = new Tuple2[1];
            UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)key);
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)nextValue);
            gCounter = new GCounter((Map<UniqueAddress, BigInt>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))), GCounter$.MODULE$.$lessinit$greater$default$2());
        } else if (option2 instanceof Some) {
            GCounter d = (GCounter)((Some)option2).value();
            UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)key);
            GCounter gCounter2 = new GCounter((Map<UniqueAddress, BigInt>)((Map)d.state().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)nextValue))), GCounter$.MODULE$.$lessinit$greater$default$2());
            gCounter = gCounter2;
        } else {
            throw new MatchError(option2);
        }
        GCounter newDelta = gCounter;
        UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)key);
        return (GCounter)this.assignAncestor(new GCounter((Map<UniqueAddress, BigInt>)((Map)this.state().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)nextValue))), (Option<GCounter>)Some$.MODULE$.apply((Object)newDelta)));
    }

    public GCounter merge(GCounter that) {
        if (this == that || that.isAncestorOf(this)) {
            return (GCounter)this.clearAncestor();
        }
        if (this.isAncestorOf(that)) {
            return (GCounter)that.clearAncestor();
        }
        ObjectRef merged = ObjectRef.create(that.state());
        this.state().withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress key = (UniqueAddress)tuple2._1();
                BigInt thisValue = (BigInt)tuple2._2();
                return true;
            }
            return false;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                BigInt thatValue;
                UniqueAddress key = (UniqueAddress)tuple2._1();
                BigInt thisValue = (BigInt)tuple2._2();
                if (thisValue.$greater((Object)(thatValue = (BigInt)((Map)merged$1.elem).getOrElse((Object)key, GCounter::$anonfun$1)))) {
                    Map map = (Map)((Map)merged$1.elem).updated((Object)key, (Object)thisValue);
                    merged$1.elem = map;
                    map = null;
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        this.clearAncestor();
        return new GCounter((Map<UniqueAddress, BigInt>)((Map)merged.elem), GCounter$.MODULE$.$lessinit$greater$default$2());
    }

    public GCounter mergeDelta(GCounter thatDelta) {
        return this.merge(thatDelta);
    }

    @Override
    public GCounter zero() {
        return GCounter$.MODULE$.empty();
    }

    @Override
    public GCounter resetDelta() {
        if (this.delta().isEmpty()) {
            return this;
        }
        return (GCounter)this.assignAncestor(new GCounter(this.state(), GCounter$.MODULE$.$lessinit$greater$default$2()));
    }

    @Override
    public Set<UniqueAddress> modifiedByNodes() {
        return this.state().keySet();
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        return this.state().contains((Object)removedNode);
    }

    @Override
    public GCounter prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        Option option = this.state().get((Object)removedNode);
        if (option instanceof Some) {
            BigInt value = (BigInt)((Some)option).value();
            return new GCounter((Map<UniqueAddress, BigInt>)((Map)this.state().$minus((Object)removedNode)), GCounter$.MODULE$.$lessinit$greater$default$2()).increment(collapseInto, value);
        }
        if (None$.MODULE$.equals(option)) {
            return this;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public GCounter pruningCleanup(UniqueAddress removedNode) {
        return new GCounter((Map<UniqueAddress, BigInt>)((Map)this.state().$minus((Object)removedNode)), GCounter$.MODULE$.$lessinit$greater$default$2());
    }

    public String toString() {
        return new StringBuilder(10).append("GCounter(").append(this.value()).append(")").toString();
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof GCounter) {
            GCounter other = (GCounter)object;
            Map<UniqueAddress, BigInt> map = this.state();
            Map<UniqueAddress, BigInt> map2 = other.state();
            return !(map != null ? !map.equals(map2) : map2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.state().hashCode();
    }

    private static final Object increment$$anonfun$1() {
        return "Can't decrement a GCounter";
    }

    private static final BigInt $anonfun$1() {
        return GCounter$.org$apache$pekko$cluster$ddata$GCounter$$$Zero;
    }
}

