/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.function.Function;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.DeltaReplicatedData;
import org.apache.pekko.cluster.ddata.ORMap$;
import org.apache.pekko.cluster.ddata.ORMap$DeltaGroup$;
import org.apache.pekko.cluster.ddata.ORMap$PutDeltaOp$;
import org.apache.pekko.cluster.ddata.ORMap$RemoveDeltaOp$;
import org.apache.pekko.cluster.ddata.ORMap$RemoveKeyDeltaOp$;
import org.apache.pekko.cluster.ddata.ORMap$UpdateDeltaOp$;
import org.apache.pekko.cluster.ddata.ORSet;
import org.apache.pekko.cluster.ddata.RemovedNodePruning;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.ReplicatedDataSerialization;
import org.apache.pekko.cluster.ddata.ReplicatedDelta;
import org.apache.pekko.cluster.ddata.ReplicatedDeltaSize;
import org.apache.pekko.cluster.ddata.RequiresCausalDeliveryOfDeltas;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class ORMap<A, B extends ReplicatedData>
implements DeltaReplicatedData,
ReplicatedDataSerialization,
RemovedNodePruning {
    private static final long serialVersionUID = 1L;
    private final ORSet keys;
    private final scala.collection.immutable.Map values;
    private final ZeroTag zeroTag;
    private final Option delta;

    public static ORMap<Object, ReplicatedData> apply() {
        return ORMap$.MODULE$.apply();
    }

    public static <A, B extends ReplicatedData> ORMap<A, B> create() {
        return ORMap$.MODULE$.create();
    }

    public static <A, B extends ReplicatedData> ORMap<A, B> empty() {
        return ORMap$.MODULE$.empty();
    }

    public static <A, B extends ReplicatedData> Option<scala.collection.immutable.Map<A, B>> unapply(ORMap<A, B> oRMap) {
        return ORMap$.MODULE$.unapply(oRMap);
    }

    public static <A, B extends ReplicatedData> Option<DeltaOp> $lessinit$greater$default$4() {
        return ORMap$.MODULE$.$lessinit$greater$default$4();
    }

    public ORMap(ORSet<A> keys, scala.collection.immutable.Map<A, B> values, ZeroTag zeroTag, Option<DeltaOp> delta) {
        this.keys = keys;
        this.values = values;
        this.zeroTag = zeroTag;
        this.delta = delta;
    }

    public ORSet<A> keys() {
        return this.keys;
    }

    public scala.collection.immutable.Map<A, B> values() {
        return this.values;
    }

    public ZeroTag zeroTag() {
        return this.zeroTag;
    }

    public Option<DeltaOp> delta() {
        return this.delta;
    }

    public scala.collection.immutable.Map<A, B> entries() {
        return this.values();
    }

    public Map<A, B> getEntries() {
        return package.JavaConverters$.MODULE$.MapHasAsJava(this.entries()).asJava();
    }

    public Option<B> get(A key) {
        return this.values().get(key);
    }

    public B getOrElse(A key, Function0<B> function0) {
        return (B)((ReplicatedData)this.values().getOrElse(key, function0));
    }

    public boolean contains(A key) {
        return this.values().contains(key);
    }

    public boolean isEmpty() {
        return this.values().isEmpty();
    }

    public int size() {
        return this.values().size();
    }

    public ORMap<A, B> $colon$plus(Tuple2<A, B> entry, SelfUniqueAddress node) {
        Tuple2<A, B> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        ReplicatedData value = (ReplicatedData)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, (Object)value);
        Object key2 = tuple22._1();
        ReplicatedData value2 = (ReplicatedData)tuple22._2();
        return this.put(node.uniqueAddress(), key2, value2);
    }

    public ORMap<A, B> $plus(Tuple2<A, B> entry, Cluster node) {
        Tuple2<A, B> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        ReplicatedData value = (ReplicatedData)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, (Object)value);
        Object key2 = tuple22._1();
        ReplicatedData value2 = (ReplicatedData)tuple22._2();
        return this.put(node.selfUniqueAddress(), key2, value2);
    }

    public ORMap<A, B> put(SelfUniqueAddress node, A key, B value) {
        return this.put(node.uniqueAddress(), key, value);
    }

    public ORMap<A, B> put(Cluster node, A key, B value) {
        return this.put(node.selfUniqueAddress(), key, value);
    }

    @InternalApi
    public ORMap<A, B> put(UniqueAddress node, A key, B value) {
        if (value instanceof ORSet && this.values().contains(key)) {
            throw new IllegalArgumentException("`ORMap.put` must not be used to replace an existing `ORSet` value, because important history can be lost when replacing the `ORSet` and undesired effects of merging will occur. Use `ORMultiMap` or `ORMap.updated` instead.");
        }
        ORSet<A> newKeys = ((ORSet)this.keys().resetDelta()).add(node, key);
        Object object = Predef$.MODULE$.ArrowAssoc(key);
        PutDeltaOp putDeltaOp = ORMap$PutDeltaOp$.MODULE$.apply((ORSet.DeltaOp)newKeys.delta().get(), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, value), this.zeroTag());
        return new ORMap<A, B>(newKeys, (scala.collection.immutable.Map)this.values().updated(key, value), this.zeroTag(), (Option<DeltaOp>)Some$.MODULE$.apply((Object)this.newDelta(putDeltaOp)));
    }

    public ORMap<A, B> updated(SelfUniqueAddress node, A key, B initial, Function1<B, B> modify) {
        return this.updated(node.uniqueAddress(), key, initial, this.updated$default$4(), modify);
    }

    public ORMap<A, B> updated(Cluster node, A key, B initial, Function1<B, B> modify) {
        return this.updated(node.selfUniqueAddress(), key, initial, this.updated$default$4(), modify);
    }

    public ORMap<A, B> updated(Cluster node, A key, B initial, Function<B, B> modify) {
        return this.updated(node.selfUniqueAddress(), key, initial, this.updated$default$4(), (Function1 & Serializable)value -> (ReplicatedData)modify.apply(value));
    }

    public ORMap<A, B> update(SelfUniqueAddress node, A key, B initial, Function<B, B> modify) {
        return this.updated(node.uniqueAddress(), key, initial, this.updated$default$4(), (Function1 & Serializable)value -> (ReplicatedData)modify.apply(value));
    }

    public ORMap<A, B> update(Cluster node, A key, B initial, Function<B, B> modify) {
        return this.updated(node, key, initial, (Function1 & Serializable)value -> (ReplicatedData)modify.apply(value));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @InternalApi
    public ORMap<A, B> updated(UniqueAddress node, A key, B initial, boolean valueDeltas, Function1<B, B> modify) {
        block4: {
            var7_6 = this.values().get(key);
            if (var7_6 instanceof Some) {
                old = (ReplicatedData)((Some)var7_6).value();
                v0 = Tuple2$.MODULE$.apply((Object)old, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                v0 = Tuple2$.MODULE$.apply(initial, (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            var6_8 = v0;
            oldValue = (ReplicatedData)var6_8._1();
            hasOldValue = BoxesRunTime.unboxToBoolean((Object)var6_8._2());
            newKeys = this.keys().resetDelta().add(node, key);
            var12_12 = oldValue;
            if (!(var12_12 instanceof DeltaReplicatedData) || !valueDeltas) break block4;
            newValue = (ReplicatedData)modify.apply((Object)((DeltaReplicatedData)oldValue).resetDelta());
            newValueDelta = ((DeltaReplicatedData)newValue).delta();
            var16_15 = newValueDelta;
            if (!(var16_15 instanceof Some)) ** GOTO lbl-1000
            d = (ReplicatedDelta)((Some)var16_15).value();
            if (hasOldValue) {
                v1 = new Tuple2[1];
                var18_17 = Predef$.MODULE$.ArrowAssoc(key);
                v1[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(var18_17, (Object)d);
                v2 /* !! */  = ORMap$UpdateDeltaOp$.MODULE$.apply((ORSet.DeltaOp)newKeys.delta().get(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(v1)), this.zeroTag());
            } else lbl-1000:
            // 2 sources

            {
                var19_18 = Predef$.MODULE$.ArrowAssoc(key);
                v2 /* !! */  = ORMap$PutDeltaOp$.MODULE$.apply((ORSet.DeltaOp)newKeys.delta().get(), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(var19_18, (Object)newValue), this.zeroTag());
            }
            deltaOp = v2 /* !! */ ;
            return new ORMap<A, B>(newKeys, (scala.collection.immutable.Map)this.values().updated(key, (Object)newValue), this.zeroTag(), (Option<DeltaOp>)Some$.MODULE$.apply((Object)this.newDelta(deltaOp)));
        }
        newValue = (ReplicatedData)modify.apply((Object)oldValue);
        var22_21 = Predef$.MODULE$.ArrowAssoc(key);
        deltaOp = ORMap$PutDeltaOp$.MODULE$.apply((ORSet.DeltaOp)newKeys.delta().get(), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(var22_21, (Object)newValue), this.zeroTag());
        return new ORMap<A, B>(newKeys, (scala.collection.immutable.Map)this.values().updated(key, (Object)newValue), this.zeroTag(), (Option<DeltaOp>)Some$.MODULE$.apply((Object)this.newDelta(deltaOp)));
    }

    public boolean updated$default$4() {
        return false;
    }

    public ORMap<A, B> remove(A key, SelfUniqueAddress node) {
        return this.remove(node.uniqueAddress(), key);
    }

    public ORMap<A, B> remove(SelfUniqueAddress node, A key) {
        return this.remove(node.uniqueAddress(), key);
    }

    public ORMap<A, B> $minus(A key, Cluster node) {
        return this.remove(node.selfUniqueAddress(), key);
    }

    public ORMap<A, B> remove(Cluster node, A key) {
        return this.remove(node.selfUniqueAddress(), key);
    }

    @InternalApi
    public ORMap<A, B> remove(UniqueAddress node, A key) {
        ORSet<A> newKeys = ((ORSet)this.keys().resetDelta()).remove(node, key);
        RemoveDeltaOp removeDeltaOp = ORMap$RemoveDeltaOp$.MODULE$.apply((ORSet.DeltaOp)newKeys.delta().get(), this.zeroTag());
        return new ORMap<A, B>(newKeys, (scala.collection.immutable.Map)this.values().$minus(key), this.zeroTag(), (Option<DeltaOp>)Some$.MODULE$.apply((Object)this.newDelta(removeDeltaOp)));
    }

    @InternalApi
    public ORMap<A, B> removeKey(UniqueAddress node, A key) {
        ORSet<A> newKeys = ((ORSet)this.keys().resetDelta()).remove(node, key);
        RemoveKeyDeltaOp removeKeyDeltaOp = ORMap$RemoveKeyDeltaOp$.MODULE$.apply((ORSet.DeltaOp)newKeys.delta().get(), key, this.zeroTag());
        return new ORMap<A, B>(newKeys, this.values(), this.zeroTag(), (Option<DeltaOp>)Some$.MODULE$.apply((Object)this.newDelta(removeKeyDeltaOp)));
    }

    private ORMap<A, B> dryMerge(ORMap<A, B> that, ORSet<A> mergedKeys, Iterator<A> valueKeysIterator) {
        ObjectRef mergedValues = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        valueKeysIterator.foreach((Function1)(JProcedure1 & Serializable)key -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this.values().get(key), (Object)that.values().get(key));
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Option option2 = (Option)tuple2._2();
                if (option instanceof Some) {
                    ReplicatedData replicatedData;
                    ReplicatedData thisValue = replicatedData = (ReplicatedData)((Some)option).value();
                    if (option2 instanceof Some) {
                        ReplicatedData thatValue = (ReplicatedData)((Some)option2).value();
                        Class<?> clazz = thisValue.getClass();
                        Class<?> clazz2 = thatValue.getClass();
                        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                            String errMsg = new StringBuilder(47).append("Wrong type for merging [").append(key).append("] in [").append(this.getClass().getName()).append("], existing type ").append(new StringBuilder(10).append("[").append(thisValue.getClass().getName()).append("], got [").append(thatValue.getClass().getName()).append("]").toString()).toString();
                            throw new IllegalArgumentException(errMsg);
                        }
                        ReplicatedData mergedValue = thisValue.merge(thatValue);
                        scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)mergedValues$1.elem).updated(key, (Object)mergedValue);
                        mergedValues$1.elem = map;
                        map = null;
                        return;
                    }
                    ReplicatedData thisValue2 = replicatedData;
                    if (None$.MODULE$.equals(option2)) {
                        if (mergedKeys.contains(key)) {
                            scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)mergedValues$1.elem).updated(key, (Object)thisValue2);
                            mergedValues$1.elem = map;
                            map = null;
                            return;
                        }
                        return;
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    if (option2 instanceof Some) {
                        ReplicatedData thatValue = (ReplicatedData)((Some)option2).value();
                        if (mergedKeys.contains(key)) {
                            scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)mergedValues$1.elem).updated(key, (Object)thatValue);
                            mergedValues$1.elem = map;
                            map = null;
                            return;
                        }
                        return;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        throw new IllegalStateException(new StringBuilder(18).append("missing value for ").append(key).toString());
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        });
        return new ORMap<A, B>(mergedKeys, (scala.collection.immutable.Map)mergedValues.elem, this.zeroTag(), ORMap$.MODULE$.$lessinit$greater$default$4());
    }

    public ORMap<A, B> merge(ORMap<A, B> that) {
        ORSet<A> mergedKeys = this.keys().merge(that.keys());
        return this.dryMerge(that, mergedKeys, mergedKeys.elementsMap().keysIterator());
    }

    @InternalApi
    public ORMap<A, B> mergeRetainingDeletedValues(ORMap<A, B> that) {
        ORSet<A> mergedKeys = this.keys().merge(that.keys());
        return this.dryMerge(that, mergedKeys, this.values().keySet().$plus$plus((IterableOnce)that.values().keySet()).iterator());
    }

    @Override
    public ORMap<A, B> resetDelta() {
        if (this.delta().isEmpty()) {
            return this;
        }
        return new ORMap<A, B>(this.keys().resetDelta(), this.values(), this.zeroTag(), ORMap$.MODULE$.$lessinit$greater$default$4());
    }

    private ORMap<A, B> dryMergeDelta(DeltaOp thatDelta, boolean withValueDeltas) {
        ObjectRef mergedKeys = ObjectRef.create(this.keys());
        Tuple2 tuple2 = this.values().partition((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                return this.keys().contains(k);
            }
            throw new MatchError((Object)tuple2);
        });
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple22 = tuple2;
        scala.collection.immutable.Map mergedValues = (scala.collection.immutable.Map)tuple22._1();
        scala.collection.immutable.Map tombstonedVals = (scala.collection.immutable.Map)tuple22._2();
        Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)mergedValues, (Object)tombstonedVals);
        ObjectRef mergedValues2 = ObjectRef.create((Object)((scala.collection.immutable.Map)tuple23._1()));
        ObjectRef tombstonedVals2 = ObjectRef.create((Object)((scala.collection.immutable.Map)tuple23._2()));
        Serializable processDelta = new Serializable(mergedKeys, mergedValues2, tombstonedVals2, this){
            private final ObjectRef mergedKeys$2;
            private final ObjectRef mergedValues$2;
            private final ObjectRef tombstonedVals$1;
            {
                this.mergedKeys$2 = mergedKeys$3;
                this.mergedValues$2 = mergedValues$3;
                this.tombstonedVals$1 = tombstonedVals$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public final boolean isDefinedAt(DeltaOp x) {
                DeltaOp deltaOp = x;
                if (deltaOp instanceof PutDeltaOp) {
                    PutDeltaOp putOp = (PutDeltaOp)deltaOp;
                    return true;
                }
                if (deltaOp instanceof RemoveDeltaOp) {
                    RemoveDeltaOp removeOp = (RemoveDeltaOp)deltaOp;
                    return true;
                }
                if (deltaOp instanceof RemoveKeyDeltaOp) {
                    RemoveKeyDeltaOp removeKeyOp = (RemoveKeyDeltaOp)deltaOp;
                    return true;
                }
                if (deltaOp instanceof UpdateDeltaOp) {
                    UpdateDeltaOp updateOp = (UpdateDeltaOp)deltaOp;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(DeltaOp x, Function1 function1) {
                DeltaOp deltaOp = x;
                if (deltaOp instanceof PutDeltaOp) {
                    ORSet oRSet;
                    PutDeltaOp putOp = (PutDeltaOp)deltaOp;
                    ORSet.DeltaOp keyDelta = putOp.underlying();
                    this.mergedKeys$2.elem = oRSet = ((ORSet)this.mergedKeys$2.elem).mergeDelta(keyDelta);
                    oRSet = null;
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$plus(putOp.value());
                    this.mergedValues$2.elem = map;
                    map = null;
                    return BoxedUnit.UNIT;
                }
                if (deltaOp instanceof RemoveDeltaOp) {
                    ORSet oRSet;
                    RemoveDeltaOp removeOp = (RemoveDeltaOp)deltaOp;
                    ORSet.DeltaOp deltaOp2 = removeOp.underlying();
                    if (!(deltaOp2 instanceof ORSet.RemoveDeltaOp)) {
                        throw new IllegalArgumentException("ORMap.RemoveDeltaOp must contain ORSet.RemoveDeltaOp inside");
                    }
                    ORSet.RemoveDeltaOp op = (ORSet.RemoveDeltaOp)deltaOp2;
                    Object removedKey = op.underlying().elements().head();
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$minus(removedKey);
                    this.mergedValues$2.elem = map;
                    map = null;
                    this.mergedKeys$2.elem = oRSet = ((ORSet)this.mergedKeys$2.elem).mergeDelta(removeOp.underlying());
                    oRSet = null;
                    return BoxedUnit.UNIT;
                }
                if (deltaOp instanceof RemoveKeyDeltaOp) {
                    ORSet oRSet;
                    RemoveKeyDeltaOp removeKeyOp = (RemoveKeyDeltaOp)deltaOp;
                    if (((scala.collection.immutable.Map)this.mergedValues$2.elem).contains(removeKeyOp.removedKey())) {
                        Object object = Predef$.MODULE$.ArrowAssoc(removeKeyOp.removedKey());
                        scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.tombstonedVals$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, ((scala.collection.immutable.Map)this.mergedValues$2.elem).apply(removeKeyOp.removedKey())));
                        this.tombstonedVals$1.elem = map;
                        map = null;
                    }
                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$minus(removeKeyOp.removedKey());
                    this.mergedValues$2.elem = map;
                    map = null;
                    this.mergedKeys$2.elem = oRSet = ((ORSet)this.mergedKeys$2.elem).mergeDelta(removeKeyOp.underlying());
                    oRSet = null;
                    return BoxedUnit.UNIT;
                }
                if (deltaOp instanceof UpdateDeltaOp) {
                    ORSet oRSet;
                    UpdateDeltaOp updateOp = (UpdateDeltaOp)deltaOp;
                    this.mergedKeys$2.elem = oRSet = ((ORSet)this.mergedKeys$2.elem).mergeDelta(updateOp.underlying());
                    oRSet = null;
                    updateOp.values().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Object key = tuple2._1();
                            ReplicatedData value = (ReplicatedData)tuple2._2();
                            if (((ORSet)this.mergedKeys$2.elem).contains(key)) {
                                if (((scala.collection.immutable.Map)this.mergedValues$2.elem).contains(key)) {
                                    Object object = Predef$.MODULE$.ArrowAssoc(key);
                                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)ORMap.org$apache$pekko$cluster$ddata$ORMap$$_$mergeValue$1((ReplicatedData)((scala.collection.immutable.Map)this.mergedValues$2.elem).apply(key), value)));
                                    this.mergedValues$2.elem = map;
                                    map = null;
                                    return;
                                }
                                if (((scala.collection.immutable.Map)this.tombstonedVals$1.elem).contains(key)) {
                                    Object object = Predef$.MODULE$.ArrowAssoc(key);
                                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)ORMap.org$apache$pekko$cluster$ddata$ORMap$$_$mergeValue$1((ReplicatedData)((scala.collection.immutable.Map)this.tombstonedVals$1.elem).apply(key), value)));
                                    this.mergedValues$2.elem = map;
                                    map = null;
                                    return;
                                }
                                ReplicatedData replicatedData = value;
                                if (replicatedData instanceof ReplicatedDelta) {
                                    Object object = Predef$.MODULE$.ArrowAssoc(key);
                                    scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)ORMap.org$apache$pekko$cluster$ddata$ORMap$$_$mergeValue$1(((ReplicatedDelta)value).zero(), value)));
                                    this.mergedValues$2.elem = map;
                                    map = null;
                                    return;
                                }
                                Object object = Predef$.MODULE$.ArrowAssoc(key);
                                scala.collection.immutable.Map map = (scala.collection.immutable.Map)((scala.collection.immutable.Map)this.mergedValues$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)value));
                                this.mergedValues$2.elem = map;
                                map = null;
                                return;
                            }
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(scala.Tuple2 )}, serializedLambda);
            }
        };
        Serializable processNestedDelta = new Serializable((PartialFunction)processDelta){
            private final PartialFunction processDelta$1;
            {
                this.processDelta$1 = processDelta$2;
            }

            public final boolean isDefinedAt(DeltaOp x) {
                DeltaOp deltaOp = x;
                if (deltaOp instanceof DeltaGroup) {
                    IndexedSeq<DeltaOp> indexedSeq;
                    DeltaGroup<A, B> deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
                    IndexedSeq<DeltaOp> ops = indexedSeq = deltaGroup._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(DeltaOp x, Function1 function1) {
                DeltaOp deltaOp = x;
                if (deltaOp instanceof DeltaGroup) {
                    IndexedSeq<DeltaOp> indexedSeq;
                    DeltaGroup<A, B> deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
                    IndexedSeq<DeltaOp> ops = indexedSeq = deltaGroup._1();
                    ops.foreach((Function1)this.processDelta$1.orElse((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(DeltaOp x) {
                            DeltaOp deltaOp = x;
                            if (deltaOp instanceof DeltaGroup) {
                                DeltaGroup<A, B> deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
                                IndexedSeq<DeltaOp> indexedSeq = deltaGroup._1();
                                return true;
                            }
                            return false;
                        }

                        public final Object applyOrElse(DeltaOp x, Function1 function1) {
                            DeltaOp deltaOp = x;
                            if (deltaOp instanceof DeltaGroup) {
                                DeltaGroup<A, B> deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
                                IndexedSeq<DeltaOp> indexedSeq = deltaGroup._1();
                                throw new IllegalStateException("Cannot nest DeltaGroups");
                            }
                            return function1.apply((Object)x);
                        }
                    }));
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }
        };
        processDelta.orElse((PartialFunction)processNestedDelta).apply((Object)thatDelta);
        if (withValueDeltas) {
            return new ORMap<A, B>((ORSet)mergedKeys.elem, (scala.collection.immutable.Map)((scala.collection.immutable.Map)tombstonedVals2.elem).$plus$plus((IterableOnce)((scala.collection.immutable.Map)mergedValues2.elem)), this.zeroTag(), ORMap$.MODULE$.$lessinit$greater$default$4());
        }
        return new ORMap<A, B>((ORSet)mergedKeys.elem, (scala.collection.immutable.Map)mergedValues2.elem, this.zeroTag(), ORMap$.MODULE$.$lessinit$greater$default$4());
    }

    private boolean dryMergeDelta$default$2() {
        return false;
    }

    public ORMap<A, B> mergeDelta(DeltaOp thatDelta) {
        ORMap<A, B> thisWithDeltas = this.dryMergeDelta(thatDelta, this.dryMergeDelta$default$2());
        return this.merge(thisWithDeltas);
    }

    @InternalApi
    public ORMap<A, B> mergeDeltaRetainingDeletedValues(DeltaOp thatDelta) {
        ORMap<A, B> thisWithDeltas = this.dryMergeDelta(thatDelta, true);
        return this.mergeRetainingDeletedValues(thisWithDeltas);
    }

    private DeltaOp newDelta(DeltaOp deltaOp) {
        Option<DeltaOp> option = this.delta();
        if (option instanceof Some) {
            DeltaOp d = (DeltaOp)((Some)option).value();
            return (DeltaOp)d.merge(deltaOp);
        }
        if (None$.MODULE$.equals(option)) {
            return deltaOp;
        }
        throw new MatchError(option);
    }

    @Override
    public scala.collection.immutable.Set<UniqueAddress> modifiedByNodes() {
        return (scala.collection.immutable.Set)this.keys().modifiedByNodes().union((Set)this.values().foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                ReplicatedData replicatedData;
                scala.collection.immutable.Set set = (scala.collection.immutable.Set)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                scala.collection.immutable.Set acc = set;
                if (tuple22 != null && (replicatedData = (ReplicatedData)tuple22._2()) instanceof RemovedNodePruning) {
                    RemovedNodePruning data = (RemovedNodePruning)replicatedData;
                    return (scala.collection.immutable.Set)acc.union(data.modifiedByNodes());
                }
                scala.collection.immutable.Set acc2 = set;
                return acc2;
            }
            throw new MatchError((Object)tuple2);
        }));
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        return this.keys().needPruningFrom(removedNode) || this.values().exists((Function1 & Serializable)x$1 -> {
            ReplicatedData replicatedData;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (replicatedData = (ReplicatedData)tuple2._2()) instanceof RemovedNodePruning) {
                RemovedNodePruning data = (RemovedNodePruning)replicatedData;
                return data.needPruningFrom(removedNode);
            }
            return false;
        });
    }

    @Override
    public ORMap<A, B> prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        ReplicatedData prunedKeys = this.keys().prune(removedNode, collapseInto);
        scala.collection.immutable.Map prunedValues = (scala.collection.immutable.Map)this.values().foldLeft(this.values(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                scala.collection.immutable.Map acc = map;
                if (tuple22 != null) {
                    RemovedNodePruning data;
                    ReplicatedData replicatedData = (ReplicatedData)tuple22._2();
                    Object key = tuple22._1();
                    if (replicatedData instanceof RemovedNodePruning && (data = (RemovedNodePruning)replicatedData).needPruningFrom(removedNode)) {
                        return (scala.collection.immutable.Map)acc.updated(key, (Object)data.prune(removedNode, collapseInto));
                    }
                }
                scala.collection.immutable.Map acc2 = map;
                return acc2;
            }
            throw new MatchError((Object)tuple2);
        });
        return new ORMap<A, B>(prunedKeys, prunedValues, this.zeroTag(), ORMap$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public ORMap<A, B> pruningCleanup(UniqueAddress removedNode) {
        ReplicatedData pruningCleanupedKeys = this.keys().pruningCleanup(removedNode);
        scala.collection.immutable.Map pruningCleanupedValues = (scala.collection.immutable.Map)this.values().foldLeft(this.values(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                scala.collection.immutable.Map acc = map;
                if (tuple22 != null) {
                    RemovedNodePruning data;
                    ReplicatedData replicatedData = (ReplicatedData)tuple22._2();
                    Object key = tuple22._1();
                    if (replicatedData instanceof RemovedNodePruning && (data = (RemovedNodePruning)replicatedData).needPruningFrom(removedNode)) {
                        return (scala.collection.immutable.Map)acc.updated(key, (Object)data.pruningCleanup(removedNode));
                    }
                }
                scala.collection.immutable.Map acc2 = map;
                return acc2;
            }
            throw new MatchError((Object)tuple2);
        });
        return new ORMap<A, B>(pruningCleanupedKeys, pruningCleanupedValues, this.zeroTag(), ORMap$.MODULE$.$lessinit$greater$default$4());
    }

    public String toString() {
        return new StringBuilder(2).append("OR").append(this.entries()).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof ORMap)) return false;
        ORMap other = (ORMap)object;
        ORSet<A> oRSet = this.keys();
        ORSet<A> oRSet2 = other.keys();
        if (oRSet == null) {
            if (oRSet2 != null) {
                return false;
            }
        } else if (!((Object)oRSet).equals(oRSet2)) return false;
        scala.collection.immutable.Map<A, B> map = this.values();
        scala.collection.immutable.Map<A, B> map2 = other.values();
        if (map == null) {
            if (map2 == null) return true;
            return false;
        } else {
            if (!map.equals(map2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.keys());
        result = HashCode$.MODULE$.hash(result, this.values());
        return result;
    }

    public static final ReplicatedData org$apache$pekko$cluster$ddata$ORMap$$_$mergeValue$1(ReplicatedData lvalue, ReplicatedData rvalue) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)lvalue, (Object)rvalue);
        if (tuple2 != null) {
            ReplicatedData replicatedData = (ReplicatedData)tuple2._1();
            ReplicatedData replicatedData2 = (ReplicatedData)tuple2._2();
            if (replicatedData instanceof DeltaReplicatedData) {
                DeltaReplicatedData v = (DeltaReplicatedData)replicatedData;
                if (replicatedData2 instanceof ReplicatedDelta) {
                    ReplicatedDelta delta = (ReplicatedDelta)replicatedData2;
                    return v.mergeDelta(delta);
                }
            }
        }
        return lvalue.merge(rvalue);
    }

    @InternalApi
    public static abstract class AtomicDeltaOp<A, B extends ReplicatedData>
    implements DeltaOp,
    ReplicatedDeltaSize {
        public abstract ORSet.DeltaOp underlying();

        public abstract ZeroTag zeroTag();

        @Override
        public DeltaReplicatedData zero() {
            return this.zeroTag().zero();
        }

        public DeltaOp merge(DeltaOp that) {
            DeltaOp deltaOp = that;
            if (deltaOp instanceof AtomicDeltaOp) {
                AtomicDeltaOp other = (AtomicDeltaOp)deltaOp;
                return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicDeltaOp[]{this, other}))));
            }
            if (deltaOp instanceof DeltaGroup) {
                IndexedSeq<DeltaOp> indexedSeq;
                DeltaGroup deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
                IndexedSeq<DeltaOp> ops = indexedSeq = deltaGroup._1();
                return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)ops.$plus$colon((Object)this)));
            }
            throw new MatchError((Object)deltaOp);
        }

        @Override
        public int deltaSize() {
            return 1;
        }
    }

    @InternalApi
    public static final class DeltaGroup<A, B extends ReplicatedData>
    implements DeltaOp,
    ReplicatedDeltaSize,
    Product {
        private final IndexedSeq ops;

        public static <A, B extends ReplicatedData> DeltaGroup<A, B> apply(IndexedSeq<DeltaOp> indexedSeq) {
            return ORMap$DeltaGroup$.MODULE$.apply(indexedSeq);
        }

        public static DeltaGroup<?, ?> fromProduct(Product product) {
            return ORMap$DeltaGroup$.MODULE$.fromProduct(product);
        }

        public static <A, B extends ReplicatedData> DeltaGroup<A, B> unapply(DeltaGroup<A, B> deltaGroup) {
            return ORMap$DeltaGroup$.MODULE$.unapply(deltaGroup);
        }

        public DeltaGroup(IndexedSeq<DeltaOp> ops) {
            this.ops = ops;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeltaGroup)) return false;
            DeltaGroup deltaGroup = (DeltaGroup)object;
            IndexedSeq<DeltaOp> indexedSeq = this.ops();
            IndexedSeq<DeltaOp> indexedSeq2 = deltaGroup.ops();
            if (indexedSeq != null) {
                if (!indexedSeq.equals(indexedSeq2)) return false;
                return true;
            }
            if (indexedSeq2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DeltaGroup;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DeltaGroup";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ops";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public IndexedSeq<DeltaOp> ops() {
            return this.ops;
        }

        public DeltaOp merge(DeltaOp that) {
            DeltaOp deltaOp = that;
            if (deltaOp instanceof AtomicDeltaOp) {
                AtomicDeltaOp that2 = (AtomicDeltaOp)deltaOp;
                DeltaOp deltaOp2 = (DeltaOp)this.ops().last();
                if (deltaOp2 instanceof PutDeltaOp) {
                    PutDeltaOp thisPut = (PutDeltaOp)deltaOp2;
                    DeltaOp merged = thisPut.merge(that2);
                    DeltaOp deltaOp3 = merged;
                    if (deltaOp3 instanceof AtomicDeltaOp) {
                        AtomicDeltaOp op = (AtomicDeltaOp)deltaOp3;
                        return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)((SeqOps)this.ops().dropRight(1)).$colon$plus((Object)op)));
                    }
                    if (deltaOp3 instanceof DeltaGroup) {
                        IndexedSeq<DeltaOp> indexedSeq;
                        DeltaGroup deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp3);
                        IndexedSeq<DeltaOp> thatOps = indexedSeq = deltaGroup._1();
                        return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)((IterableOps)this.ops().dropRight(1)).$plus$plus(thatOps)));
                    }
                    throw new MatchError((Object)deltaOp3);
                }
                if (deltaOp2 instanceof UpdateDeltaOp) {
                    UpdateDeltaOp thisUpdate = (UpdateDeltaOp)deltaOp2;
                    DeltaOp merged = thisUpdate.merge(that2);
                    DeltaOp deltaOp4 = merged;
                    if (deltaOp4 instanceof AtomicDeltaOp) {
                        AtomicDeltaOp op = (AtomicDeltaOp)deltaOp4;
                        return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)((SeqOps)this.ops().dropRight(1)).$colon$plus((Object)op)));
                    }
                    if (deltaOp4 instanceof DeltaGroup) {
                        IndexedSeq<DeltaOp> indexedSeq;
                        DeltaGroup deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp4);
                        IndexedSeq<DeltaOp> thatOps = indexedSeq = deltaGroup._1();
                        return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)((IterableOps)this.ops().dropRight(1)).$plus$plus(thatOps)));
                    }
                    throw new MatchError((Object)deltaOp4);
                }
                return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)this.ops().$colon$plus((Object)that2)));
            }
            if (deltaOp instanceof DeltaGroup) {
                IndexedSeq<DeltaOp> indexedSeq;
                DeltaGroup deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
                IndexedSeq<DeltaOp> thatOps = indexedSeq = deltaGroup._1();
                return ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)this.ops().$plus$plus(thatOps)));
            }
            throw new MatchError((Object)deltaOp);
        }

        @Override
        public DeltaReplicatedData zero() {
            return (DeltaReplicatedData)this.ops().headOption().fold(this::zero$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.zero());
        }

        @Override
        public int deltaSize() {
            return this.ops().size();
        }

        public <A, B extends ReplicatedData> DeltaGroup<A, B> copy(IndexedSeq<DeltaOp> ops) {
            return new DeltaGroup<A, B>(ops);
        }

        public <A, B extends ReplicatedData> IndexedSeq<DeltaOp> copy$default$1() {
            return this.ops();
        }

        public IndexedSeq<DeltaOp> _1() {
            return this.ops();
        }

        private final DeltaReplicatedData zero$$anonfun$1() {
            return ORMap$.MODULE$.empty();
        }
    }

    public static interface DeltaOp
    extends RequiresCausalDeliveryOfDeltas,
    ReplicatedDataSerialization {
        @Override
        public DeltaReplicatedData zero();
    }

    @InternalApi
    public static final class PutDeltaOp<A, B extends ReplicatedData>
    extends AtomicDeltaOp<A, B>
    implements Product {
        private final ORSet.DeltaOp underlying;
        private final Tuple2 value;
        private final ZeroTag zeroTag;

        public static <A, B extends ReplicatedData> PutDeltaOp<A, B> apply(ORSet.DeltaOp deltaOp, Tuple2<A, B> tuple2, ZeroTag zeroTag) {
            return ORMap$PutDeltaOp$.MODULE$.apply(deltaOp, tuple2, zeroTag);
        }

        public static PutDeltaOp<?, ?> fromProduct(Product product) {
            return ORMap$PutDeltaOp$.MODULE$.fromProduct(product);
        }

        public static <A, B extends ReplicatedData> PutDeltaOp<A, B> unapply(PutDeltaOp<A, B> putDeltaOp) {
            return ORMap$PutDeltaOp$.MODULE$.unapply(putDeltaOp);
        }

        public PutDeltaOp(ORSet.DeltaOp underlying, Tuple2<A, B> value, ZeroTag zeroTag) {
            this.underlying = underlying;
            this.value = value;
            this.zeroTag = zeroTag;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PutDeltaOp)) return false;
            PutDeltaOp putDeltaOp = (PutDeltaOp)object;
            ORSet.DeltaOp deltaOp = this.underlying();
            ORSet.DeltaOp deltaOp2 = putDeltaOp.underlying();
            if (deltaOp == null) {
                if (deltaOp2 != null) {
                    return false;
                }
            } else if (!deltaOp.equals(deltaOp2)) return false;
            Tuple2<A, B> tuple2 = this.value();
            Tuple2<A, B> tuple22 = putDeltaOp.value();
            if (tuple2 == null) {
                if (tuple22 != null) {
                    return false;
                }
            } else if (!tuple2.equals(tuple22)) return false;
            ZeroTag zeroTag = this.zeroTag();
            ZeroTag zeroTag2 = putDeltaOp.zeroTag();
            if (zeroTag == null) {
                if (zeroTag2 == null) return true;
                return false;
            } else {
                if (!zeroTag.equals(zeroTag2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PutDeltaOp;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "PutDeltaOp";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "underlying";
                }
                case 1: {
                    return "value";
                }
                case 2: {
                    return "zeroTag";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ORSet.DeltaOp underlying() {
            return this.underlying;
        }

        public Tuple2<A, B> value() {
            return this.value;
        }

        @Override
        public ZeroTag zeroTag() {
            return this.zeroTag;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public DeltaOp merge(DeltaOp that) {
            IndexedSeq<DeltaOp> indexedSeq;
            UpdateDeltaOp update;
            PutDeltaOp<A, B> putDeltaOp;
            DeltaOp deltaOp = that;
            if (deltaOp instanceof PutDeltaOp) {
                PutDeltaOp put = (PutDeltaOp)deltaOp;
                if (BoxesRunTime.equals((Object)this.value()._1(), (Object)put.value()._1())) {
                    putDeltaOp = new PutDeltaOp<A, B>((ORSet.DeltaOp)this.underlying().merge(put.underlying()), put.value(), this.zeroTag());
                    return putDeltaOp;
                }
            }
            if (deltaOp instanceof UpdateDeltaOp && (update = (UpdateDeltaOp)deltaOp).values().size() == 1 && update.values().contains(this.value()._1())) {
                Tuple2 tuple2;
                ReplicatedData elem1;
                Tuple2<A, B> tuple22 = this.value();
                if (tuple22 == null) throw new MatchError(tuple22);
                Object key = tuple22._1();
                ReplicatedData elem12 = (ReplicatedData)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply(key, (Object)elem12);
                Object key2 = tuple23._1();
                ReplicatedData replicatedData = elem1 = (ReplicatedData)tuple23._2();
                if (replicatedData instanceof DeltaReplicatedData) {
                    DeltaReplicatedData e1 = (DeltaReplicatedData)replicatedData;
                    ReplicatedDelta e2 = (ReplicatedDelta)((Tuple2)update.values().head())._2();
                    tuple2 = Tuple2$.MODULE$.apply(key2, (Object)e1.mergeDelta(e2));
                } else {
                    ReplicatedData elem2 = (ReplicatedData)((Tuple2)update.values().head())._2();
                    tuple2 = Tuple2$.MODULE$.apply(key2, (Object)elem1.merge(elem2));
                }
                Tuple2 newValue = tuple2;
                putDeltaOp = new PutDeltaOp<A, B>((ORSet.DeltaOp)this.underlying().merge(update.underlying()), newValue, this.zeroTag());
                return putDeltaOp;
            }
            if (deltaOp instanceof AtomicDeltaOp) {
                AtomicDeltaOp other = (AtomicDeltaOp)deltaOp;
                putDeltaOp = ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicDeltaOp[]{this, other}))));
                return putDeltaOp;
            }
            if (!(deltaOp instanceof DeltaGroup)) throw new MatchError((Object)deltaOp);
            DeltaGroup deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp);
            IndexedSeq<DeltaOp> ops = indexedSeq = deltaGroup._1();
            putDeltaOp = ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)ops.$plus$colon((Object)this)));
            return putDeltaOp;
        }

        public <A, B extends ReplicatedData> PutDeltaOp<A, B> copy(ORSet.DeltaOp underlying, Tuple2<A, B> value, ZeroTag zeroTag) {
            return new PutDeltaOp<A, B>(underlying, value, zeroTag);
        }

        public <A, B extends ReplicatedData> ORSet.DeltaOp copy$default$1() {
            return this.underlying();
        }

        public <A, B extends ReplicatedData> Tuple2<A, B> copy$default$2() {
            return this.value();
        }

        public <A, B extends ReplicatedData> ZeroTag copy$default$3() {
            return this.zeroTag();
        }

        public ORSet.DeltaOp _1() {
            return this.underlying();
        }

        public Tuple2<A, B> _2() {
            return this.value();
        }

        public ZeroTag _3() {
            return this.zeroTag();
        }
    }

    @InternalApi
    public static final class RemoveDeltaOp<A, B extends ReplicatedData>
    extends AtomicDeltaOp<A, B>
    implements Product {
        private final ORSet.DeltaOp underlying;
        private final ZeroTag zeroTag;

        public static <A, B extends ReplicatedData> RemoveDeltaOp<A, B> apply(ORSet.DeltaOp deltaOp, ZeroTag zeroTag) {
            return ORMap$RemoveDeltaOp$.MODULE$.apply(deltaOp, zeroTag);
        }

        public static RemoveDeltaOp<?, ?> fromProduct(Product product) {
            return ORMap$RemoveDeltaOp$.MODULE$.fromProduct(product);
        }

        public static <A, B extends ReplicatedData> RemoveDeltaOp<A, B> unapply(RemoveDeltaOp<A, B> removeDeltaOp) {
            return ORMap$RemoveDeltaOp$.MODULE$.unapply(removeDeltaOp);
        }

        public RemoveDeltaOp(ORSet.DeltaOp underlying, ZeroTag zeroTag) {
            this.underlying = underlying;
            this.zeroTag = zeroTag;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RemoveDeltaOp)) return false;
            RemoveDeltaOp removeDeltaOp = (RemoveDeltaOp)object;
            ORSet.DeltaOp deltaOp = this.underlying();
            ORSet.DeltaOp deltaOp2 = removeDeltaOp.underlying();
            if (deltaOp == null) {
                if (deltaOp2 != null) {
                    return false;
                }
            } else if (!deltaOp.equals(deltaOp2)) return false;
            ZeroTag zeroTag = this.zeroTag();
            ZeroTag zeroTag2 = removeDeltaOp.zeroTag();
            if (zeroTag == null) {
                if (zeroTag2 == null) return true;
                return false;
            } else {
                if (!zeroTag.equals(zeroTag2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RemoveDeltaOp;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "RemoveDeltaOp";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "underlying";
            }
            if (1 == n2) {
                return "zeroTag";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ORSet.DeltaOp underlying() {
            return this.underlying;
        }

        @Override
        public ZeroTag zeroTag() {
            return this.zeroTag;
        }

        public <A, B extends ReplicatedData> RemoveDeltaOp<A, B> copy(ORSet.DeltaOp underlying, ZeroTag zeroTag) {
            return new RemoveDeltaOp<A, B>(underlying, zeroTag);
        }

        public <A, B extends ReplicatedData> ORSet.DeltaOp copy$default$1() {
            return this.underlying();
        }

        public <A, B extends ReplicatedData> ZeroTag copy$default$2() {
            return this.zeroTag();
        }

        public ORSet.DeltaOp _1() {
            return this.underlying();
        }

        public ZeroTag _2() {
            return this.zeroTag();
        }
    }

    @InternalApi
    public static final class RemoveKeyDeltaOp<A, B extends ReplicatedData>
    extends AtomicDeltaOp<A, B>
    implements Product {
        private final ORSet.DeltaOp underlying;
        private final Object removedKey;
        private final ZeroTag zeroTag;

        public static <A, B extends ReplicatedData> RemoveKeyDeltaOp<A, B> apply(ORSet.DeltaOp deltaOp, A a, ZeroTag zeroTag) {
            return ORMap$RemoveKeyDeltaOp$.MODULE$.apply(deltaOp, a, zeroTag);
        }

        public static RemoveKeyDeltaOp<?, ?> fromProduct(Product product) {
            return ORMap$RemoveKeyDeltaOp$.MODULE$.fromProduct(product);
        }

        public static <A, B extends ReplicatedData> RemoveKeyDeltaOp<A, B> unapply(RemoveKeyDeltaOp<A, B> removeKeyDeltaOp) {
            return ORMap$RemoveKeyDeltaOp$.MODULE$.unapply(removeKeyDeltaOp);
        }

        public RemoveKeyDeltaOp(ORSet.DeltaOp underlying, A removedKey, ZeroTag zeroTag) {
            this.underlying = underlying;
            this.removedKey = removedKey;
            this.zeroTag = zeroTag;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RemoveKeyDeltaOp)) return false;
            RemoveKeyDeltaOp removeKeyDeltaOp = (RemoveKeyDeltaOp)object;
            ORSet.DeltaOp deltaOp = this.underlying();
            ORSet.DeltaOp deltaOp2 = removeKeyDeltaOp.underlying();
            if (deltaOp == null) {
                if (deltaOp2 != null) {
                    return false;
                }
            } else if (!deltaOp.equals(deltaOp2)) return false;
            if (!BoxesRunTime.equals(this.removedKey(), removeKeyDeltaOp.removedKey())) return false;
            ZeroTag zeroTag = this.zeroTag();
            ZeroTag zeroTag2 = removeKeyDeltaOp.zeroTag();
            if (zeroTag == null) {
                if (zeroTag2 == null) return true;
                return false;
            } else {
                if (!zeroTag.equals(zeroTag2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RemoveKeyDeltaOp;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "RemoveKeyDeltaOp";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "underlying";
                }
                case 1: {
                    return "removedKey";
                }
                case 2: {
                    return "zeroTag";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ORSet.DeltaOp underlying() {
            return this.underlying;
        }

        public A removedKey() {
            return (A)this.removedKey;
        }

        @Override
        public ZeroTag zeroTag() {
            return this.zeroTag;
        }

        public <A, B extends ReplicatedData> RemoveKeyDeltaOp<A, B> copy(ORSet.DeltaOp underlying, A removedKey, ZeroTag zeroTag) {
            return new RemoveKeyDeltaOp<A, B>(underlying, removedKey, zeroTag);
        }

        public <A, B extends ReplicatedData> ORSet.DeltaOp copy$default$1() {
            return this.underlying();
        }

        public <A, B extends ReplicatedData> A copy$default$2() {
            return this.removedKey();
        }

        public <A, B extends ReplicatedData> ZeroTag copy$default$3() {
            return this.zeroTag();
        }

        public ORSet.DeltaOp _1() {
            return this.underlying();
        }

        public A _2() {
            return this.removedKey();
        }

        public ZeroTag _3() {
            return this.zeroTag();
        }
    }

    @InternalApi
    public static final class UpdateDeltaOp<A, B extends ReplicatedData>
    extends AtomicDeltaOp<A, B>
    implements Product {
        private final ORSet.DeltaOp underlying;
        private final scala.collection.immutable.Map values;
        private final ZeroTag zeroTag;

        public static <A, B extends ReplicatedData> UpdateDeltaOp<A, B> apply(ORSet.DeltaOp deltaOp, scala.collection.immutable.Map<A, B> map, ZeroTag zeroTag) {
            return ORMap$UpdateDeltaOp$.MODULE$.apply(deltaOp, map, zeroTag);
        }

        public static UpdateDeltaOp<?, ?> fromProduct(Product product) {
            return ORMap$UpdateDeltaOp$.MODULE$.fromProduct(product);
        }

        public static <A, B extends ReplicatedData> UpdateDeltaOp<A, B> unapply(UpdateDeltaOp<A, B> updateDeltaOp) {
            return ORMap$UpdateDeltaOp$.MODULE$.unapply(updateDeltaOp);
        }

        public UpdateDeltaOp(ORSet.DeltaOp underlying, scala.collection.immutable.Map<A, B> values, ZeroTag zeroTag) {
            this.underlying = underlying;
            this.values = values;
            this.zeroTag = zeroTag;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpdateDeltaOp)) return false;
            UpdateDeltaOp updateDeltaOp = (UpdateDeltaOp)object;
            ORSet.DeltaOp deltaOp = this.underlying();
            ORSet.DeltaOp deltaOp2 = updateDeltaOp.underlying();
            if (deltaOp == null) {
                if (deltaOp2 != null) {
                    return false;
                }
            } else if (!deltaOp.equals(deltaOp2)) return false;
            scala.collection.immutable.Map<A, B> map = this.values();
            scala.collection.immutable.Map<A, B> map2 = updateDeltaOp.values();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            ZeroTag zeroTag = this.zeroTag();
            ZeroTag zeroTag2 = updateDeltaOp.zeroTag();
            if (zeroTag == null) {
                if (zeroTag2 == null) return true;
                return false;
            } else {
                if (!zeroTag.equals(zeroTag2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UpdateDeltaOp;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "UpdateDeltaOp";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "underlying";
                }
                case 1: {
                    return "values";
                }
                case 2: {
                    return "zeroTag";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ORSet.DeltaOp underlying() {
            return this.underlying;
        }

        public scala.collection.immutable.Map<A, B> values() {
            return this.values;
        }

        @Override
        public ZeroTag zeroTag() {
            return this.zeroTag;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public DeltaOp merge(DeltaOp that) {
            IndexedSeq<DeltaOp> indexedSeq;
            DeltaOp deltaOp;
            DeltaOp deltaOp2 = that;
            if (deltaOp2 instanceof UpdateDeltaOp) {
                UpdateDeltaOp update = (UpdateDeltaOp)deltaOp2;
                deltaOp = new UpdateDeltaOp<A, B>((ORSet.DeltaOp)this.underlying().merge(update.underlying()), (scala.collection.immutable.Map)update.values().foldLeft(this.values(), (Function2 & Serializable)(map, pair) -> {
                    Tuple2 tuple2 = pair;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object key = tuple2._1();
                    ReplicatedData value = (ReplicatedData)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, (Object)value);
                    Object key2 = tuple22._1();
                    ReplicatedData value2 = (ReplicatedData)tuple22._2();
                    if (this.values().contains(key2)) {
                        ReplicatedData elem1 = (ReplicatedData)this.values().apply(key2);
                        ReplicatedData elem2 = value2;
                        Object object = Predef$.MODULE$.ArrowAssoc(key2);
                        return (scala.collection.immutable.Map)map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)elem1.merge(elem2)));
                    }
                    return (scala.collection.immutable.Map)map.$plus(pair);
                }), this.zeroTag());
                return deltaOp;
            }
            if (deltaOp2 instanceof PutDeltaOp) {
                PutDeltaOp put = (PutDeltaOp)deltaOp2;
                if (this.values().size() == 1 && this.values().contains(put.value()._1())) {
                    deltaOp = new PutDeltaOp((ORSet.DeltaOp)this.underlying().merge(put.underlying()), put.value(), this.zeroTag());
                    return deltaOp;
                }
            }
            if (deltaOp2 instanceof AtomicDeltaOp) {
                AtomicDeltaOp other = (AtomicDeltaOp)deltaOp2;
                deltaOp = ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicDeltaOp[]{this, other}))));
                return deltaOp;
            }
            if (!(deltaOp2 instanceof DeltaGroup)) throw new MatchError((Object)deltaOp2);
            DeltaGroup deltaGroup = ORMap$DeltaGroup$.MODULE$.unapply((DeltaGroup)deltaOp2);
            IndexedSeq<DeltaOp> ops = indexedSeq = deltaGroup._1();
            deltaOp = ORMap$DeltaGroup$.MODULE$.apply((IndexedSeq<DeltaOp>)((IndexedSeq)ops.$plus$colon((Object)this)));
            return deltaOp;
        }

        public <A, B extends ReplicatedData> UpdateDeltaOp<A, B> copy(ORSet.DeltaOp underlying, scala.collection.immutable.Map<A, B> values, ZeroTag zeroTag) {
            return new UpdateDeltaOp<A, B>(underlying, values, zeroTag);
        }

        public <A, B extends ReplicatedData> ORSet.DeltaOp copy$default$1() {
            return this.underlying();
        }

        public <A, B extends ReplicatedData> scala.collection.immutable.Map<A, B> copy$default$2() {
            return this.values();
        }

        public <A, B extends ReplicatedData> ZeroTag copy$default$3() {
            return this.zeroTag();
        }

        public ORSet.DeltaOp _1() {
            return this.underlying();
        }

        public scala.collection.immutable.Map<A, B> _2() {
            return this.values();
        }

        public ZeroTag _3() {
            return this.zeroTag();
        }
    }

    @InternalApi
    public static interface ZeroTag {
        public DeltaReplicatedData zero();

        public int value();
    }
}

