/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.EstimatedSize$;
import org.apache.pekko.cluster.ddata.ManyVersionVector;
import org.apache.pekko.cluster.ddata.ManyVersionVector$;
import org.apache.pekko.cluster.ddata.OneVersionVector$;
import org.apache.pekko.cluster.ddata.VersionVector;
import org.apache.pekko.cluster.ddata.VersionVector$;
import org.apache.pekko.cluster.ddata.VersionVector$Timestamp$;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class OneVersionVector
extends VersionVector
implements Product {
    private final UniqueAddress node;
    private final long version;

    public static OneVersionVector apply(UniqueAddress uniqueAddress, long l) {
        return OneVersionVector$.MODULE$.apply(uniqueAddress, l);
    }

    public static OneVersionVector fromProduct(Product product) {
        return OneVersionVector$.MODULE$.fromProduct(product);
    }

    public static OneVersionVector unapply(OneVersionVector oneVersionVector) {
        return OneVersionVector$.MODULE$.unapply(oneVersionVector);
    }

    public OneVersionVector(UniqueAddress node, long version) {
        this.node = node;
        this.version = version;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.node()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof OneVersionVector)) return false;
        OneVersionVector oneVersionVector = (OneVersionVector)object;
        if (this.version() != oneVersionVector.version()) return false;
        UniqueAddress uniqueAddress = this.node();
        UniqueAddress uniqueAddress2 = oneVersionVector.node();
        if (uniqueAddress != null) {
            if (!uniqueAddress.equals(uniqueAddress2)) return false;
            return true;
        }
        if (uniqueAddress2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof OneVersionVector;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "OneVersionVector";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        if (1 == n2) {
            return BoxesRunTime.boxToLong((long)this._2());
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "node";
        }
        if (1 == n2) {
            return "version";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public UniqueAddress node() {
        return this.node;
    }

    public long version() {
        return this.version;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @InternalApi
    public int size() {
        return 1;
    }

    @Override
    @InternalApi
    public VersionVector increment(UniqueAddress n) {
        VersionVector versionVector;
        long v = VersionVector$Timestamp$.MODULE$.counter().getAndIncrement();
        UniqueAddress uniqueAddress = n;
        UniqueAddress uniqueAddress2 = this.node();
        if (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null)) {
            versionVector = this.copy(this.copy$default$1(), v);
        } else {
            Object[] objectArray = new Tuple2[2];
            UniqueAddress uniqueAddress3 = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)this.node());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress3, (Object)BoxesRunTime.boxToLong((long)this.version()));
            UniqueAddress uniqueAddress4 = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)n);
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress4, (Object)BoxesRunTime.boxToLong((long)v));
            versionVector = ManyVersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)((TreeMap)TreeMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
        }
        return versionVector;
    }

    @Override
    @InternalApi
    public long versionAt(UniqueAddress n) {
        UniqueAddress uniqueAddress = n;
        UniqueAddress uniqueAddress2 = this.node();
        if (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null)) {
            return this.version();
        }
        return 0L;
    }

    @Override
    @InternalApi
    public boolean contains(UniqueAddress n) {
        UniqueAddress uniqueAddress = n;
        UniqueAddress uniqueAddress2 = this.node();
        return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
    }

    @Override
    @InternalApi
    public Iterator<Tuple2<UniqueAddress, Object>> versionsIterator() {
        return package$.MODULE$.Iterator().single((Object)Tuple2$.MODULE$.apply((Object)this.node(), (Object)BoxesRunTime.boxToLong((long)this.version())));
    }

    @Override
    public VersionVector merge(VersionVector that) {
        VersionVector versionVector = that;
        if (versionVector instanceof OneVersionVector) {
            VersionVector versionVector2;
            OneVersionVector oneVersionVector = OneVersionVector$.MODULE$.unapply((OneVersionVector)versionVector);
            UniqueAddress uniqueAddress = oneVersionVector._1();
            long l = oneVersionVector._2();
            UniqueAddress n2 = uniqueAddress;
            long v2 = l;
            UniqueAddress uniqueAddress2 = this.node();
            UniqueAddress uniqueAddress3 = n2;
            if (!(uniqueAddress2 != null ? !uniqueAddress2.equals(uniqueAddress3) : uniqueAddress3 != null)) {
                versionVector2 = this.version() >= v2 ? this : OneVersionVector$.MODULE$.apply(n2, v2);
            } else {
                Object[] objectArray = new Tuple2[2];
                UniqueAddress uniqueAddress4 = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)this.node());
                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress4, (Object)BoxesRunTime.boxToLong((long)this.version()));
                UniqueAddress uniqueAddress5 = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)n2);
                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress5, (Object)BoxesRunTime.boxToLong((long)v2));
                versionVector2 = ManyVersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)((TreeMap)TreeMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
            }
            return versionVector2;
        }
        if (versionVector instanceof ManyVersionVector) {
            ManyVersionVector manyVersionVector = ManyVersionVector$.MODULE$.unapply((ManyVersionVector)versionVector);
            TreeMap treeMap = manyVersionVector._1();
            TreeMap vs2 = treeMap;
            long v2 = BoxesRunTime.unboxToLong((Object)vs2.getOrElse((Object)this.node(), OneVersionVector::$anonfun$1));
            TreeMap mergedVersions = v2 >= this.version() ? vs2 : vs2.updated((Object)this.node(), (Object)BoxesRunTime.boxToLong((long)this.version()));
            return VersionVector$.MODULE$.apply(mergedVersions);
        }
        throw new MatchError((Object)versionVector);
    }

    @Override
    public Set<UniqueAddress> modifiedByNodes() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UniqueAddress[]{this.node()}));
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        UniqueAddress uniqueAddress = this.node();
        UniqueAddress uniqueAddress2 = removedNode;
        return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
    }

    @Override
    public VersionVector prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        UniqueAddress uniqueAddress = this.node();
        UniqueAddress uniqueAddress2 = removedNode;
        return (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null) ? VersionVector$.MODULE$.empty() : this).$plus(collapseInto);
    }

    @Override
    public VersionVector pruningCleanup(UniqueAddress removedNode) {
        UniqueAddress uniqueAddress = this.node();
        UniqueAddress uniqueAddress2 = removedNode;
        if (!(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null)) {
            return VersionVector$.MODULE$.empty();
        }
        return this;
    }

    public String toString() {
        return new StringBuilder(19).append("VersionVector(").append(this.node()).append(" -> ").append(this.version()).append(")").toString();
    }

    @Override
    @InternalApi
    public int estimatedSize() {
        return EstimatedSize$.MODULE$.UniqueAddress() + EstimatedSize$.MODULE$.LongValue();
    }

    public OneVersionVector copy(UniqueAddress node, long version) {
        return new OneVersionVector(node, version);
    }

    public UniqueAddress copy$default$1() {
        return this.node();
    }

    public long copy$default$2() {
        return this.version();
    }

    public UniqueAddress _1() {
        return this.node();
    }

    public long _2() {
        return this.version();
    }

    private static final long $anonfun$1() {
        return 0L;
    }
}

