/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

@InternalApi
public class PayloadSizeAggregator {
    private final LoggingAdapter log;
    private final int logSizeExceeding;
    private final int maxFrameSize;
    private final int warnSizeExceeding;
    private Map<String, Object> maxPayloadBytes;

    public PayloadSizeAggregator(LoggingAdapter log, int logSizeExceeding, int maxFrameSize) {
        this.log = log;
        this.logSizeExceeding = logSizeExceeding;
        this.maxFrameSize = maxFrameSize;
        this.warnSizeExceeding = maxFrameSize * 3 / 4;
        this.maxPayloadBytes = Predef$.MODULE$.Map().empty();
    }

    public int maxFrameSize() {
        return this.maxFrameSize;
    }

    public void updatePayloadSize(String key, int size) {
        if (size > 0) {
            Option option = this.maxPayloadBytes.get((Object)key);
            if (option instanceof Some) {
                int max = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (size > max) {
                    this.maxPayloadBytes = (Map)this.maxPayloadBytes.updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)PayloadSizeAggregator.newMax$1(size)));
                    if (size >= this.logSizeExceeding) {
                        this.logSize$1(key, size);
                        return;
                    }
                    return;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.maxPayloadBytes = (Map)this.maxPayloadBytes.updated((Object)key, (Object)BoxesRunTime.boxToInteger((int)PayloadSizeAggregator.newMax$1(size)));
                if (size >= this.logSizeExceeding) {
                    this.logSize$1(key, size);
                    return;
                }
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public int getMaxSize(String key) {
        return BoxesRunTime.unboxToInt((Object)this.maxPayloadBytes.getOrElse((Object)key, PayloadSizeAggregator::getMaxSize$$anonfun$1));
    }

    public void remove(String key) {
        this.maxPayloadBytes = (Map)this.maxPayloadBytes.$minus((Object)key);
    }

    private static final int newMax$1(int size$1) {
        return (int)((double)size$1 * 1.1);
    }

    private final void logSize$1(String key$1, int size$2) {
        if (size$2 >= this.warnSizeExceeding) {
            this.log.warning("Distributed data size for [{}] is [{}] bytes. Close to max remote message payload size.", (Object)key$1, (Object)BoxesRunTime.boxToInteger((int)size$2));
            return;
        }
        this.log.info("Distributed data size for [{}] is [{}] bytes.", (Object)key$1, (Object)BoxesRunTime.boxToInteger((int)size$2));
    }

    private static final int getMaxSize$$anonfun$1() {
        return 0;
    }
}

