/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import org.apache.pekko.actor.Address;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.EstimatedSize$;
import org.apache.pekko.cluster.ddata.PruningState$;
import org.apache.pekko.cluster.ddata.PruningState$PruningInitialized$;
import org.apache.pekko.cluster.ddata.PruningState$PruningPerformed$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@InternalApi
public interface PruningState {
    public static int ordinal(PruningState pruningState) {
        return PruningState$.MODULE$.ordinal(pruningState);
    }

    public static PruningState merge$(PruningState $this, PruningState that) {
        return $this.merge(that);
    }

    default public PruningState merge(PruningState that) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this, (Object)that);
        if (tuple2 != null) {
            PruningState pruningState = (PruningState)tuple2._1();
            PruningState pruningState2 = (PruningState)tuple2._2();
            if (pruningState instanceof PruningPerformed) {
                PruningPerformed p1 = (PruningPerformed)pruningState;
                if (pruningState2 instanceof PruningPerformed) {
                    PruningPerformed p2 = (PruningPerformed)pruningState2;
                    if (p1.obsoleteTime() >= p2.obsoleteTime()) {
                        return this;
                    }
                    return that;
                }
                return this;
            }
            if (pruningState2 instanceof PruningPerformed) {
                return that;
            }
            if (pruningState instanceof PruningInitialized) {
                PruningInitialized pruningInitialized = PruningState$PruningInitialized$.MODULE$.unapply((PruningInitialized)pruningState);
                UniqueAddress uniqueAddress = pruningInitialized._1();
                Set<Address> set = pruningInitialized._2();
                UniqueAddress thisOwner = uniqueAddress;
                Set<Address> thisSeen = set;
                if (pruningState2 instanceof PruningInitialized) {
                    PruningInitialized pruningInitialized2 = PruningState$PruningInitialized$.MODULE$.unapply((PruningInitialized)pruningState2);
                    UniqueAddress uniqueAddress2 = pruningInitialized2._1();
                    Set<Address> set2 = pruningInitialized2._2();
                    UniqueAddress thatOwner = uniqueAddress2;
                    Set<Address> thatSeen = set2;
                    UniqueAddress uniqueAddress3 = thisOwner;
                    UniqueAddress uniqueAddress4 = thatOwner;
                    if (!(uniqueAddress3 != null ? !uniqueAddress3.equals(uniqueAddress4) : uniqueAddress4 != null)) {
                        return PruningState$PruningInitialized$.MODULE$.apply(thisOwner, (Set<Address>)((Set)thisSeen.union(thatSeen)));
                    }
                    if (Member$.MODULE$.addressOrdering().compare((Object)thisOwner.address(), (Object)thatOwner.address()) > 0) {
                        return that;
                    }
                    return this;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public PruningState addSeen(Address var1);

    public int estimatedSize();

    public static final class PruningInitialized
    implements PruningState,
    Product,
    Serializable {
        private final UniqueAddress owner;
        private final Set seen;

        public static PruningInitialized apply(UniqueAddress uniqueAddress, Set<Address> set) {
            return PruningState$PruningInitialized$.MODULE$.apply(uniqueAddress, set);
        }

        public static PruningInitialized fromProduct(Product product) {
            return PruningState$PruningInitialized$.MODULE$.fromProduct(product);
        }

        public static PruningInitialized unapply(PruningInitialized pruningInitialized) {
            return PruningState$PruningInitialized$.MODULE$.unapply(pruningInitialized);
        }

        public PruningInitialized(UniqueAddress owner, Set<Address> seen) {
            this.owner = owner;
            this.seen = seen;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PruningInitialized)) return false;
            PruningInitialized pruningInitialized = (PruningInitialized)object;
            UniqueAddress uniqueAddress = this.owner();
            UniqueAddress uniqueAddress2 = pruningInitialized.owner();
            if (uniqueAddress == null) {
                if (uniqueAddress2 != null) {
                    return false;
                }
            } else if (!uniqueAddress.equals(uniqueAddress2)) return false;
            Set<Address> set = this.seen();
            Set<Address> set2 = pruningInitialized.seen();
            if (set == null) {
                if (set2 == null) return true;
                return false;
            } else {
                if (!set.equals(set2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PruningInitialized;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "PruningInitialized";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "owner";
            }
            if (1 == n2) {
                return "seen";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UniqueAddress owner() {
            return this.owner;
        }

        public Set<Address> seen() {
            return this.seen;
        }

        @Override
        public PruningState addSeen(Address node) {
            block3: {
                block2: {
                    if (this.seen().apply((Object)node)) break block2;
                    Address address = this.owner().address();
                    Address address2 = node;
                    if (address != null ? !address.equals(address2) : address2 != null) break block3;
                }
                return this;
            }
            Set set = (Set)this.seen().$plus((Object)node);
            UniqueAddress uniqueAddress = this.copy$default$1();
            return this.copy(uniqueAddress, (Set<Address>)set);
        }

        @Override
        public int estimatedSize() {
            return EstimatedSize$.MODULE$.UniqueAddress() + EstimatedSize$.MODULE$.Address() * this.seen().size();
        }

        public PruningInitialized copy(UniqueAddress owner, Set<Address> seen) {
            return new PruningInitialized(owner, seen);
        }

        public UniqueAddress copy$default$1() {
            return this.owner();
        }

        public Set<Address> copy$default$2() {
            return this.seen();
        }

        public UniqueAddress _1() {
            return this.owner();
        }

        public Set<Address> _2() {
            return this.seen();
        }
    }

    public static final class PruningPerformed
    implements PruningState,
    Product,
    Serializable {
        private final long obsoleteTime;

        public static PruningPerformed apply(long l) {
            return PruningState$PruningPerformed$.MODULE$.apply(l);
        }

        public static PruningPerformed fromProduct(Product product) {
            return PruningState$PruningPerformed$.MODULE$.fromProduct(product);
        }

        public static PruningPerformed unapply(PruningPerformed pruningPerformed) {
            return PruningState$PruningPerformed$.MODULE$.unapply(pruningPerformed);
        }

        public PruningPerformed(long obsoleteTime) {
            this.obsoleteTime = obsoleteTime;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.obsoleteTime()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PruningPerformed)) return false;
            PruningPerformed pruningPerformed = (PruningPerformed)object;
            if (this.obsoleteTime() != pruningPerformed.obsoleteTime()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PruningPerformed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "PruningPerformed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "obsoleteTime";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long obsoleteTime() {
            return this.obsoleteTime;
        }

        public boolean isObsolete(long currentTime) {
            return this.obsoleteTime() <= currentTime;
        }

        @Override
        public PruningState addSeen(Address node) {
            return this;
        }

        @Override
        public int estimatedSize() {
            return EstimatedSize$.MODULE$.LongValue();
        }

        public PruningPerformed copy(long obsoleteTime) {
            return new PruningPerformed(obsoleteTime);
        }

        public long copy$default$1() {
            return this.obsoleteTime();
        }

        public long _1() {
            return this.obsoleteTime();
        }
    }
}

