/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.ReadWriteAggregator$;
import org.apache.pekko.cluster.ddata.ReadWriteAggregator$SendToSecondary$;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Statics;
import scala.util.Random$;

@InternalApi
public abstract class ReadWriteAggregator
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final Cancellable sendToSecondarySchedule;
    private final Cancellable timeoutSchedule;
    private Set remaining;

    public static int MaxSecondaryNodes() {
        return ReadWriteAggregator$.MODULE$.MaxSecondaryNodes();
    }

    public static int calculateMajority(int n, int n2, int n3) {
        return ReadWriteAggregator$.MODULE$.calculateMajority(n, n2, n3);
    }

    public ReadWriteAggregator() {
        Actor.$init$((Actor)this);
        this.sendToSecondarySchedule = this.context().system().scheduler().scheduleOnce(this.timeout().$div(5L), this.self(), (Object)ReadWriteAggregator$SendToSecondary$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.timeoutSchedule = this.context().system().scheduler().scheduleOnce(this.timeout(), this.self(), (Object)ReceiveTimeout$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.remaining = this.nodes().iterator().map((Function1 & Serializable)_$11 -> _$11.address()).toSet();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public abstract FiniteDuration timeout();

    public abstract Vector<UniqueAddress> nodes();

    public abstract Set<UniqueAddress> unreachable();

    public Vector<UniqueAddress> reachableNodes() {
        return (Vector)this.nodes().filterNot(this.unreachable());
    }

    public abstract boolean shuffle();

    public Set<Address> remaining() {
        return this.remaining;
    }

    public void remaining_$eq(Set<Address> x$1) {
        this.remaining = x$1;
    }

    public abstract int doneWhenRemainingSize();

    public Tuple2<Vector<UniqueAddress>, Vector<UniqueAddress>> primaryAndSecondaryNodes() {
        int primarySize = this.nodes().size() - this.doneWhenRemainingSize();
        if (primarySize >= this.nodes().size()) {
            return Tuple2$.MODULE$.apply(this.nodes(), (Object)package$.MODULE$.Vector().empty());
        }
        Vector orderedNodes = this.shuffle() ? (Vector)((IterableOps)Random$.MODULE$.shuffle(this.reachableNodes(), BuildFrom$.MODULE$.buildFromIterableOps())).$plus$plus((IterableOnce)Random$.MODULE$.shuffle((IterableOnce)this.unreachable().toVector(), BuildFrom$.MODULE$.buildFromIterableOps())) : (Vector)this.reachableNodes().$plus$plus(this.unreachable());
        Tuple2 tuple2 = orderedNodes.splitAt(primarySize);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector p = (Vector)tuple2._1();
        Vector s = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)p, (Object)s);
        Vector p2 = (Vector)tuple22._1();
        Vector s2 = (Vector)tuple22._2();
        return Tuple2$.MODULE$.apply((Object)p2, (Object)s2.take(ReadWriteAggregator$.MODULE$.MaxSecondaryNodes()));
    }

    public void postStop() {
        this.sendToSecondarySchedule.cancel();
        this.timeoutSchedule.cancel();
    }

    public ActorSelection replica(UniqueAddress node) {
        return this.context().actorSelection(this.context().parent().path().toStringWithAddress(node.address()));
    }
}

