/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.OneForOneStrategy$;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.actor.SupervisorStrategy;
import org.apache.pekko.actor.SupervisorStrategy$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ClusterEvent;
import org.apache.pekko.cluster.Member;
import org.apache.pekko.cluster.Member$;
import org.apache.pekko.cluster.MemberStatus;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.DeltaPropagationSelector;
import org.apache.pekko.cluster.ddata.DeltaReplicatedData;
import org.apache.pekko.cluster.ddata.DurableStore;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAll$;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAllCompleted$;
import org.apache.pekko.cluster.ddata.DurableStore$LoadData$;
import org.apache.pekko.cluster.ddata.DurableStore$Store$;
import org.apache.pekko.cluster.ddata.DurableStore$StoreReply$;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.PayloadSizeAggregator;
import org.apache.pekko.cluster.ddata.PruningState;
import org.apache.pekko.cluster.ddata.PruningState$PruningInitialized$;
import org.apache.pekko.cluster.ddata.PruningState$PruningPerformed$;
import org.apache.pekko.cluster.ddata.ReadAggregator$;
import org.apache.pekko.cluster.ddata.RemovedNodePruning;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.ReplicatedDelta;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.Replicator$;
import org.apache.pekko.cluster.ddata.Replicator$Changed$;
import org.apache.pekko.cluster.ddata.Replicator$DataDeleted$;
import org.apache.pekko.cluster.ddata.Replicator$Delete$;
import org.apache.pekko.cluster.ddata.Replicator$DeleteSuccess$;
import org.apache.pekko.cluster.ddata.Replicator$Deleted$;
import org.apache.pekko.cluster.ddata.Replicator$FlushChanges$;
import org.apache.pekko.cluster.ddata.Replicator$Get$;
import org.apache.pekko.cluster.ddata.Replicator$GetDataDeleted$;
import org.apache.pekko.cluster.ddata.Replicator$GetFailure$;
import org.apache.pekko.cluster.ddata.Replicator$GetKeyIds$;
import org.apache.pekko.cluster.ddata.Replicator$GetKeyIdsResult$;
import org.apache.pekko.cluster.ddata.Replicator$GetReplicaCount$;
import org.apache.pekko.cluster.ddata.Replicator$GetSuccess$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$ClockTick$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DataEnvelope$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeletedData$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$Delta$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeltaNack$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeltaPropagation$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeltaPropagationTick$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$Gossip$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$GossipTick$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$Read$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$ReadRepair$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$ReadRepairAck$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$ReadResult$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$RemovedNodePruningTick$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$Status$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$TestFullStateGossip$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$Write$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$WriteAck$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$WriteNack$;
import org.apache.pekko.cluster.ddata.Replicator$ModifyFailure$;
import org.apache.pekko.cluster.ddata.Replicator$NotFound$;
import org.apache.pekko.cluster.ddata.Replicator$ReadAll$;
import org.apache.pekko.cluster.ddata.Replicator$ReadFrom$;
import org.apache.pekko.cluster.ddata.Replicator$ReadLocal$;
import org.apache.pekko.cluster.ddata.Replicator$ReadMajority$;
import org.apache.pekko.cluster.ddata.Replicator$ReadMajorityPlus$;
import org.apache.pekko.cluster.ddata.Replicator$ReplicaCount$;
import org.apache.pekko.cluster.ddata.Replicator$ReplicationDeleteFailure$;
import org.apache.pekko.cluster.ddata.Replicator$StoreFailure$;
import org.apache.pekko.cluster.ddata.Replicator$Subscribe$;
import org.apache.pekko.cluster.ddata.Replicator$Unsubscribe$;
import org.apache.pekko.cluster.ddata.Replicator$Update$;
import org.apache.pekko.cluster.ddata.Replicator$UpdateDataDeleted$;
import org.apache.pekko.cluster.ddata.Replicator$UpdateSuccess$;
import org.apache.pekko.cluster.ddata.Replicator$UpdateTimeout$;
import org.apache.pekko.cluster.ddata.Replicator$WriteAll$;
import org.apache.pekko.cluster.ddata.Replicator$WriteLocal$;
import org.apache.pekko.cluster.ddata.Replicator$WriteMajority$;
import org.apache.pekko.cluster.ddata.Replicator$WriteMajorityPlus$;
import org.apache.pekko.cluster.ddata.Replicator$WriteTo$;
import org.apache.pekko.cluster.ddata.ReplicatorSettings;
import org.apache.pekko.cluster.ddata.RequiresCausalDeliveryOfDeltas;
import org.apache.pekko.cluster.ddata.VersionVector;
import org.apache.pekko.cluster.ddata.VersionVector$;
import org.apache.pekko.cluster.ddata.WriteAggregator$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.remote.RARP;
import org.apache.pekko.remote.RARP$;
import org.apache.pekko.remote.RemoteActorRefProvider;
import org.apache.pekko.remote.RemoteSettings;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.ccompat.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.ReusableBuilder;
import scala.collection.mutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NoStackTrace;
import scala.util.control.NonFatal$;

public final class Replicator
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    public final ReplicatorSettings org$apache$pekko$cluster$ddata$Replicator$$settings;
    private final Cluster cluster;
    private final Address selfAddress;
    private final UniqueAddress selfUniqueAddress;
    private final Some selfFromSystemUid;
    private final PayloadSizeAggregator payloadSizeAggregator;
    private final Cancellable gossipTask;
    private final Cancellable notifyTask;
    private final Option pruningTask;
    private final Cancellable clockTask;
    private final Serializer serializer;
    private final long maxPruningDisseminationNanos;
    private final boolean hasDurableKeys;
    private final scala.collection.immutable.Set durable;
    private final scala.collection.immutable.Set durableWildcards;
    private final ActorRef durableStore;
    private final DeltaPropagationSelector deltaPropagationSelector;
    private final Option deltaPropagationTask;
    private SortedSet nodes;
    private SortedSet membersByAge;
    private SortedSet weaklyUpNodes;
    private SortedSet joiningNodes;
    private SortedSet exitingNodes;
    private Map removedNodes;
    private TreeSet leader;
    private long previousClockTime;
    private long allReachableClockTime;
    private scala.collection.immutable.Set unreachable;
    private Map dataEntries;
    private scala.collection.immutable.Set changed;
    private long statusCount;
    private int statusTotChunks;
    private boolean fullStateGossipEnabled;
    private final HashMap subscribers;
    private final HashMap newSubscribers;
    private Map subscriptionKeys;
    private ActorRef replyTo;
    private final SupervisorStrategy supervisorStrategy;
    private final PartialFunction load;
    private final PartialFunction normalReceive;

    public static int DefaultMajorityMinCap() {
        return Replicator$.MODULE$.DefaultMajorityMinCap();
    }

    public static Replicator$FlushChanges$ flushChanges() {
        return Replicator$.MODULE$.flushChanges();
    }

    public static Replicator$GetReplicaCount$ getReplicaCount() {
        return Replicator$.MODULE$.getReplicaCount();
    }

    public static Props props(ReplicatorSettings replicatorSettings) {
        return Replicator$.MODULE$.props(replicatorSettings);
    }

    public static Replicator$ReadLocal$ readLocal() {
        return Replicator$.MODULE$.readLocal();
    }

    public static Replicator$WriteLocal$ writeLocal() {
        return Replicator$.MODULE$.writeLocal();
    }

    public Replicator(ReplicatorSettings settings) {
        None$ none$;
        ActorRef actorRef;
        this.org$apache$pekko$cluster$ddata$Replicator$$settings = settings;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.selfAddress = this.cluster().selfAddress();
        this.selfUniqueAddress = this.cluster().selfUniqueAddress();
        this.selfFromSystemUid = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)this.selfUniqueAddress().longUid()));
        Predef$.MODULE$.require(!this.cluster().isTerminated(), Replicator::$init$$$anonfun$1);
        Predef$.MODULE$.require(settings.roles().subsetOf((scala.collection.Set)this.cluster().selfRoles()), () -> this.$init$$$anonfun$2(settings));
        int sizeExceeding = BoxesRunTime.unboxToInt((Object)settings.logDataSizeExceeding().getOrElse(Replicator::$anonfun$1));
        RemoteActorRefProvider remoteProvider = ((RARP)RARP$.MODULE$.apply(this.context().system())).provider();
        RemoteSettings remoteSettings = remoteProvider.remoteSettings();
        int maxFrameSize = remoteSettings.Artery().Enabled() ? remoteSettings.Artery().Advanced().MaximumFrameSize() : (int)Predef$.MODULE$.Long2long(this.context().system().settings().config().getBytes("pekko.remote.classic.netty.tcp.maximum-frame-size"));
        this.payloadSizeAggregator = new PayloadSizeAggregator(this.log(), sizeExceeding, maxFrameSize);
        this.gossipTask = this.context().system().scheduler().scheduleWithFixedDelay(settings.gossipInterval(), settings.gossipInterval(), this.self(), (Object)Replicator$Internal$GossipTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.notifyTask = this.context().system().scheduler().scheduleWithFixedDelay(settings.notifySubscribersInterval(), settings.notifySubscribersInterval(), this.self(), (Object)Replicator$FlushChanges$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.pruningTask = settings.pruningInterval().$greater$eq((Object)Duration$.MODULE$.Zero()) ? Some$.MODULE$.apply((Object)this.context().system().scheduler().scheduleWithFixedDelay(settings.pruningInterval(), settings.pruningInterval(), this.self(), (Object)Replicator$Internal$RemovedNodePruningTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self())) : None$.MODULE$;
        this.clockTask = this.context().system().scheduler().scheduleWithFixedDelay(settings.gossipInterval(), settings.gossipInterval(), this.self(), (Object)Replicator$Internal$ClockTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.serializer = ((Serialization)SerializationExtension$.MODULE$.apply(this.context().system())).serializerFor(Internal.DataEnvelope.class);
        this.maxPruningDisseminationNanos = settings.maxPruningDissemination().toNanos();
        this.hasDurableKeys = settings.durableKeys().nonEmpty();
        this.durable = (scala.collection.immutable.Set)settings.durableKeys().filterNot((Function1 & Serializable)_$2 -> _$2.endsWith("*"));
        this.durableWildcards = (scala.collection.immutable.Set)settings.durableKeys().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                String k = string;
                return k.endsWith("*");
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String k = string;
                if (k.endsWith("*")) {
                    return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(k), 1);
                }
                return function1.apply((Object)x);
            }
        });
        if (this.hasDurableKeys()) {
            Tuple2 tuple2;
            Props props;
            Either<Tuple2<String, Config>, Props> either = settings.durableStoreProps();
            if (either instanceof Right) {
                Props p;
                props = p = (Props)((Right)either).value();
            } else if (either instanceof Left && (tuple2 = (Tuple2)((Left)either).value()) != null) {
                String s = (String)tuple2._1();
                Config c = (Config)tuple2._2();
                Class clazz = (Class)((ExtendedActorSystem)this.context().system()).dynamicAccess().getClassFor(s, ClassTag$.MODULE$.apply(Actor.class)).get();
                props = Props$.MODULE$.apply(clazz, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{c})).withDispatcher(c.getString("use-dispatcher"));
            } else {
                throw new MatchError(either);
            }
            Props props2 = props;
            actorRef = this.context().watch(this.context().actorOf(props2.withDeploy(Deploy$.MODULE$.local()), "durableStore"));
        } else {
            actorRef = this.context().system().deadLetters();
        }
        this.durableStore = actorRef;
        this.deltaPropagationSelector = new DeltaPropagationSelector(this){
            private long org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount;
            private Map org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter;
            private Map org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries;
            private Map org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode;
            private long org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter;
            private final int gossipIntervalDivisor;
            private final /* synthetic */ Replicator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                DeltaPropagationSelector.$init$(this);
                this.gossipIntervalDivisor = 5;
            }

            public long org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount() {
                return this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount;
            }

            public Map org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter() {
                return this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter;
            }

            public Map org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries() {
                return this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries;
            }

            public Map org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode() {
                return this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode;
            }

            public long org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter() {
                return this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter;
            }

            public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount_$eq(long x$1) {
                this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$_propagationCount = x$1;
            }

            public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter_$eq(Map x$1) {
                this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaCounter = x$1;
            }

            public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries_$eq(Map x$1) {
                this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaEntries = x$1;
            }

            public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode_$eq(Map x$1) {
                this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaSentToNode = x$1;
            }

            public void org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter_$eq(long x$1) {
                this.org$apache$pekko$cluster$ddata$DeltaPropagationSelector$$deltaNodeRoundRobinCounter = x$1;
            }

            public int gossipIntervalDivisor() {
                return this.gossipIntervalDivisor;
            }

            public Vector allNodes() {
                return this.$outer.org$apache$pekko$cluster$ddata$Replicator$$allNodes().diff(this.$outer.unreachable()).toVector();
            }

            public int maxDeltaSize() {
                return this.$outer.org$apache$pekko$cluster$ddata$Replicator$$settings.maxDeltaSize();
            }

            public Internal.DeltaPropagation createDeltaPropagation(Map deltas) {
                return Replicator$Internal$DeltaPropagation$.MODULE$.apply(this.$outer.selfUniqueAddress(), false, (Map<String, Internal.Delta>)deltas.iterator().collect((PartialFunction)new Serializable(this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Tuple2 x) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            Tuple3 tuple3 = (Tuple3)tuple2._2();
                            String key = (String)tuple2._1();
                            if (tuple3 != null) {
                                ReplicatedData d = (ReplicatedData)tuple3._1();
                                long fromSeqNr = BoxesRunTime.unboxToLong((Object)tuple3._2());
                                long toSeqNr = BoxesRunTime.unboxToLong((Object)tuple3._3());
                                ReplicatedData replicatedData = d;
                                ReplicatedDelta replicatedDelta = Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder();
                                if (replicatedData == null ? replicatedDelta != null : !replicatedData.equals(replicatedDelta)) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    }

                    public final Object applyOrElse(Tuple2 x, Function1 function1) {
                        Tuple2 tuple2 = x;
                        if (tuple2 != null) {
                            Tuple3 tuple3 = (Tuple3)tuple2._2();
                            String key = (String)tuple2._1();
                            if (tuple3 != null) {
                                ReplicatedData d = (ReplicatedData)tuple3._1();
                                long fromSeqNr = BoxesRunTime.unboxToLong((Object)tuple3._2());
                                long toSeqNr = BoxesRunTime.unboxToLong((Object)tuple3._3());
                                ReplicatedData replicatedData = d;
                                ReplicatedDelta replicatedDelta = Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder();
                                if (replicatedData == null ? replicatedDelta != null : !replicatedData.equals(replicatedDelta)) {
                                    Option<Internal.DataEnvelope> option = this.$outer.org$apache$pekko$cluster$ddata$Replicator$_$$anon$$$outer().getData(key);
                                    if (option instanceof Some) {
                                        Internal.DataEnvelope envelope = (Internal.DataEnvelope)((Some)option).value();
                                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Replicator$Internal$Delta$.MODULE$.apply(envelope.copy(d, envelope.copy$default$2(), envelope.copy$default$3()), fromSeqNr, toSeqNr));
                                    }
                                    if (None$.MODULE$.equals(option)) {
                                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Replicator$Internal$Delta$.MODULE$.apply(Replicator$Internal$DataEnvelope$.MODULE$.apply(d, Replicator$Internal$DataEnvelope$.MODULE$.$lessinit$greater$default$2(), Replicator$Internal$DataEnvelope$.MODULE$.$lessinit$greater$default$3()), fromSeqNr, toSeqNr));
                                    }
                                    throw new MatchError(option);
                                }
                            }
                        }
                        return function1.apply((Object)x);
                    }
                }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            }

            public final /* synthetic */ Replicator org$apache$pekko$cluster$ddata$Replicator$_$$anon$$$outer() {
                return this.$outer;
            }
        };
        if (settings.deltaCrdtEnabled()) {
            FiniteDuration deltaPropagationInterval = settings.gossipInterval().$div(Int$.MODULE$.int2long(this.deltaPropagationSelector().gossipIntervalDivisor())).max(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(200)).millis());
            none$ = Some$.MODULE$.apply((Object)this.context().system().scheduler().scheduleWithFixedDelay(deltaPropagationInterval, deltaPropagationInterval, this.self(), (Object)Replicator$Internal$DeltaPropagationTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self()));
        } else {
            none$ = None$.MODULE$;
        }
        this.deltaPropagationTask = none$;
        this.nodes = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.membersByAge = (SortedSet)SortedSet$.MODULE$.empty((Object)Member$.MODULE$.ageOrdering());
        this.weaklyUpNodes = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.joiningNodes = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.exitingNodes = (SortedSet)SortedSet$.MODULE$.empty((Object)Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        this.removedNodes = Predef$.MODULE$.Map().empty();
        this.leader = TreeSet$.MODULE$.empty(Member$.MODULE$.leaderStatusOrdering());
        this.previousClockTime = System.nanoTime();
        this.allReachableClockTime = 0L;
        this.unreachable = Predef$.MODULE$.Set().empty();
        this.dataEntries = Predef$.MODULE$.Map().empty();
        this.changed = Predef$.MODULE$.Set().empty();
        this.statusCount = 0L;
        this.statusTotChunks = 0;
        this.fullStateGossipEnabled = true;
        this.subscribers = new MultiMap<String, ActorRef>(){
            {
                MultiMap.$init$((MultiMap)this);
            }
        };
        this.newSubscribers = new MultiMap<String, ActorRef>(){
            {
                MultiMap.$init$((MultiMap)this);
            }
        };
        this.subscriptionKeys = Predef$.MODULE$.Map().empty();
        this.replyTo = null;
        this.supervisorStrategy = OneForOneStrategy$.MODULE$.apply(OneForOneStrategy$.MODULE$.$lessinit$greater$default$1(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$2(), OneForOneStrategy$.MODULE$.$lessinit$greater$default$3(), new Serializable(this){
            private final /* synthetic */ Replicator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof DurableStore.LoadFailed || throwable instanceof ActorInitializationException) {
                    RuntimeException e = (RuntimeException)throwable;
                    if (this.$outer.org$apache$pekko$cluster$ddata$Replicator$$_$fromDurableStore$1()) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof DurableStore.LoadFailed || throwable instanceof ActorInitializationException) {
                    RuntimeException e = (RuntimeException)throwable;
                    if (this.$outer.org$apache$pekko$cluster$ddata$Replicator$$_$fromDurableStore$1()) {
                        this.$outer.log().error((Throwable)e, "Stopping distributed-data Replicator due to load or startup failure in durable store, caused by: {}", (Object)(e.getCause() == null ? "" : e.getCause().getMessage()));
                        this.$outer.context().stop(this.$outer.self());
                        return SupervisorStrategy.Stop$.MODULE$;
                    }
                }
                return function1.apply((Object)x);
            }
        }.orElse(SupervisorStrategy$.MODULE$.defaultDecider()));
        long startTime = System.nanoTime();
        IntRef count = IntRef.create((int)0);
        ObjectRef stash = ObjectRef.create((Object)scala.package$.MODULE$.Vector().empty());
        this.load = new Serializable(startTime, count, stash, this){
            private final long startTime$1;
            private final IntRef count$1;
            private final ObjectRef stash$2;
            private final /* synthetic */ Replicator $outer;
            {
                this.startTime$1 = startTime$2;
                this.count$1 = count$2;
                this.stash$2 = stash$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DurableStore.LoadData) {
                    Map<String, DurableStore.DurableDataEnvelope> map;
                    DurableStore.LoadData loadData = DurableStore$LoadData$.MODULE$.unapply((DurableStore.LoadData)object);
                    Map<String, DurableStore.DurableDataEnvelope> data = map = loadData._1();
                    return true;
                }
                if (DurableStore$LoadAllCompleted$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$GetReplicaCount$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$Internal$RemovedNodePruningTick$.MODULE$.equals(object) || Replicator$FlushChanges$.MODULE$.equals(object) || Replicator$Internal$GossipTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Internal.TestFullStateGossip) {
                    boolean bl;
                    Internal.TestFullStateGossip testFullStateGossip = Replicator$Internal$TestFullStateGossip$.MODULE$.unapply((Internal.TestFullStateGossip)object);
                    boolean enabled = bl = testFullStateGossip._1();
                    return true;
                }
                if (object instanceof Internal.Read || object instanceof Internal.Write || object instanceof Internal.Status || object instanceof Internal.Gossip) {
                    Product m = (Product)object;
                    return true;
                }
                if (object instanceof ClusterEvent.ClusterDomainEvent) {
                    ClusterEvent.ClusterDomainEvent msg = (ClusterEvent.ClusterDomainEvent)object;
                    return true;
                }
                Object msg = object;
                return true;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                block7: {
                    Object object;
                    block9: {
                        block8: {
                            block6: {
                                int n;
                                Map<String, DurableStore.DurableDataEnvelope> map;
                                object = x;
                                if (!(object instanceof DurableStore.LoadData)) break block6;
                                DurableStore.LoadData loadData = DurableStore$LoadData$.MODULE$.unapply((DurableStore.LoadData)object);
                                Map<String, DurableStore.DurableDataEnvelope> data = map = loadData._1();
                                this.count$1.elem = n = this.count$1.elem + data.size();
                                data.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                                    Tuple2 tuple2 = x$1;
                                    if (tuple2 != null) {
                                        DurableStore.DurableDataEnvelope d;
                                        String key = (String)tuple2._1();
                                        Option<Internal.DataEnvelope> option = this.$outer.write(key, (d = (DurableStore.DurableDataEnvelope)tuple2._2()).dataEnvelope());
                                        if (option instanceof Some) {
                                            Internal.DataEnvelope newEnvelope = (Internal.DataEnvelope)((Some)option).value();
                                            if (newEnvelope != d.dataEnvelope()) {
                                                this.$outer.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key, new DurableStore.DurableDataEnvelope(newEnvelope), (Option<DurableStore.StoreReply>)None$.MODULE$), this.$outer.self());
                                                return;
                                            }
                                            return;
                                        }
                                        if (None$.MODULE$.equals(option)) {
                                            return;
                                        }
                                        throw new MatchError(option);
                                    }
                                    throw new MatchError((Object)tuple2);
                                });
                                break block7;
                            }
                            if (!DurableStore$LoadAllCompleted$.MODULE$.equals(object)) break block8;
                            this.$outer.log().debug("Loading {} entries from durable store took {} ms, stashed {}", (Object)BoxesRunTime.boxToInteger((int)this.count$1.elem), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startTime$1)), (Object)BoxesRunTime.boxToInteger((int)((Vector)this.stash$2.elem).size()));
                            this.$outer.context().become(this.$outer.normalReceive());
                            this.$outer.org$apache$pekko$cluster$ddata$Replicator$$_$unstashAll$1(this.stash$2);
                            this.$outer.self().$bang((Object)Replicator$FlushChanges$.MODULE$, this.$outer.self());
                            break block7;
                        }
                        if (!Replicator$GetReplicaCount$.MODULE$.equals(object)) break block9;
                        this.$outer.replyTo().$bang((Object)Replicator$ReplicaCount$.MODULE$.apply(0), this.$outer.self());
                        break block7;
                    }
                    if (Replicator$Internal$RemovedNodePruningTick$.MODULE$.equals(object) || Replicator$FlushChanges$.MODULE$.equals(object) || Replicator$Internal$GossipTick$.MODULE$.equals(object)) break block7;
                    if (object instanceof Internal.TestFullStateGossip) {
                        boolean bl;
                        Internal.TestFullStateGossip testFullStateGossip = Replicator$Internal$TestFullStateGossip$.MODULE$.unapply((Internal.TestFullStateGossip)object);
                        boolean enabled = bl = testFullStateGossip._1();
                        this.$outer.fullStateGossipEnabled_$eq(enabled);
                    } else if (object instanceof Internal.Read || object instanceof Internal.Write || object instanceof Internal.Status || object instanceof Internal.Gossip) {
                        Product m = (Product)object;
                        this.$outer.log().debug("ignoring message [{}] when loading durable data", (Object)m.getClass().getName());
                    } else if (object instanceof ClusterEvent.ClusterDomainEvent) {
                        ClusterEvent.ClusterDomainEvent msg = (ClusterEvent.ClusterDomainEvent)object;
                        this.$outer.normalReceive().applyOrElse((Object)msg, (Function1)(JProcedure1 & Serializable)message -> this.$outer.unhandled(message));
                    } else {
                        Object msg = object;
                        Object object2 = Predef$.MODULE$.ArrowAssoc(msg);
                        Vector vector = (Vector)((Vector)this.stash$2.elem).$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object2, (Object)this.$outer.replyTo()));
                        this.stash$2.elem = vector;
                        vector = null;
                    }
                }
                return BoxedUnit.UNIT;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(scala.Tuple2 ), applyOrElse$$anonfun$2(java.lang.Object )}, serializedLambda);
            }
        };
        this.normalReceive = new Serializable(this){
            private final /* synthetic */ Replicator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Internal.DestinationSystemUid) {
                    Internal.DestinationSystemUid msg = (Internal.DestinationSystemUid)object;
                    return true;
                }
                if (object instanceof Internal.SendingSystemUid) {
                    Internal.SendingSystemUid msg = (Internal.SendingSystemUid)object;
                    return true;
                }
                if (object instanceof Get) {
                    Get<A> get = Replicator$Get$.MODULE$.unapply((Get)object);
                    Key<A> key = get._1();
                    ReadConsistency readConsistency = get._2();
                    Option<Object> option = get._3();
                    Key<A> key2 = key;
                    ReadConsistency consistency = readConsistency;
                    Option<Object> req = option;
                    return true;
                }
                if (object instanceof Update) {
                    Update update = (Update)object;
                    Update<A> update2 = Replicator$Update$.MODULE$.unapply(update);
                    Key<A> key = update2._1();
                    WriteConsistency writeConsistency = update2._2();
                    Option<Object> option = update2._3();
                    Key<A> key3 = key;
                    WriteConsistency writeC = writeConsistency;
                    Option<Object> req = option;
                    Update u = update;
                    return true;
                }
                if (object instanceof Internal.ReadRepair) {
                    Internal.ReadRepair readRepair = Replicator$Internal$ReadRepair$.MODULE$.unapply((Internal.ReadRepair)object);
                    String string = readRepair._1();
                    Internal.DataEnvelope dataEnvelope = readRepair._2();
                    String key = string;
                    Internal.DataEnvelope envelope = dataEnvelope;
                    return true;
                }
                if (Replicator$FlushChanges$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$Internal$DeltaPropagationTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$Internal$GossipTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$Internal$ClockTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Subscribe) {
                    Subscribe<A> subscribe = Replicator$Subscribe$.MODULE$.unapply((Subscribe)object);
                    Key<A> key = subscribe._1();
                    ActorRef actorRef = subscribe._2();
                    Key<A> key4 = key;
                    ActorRef subscriber = actorRef;
                    return true;
                }
                if (object instanceof Unsubscribe) {
                    Unsubscribe<A> unsubscribe = Replicator$Unsubscribe$.MODULE$.unapply((Unsubscribe)object);
                    Key<A> key = unsubscribe._1();
                    ActorRef actorRef = unsubscribe._2();
                    Key<A> key5 = key;
                    ActorRef subscriber = actorRef;
                    return true;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    Member member;
                    ClusterEvent.MemberJoined memberJoined = ClusterEvent.MemberJoined$.MODULE$.unapply((ClusterEvent.MemberJoined)object);
                    Member m = member = memberJoined._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    Member member;
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = ClusterEvent.MemberWeaklyUp$.MODULE$.unapply((ClusterEvent.MemberWeaklyUp)object);
                    Member m = member = memberWeaklyUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    Member member;
                    ClusterEvent.MemberExited memberExited = ClusterEvent.MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)object);
                    Member m = member = memberExited._1();
                    return true;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    return true;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    return true;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent.UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    return true;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent.ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    return true;
                }
                if (Replicator$GetKeyIds$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Delete) {
                    Delete<A> delete = Replicator$Delete$.MODULE$.unapply((Delete)object);
                    Key<A> key = delete._1();
                    WriteConsistency writeConsistency = delete._2();
                    Option<Object> option = delete._3();
                    Key<A> key6 = key;
                    WriteConsistency consistency = writeConsistency;
                    Option<Object> req = option;
                    return true;
                }
                if (Replicator$Internal$RemovedNodePruningTick$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$GetReplicaCount$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Internal.TestFullStateGossip) {
                    boolean bl;
                    Internal.TestFullStateGossip testFullStateGossip = Replicator$Internal$TestFullStateGossip$.MODULE$.unapply((Internal.TestFullStateGossip)object);
                    boolean enabled = bl = testFullStateGossip._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Internal.DestinationSystemUid) {
                    long uid;
                    Internal.DestinationSystemUid msg = (Internal.DestinationSystemUid)object;
                    Option<Object> option = msg.toSystemUid();
                    if (option instanceof Some && (uid = BoxesRunTime.unboxToLong((Object)((Some)option).value())) != this.$outer.selfUniqueAddress().longUid()) {
                        this.$outer.log().info("Ignoring message [{}] from [{}] intended for system uid [{}], self uid is [{}]", (Object)Logging$.MODULE$.simpleName((Object)msg), (Object)this.$outer.replyTo(), (Object)BoxesRunTime.boxToLong((long)uid), (Object)BoxesRunTime.boxToLong((long)this.$outer.selfUniqueAddress().longUid()));
                    } else {
                        Internal.DestinationSystemUid destinationSystemUid = msg;
                        if (destinationSystemUid instanceof Internal.Status) {
                            Internal.Status status = Replicator$Internal$Status$.MODULE$.unapply((Internal.Status)destinationSystemUid);
                            Map<String, ByteString> map = status._1();
                            int n = status._2();
                            int n2 = status._3();
                            Option<Object> option2 = status._4();
                            Option<Object> option3 = status._5();
                            Map<String, ByteString> otherDigests = map;
                            int chunk = n;
                            int totChunks = n2;
                            Option<Object> fromSystemUid = option3;
                            this.$outer.receiveStatus(otherDigests, chunk, totChunks, fromSystemUid);
                        } else if (destinationSystemUid instanceof Internal.Gossip) {
                            Internal.Gossip gossip = Replicator$Internal$Gossip$.MODULE$.unapply((Internal.Gossip)destinationSystemUid);
                            Map<String, Internal.DataEnvelope> map = gossip._1();
                            boolean bl = gossip._2();
                            Option<Object> option4 = gossip._3();
                            Option<Object> option5 = gossip._4();
                            Map<String, Internal.DataEnvelope> updatedData = map;
                            boolean sendBack = bl;
                            Option<Object> fromSystemUid = option5;
                            this.$outer.receiveGossip(updatedData, sendBack, fromSystemUid);
                        } else {
                            throw new MatchError((Object)destinationSystemUid);
                        }
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.SendingSystemUid) {
                    UniqueAddress fromNode;
                    Internal.SendingSystemUid msg = (Internal.SendingSystemUid)object;
                    Option<UniqueAddress> option = msg.fromNode();
                    if (option instanceof Some && !this.$outer.org$apache$pekko$cluster$ddata$Replicator$$isKnownNode(fromNode = (UniqueAddress)((Some)option).value())) {
                        this.$outer.log().info("Ignoring message [{}] from [{}] unknown node [{}]", (Object)Logging$.MODULE$.simpleName((Object)msg), (Object)this.$outer.replyTo(), (Object)fromNode);
                    } else {
                        Internal.SendingSystemUid sendingSystemUid = msg;
                        if (sendingSystemUid instanceof Internal.Read) {
                            Internal.Read read = Replicator$Internal$Read$.MODULE$.unapply((Internal.Read)sendingSystemUid);
                            String string = read._1();
                            Option<UniqueAddress> option6 = read._2();
                            String key = string;
                            this.$outer.receiveRead(key);
                        } else if (sendingSystemUid instanceof Internal.Write) {
                            Internal.Write write = Replicator$Internal$Write$.MODULE$.unapply((Internal.Write)sendingSystemUid);
                            String string = write._1();
                            Internal.DataEnvelope dataEnvelope = write._2();
                            Option<UniqueAddress> option7 = write._3();
                            String key = string;
                            Internal.DataEnvelope envelope = dataEnvelope;
                            this.$outer.receiveWrite(key, envelope);
                        } else if (sendingSystemUid instanceof Internal.DeltaPropagation) {
                            Internal.DeltaPropagation deltaPropagation = Replicator$Internal$DeltaPropagation$.MODULE$.unapply((Internal.DeltaPropagation)sendingSystemUid);
                            UniqueAddress uniqueAddress = deltaPropagation._1();
                            boolean bl = deltaPropagation._2();
                            Map<String, Internal.Delta> map = deltaPropagation._3();
                            UniqueAddress from = uniqueAddress;
                            boolean reply = bl;
                            Map<String, Internal.Delta> deltas = map;
                            this.$outer.receiveDeltaPropagation(from, reply, deltas);
                        } else {
                            throw new MatchError((Object)sendingSystemUid);
                        }
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Get) {
                    Get<A> get = Replicator$Get$.MODULE$.unapply((Get)object);
                    Key<ReplicatedData> key = get._1();
                    ReadConsistency readConsistency = get._2();
                    Option<Object> option = get._3();
                    Key<ReplicatedData> key2 = key;
                    ReadConsistency consistency = readConsistency;
                    Option<Object> req = option;
                    this.$outer.receiveGet(key2, consistency, req);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Update) {
                    Update update = (Update)object;
                    Update<A> update2 = Replicator$Update$.MODULE$.unapply(update);
                    Key<ReplicatedData> key = update2._1();
                    WriteConsistency writeConsistency = update2._2();
                    Option<Object> option = update2._3();
                    Key<ReplicatedData> key3 = key;
                    WriteConsistency writeC = writeConsistency;
                    Option<Object> req = option;
                    Update u = update;
                    this.$outer.receiveUpdate(key3, u.modify(), writeC, req);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.ReadRepair) {
                    Internal.ReadRepair readRepair = Replicator$Internal$ReadRepair$.MODULE$.unapply((Internal.ReadRepair)object);
                    String string = readRepair._1();
                    Internal.DataEnvelope dataEnvelope = readRepair._2();
                    String key = string;
                    Internal.DataEnvelope envelope = dataEnvelope;
                    this.$outer.receiveReadRepair(key, envelope);
                    return BoxedUnit.UNIT;
                }
                if (Replicator$FlushChanges$.MODULE$.equals(object)) {
                    this.$outer.receiveFlushChanges();
                    return BoxedUnit.UNIT;
                }
                if (Replicator$Internal$DeltaPropagationTick$.MODULE$.equals(object)) {
                    this.$outer.receiveDeltaPropagationTick();
                    return BoxedUnit.UNIT;
                }
                if (Replicator$Internal$GossipTick$.MODULE$.equals(object)) {
                    this.$outer.receiveGossipTick();
                    return BoxedUnit.UNIT;
                }
                if (Replicator$Internal$ClockTick$.MODULE$.equals(object)) {
                    this.$outer.receiveClockTick();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Subscribe) {
                    Subscribe<A> subscribe = Replicator$Subscribe$.MODULE$.unapply((Subscribe)object);
                    Key<ReplicatedData> key = subscribe._1();
                    ActorRef actorRef = subscribe._2();
                    Key<ReplicatedData> key4 = key;
                    ActorRef subscriber = actorRef;
                    this.$outer.receiveSubscribe(key4, subscriber);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Unsubscribe) {
                    Unsubscribe<A> unsubscribe = Replicator$Unsubscribe$.MODULE$.unapply((Unsubscribe)object);
                    Key<ReplicatedData> key = unsubscribe._1();
                    ActorRef actorRef = unsubscribe._2();
                    Key<ReplicatedData> key5 = key;
                    ActorRef subscriber = actorRef;
                    this.$outer.receiveUnsubscribe(key5, subscriber);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Terminated) {
                    ActorRef actorRef;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
                    ActorRef ref = actorRef = terminated._1();
                    this.$outer.receiveTerminated(ref);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberJoined) {
                    Member member;
                    ClusterEvent.MemberJoined memberJoined = ClusterEvent.MemberJoined$.MODULE$.unapply((ClusterEvent.MemberJoined)object);
                    Member m = member = memberJoined._1();
                    this.$outer.receiveMemberJoining(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberWeaklyUp) {
                    Member member;
                    ClusterEvent.MemberWeaklyUp memberWeaklyUp = ClusterEvent.MemberWeaklyUp$.MODULE$.unapply((ClusterEvent.MemberWeaklyUp)object);
                    Member m = member = memberWeaklyUp._1();
                    this.$outer.receiveMemberWeaklyUp(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberUp) {
                    Member member;
                    ClusterEvent.MemberUp memberUp = ClusterEvent.MemberUp$.MODULE$.unapply((ClusterEvent.MemberUp)object);
                    Member m = member = memberUp._1();
                    this.$outer.receiveMemberUp(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberExited) {
                    Member member;
                    ClusterEvent.MemberExited memberExited = ClusterEvent.MemberExited$.MODULE$.unapply((ClusterEvent.MemberExited)object);
                    Member m = member = memberExited._1();
                    this.$outer.receiveMemberExiting(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberRemoved) {
                    ClusterEvent.MemberRemoved memberRemoved = ClusterEvent.MemberRemoved$.MODULE$.unapply((ClusterEvent.MemberRemoved)object);
                    Member member = memberRemoved._1();
                    MemberStatus memberStatus = memberRemoved._2();
                    Member m = member;
                    this.$outer.receiveMemberRemoved(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.MemberEvent) {
                    ClusterEvent.MemberEvent evt = (ClusterEvent.MemberEvent)object;
                    this.$outer.receiveOtherMemberEvent(evt.member());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.UnreachableMember) {
                    Member member;
                    ClusterEvent.UnreachableMember unreachableMember = ClusterEvent.UnreachableMember$.MODULE$.unapply((ClusterEvent.UnreachableMember)object);
                    Member m = member = unreachableMember._1();
                    this.$outer.receiveUnreachable(m);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ClusterEvent.ReachableMember) {
                    Member member;
                    ClusterEvent.ReachableMember reachableMember = ClusterEvent.ReachableMember$.MODULE$.unapply((ClusterEvent.ReachableMember)object);
                    Member m = member = reachableMember._1();
                    this.$outer.receiveReachable(m);
                    return BoxedUnit.UNIT;
                }
                if (Replicator$GetKeyIds$.MODULE$.equals(object)) {
                    this.$outer.receiveGetKeyIds();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Delete) {
                    Delete<A> delete = Replicator$Delete$.MODULE$.unapply((Delete)object);
                    Key<ReplicatedData> key = delete._1();
                    WriteConsistency writeConsistency = delete._2();
                    Option<Object> option = delete._3();
                    Key<ReplicatedData> key6 = key;
                    WriteConsistency consistency = writeConsistency;
                    Option<Object> req = option;
                    this.$outer.receiveDelete(key6, consistency, req);
                    return BoxedUnit.UNIT;
                }
                if (Replicator$Internal$RemovedNodePruningTick$.MODULE$.equals(object)) {
                    this.$outer.receiveRemovedNodePruningTick();
                    return BoxedUnit.UNIT;
                }
                if (Replicator$GetReplicaCount$.MODULE$.equals(object)) {
                    this.$outer.receiveGetReplicaCount();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Internal.TestFullStateGossip) {
                    boolean bl;
                    Internal.TestFullStateGossip testFullStateGossip = Replicator$Internal$TestFullStateGossip$.MODULE$.unapply((Internal.TestFullStateGossip)object);
                    boolean enabled = bl = testFullStateGossip._1();
                    this.$outer.fullStateGossipEnabled_$eq(enabled);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Address selfAddress() {
        return this.selfAddress;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Some<Object> selfFromSystemUid() {
        return this.selfFromSystemUid;
    }

    public Cancellable gossipTask() {
        return this.gossipTask;
    }

    public Cancellable notifyTask() {
        return this.notifyTask;
    }

    public Option<Cancellable> pruningTask() {
        return this.pruningTask;
    }

    public Cancellable clockTask() {
        return this.clockTask;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public long maxPruningDisseminationNanos() {
        return this.maxPruningDisseminationNanos;
    }

    public boolean hasDurableKeys() {
        return this.hasDurableKeys;
    }

    public scala.collection.immutable.Set<String> durable() {
        return this.durable;
    }

    public scala.collection.immutable.Set<String> durableWildcards() {
        return this.durableWildcards;
    }

    public ActorRef durableStore() {
        return this.durableStore;
    }

    public DeltaPropagationSelector deltaPropagationSelector() {
        return this.deltaPropagationSelector;
    }

    public Option<Cancellable> deltaPropagationTask() {
        return this.deltaPropagationTask;
    }

    public SortedSet<UniqueAddress> nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet<UniqueAddress> x$1) {
        this.nodes = x$1;
    }

    public SortedSet<Member> membersByAge() {
        return this.membersByAge;
    }

    public void membersByAge_$eq(SortedSet<Member> x$1) {
        this.membersByAge = x$1;
    }

    public SortedSet<UniqueAddress> weaklyUpNodes() {
        return this.weaklyUpNodes;
    }

    public void weaklyUpNodes_$eq(SortedSet<UniqueAddress> x$1) {
        this.weaklyUpNodes = x$1;
    }

    public SortedSet<UniqueAddress> joiningNodes() {
        return this.joiningNodes;
    }

    public void joiningNodes_$eq(SortedSet<UniqueAddress> x$1) {
        this.joiningNodes = x$1;
    }

    public SortedSet<UniqueAddress> exitingNodes() {
        return this.exitingNodes;
    }

    public void exitingNodes_$eq(SortedSet<UniqueAddress> x$1) {
        this.exitingNodes = x$1;
    }

    public SortedSet<UniqueAddress> org$apache$pekko$cluster$ddata$Replicator$$allNodes() {
        return (SortedSet)this.nodes().union(this.weaklyUpNodes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean org$apache$pekko$cluster$ddata$Replicator$$isKnownNode(UniqueAddress node) {
        if (this.nodes().apply((Object)node)) return true;
        if (this.weaklyUpNodes().apply((Object)node)) return true;
        if (this.joiningNodes().apply((Object)node)) return true;
        UniqueAddress uniqueAddress = this.selfUniqueAddress();
        UniqueAddress uniqueAddress2 = node;
        if (uniqueAddress != null) {
            if (!uniqueAddress.equals(uniqueAddress2)) return false;
            return true;
        }
        if (uniqueAddress2 == null) return true;
        return false;
    }

    public Map<UniqueAddress, Object> removedNodes() {
        return this.removedNodes;
    }

    public void removedNodes_$eq(Map<UniqueAddress, Object> x$1) {
        this.removedNodes = x$1;
    }

    public TreeSet<Member> leader() {
        return this.leader;
    }

    public void leader_$eq(TreeSet<Member> x$1) {
        this.leader = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLeader() {
        if (!this.leader().nonEmpty()) return false;
        Address address = ((Member)this.leader().head()).address();
        Address address2 = this.selfAddress();
        if (address == null) {
            if (address2 != null) {
                return false;
            }
        } else if (!address.equals(address2)) return false;
        MemberStatus memberStatus = ((Member)this.leader().head()).status();
        MemberStatus.Up$ up$ = MemberStatus.Up$.MODULE$;
        if (memberStatus == null) {
            if (up$ == null) return true;
            return false;
        } else {
            if (!memberStatus.equals(up$)) return false;
            return true;
        }
    }

    public long previousClockTime() {
        return this.previousClockTime;
    }

    public void previousClockTime_$eq(long x$1) {
        this.previousClockTime = x$1;
    }

    public long allReachableClockTime() {
        return this.allReachableClockTime;
    }

    public void allReachableClockTime_$eq(long x$1) {
        this.allReachableClockTime = x$1;
    }

    public scala.collection.immutable.Set<UniqueAddress> unreachable() {
        return this.unreachable;
    }

    public void unreachable_$eq(scala.collection.immutable.Set<UniqueAddress> x$1) {
        this.unreachable = x$1;
    }

    public Map<String, Tuple2<Internal.DataEnvelope, ByteString>> dataEntries() {
        return this.dataEntries;
    }

    public void dataEntries_$eq(Map<String, Tuple2<Internal.DataEnvelope, ByteString>> x$1) {
        this.dataEntries = x$1;
    }

    public scala.collection.immutable.Set<String> changed() {
        return this.changed;
    }

    public void changed_$eq(scala.collection.immutable.Set<String> x$1) {
        this.changed = x$1;
    }

    public long statusCount() {
        return this.statusCount;
    }

    public void statusCount_$eq(long x$1) {
        this.statusCount = x$1;
    }

    public int statusTotChunks() {
        return this.statusTotChunks;
    }

    public void statusTotChunks_$eq(int x$1) {
        this.statusTotChunks = x$1;
    }

    public boolean fullStateGossipEnabled() {
        return this.fullStateGossipEnabled;
    }

    public void fullStateGossipEnabled_$eq(boolean x$1) {
        this.fullStateGossipEnabled = x$1;
    }

    public HashMap<String, Set<ActorRef>> subscribers() {
        return this.subscribers;
    }

    public HashMap<String, Set<ActorRef>> newSubscribers() {
        return this.newSubscribers;
    }

    public Map<String, Key<ReplicatedData>> subscriptionKeys() {
        return this.subscriptionKeys;
    }

    public void subscriptionKeys_$eq(Map<String, Key<ReplicatedData>> x$1) {
        this.subscriptionKeys = x$1;
    }

    public ActorRef replyTo() {
        return this.replyTo;
    }

    public void replyTo_$eq(ActorRef x$1) {
        this.replyTo = x$1;
    }

    private Vector<UniqueAddress> nodesForReadWrite(boolean excludeExiting) {
        if (excludeExiting && this.exitingNodes().nonEmpty()) {
            if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest()) {
                return this.membersByAge().iterator().collect((PartialFunction)new Serializable(this){
                    private final /* synthetic */ Replicator $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Member x) {
                        Member member;
                        Member m = member = x;
                        return !this.$outer.exitingNodes().contains((Object)m.uniqueAddress());
                    }

                    public final Object applyOrElse(Member x, Function1 function1) {
                        Member member;
                        Member m = member = x;
                        if (!this.$outer.exitingNodes().contains((Object)m.uniqueAddress())) {
                            return m.uniqueAddress();
                        }
                        return function1.apply((Object)x);
                    }
                }).toVector();
            }
            return this.nodes().diff(this.exitingNodes()).toVector();
        }
        if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest()) {
            return this.membersByAge().iterator().map((Function1 & Serializable)_$3 -> _$3.uniqueAddress()).toVector();
        }
        return this.nodes().toVector();
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> rcv, Object msg) {
        this.replyTo_$eq(this.sender());
        try {
            Actor.aroundReceive$((Actor)this, rcv, (Object)msg);
        }
        finally {
            this.replyTo_$eq(null);
        }
    }

    public void preStart() {
        if (this.hasDurableKeys()) {
            this.durableStore().$bang((Object)DurableStore$LoadAll$.MODULE$, this.self());
        }
        this.cluster().subscribe(this.self(), (ClusterEvent.SubscriptionInitialStateMode)ClusterEvent.InitialStateAsEvents$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
    }

    public void postStop() {
        this.cluster().unsubscribe(this.self());
        this.gossipTask().cancel();
        this.deltaPropagationTask().foreach((Function1 & Serializable)_$4 -> _$4.cancel());
        this.notifyTask().cancel();
        this.pruningTask().foreach((Function1 & Serializable)_$5 -> _$5.cancel());
        this.clockTask().cancel();
    }

    public boolean matchingRole(Member m) {
        return this.org$apache$pekko$cluster$ddata$Replicator$$settings.roles().subsetOf((scala.collection.Set)m.roles());
    }

    public SupervisorStrategy supervisorStrategy() {
        return this.supervisorStrategy;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        if (this.hasDurableKeys()) {
            return this.load();
        }
        return this.normalReceive();
    }

    public PartialFunction<Object, BoxedUnit> load() {
        return this.load;
    }

    public PartialFunction<Object, BoxedUnit> normalReceive() {
        return this.normalReceive;
    }

    public void receiveGet(Key<ReplicatedData> key, ReadConsistency consistency, Option<Object> req) {
        Option<Internal.DataEnvelope> localValue = this.getData(key.id());
        this.log().debug("Received Get for key [{}].", key);
        if (this.isLocalGet(consistency)) {
            GetResponse getResponse;
            Internal.DataEnvelope dataEnvelope;
            Option<Internal.DataEnvelope> option = localValue;
            if (option instanceof Some && (dataEnvelope = (Internal.DataEnvelope)((Some)option).value()) != null) {
                Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                ReplicatedData replicatedData = dataEnvelope2._1();
                Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                VersionVector versionVector = dataEnvelope2._3();
                if (Replicator$Internal$DeletedData$.MODULE$.equals(replicatedData)) {
                    getResponse = Replicator$GetDataDeleted$.MODULE$.apply(key, req);
                } else {
                    ReplicatedData data = replicatedData;
                    getResponse = Replicator$GetSuccess$.MODULE$.apply(key, req, data);
                }
            } else if (None$.MODULE$.equals(option)) {
                getResponse = Replicator$NotFound$.MODULE$.apply(key, req);
            } else {
                throw new MatchError(option);
            }
            GetResponse reply = getResponse;
            this.replyTo().$bang((Object)reply, this.self());
            return;
        }
        ReadConsistency readConsistency = consistency;
        boolean excludeExiting = readConsistency instanceof ReadMajorityPlus || readConsistency instanceof ReadAll;
        this.context().actorOf(ReadAggregator$.MODULE$.props(key, consistency, req, this.selfUniqueAddress(), this.nodesForReadWrite(excludeExiting), this.unreachable(), !this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest(), localValue, this.replyTo()).withDispatcher(this.context().props().dispatcher()));
    }

    public boolean isLocalGet(ReadConsistency readConsistency) {
        ReadConsistency readConsistency2 = readConsistency;
        if (Replicator$ReadLocal$.MODULE$.equals(readConsistency2)) {
            return true;
        }
        if (readConsistency2 instanceof ReadMajority || readConsistency2 instanceof ReadAll) {
            return this.nodes().isEmpty();
        }
        return false;
    }

    public void receiveRead(String key) {
        this.replyTo().$bang((Object)Replicator$Internal$ReadResult$.MODULE$.apply(this.getData(key)), this.self());
    }

    public boolean isLocalSender() {
        return !this.replyTo().path().address().hasGlobalScope();
    }

    public <A extends ReplicatedData> void receiveUpdate(Key<ReplicatedData> key, Function1<Option<A>, A> modify, WriteConsistency writeConsistency, Option<Object> req) {
        Tuple2 tuple2;
        Option<Internal.DataEnvelope> localValue = this.getData(key.id());
        Try try_ = Try$.MODULE$.apply(() -> this.receiveUpdate$$anonfun$1(modify, localValue));
        if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
            Tuple2 tuple22;
            Internal.DataEnvelope dataEnvelope = (Internal.DataEnvelope)tuple2._1();
            if (dataEnvelope != null) {
                Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                ReplicatedData replicatedData = dataEnvelope2._1();
                Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                VersionVector versionVector = dataEnvelope2._3();
                if (Replicator$Internal$DeletedData$.MODULE$.equals(replicatedData)) {
                    this.log().debug("Received Update for deleted key [{}].", key);
                    this.replyTo().$bang(Replicator$UpdateDataDeleted$.MODULE$.apply(key, req), this.self());
                    return;
                }
            }
            Internal.DataEnvelope envelope = dataEnvelope;
            Option delta = (Option)tuple2._2();
            this.log().debug("Received Update for key [{}].", key);
            Option option = delta;
            if (option instanceof Some) {
                ReplicatedDelta d = (ReplicatedDelta)((Some)option).value();
                this.deltaPropagationSelector().update(key.id(), d);
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            Internal.DataEnvelope newEnvelope = this.setData(key.id(), envelope);
            boolean durable = this.isDurable(key.id());
            if (this.isLocalUpdate(writeConsistency)) {
                if (durable) {
                    this.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key.id(), new DurableStore.DurableDataEnvelope(newEnvelope), (Option<DurableStore.StoreReply>)Some$.MODULE$.apply((Object)DurableStore$StoreReply$.MODULE$.apply(Replicator$UpdateSuccess$.MODULE$.apply(key, req), Replicator$StoreFailure$.MODULE$.apply(key, req), this.replyTo()))), this.self());
                    return;
                }
                this.replyTo().$bang(Replicator$UpdateSuccess$.MODULE$.apply(key, req), this.self());
                return;
            }
            Option option2 = delta;
            if (option2 instanceof Some) {
                ReplicatedDelta replicatedDelta = (ReplicatedDelta)((Some)option2).value();
                ReplicatedDelta replicatedDelta2 = Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder();
                ReplicatedDelta replicatedDelta3 = replicatedDelta;
                if (!(replicatedDelta2 != null ? !replicatedDelta2.equals(replicatedDelta3) : replicatedDelta3 != null)) {
                    tuple22 = Tuple2$.MODULE$.apply((Object)newEnvelope, (Object)None$.MODULE$);
                } else if (replicatedDelta instanceof RequiresCausalDeliveryOfDeltas) {
                    RequiresCausalDeliveryOfDeltas d = (RequiresCausalDeliveryOfDeltas)replicatedDelta;
                    long v = this.deltaPropagationSelector().currentVersion(key.id());
                    tuple22 = Tuple2$.MODULE$.apply((Object)newEnvelope, (Object)Some$.MODULE$.apply((Object)Replicator$Internal$Delta$.MODULE$.apply(newEnvelope.copy(d, newEnvelope.copy$default$2(), newEnvelope.copy$default$3()), v, v)));
                } else {
                    ReplicatedDelta d = replicatedDelta;
                    tuple22 = Tuple2$.MODULE$.apply((Object)newEnvelope.copy(d, newEnvelope.copy$default$2(), newEnvelope.copy$default$3()), (Object)None$.MODULE$);
                }
            } else if (None$.MODULE$.equals(option2)) {
                tuple22 = Tuple2$.MODULE$.apply((Object)newEnvelope, (Object)None$.MODULE$);
            } else {
                throw new MatchError((Object)option2);
            }
            Tuple2 tuple23 = tuple22;
            Internal.DataEnvelope writeEnvelope = (Internal.DataEnvelope)tuple23._1();
            Option writeDelta = (Option)tuple23._2();
            boolean shuffle = !this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest() && !writeDelta.exists((Function1 & Serializable)_$6 -> _$6.requiresCausalDeliveryOfDeltas());
            WriteConsistency writeConsistency2 = writeConsistency;
            boolean excludeExiting = writeConsistency2 instanceof WriteMajorityPlus || writeConsistency2 instanceof WriteAll;
            ActorRef writeAggregator = this.context().actorOf(WriteAggregator$.MODULE$.props(key, writeEnvelope, (Option<Internal.Delta>)writeDelta, writeConsistency, req, this.selfUniqueAddress(), this.nodesForReadWrite(excludeExiting), this.unreachable(), shuffle, this.replyTo(), durable).withDispatcher(this.context().props().dispatcher()));
            if (durable) {
                this.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key.id(), new DurableStore.DurableDataEnvelope(newEnvelope), (Option<DurableStore.StoreReply>)Some$.MODULE$.apply((Object)DurableStore$StoreReply$.MODULE$.apply(Replicator$UpdateSuccess$.MODULE$.apply(key, req), Replicator$StoreFailure$.MODULE$.apply(key, req), writeAggregator))), this.self());
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            this.log().debug("Received Update for key [{}], failed: {}", key, (Object)e.getMessage());
            this.replyTo().$bang(Replicator$ModifyFailure$.MODULE$.apply(key, new StringBuilder(15).append("Update failed: ").append(e.getMessage()).toString(), e, req), this.self());
            return;
        }
        throw new MatchError((Object)try_);
    }

    public boolean isDurable(String key) {
        return this.durable().apply((Object)key) || this.durableWildcards().nonEmpty() && this.durableWildcards().exists((Function1 & Serializable)x$0 -> key.startsWith((String)x$0));
    }

    public boolean isLocalUpdate(WriteConsistency writeConsistency) {
        WriteConsistency writeConsistency2 = writeConsistency;
        if (Replicator$WriteLocal$.MODULE$.equals(writeConsistency2)) {
            return true;
        }
        if (writeConsistency2 instanceof WriteMajority || writeConsistency2 instanceof WriteAll) {
            return this.nodes().isEmpty();
        }
        return false;
    }

    public void receiveWrite(String key, Internal.DataEnvelope envelope) {
        this.writeAndStore(key, envelope, true);
    }

    public void writeAndStore(String key, Internal.DataEnvelope writeEnvelope, boolean reply) {
        Option<Internal.DataEnvelope> option = this.write(key, writeEnvelope);
        if (option instanceof Some) {
            Internal.DataEnvelope newEnvelope = (Internal.DataEnvelope)((Some)option).value();
            if (this.isDurable(key)) {
                None$ storeReply = reply ? Some$.MODULE$.apply((Object)DurableStore$StoreReply$.MODULE$.apply(Replicator$Internal$WriteAck$.MODULE$, Replicator$Internal$WriteNack$.MODULE$, this.replyTo())) : None$.MODULE$;
                this.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key, new DurableStore.DurableDataEnvelope(newEnvelope), (Option<DurableStore.StoreReply>)storeReply), this.self());
                return;
            }
            if (reply) {
                this.replyTo().$bang((Object)Replicator$Internal$WriteAck$.MODULE$, this.self());
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (reply) {
                this.replyTo().$bang((Object)Replicator$Internal$WriteNack$.MODULE$, this.self());
                return;
            }
            return;
        }
        throw new MatchError(option);
    }

    public Option<Internal.DataEnvelope> write(String key, Internal.DataEnvelope writeEnvelope) {
        Option<Internal.DataEnvelope> option = this.getData(key);
        if (option instanceof Some) {
            Internal.DataEnvelope dataEnvelope;
            Some some = (Some)option;
            Internal.DataEnvelope envelope = dataEnvelope = (Internal.DataEnvelope)some.value();
            Some someEnvelope = some;
            if (envelope == writeEnvelope) {
                return someEnvelope;
            }
            if (dataEnvelope != null) {
                None$ none$;
                Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                ReplicatedData replicatedData = dataEnvelope2._1();
                Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                VersionVector versionVector = dataEnvelope2._3();
                if (Replicator$Internal$DeletedData$.MODULE$.equals(replicatedData)) {
                    return Some$.MODULE$.apply((Object)Replicator$Internal$.MODULE$.DeletedEnvelope());
                }
                ReplicatedData existingData = replicatedData;
                Internal.DataEnvelope envelope2 = dataEnvelope;
                try {
                    Internal.DataEnvelope merged = envelope2.merge(writeEnvelope).addSeen(this.selfAddress());
                    none$ = Some$.MODULE$.apply((Object)this.setData(key, merged));
                }
                catch (IllegalArgumentException e) {
                    this.log().warning("Couldn't merge [{}], due to: {}", (Object)key, (Object)e.getMessage());
                    none$ = None$.MODULE$;
                }
                return none$;
            }
        }
        if (None$.MODULE$.equals(option)) {
            Internal.DataEnvelope dataEnvelope;
            ReplicatedData replicatedData = writeEnvelope.data();
            if (replicatedData instanceof ReplicatedDelta) {
                ReplicatedDelta d = (ReplicatedDelta)replicatedData;
                DeltaReplicatedData z = d.zero();
                dataEnvelope = writeEnvelope.copy(z.mergeDelta(d), writeEnvelope.copy$default$2(), writeEnvelope.copy$default$3());
            } else {
                dataEnvelope = writeEnvelope;
            }
            Internal.DataEnvelope writeEnvelope2 = dataEnvelope;
            Internal.DataEnvelope writeEnvelope3 = writeEnvelope2.addSeen(this.selfAddress());
            return Some$.MODULE$.apply((Object)this.setData(key, writeEnvelope3));
        }
        throw new MatchError(option);
    }

    public void receiveReadRepair(String key, Internal.DataEnvelope writeEnvelope) {
        this.writeAndStore(key, writeEnvelope, false);
        this.replyTo().$bang((Object)Replicator$Internal$ReadRepairAck$.MODULE$, this.self());
    }

    public void receiveGetKeyIds() {
        scala.collection.immutable.Set keys = (scala.collection.immutable.Set)this.dataEntries().iterator().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Internal.DataEnvelope dataEnvelope;
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    String key = (String)tuple2._1();
                    if (tuple22 != null && (dataEnvelope = (Internal.DataEnvelope)tuple22._1()) != null) {
                        ReplicatedData data;
                        Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                        ReplicatedData replicatedData = dataEnvelope2._1();
                        Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                        VersionVector versionVector = dataEnvelope2._3();
                        ReplicatedData replicatedData2 = data = replicatedData;
                        Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
                        if (replicatedData2 == null ? replicator$Internal$DeletedData$ != null : !replicatedData2.equals(replicator$Internal$DeletedData$)) {
                            return true;
                        }
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Internal.DataEnvelope dataEnvelope;
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    String key = (String)tuple2._1();
                    if (tuple22 != null && (dataEnvelope = (Internal.DataEnvelope)tuple22._1()) != null) {
                        ReplicatedData data;
                        Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                        ReplicatedData replicatedData = dataEnvelope2._1();
                        Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                        VersionVector versionVector = dataEnvelope2._3();
                        ReplicatedData replicatedData2 = data = replicatedData;
                        Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
                        if (replicatedData2 == null ? replicator$Internal$DeletedData$ != null : !replicatedData2.equals(replicator$Internal$DeletedData$)) {
                            return key;
                        }
                    }
                }
                return function1.apply((Object)x);
            }
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
        this.replyTo().$bang((Object)Replicator$GetKeyIdsResult$.MODULE$.apply((scala.collection.immutable.Set<String>)keys), this.self());
    }

    public void receiveDelete(Key<ReplicatedData> key, WriteConsistency consistency, Option<Object> req) {
        Internal.DataEnvelope dataEnvelope;
        Option<Internal.DataEnvelope> option = this.getData(key.id());
        if (option instanceof Some && (dataEnvelope = (Internal.DataEnvelope)((Some)option).value()) != null) {
            Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
            ReplicatedData replicatedData = dataEnvelope2._1();
            Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
            VersionVector versionVector = dataEnvelope2._3();
            if (Replicator$Internal$DeletedData$.MODULE$.equals(replicatedData)) {
                this.replyTo().$bang(Replicator$DataDeleted$.MODULE$.apply(key, req), this.self());
                return;
            }
        }
        this.setData(key.id(), Replicator$Internal$.MODULE$.DeletedEnvelope());
        this.payloadSizeAggregator.remove(key.id());
        boolean durable = this.isDurable(key.id());
        if (this.isLocalUpdate(consistency)) {
            if (durable) {
                this.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key.id(), new DurableStore.DurableDataEnvelope(Replicator$Internal$.MODULE$.DeletedEnvelope()), (Option<DurableStore.StoreReply>)Some$.MODULE$.apply((Object)DurableStore$StoreReply$.MODULE$.apply(Replicator$DeleteSuccess$.MODULE$.apply(key, req), Replicator$StoreFailure$.MODULE$.apply(key, req), this.replyTo()))), this.self());
                return;
            }
            this.replyTo().$bang(Replicator$DeleteSuccess$.MODULE$.apply(key, req), this.self());
            return;
        }
        WriteConsistency writeConsistency = consistency;
        boolean excludeExiting = writeConsistency instanceof WriteMajorityPlus || writeConsistency instanceof WriteAll;
        ActorRef writeAggregator = this.context().actorOf(WriteAggregator$.MODULE$.props(key, Replicator$Internal$.MODULE$.DeletedEnvelope(), (Option<Internal.Delta>)None$.MODULE$, consistency, req, this.selfUniqueAddress(), this.nodesForReadWrite(excludeExiting), this.unreachable(), !this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest(), this.replyTo(), durable).withDispatcher(this.context().props().dispatcher()));
        if (durable) {
            this.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key.id(), new DurableStore.DurableDataEnvelope(Replicator$Internal$.MODULE$.DeletedEnvelope()), (Option<DurableStore.StoreReply>)Some$.MODULE$.apply((Object)DurableStore$StoreReply$.MODULE$.apply(Replicator$DeleteSuccess$.MODULE$.apply(key, req), Replicator$StoreFailure$.MODULE$.apply(key, req), writeAggregator))), this.self());
            return;
        }
    }

    public Internal.DataEnvelope setData(String key, Internal.DataEnvelope envelope) {
        ByteString byteString;
        Internal.DataEnvelope newEnvelope;
        Internal.DataEnvelope dataEnvelope;
        if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.deltaCrdtEnabled()) {
            VersionVector deltaVersions = envelope.deltaVersions();
            long currVersion = this.deltaPropagationSelector().currentVersion(key);
            if (currVersion == 0L || currVersion == deltaVersions.versionAt(this.selfUniqueAddress())) {
                dataEnvelope = envelope;
            } else {
                VersionVector versionVector = deltaVersions.merge(VersionVector$.MODULE$.apply(this.selfUniqueAddress(), currVersion));
                ReplicatedData replicatedData = envelope.copy$default$1();
                Map<UniqueAddress, PruningState> map = envelope.copy$default$2();
                dataEnvelope = envelope.copy(replicatedData, map, versionVector);
            }
        } else {
            dataEnvelope = newEnvelope = envelope;
        }
        if (this.subscribers().contains((Object)key) && !this.changed().contains((Object)key)) {
            ByteString oldDigest = this.getDigest(key);
            Tuple2<ByteString, Object> tuple2 = this.digest(newEnvelope);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            ByteString dig = (ByteString)tuple2._1();
            int payloadSize = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)dig, (Object)BoxesRunTime.boxToInteger((int)payloadSize));
            ByteString dig2 = (ByteString)tuple22._1();
            int payloadSize2 = BoxesRunTime.unboxToInt((Object)tuple22._2());
            this.payloadSizeAggregator.updatePayloadSize(key, payloadSize2);
            ByteString byteString2 = dig2;
            ByteString byteString3 = oldDigest;
            if (byteString2 == null ? byteString3 != null : !byteString2.equals(byteString3)) {
                this.changed_$eq((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)this.changed().$plus((Object)key)));
            }
            byteString = dig2;
        } else {
            ReplicatedData replicatedData = newEnvelope.data();
            Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
            byteString = !(replicatedData != null ? !replicatedData.equals(replicator$Internal$DeletedData$) : replicator$Internal$DeletedData$ != null) ? Replicator$Internal$.MODULE$.DeletedDigest() : Replicator$Internal$.MODULE$.LazyDigest();
        }
        ByteString dig = byteString;
        this.dataEntries_$eq((Map<String, Tuple2<Internal.DataEnvelope, ByteString>>)((Map)this.dataEntries().updated((Object)key, (Object)Tuple2$.MODULE$.apply((Object)newEnvelope, (Object)dig))));
        ReplicatedData replicatedData = newEnvelope.data();
        Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
        if (!(replicatedData != null ? !replicatedData.equals(replicator$Internal$DeletedData$) : replicator$Internal$DeletedData$ != null)) {
            this.deltaPropagationSelector().delete(key);
        }
        return newEnvelope;
    }

    public ByteString getDigest(String key) {
        Tuple2 tuple2;
        Option option = this.dataEntries().get((Object)key);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            ByteString byteString = (ByteString)tuple2._2();
            Internal.DataEnvelope envelope = (Internal.DataEnvelope)tuple2._1();
            ByteString byteString2 = Replicator$Internal$.MODULE$.LazyDigest();
            ByteString byteString3 = byteString;
            if (!(byteString2 != null ? !byteString2.equals(byteString3) : byteString3 != null)) {
                Tuple2<ByteString, Object> tuple22 = this.digest(envelope);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                ByteString d = (ByteString)tuple22._1();
                int size = BoxesRunTime.unboxToInt((Object)tuple22._2());
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)d, (Object)BoxesRunTime.boxToInteger((int)size));
                ByteString d2 = (ByteString)tuple23._1();
                int size2 = BoxesRunTime.unboxToInt((Object)tuple23._2());
                this.payloadSizeAggregator.updatePayloadSize(key, size2);
                this.dataEntries_$eq((Map<String, Tuple2<Internal.DataEnvelope, ByteString>>)((Map)this.dataEntries().updated((Object)key, (Object)Tuple2$.MODULE$.apply((Object)envelope, (Object)d2))));
                return d2;
            }
            ByteString digest = byteString;
            return digest;
        }
        if (None$.MODULE$.equals(option)) {
            return Replicator$Internal$.MODULE$.NotFoundDigest();
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<ByteString, Object> digest(Internal.DataEnvelope envelope) {
        ReplicatedData replicatedData = envelope.data();
        Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
        if (!(replicatedData != null ? !replicatedData.equals(replicator$Internal$DeletedData$) : replicator$Internal$DeletedData$ != null)) {
            return Tuple2$.MODULE$.apply((Object)Replicator$Internal$.MODULE$.DeletedDigest(), (Object)BoxesRunTime.boxToInteger((int)0));
        }
        byte[] bytes = this.serializer().toBinary((Object)envelope.withoutDeltaVersions());
        ByteString dig = ByteString$.MODULE$.fromArray(MessageDigest.getInstance("SHA-1").digest(bytes));
        return Tuple2$.MODULE$.apply((Object)dig, (Object)BoxesRunTime.boxToInteger((int)bytes.length));
    }

    public Option<Internal.DataEnvelope> getData(String key) {
        return this.dataEntries().get((Object)key).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Internal.DataEnvelope envelope = (Internal.DataEnvelope)tuple2._1();
                return envelope;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public long getDeltaSeqNr(String key, UniqueAddress fromNode) {
        Internal.DataEnvelope dataEnvelope;
        Tuple2 tuple2;
        Option option = this.dataEntries().get((Object)key);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null && (dataEnvelope = (Internal.DataEnvelope)tuple2._1()) != null) {
            VersionVector versionVector;
            Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
            ReplicatedData replicatedData = dataEnvelope2._1();
            Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
            VersionVector deltaVersions = versionVector = dataEnvelope2._3();
            return deltaVersions.versionAt(fromNode);
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    public boolean isNodeRemoved(UniqueAddress node, scala.collection.Iterable<String> keys) {
        return this.removedNodes().contains((Object)node) || keys.exists((Function1 & Serializable)key -> {
            Internal.DataEnvelope dataEnvelope;
            Tuple2 tuple2;
            Option option = this.dataEntries().get(key);
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null && (dataEnvelope = (Internal.DataEnvelope)tuple2._1()) != null) {
                Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                ReplicatedData replicatedData = dataEnvelope2._1();
                Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                VersionVector versionVector = dataEnvelope2._3();
                Map<UniqueAddress, PruningState> pruning = map;
                return pruning.contains((Object)node);
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError((Object)option);
        });
    }

    public void receiveFlushChanges() {
        if (this.subscribers().nonEmpty()) {
            this.changed().withFilter((Function1 & Serializable)key -> this.subscribers().contains(key)).foreach((Function1)(JProcedure1 & Serializable)key -> this.subscribers().get(key).foreach((Function1)(JProcedure1 & Serializable)subs -> this.notify$1((String)key, (Set)subs)));
        }
        if (this.newSubscribers().nonEmpty()) {
            this.newSubscribers().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Set subs = (Set)tuple2._2();
                    return true;
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Set subs = (Set)tuple2._2();
                    this.notify$1(key, subs);
                    subs.foreach((Function1 & Serializable)_$8 -> (HashMap)((MultiMap)this.subscribers()).addBinding((Object)key, _$8));
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            this.newSubscribers().clear();
        }
        this.changed_$eq((scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty());
    }

    public void receiveDeltaPropagationTick() {
        this.deltaPropagationSelector().collectPropagations().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress node = (UniqueAddress)tuple2._1();
                Internal.DeltaPropagation deltaPropagation = (Internal.DeltaPropagation)tuple2._2();
                if (deltaPropagation.deltas().nonEmpty()) {
                    ActorSelection$.MODULE$.toScala(this.replica(node)).$bang((Object)deltaPropagation, this.self());
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (this.deltaPropagationSelector().propagationCount() % (long)this.deltaPropagationSelector().gossipIntervalDivisor() == 0L) {
            this.deltaPropagationSelector().cleanupDeltaEntries();
            return;
        }
    }

    public void receiveDeltaPropagation(UniqueAddress fromNode, boolean reply, Map<String, Internal.Delta> deltas) {
        if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.deltaCrdtEnabled()) {
            try {
                boolean isDebugEnabled = this.log().isDebugEnabled();
                if (isDebugEnabled) {
                    this.log().debug("Received DeltaPropagation from [{}], containing [{}].", (Object)fromNode.address(), (Object)((IterableOnceOps)deltas.collect((PartialFunction)new Serializable(){

                        public final boolean isDefinedAt(Tuple2 x) {
                            Tuple2 tuple2 = x;
                            if (tuple2 != null) {
                                Internal.Delta delta = (Internal.Delta)tuple2._2();
                                String key = (String)tuple2._1();
                                if (delta != null) {
                                    Internal.Delta delta2 = Replicator$Internal$Delta$.MODULE$.unapply(delta);
                                    Internal.DataEnvelope dataEnvelope = delta2._1();
                                    long l = delta2._2();
                                    long l2 = delta2._3();
                                    long fromSeqNr = l;
                                    long toSeqNr = l2;
                                    return true;
                                }
                            }
                            return false;
                        }

                        public final Object applyOrElse(Tuple2 x, Function1 function1) {
                            Tuple2 tuple2 = x;
                            if (tuple2 != null) {
                                Internal.Delta delta = (Internal.Delta)tuple2._2();
                                String key = (String)tuple2._1();
                                if (delta != null) {
                                    Internal.Delta delta2 = Replicator$Internal$Delta$.MODULE$.unapply(delta);
                                    Internal.DataEnvelope dataEnvelope = delta2._1();
                                    long l = delta2._2();
                                    long l2 = delta2._3();
                                    long fromSeqNr = l;
                                    long toSeqNr = l2;
                                    return new StringBuilder(2).append(key).append(" ").append(fromSeqNr).append("-").append(toSeqNr).toString();
                                }
                            }
                            return function1.apply((Object)x);
                        }
                    })).mkString(", "));
                }
                if (this.isNodeRemoved(fromNode, (scala.collection.Iterable<String>)deltas.keys())) {
                    if (isDebugEnabled) {
                        this.log().debug("Skipping DeltaPropagation from [{}] because that node has been removed", (Object)fromNode.address());
                    }
                } else {
                    deltas.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String string = (String)tuple2._1();
                            Internal.Delta delta = (Internal.Delta)tuple2._2();
                            String key = string;
                            if (delta != null) {
                                Internal.Delta delta2 = Replicator$Internal$Delta$.MODULE$.unapply(delta);
                                Internal.DataEnvelope dataEnvelope = delta2._1();
                                long l = delta2._2();
                                long l2 = delta2._3();
                                if (dataEnvelope != null) {
                                    Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                                    ReplicatedData replicatedData = dataEnvelope2._1();
                                    Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                                    VersionVector versionVector = dataEnvelope2._3();
                                    if (replicatedData instanceof RequiresCausalDeliveryOfDeltas) {
                                        Internal.DataEnvelope envelope = dataEnvelope;
                                        long fromSeqNr = l;
                                        long toSeqNr = l2;
                                        long currentSeqNr = this.getDeltaSeqNr(key, fromNode);
                                        if (currentSeqNr >= toSeqNr) {
                                            if (isDebugEnabled) {
                                                this.log().debug("Skipping DeltaPropagation from [{}] for [{}] because toSeqNr [{}] already handled [{}]", (Object)fromNode.address(), (Object)key, (Object)BoxesRunTime.boxToLong((long)toSeqNr), (Object)BoxesRunTime.boxToLong((long)currentSeqNr));
                                            }
                                            if (reply) {
                                                this.replyTo().$bang((Object)Replicator$Internal$WriteAck$.MODULE$, this.self());
                                                return;
                                            }
                                            return;
                                        }
                                        if (fromSeqNr > currentSeqNr + 1L) {
                                            if (isDebugEnabled) {
                                                this.log().debug("Skipping DeltaPropagation from [{}] for [{}] because missing deltas between [{}-{}]", (Object)fromNode.address(), (Object)key, (Object)BoxesRunTime.boxToLong((long)(currentSeqNr + 1L)), (Object)BoxesRunTime.boxToLong((long)(fromSeqNr - 1L)));
                                            }
                                            if (reply) {
                                                this.replyTo().$bang((Object)Replicator$Internal$DeltaNack$.MODULE$, this.self());
                                                return;
                                            }
                                            return;
                                        }
                                        if (isDebugEnabled) {
                                            this.log().debug("Applying DeltaPropagation from [{}] for [{}] with sequence numbers [{}], current was [{}]", (Object)fromNode.address(), (Object)key, (Object)new StringBuilder(1).append(fromSeqNr).append("-").append(toSeqNr).toString(), (Object)BoxesRunTime.boxToLong((long)currentSeqNr));
                                        }
                                        VersionVector versionVector2 = VersionVector$.MODULE$.apply(fromNode, toSeqNr);
                                        ReplicatedData replicatedData2 = envelope.copy$default$1();
                                        Map<UniqueAddress, PruningState> map2 = envelope.copy$default$2();
                                        Internal.DataEnvelope newEnvelope = envelope.copy(replicatedData2, map2, versionVector2);
                                        this.writeAndStore(key, newEnvelope, reply);
                                        return;
                                    }
                                }
                                String key2 = string;
                                Internal.DataEnvelope envelope = dataEnvelope;
                                this.writeAndStore(key2, envelope, reply);
                                return;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.log().warning("Couldn't process DeltaPropagation from [{}] due to {}", (Object)fromNode, (Object)e);
                }
                throw throwable;
            }
            return;
        }
        if (reply) {
            this.replyTo().$bang((Object)Replicator$Internal$DeltaNack$.MODULE$, this.self());
            return;
        }
    }

    public void receiveGossipTick() {
        if (this.fullStateGossipEnabled()) {
            this.selectRandomNode((IndexedSeq<UniqueAddress>)this.org$apache$pekko$cluster$ddata$Replicator$$allNodes().toVector()).foreach((Function1)(JProcedure1 & Serializable)address -> this.gossipTo((UniqueAddress)address));
            return;
        }
    }

    public void gossipTo(UniqueAddress address) {
        ActorSelection to = this.replica(address);
        Some toSystemUid = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)address.longUid()));
        if (this.dataEntries().size() <= this.org$apache$pekko$cluster$ddata$Replicator$$settings.maxDeltaElements()) {
            Internal.Status status = Replicator$Internal$Status$.MODULE$.apply((Map<String, ByteString>)((Map)this.dataEntries().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    if (tuple2._2() != null) {
                        return Tuple2$.MODULE$.apply((Object)key, (Object)this.getDigest(key));
                    }
                }
                throw new MatchError((Object)tuple2);
            })), 0, 1, (Option<Object>)toSystemUid, (Option<Object>)this.selfFromSystemUid());
            ActorSelection$.MODULE$.toScala(to).$bang((Object)status, this.self());
            return;
        }
        int totChunks = this.dataEntries().size() / this.org$apache$pekko$cluster$ddata$Replicator$$settings.maxDeltaElements();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), package$.MODULE$.min(totChunks, 10)).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$1 -> {
            int n = x$1;
            if (totChunks == this.statusTotChunks()) {
                this.statusCount_$eq(this.statusCount() + 1L);
            } else {
                this.statusCount_$eq(Int$.MODULE$.int2long(ThreadLocalRandom.current().nextInt(0, totChunks)));
                this.statusTotChunks_$eq(totChunks);
            }
            int chunk = (int)(this.statusCount() % (long)totChunks);
            Internal.Status status = Replicator$Internal$Status$.MODULE$.apply((Map<String, ByteString>)((Map)this.dataEntries().collect((PartialFunction)new Serializable(totChunks, chunk, this){
                private final int totChunks$2;
                private final int chunk$1;
                private final /* synthetic */ Replicator $outer;
                {
                    this.totChunks$2 = totChunks$4;
                    this.chunk$1 = chunk$3;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        if (tuple2._2() != null && package$.MODULE$.abs(key.hashCode() % this.totChunks$2) == this.chunk$1) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        if (tuple2._2() != null && package$.MODULE$.abs(key.hashCode() % this.totChunks$2) == this.chunk$1) {
                            return Tuple2$.MODULE$.apply((Object)key, (Object)this.$outer.getDigest(key));
                        }
                    }
                    return function1.apply((Object)x);
                }
            })), chunk, totChunks, (Option<Object>)toSystemUid, (Option<Object>)this.selfFromSystemUid());
            ActorSelection$.MODULE$.toScala(to).$bang((Object)status, this.self());
        });
    }

    public Option<UniqueAddress> selectRandomNode(IndexedSeq<UniqueAddress> addresses) {
        if (addresses.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(addresses.apply(ThreadLocalRandom.current().nextInt(addresses.size())));
    }

    public ActorSelection replica(UniqueAddress node) {
        return this.context().actorSelection(this.self().path().toStringWithAddress(node.address()));
    }

    public void receiveStatus(Map<String, ByteString> otherDigests, int chunk, int totChunks, Option<Object> fromSystemUid) {
        scala.collection.immutable.Set myMissingKeys;
        scala.collection.immutable.Set otherKeys;
        scala.collection.immutable.Set myKeys;
        scala.collection.immutable.Set otherMissingKeys;
        scala.collection.immutable.Iterable otherDifferentKeys;
        scala.collection.immutable.Iterable keys;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Received gossip status from [{}], chunk [{}] of [{}] containing [{}].", (Object)this.replyTo().path().address(), (Object)BoxesRunTime.boxToInteger((int)(chunk + 1)), (Object)BoxesRunTime.boxToInteger((int)totChunks), (Object)otherDigests.keys().mkString(", "));
        }
        if ((keys = (scala.collection.immutable.Iterable)((IterableOps)(otherDifferentKeys = (scala.collection.immutable.Iterable)otherDigests.collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ Replicator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                ByteString otherDigest;
                String key;
                Tuple2 tuple2 = x;
                return tuple2 != null && this.$outer.org$apache$pekko$cluster$ddata$Replicator$$_$isOtherDifferent$1(key = (String)tuple2._1(), otherDigest = (ByteString)tuple2._2());
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                ByteString otherDigest;
                String key;
                Tuple2 tuple2 = x;
                if (tuple2 != null && this.$outer.org$apache$pekko$cluster$ddata$Replicator$$_$isOtherDifferent$1(key = (String)tuple2._1(), otherDigest = (ByteString)tuple2._2())) {
                    return key;
                }
                return function1.apply((Object)x);
            }
        })).$plus$plus((IterableOnce)(otherMissingKeys = (scala.collection.immutable.Set)(myKeys = totChunks == 1 ? this.dataEntries().keySet() : this.dataEntries().keysIterator().filter((Function1 & Serializable)key -> package$.MODULE$.abs(key.hashCode() % totChunks) == chunk).toSet()).diff((scala.collection.Set)(otherKeys = otherDigests.keySet()))))).take(this.org$apache$pekko$cluster$ddata$Replicator$$settings.maxDeltaElements())).nonEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Sending gossip to [{}], containing [{}]", (Object)this.replyTo().path().address(), (Object)keys.mkString(", "));
            }
            boolean sendBack = otherDifferentKeys.nonEmpty();
            this.createGossipMessages((scala.collection.immutable.Iterable<String>)keys, sendBack, fromSystemUid).foreach((Function1)(JProcedure1 & Serializable)g -> this.replyTo().$bang(g, this.self()));
        }
        if ((myMissingKeys = (scala.collection.immutable.Set)otherKeys.diff((scala.collection.Set)myKeys)).nonEmpty()) {
            if (this.log().isDebugEnabled()) {
                this.log().debug("Sending gossip status to [{}], requesting missing [{}]", (Object)this.replyTo().path().address(), (Object)myMissingKeys.mkString(", "));
            }
            Internal.Status status = Replicator$Internal$Status$.MODULE$.apply((Map<String, ByteString>)myMissingKeys.iterator().map((Function1 & Serializable)k -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc(k);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Replicator$Internal$.MODULE$.NotFoundDigest());
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), chunk, totChunks, fromSystemUid, (Option<Object>)this.selfFromSystemUid());
            this.replyTo().$bang((Object)status, this.self());
            return;
        }
    }

    private Vector<Internal.Gossip> createGossipMessages(scala.collection.immutable.Iterable<String> keys, boolean sendBack, Option<Object> fromSystemUid) {
        int maxMessageSize = this.payloadSizeAggregator.maxFrameSize() - 128;
        ObjectRef messages = ObjectRef.create((Object)scala.package$.MODULE$.Vector().empty());
        ReusableBuilder collectedEntries = scala.package$.MODULE$.Vector().newBuilder();
        IntRef sum = IntRef.create((int)0);
        keys.foreach((Function1)(JProcedure1 & Serializable)key -> {
            int n;
            int n2;
            int keySize = key.length() + 4;
            int n3 = this.payloadSizeAggregator.getMaxSize((String)key);
            if (0 == n3) {
                this.getDigest((String)key);
                n2 = this.payloadSizeAggregator.getMaxSize((String)key);
            } else {
                int size;
                n2 = size = n3;
            }
            int dataSize = n2;
            Internal.DataEnvelope dataEnvelope = (Internal.DataEnvelope)this.getData((String)key).get();
            int envelopeSize = 100 + dataEnvelope.estimatedSizeWithoutData();
            int entrySize = keySize + dataSize + envelopeSize;
            if (sum$1.elem + entrySize <= maxMessageSize) {
                int n4;
                String string = (String)Predef$.MODULE$.ArrowAssoc(key);
                collectedEntries.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)dataEnvelope));
                sum$1.elem = n4 = sum$1.elem + entrySize;
                return;
            }
            this.addGossip$1(sendBack, fromSystemUid, messages, collectedEntries);
            collectedEntries.clear();
            String string = (String)Predef$.MODULE$.ArrowAssoc(key);
            collectedEntries.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)dataEnvelope));
            sum$1.elem = n = entrySize;
        });
        this.addGossip$1(sendBack, fromSystemUid, messages, collectedEntries);
        this.log().debug("Created [{}] Gossip messages from [{}] data entries.", (Object)BoxesRunTime.boxToInteger((int)((Vector)messages.elem).size()), (Object)BoxesRunTime.boxToInteger((int)keys.size()));
        return (Vector)messages.elem;
    }

    public void receiveGossip(Map<String, Internal.DataEnvelope> updatedData, boolean sendBack, Option<Object> fromSystemUid) {
        if (this.log().isDebugEnabled()) {
            this.log().debug("Received gossip from [{}], containing [{}].", (Object)this.replyTo().path().address(), (Object)updatedData.keys().mkString(", "));
        }
        ObjectRef replyKeys = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        updatedData.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Internal.DataEnvelope envelope = (Internal.DataEnvelope)tuple2._2();
                boolean hadData = this.dataEntries().contains((Object)key);
                this.writeAndStore(key, envelope, false);
                if (sendBack) {
                    Option<Internal.DataEnvelope> option = this.getData(key);
                    if (option instanceof Some) {
                        Internal.DataEnvelope d = (Internal.DataEnvelope)((Some)option).value();
                        if (hadData || d.pruning().nonEmpty()) {
                            scala.collection.immutable.Set set = (scala.collection.immutable.Set)((scala.collection.immutable.Set)replyKeys$1.elem).$plus((Object)key);
                            replyKeys$1.elem = set;
                            set = null;
                            return;
                        }
                        return;
                    }
                    if (None$.MODULE$.equals(option)) {
                        return;
                    }
                    throw new MatchError(option);
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        if (sendBack && ((scala.collection.immutable.Set)replyKeys.elem).nonEmpty()) {
            this.createGossipMessages((scala.collection.immutable.Iterable<String>)((scala.collection.immutable.Set)replyKeys.elem), false, fromSystemUid).foreach((Function1)(JProcedure1 & Serializable)g -> this.replyTo().$bang(g, this.self()));
            return;
        }
    }

    public void receiveSubscribe(Key<ReplicatedData> key, ActorRef subscriber) {
        ((MultiMap)this.newSubscribers()).addBinding((Object)key.id(), (Object)subscriber);
        if (!this.subscriptionKeys().contains((Object)key.id())) {
            this.subscriptionKeys_$eq((Map<String, Key<ReplicatedData>>)((Map)this.subscriptionKeys().updated((Object)key.id(), key)));
        }
        this.context().watch(subscriber);
    }

    public void receiveUnsubscribe(Key<ReplicatedData> key, ActorRef subscriber) {
        ((MultiMap)this.subscribers()).removeBinding((Object)key.id(), (Object)subscriber);
        ((MultiMap)this.newSubscribers()).removeBinding((Object)key.id(), (Object)subscriber);
        if (!this.hasSubscriber(subscriber)) {
            this.context().unwatch(subscriber);
        }
        if (!this.subscribers().contains((Object)key.id()) && !this.newSubscribers().contains((Object)key.id())) {
            this.subscriptionKeys_$eq((Map<String, Key<ReplicatedData>>)((Map)this.subscriptionKeys().$minus((Object)key.id())));
            return;
        }
    }

    public boolean hasSubscriber(ActorRef subscriber) {
        return this.subscribers().exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Set s = (Set)tuple2._2();
                return s.contains((Object)subscriber);
            }
            throw new MatchError((Object)tuple2);
        }) || this.newSubscribers().exists((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Set s = (Set)tuple2._2();
                return s.contains((Object)subscriber);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void receiveTerminated(ActorRef ref) {
        ActorRef actorRef = ref;
        ActorRef actorRef2 = this.durableStore();
        if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
            this.log().error("Stopping distributed-data Replicator because durable store terminated");
            this.context().stop(this.self());
            return;
        }
        Iterable keys1 = (Iterable)this.subscribers().collect((PartialFunction)new Serializable(ref){
            private final ActorRef ref$1;
            {
                this.ref$1 = ref$5;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Set s = (Set)tuple2._2();
                    if (s.contains((Object)this.ref$1)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Set s = (Set)tuple2._2();
                    if (s.contains((Object)this.ref$1)) {
                        return k;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        keys1.foreach((Function1 & Serializable)key -> (HashMap)((MultiMap)this.subscribers()).removeBinding(key, (Object)ref));
        Iterable keys2 = (Iterable)this.newSubscribers().collect((PartialFunction)new Serializable(ref){
            private final ActorRef ref$3;
            {
                this.ref$3 = ref$6;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Set s = (Set)tuple2._2();
                    if (s.contains((Object)this.ref$3)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Set s = (Set)tuple2._2();
                    if (s.contains((Object)this.ref$3)) {
                        return k;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        keys2.foreach((Function1 & Serializable)key -> (HashMap)((MultiMap)this.newSubscribers()).removeBinding(key, (Object)ref));
        ((IterableOnceOps)keys1.$plus$plus((IterableOnce)keys2)).foreach((Function1)(JProcedure1 & Serializable)key -> {
            if (!this.subscribers().contains(key) && !this.newSubscribers().contains(key)) {
                this.subscriptionKeys_$eq((Map<String, Key<ReplicatedData>>)((Map)this.subscriptionKeys().$minus(key)));
                return;
            }
        });
    }

    public void receiveMemberJoining(Member m) {
        if (this.matchingRole(m)) {
            Address address = m.address();
            Address address2 = this.selfAddress();
            if (address == null ? address2 != null : !address.equals(address2)) {
                this.joiningNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.joiningNodes().$plus((Object)m.uniqueAddress())));
                return;
            }
        }
    }

    public void receiveMemberWeaklyUp(Member m) {
        if (this.matchingRole(m)) {
            Address address = m.address();
            Address address2 = this.selfAddress();
            if (address == null ? address2 != null : !address.equals(address2)) {
                this.weaklyUpNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.weaklyUpNodes().$plus((Object)m.uniqueAddress())));
                this.joiningNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.joiningNodes().$minus((Object)m.uniqueAddress())));
                return;
            }
        }
    }

    public void receiveMemberUp(Member m) {
        if (this.matchingRole(m)) {
            this.leader_$eq((TreeSet<Member>)((TreeSet)this.leader().$plus((Object)m)));
            Address address = m.address();
            Address address2 = this.selfAddress();
            if (address == null ? address2 != null : !address.equals(address2)) {
                this.nodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.nodes().$plus((Object)m.uniqueAddress())));
                this.weaklyUpNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.weaklyUpNodes().$minus((Object)m.uniqueAddress())));
                this.joiningNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.joiningNodes().$minus((Object)m.uniqueAddress())));
                if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest()) {
                    this.membersByAge_$eq((SortedSet<Member>)((SortedSet)this.membersByAge().$plus((Object)m)));
                    return;
                }
                return;
            }
            return;
        }
    }

    public void receiveMemberExiting(Member m) {
        if (this.matchingRole(m)) {
            Address address = m.address();
            Address address2 = this.selfAddress();
            if (address == null ? address2 != null : !address.equals(address2)) {
                this.exitingNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.exitingNodes().$plus((Object)m.uniqueAddress())));
                return;
            }
        }
    }

    public void receiveMemberRemoved(Member m) {
        Address address = m.address();
        Address address2 = this.selfAddress();
        if (!(address != null ? !address.equals(address2) : address2 != null)) {
            this.context().stop(this.self());
            return;
        }
        if (this.matchingRole(m)) {
            this.log().debug("adding removed node [{}] from MemberRemoved", (Object)m.uniqueAddress());
            this.leader_$eq((TreeSet<Member>)((TreeSet)this.leader().filterNot((Function1 & Serializable)_$9 -> {
                UniqueAddress uniqueAddress = _$9.uniqueAddress();
                UniqueAddress uniqueAddress2 = m.uniqueAddress();
                return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
            })));
            this.nodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.nodes().$minus((Object)m.uniqueAddress())));
            this.weaklyUpNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.weaklyUpNodes().$minus((Object)m.uniqueAddress())));
            this.joiningNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.joiningNodes().$minus((Object)m.uniqueAddress())));
            this.exitingNodes_$eq((SortedSet<UniqueAddress>)((SortedSet)this.exitingNodes().$minus((Object)m.uniqueAddress())));
            this.removedNodes_$eq((Map<UniqueAddress, Object>)((Map)this.removedNodes().updated((Object)m.uniqueAddress(), (Object)BoxesRunTime.boxToLong((long)this.allReachableClockTime()))));
            this.unreachable_$eq((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.unreachable().$minus((Object)m.uniqueAddress())));
            if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.preferOldest()) {
                this.membersByAge_$eq((SortedSet<Member>)((SortedSet)this.membersByAge().$minus((Object)m)));
            }
            this.deltaPropagationSelector().cleanupRemovedNode(m.uniqueAddress());
            return;
        }
    }

    public void receiveOtherMemberEvent(Member m) {
        if (this.matchingRole(m)) {
            this.leader_$eq((TreeSet<Member>)((TreeSet)this.leader().filterNot((Function1 & Serializable)_$10 -> {
                UniqueAddress uniqueAddress = _$10.uniqueAddress();
                UniqueAddress uniqueAddress2 = m.uniqueAddress();
                return !(uniqueAddress != null ? !uniqueAddress.equals(uniqueAddress2) : uniqueAddress2 != null);
            })));
            this.leader_$eq((TreeSet<Member>)((TreeSet)this.leader().$plus((Object)m)));
            return;
        }
    }

    public void receiveUnreachable(Member m) {
        if (this.matchingRole(m)) {
            this.unreachable_$eq((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.unreachable().$plus((Object)m.uniqueAddress())));
            return;
        }
    }

    public void receiveReachable(Member m) {
        if (this.matchingRole(m)) {
            this.unreachable_$eq((scala.collection.immutable.Set<UniqueAddress>)((scala.collection.immutable.Set)this.unreachable().$minus((Object)m.uniqueAddress())));
            return;
        }
    }

    public void receiveClockTick() {
        long now = System.nanoTime();
        if (this.unreachable().isEmpty()) {
            this.allReachableClockTime_$eq(this.allReachableClockTime() + (now - this.previousClockTime()));
        }
        this.previousClockTime_$eq(now);
    }

    public void receiveRemovedNodePruningTick() {
        if (this.unreachable().isEmpty()) {
            if (this.isLeader()) {
                this.collectRemovedNodes();
                this.initRemovedNodePruning();
            }
            this.performRemovedNodePruning();
            this.deleteObsoletePruningPerformed();
            return;
        }
    }

    public void collectRemovedNodes() {
        SortedSet knownNodes = (SortedSet)this.org$apache$pekko$cluster$ddata$Replicator$$allNodes().union((scala.collection.Set)this.removedNodes().keySet());
        scala.collection.immutable.Set newRemovedNodes = (scala.collection.immutable.Set)this.dataEntries().foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Internal.DataEnvelope dataEnvelope;
                Tuple2 tuple22;
                scala.collection.immutable.Set set = (scala.collection.immutable.Set)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                scala.collection.immutable.Set acc = set;
                if (tuple23 != null && (tuple22 = (Tuple2)tuple23._2()) != null && (dataEnvelope = (Internal.DataEnvelope)tuple22._1()) != null) {
                    Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                    ReplicatedData replicatedData = dataEnvelope2._1();
                    Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                    VersionVector versionVector = dataEnvelope2._3();
                    if (replicatedData instanceof RemovedNodePruning) {
                        RemovedNodePruning data = (RemovedNodePruning)replicatedData;
                        return (scala.collection.immutable.Set)acc.union((scala.collection.Set)data.modifiedByNodes().filterNot((Function1 & Serializable)n -> {
                            UniqueAddress uniqueAddress = n;
                            UniqueAddress uniqueAddress2 = this.selfUniqueAddress();
                            return !(uniqueAddress == null ? uniqueAddress2 != null : !uniqueAddress.equals(uniqueAddress2)) || knownNodes.apply(n);
                        }));
                    }
                }
                scala.collection.immutable.Set acc2 = set;
                return acc2;
            }
            throw new MatchError((Object)tuple2);
        });
        newRemovedNodes.foreach((Function1)(JProcedure1 & Serializable)n -> {
            this.log().debug("Adding removed node [{}] from data", n);
            this.removedNodes_$eq((Map<UniqueAddress, Object>)((Map)this.removedNodes().updated(n, (Object)BoxesRunTime.boxToLong((long)this.allReachableClockTime()))));
        });
    }

    public void initRemovedNodePruning() {
        scala.collection.immutable.Set removedSet = (scala.collection.immutable.Set)this.removedNodes().iterator().collect((PartialFunction)new Serializable(this){
            private final /* synthetic */ Replicator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    UniqueAddress r = (UniqueAddress)tuple2._1();
                    long t = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    if (this.$outer.allReachableClockTime() - t > this.$outer.maxPruningDisseminationNanos()) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    UniqueAddress r = (UniqueAddress)tuple2._1();
                    long t = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    if (this.$outer.allReachableClockTime() - t > this.$outer.maxPruningDisseminationNanos()) {
                        return r;
                    }
                }
                return function1.apply((Object)x);
            }
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
        if (removedSet.nonEmpty()) {
            this.dataEntries().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    String key = (String)tuple2._1();
                    if (tuple22 != null) {
                        Internal.DataEnvelope envelope = (Internal.DataEnvelope)tuple22._1();
                        return true;
                    }
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    String key = (String)tuple2._1();
                    if (tuple22 != null) {
                        Internal.DataEnvelope envelope = (Internal.DataEnvelope)tuple22._1();
                        removedSet.foreach((Function1)(JProcedure1 & Serializable)removed -> {
                            if (envelope.needPruningFrom((UniqueAddress)removed)) {
                                ReplicatedData replicatedData = envelope.data();
                                if (replicatedData instanceof RemovedNodePruning) {
                                    PruningState pruningState;
                                    Option option = envelope.pruning().get(removed);
                                    if (None$.MODULE$.equals(option)) {
                                        this.init$1(key, envelope, (UniqueAddress)removed);
                                        return;
                                    }
                                    if (option instanceof Some && (pruningState = (PruningState)((Some)option).value()) instanceof PruningState.PruningInitialized) {
                                        UniqueAddress owner;
                                        PruningState.PruningInitialized pruningInitialized = PruningState$PruningInitialized$.MODULE$.unapply((PruningState.PruningInitialized)pruningState);
                                        UniqueAddress uniqueAddress = pruningInitialized._1();
                                        scala.collection.immutable.Set<Address> set = pruningInitialized._2();
                                        UniqueAddress uniqueAddress2 = owner = uniqueAddress;
                                        UniqueAddress uniqueAddress3 = this.selfUniqueAddress();
                                        if (uniqueAddress2 == null ? uniqueAddress3 != null : !uniqueAddress2.equals(uniqueAddress3)) {
                                            this.init$1(key, envelope, (UniqueAddress)removed);
                                            return;
                                        }
                                    }
                                    return;
                                }
                                return;
                            }
                        });
                        return;
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
    }

    public void performRemovedNodePruning() {
        SortedSet<UniqueAddress> all = this.org$apache$pekko$cluster$ddata$Replicator$$allNodes();
        PruningState.PruningPerformed pruningPerformed = PruningState$PruningPerformed$.MODULE$.apply(System.currentTimeMillis() + this.org$apache$pekko$cluster$ddata$Replicator$$settings.pruningMarkerTimeToLive().toMillis());
        PruningState.PruningPerformed durablePruningPerformed = PruningState$PruningPerformed$.MODULE$.apply(System.currentTimeMillis() + this.org$apache$pekko$cluster$ddata$Replicator$$settings.durablePruningMarkerTimeToLive().toMillis());
        this.dataEntries().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Internal.DataEnvelope dataEnvelope;
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                String key = (String)tuple2._1();
                if (tuple22 != null && (dataEnvelope = (Internal.DataEnvelope)tuple22._1()) != null) {
                    Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                    ReplicatedData replicatedData = dataEnvelope2._1();
                    Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                    VersionVector versionVector = dataEnvelope2._3();
                    if (replicatedData instanceof RemovedNodePruning) {
                        RemovedNodePruning data = (RemovedNodePruning)replicatedData;
                        Map<UniqueAddress, PruningState> pruning = map;
                        Internal.DataEnvelope envelope = dataEnvelope;
                        pruning.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                PruningState pruningState = (PruningState)tuple2._2();
                                UniqueAddress removed = (UniqueAddress)tuple2._1();
                                if (pruningState instanceof PruningState.PruningInitialized) {
                                    PruningState.PruningInitialized pruningInitialized = PruningState$PruningInitialized$.MODULE$.unapply((PruningState.PruningInitialized)pruningState);
                                    UniqueAddress uniqueAddress = pruningInitialized._1();
                                    scala.collection.immutable.Set<Address> set = pruningInitialized._2();
                                    UniqueAddress owner = uniqueAddress;
                                    scala.collection.immutable.Set<Address> seen = set;
                                    UniqueAddress uniqueAddress2 = owner;
                                    UniqueAddress uniqueAddress3 = this.selfUniqueAddress();
                                    if (!(uniqueAddress2 != null ? !uniqueAddress2.equals(uniqueAddress3) : uniqueAddress3 != null)) {
                                        if (all.isEmpty() || all.forall((Function1 & Serializable)n -> seen.apply((Object)n.address()))) {
                                            Internal.DataEnvelope newEnvelope = envelope.prune(removed, this.isDurable(key) ? durablePruningPerformed : pruningPerformed);
                                            this.log().debug("Perform pruning of [{}] from [{}] to [{}]", (Object)key, (Object)removed, (Object)this.selfUniqueAddress());
                                            this.setData(key, newEnvelope);
                                            if (newEnvelope.data() != data && this.isDurable(key)) {
                                                this.durableStore().$bang((Object)DurableStore$Store$.MODULE$.apply(key, new DurableStore.DurableDataEnvelope(newEnvelope), (Option<DurableStore.StoreReply>)None$.MODULE$), this.self());
                                                return;
                                            }
                                            return;
                                        }
                                    }
                                }
                            }
                        });
                        return;
                    }
                }
            }
        });
    }

    public void deleteObsoletePruningPerformed() {
        long currentTime = System.currentTimeMillis();
        this.dataEntries().foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                Internal.DataEnvelope dataEnvelope;
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                String key = (String)tuple2._1();
                if (tuple22 != null && (dataEnvelope = (Internal.DataEnvelope)tuple22._1()) != null) {
                    Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
                    ReplicatedData replicatedData = dataEnvelope2._1();
                    Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
                    VersionVector versionVector = dataEnvelope2._3();
                    if (replicatedData instanceof RemovedNodePruning) {
                        Map<UniqueAddress, PruningState> pruning = map;
                        Internal.DataEnvelope envelope = dataEnvelope;
                        Internal.DataEnvelope newEnvelope = (Internal.DataEnvelope)pruning.foldLeft((Object)envelope, (Function2 & Serializable)(x$1, x$2) -> {
                            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                            if (tuple2 != null) {
                                Internal.DataEnvelope dataEnvelope = (Internal.DataEnvelope)tuple2._1();
                                Tuple2 tuple22 = (Tuple2)tuple2._2();
                                Internal.DataEnvelope acc = dataEnvelope;
                                if (tuple22 != null) {
                                    PruningState.PruningPerformed p;
                                    PruningState pruningState = (PruningState)tuple22._2();
                                    UniqueAddress removed = (UniqueAddress)tuple22._1();
                                    if (pruningState instanceof PruningState.PruningPerformed && (p = (PruningState.PruningPerformed)pruningState).isObsolete(currentTime)) {
                                        this.log().debug("Removing obsolete pruning marker for [{}] in [{}]", (Object)removed, (Object)key);
                                        this.removedNodes_$eq((Map<UniqueAddress, Object>)((Map)this.removedNodes().$minus((Object)removed)));
                                        Map map = (Map)acc.pruning().$minus((Object)removed);
                                        ReplicatedData replicatedData = acc.copy$default$1();
                                        VersionVector versionVector = acc.copy$default$3();
                                        return acc.copy(replicatedData, (Map<UniqueAddress, PruningState>)map, versionVector);
                                    }
                                }
                                Internal.DataEnvelope acc2 = dataEnvelope;
                                return acc2;
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        if (newEnvelope != envelope) {
                            this.setData(key, newEnvelope);
                            return;
                        }
                        return;
                    }
                }
            }
        });
    }

    public void receiveGetReplicaCount() {
        this.replyTo().$bang((Object)Replicator$ReplicaCount$.MODULE$.apply(this.nodes().size() + 1), this.self());
    }

    private static final Object $init$$$anonfun$1() {
        return "Cluster node must not be terminated";
    }

    private final Object $init$$$anonfun$2(ReplicatorSettings settings$1) {
        return new StringBuilder(52).append("This cluster member [").append(this.selfAddress()).append("] doesn't have all the roles [").append(settings$1.roles().mkString(", ")).append("]").toString();
    }

    private static final int $anonfun$1() {
        return Integer.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$apache$pekko$cluster$ddata$Replicator$$_$fromDurableStore$1() {
        ActorRef actorRef = this.sender();
        ActorRef actorRef2 = this.durableStore();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!actorRef.equals(actorRef2)) return false;
        ActorRef actorRef3 = this.sender();
        ActorRef actorRef4 = this.context().system().deadLetters();
        if (actorRef3 == null) {
            if (actorRef4 == null) return false;
            return true;
        } else if (actorRef3.equals(actorRef4)) return false;
        return true;
    }

    public final void org$apache$pekko$cluster$ddata$Replicator$$_$unstashAll$1(ObjectRef stash$1) {
        ActorRef originalReplyTo = this.replyTo();
        ((Vector)stash$1.elem).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object msg = tuple2._1();
                ActorRef snd = (ActorRef)tuple2._2();
                this.replyTo_$eq(snd);
                this.normalReceive().applyOrElse(msg, (Function1)(JProcedure1 & Serializable)message -> this.unhandled(message));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        Vector vector = scala.package$.MODULE$.Vector().empty();
        stash$1.elem = vector;
        vector = null;
        this.replyTo_$eq(originalReplyTo);
    }

    private static final Option deltaOrPlaceholder$1(DeltaReplicatedData d) {
        Option<ReplicatedDelta> option = d.delta();
        if (option instanceof Some) {
            Some s = (Some)option;
            return s;
        }
        if (None$.MODULE$.equals(option)) {
            return Some$.MODULE$.apply((Object)Replicator$Internal$DeltaPropagation$.MODULE$.NoDeltaPlaceholder());
        }
        throw new MatchError(option);
    }

    private final Tuple2 receiveUpdate$$anonfun$1(Function1 modify$1, Option localValue$1) {
        Internal.DataEnvelope dataEnvelope;
        Option option = localValue$1;
        if (option instanceof Some && (dataEnvelope = (Internal.DataEnvelope)((Some)option).value()) != null) {
            Internal.DataEnvelope dataEnvelope2 = Replicator$Internal$DataEnvelope$.MODULE$.unapply(dataEnvelope);
            ReplicatedData replicatedData = dataEnvelope2._1();
            Map<UniqueAddress, PruningState> map = dataEnvelope2._2();
            VersionVector versionVector = dataEnvelope2._3();
            if (Replicator$Internal$DeletedData$.MODULE$.equals(replicatedData)) {
                Internal.DataEnvelope envelope = dataEnvelope;
                return Tuple2$.MODULE$.apply((Object)envelope, (Object)None$.MODULE$);
            }
            ReplicatedData existing = replicatedData;
            Internal.DataEnvelope envelope = dataEnvelope;
            ReplicatedData replicatedData2 = (ReplicatedData)modify$1.apply((Object)Some$.MODULE$.apply((Object)existing));
            if (replicatedData2 instanceof DeltaReplicatedData) {
                DeltaReplicatedData d = (DeltaReplicatedData)replicatedData2;
                if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.deltaCrdtEnabled()) {
                    return Tuple2$.MODULE$.apply((Object)envelope.merge(d.resetDelta()), (Object)Replicator.deltaOrPlaceholder$1(d));
                }
            }
            ReplicatedData d = replicatedData2;
            return Tuple2$.MODULE$.apply((Object)envelope.merge(d), (Object)None$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            ReplicatedData replicatedData = (ReplicatedData)modify$1.apply((Object)None$.MODULE$);
            if (replicatedData instanceof DeltaReplicatedData) {
                DeltaReplicatedData d = (DeltaReplicatedData)replicatedData;
                if (this.org$apache$pekko$cluster$ddata$Replicator$$settings.deltaCrdtEnabled()) {
                    return Tuple2$.MODULE$.apply((Object)Replicator$Internal$DataEnvelope$.MODULE$.apply(d.resetDelta(), Replicator$Internal$DataEnvelope$.MODULE$.$lessinit$greater$default$2(), Replicator$Internal$DataEnvelope$.MODULE$.$lessinit$greater$default$3()), (Object)Replicator.deltaOrPlaceholder$1(d));
                }
            }
            ReplicatedData d = replicatedData;
            return Tuple2$.MODULE$.apply((Object)Replicator$Internal$DataEnvelope$.MODULE$.apply(d, Replicator$Internal$DataEnvelope$.MODULE$.$lessinit$greater$default$2(), Replicator$Internal$DataEnvelope$.MODULE$.$lessinit$greater$default$3()), (Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    private final void notify$1(String keyId, Set subs) {
        Key key = (Key)this.subscriptionKeys().apply((Object)keyId);
        Option<Internal.DataEnvelope> option = this.getData(keyId);
        if (option instanceof Some) {
            Internal.DataEnvelope envelope = (Internal.DataEnvelope)((Some)option).value();
            ReplicatedData replicatedData = envelope.data();
            Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
            SubscribeResponse msg = (SubscribeResponse)(!(replicatedData != null ? !replicatedData.equals(replicator$Internal$DeletedData$) : replicator$Internal$DeletedData$ != null) ? Replicator$Deleted$.MODULE$.apply(key) : Replicator$Changed$.MODULE$.apply(key, envelope.data()));
            subs.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.$bang((Object)msg, this.self()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$apache$pekko$cluster$ddata$Replicator$$_$isOtherDifferent$1(String key, ByteString otherDigest) {
        ByteString d;
        ByteString byteString = d = this.getDigest(key);
        ByteString byteString2 = Replicator$Internal$.MODULE$.NotFoundDigest();
        if (byteString == null) {
            if (byteString2 == null) return false;
        } else if (byteString.equals(byteString2)) return false;
        ByteString byteString3 = d;
        ByteString byteString4 = otherDigest;
        if (byteString3 == null) {
            if (byteString4 == null) return false;
            return true;
        } else if (byteString3.equals(byteString4)) return false;
        return true;
    }

    private final void addGossip$1(boolean sendBack$1, Option fromSystemUid$1, ObjectRef messages$1, ReusableBuilder collectedEntries$1) {
        Map entries = ((IterableOnceOps)collectedEntries$1.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (entries.nonEmpty()) {
            Vector vector = (Vector)((Vector)messages$1.elem).$colon$plus((Object)Replicator$Internal$Gossip$.MODULE$.apply((Map<String, Internal.DataEnvelope>)entries, sendBack$1, (Option<Object>)fromSystemUid$1, (Option<Object>)this.selfFromSystemUid()));
            messages$1.elem = vector;
            vector = null;
            return;
        }
    }

    private final void init$1(String key$5, Internal.DataEnvelope envelope$2, UniqueAddress removed$1) {
        Internal.DataEnvelope newEnvelope = envelope$2.initRemovedNodePruning(removed$1, this.selfUniqueAddress());
        this.log().debug("Initiated pruning of [{}] for data key [{}] to [{}]", (Object)removed$1, (Object)key$5, (Object)this.selfUniqueAddress());
        this.setData(key$5, newEnvelope);
    }

    public static final class Changed<A extends ReplicatedData>
    implements SubscribeResponse<A>,
    ReplicatorMessage,
    Product {
        private final Key key;
        private final A data;

        public static <A extends ReplicatedData> Changed<A> apply(Key<A> key, A a) {
            return Replicator$Changed$.MODULE$.apply(key, a);
        }

        public static <A extends ReplicatedData> Changed<A> unapply(Changed<A> changed) {
            return Replicator$Changed$.MODULE$.unapply(changed);
        }

        public Changed(Key<A> key, A data) {
            this.key = key;
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Changed)) return false;
            Changed changed = (Changed)object;
            Key<A> key = this.key();
            Key<A> key2 = changed.key();
            if (key != null) {
                if (!((Object)key).equals(key2)) return false;
                return true;
            }
            if (key2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Changed;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Changed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        public <T extends ReplicatedData> T get(Key<T> key) {
            Key<T> key2 = key;
            Key<A> key3 = this.key();
            Predef$.MODULE$.require(!(key2 != null ? !((Object)key2).equals(key3) : key3 != null), this::get$$anonfun$2);
            return (T)this.data;
        }

        public A dataValue() {
            return this.data;
        }

        public <A extends ReplicatedData> Changed<A> copy(Key<A> key, A data) {
            return new Changed<A>(key, data);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public Key<A> _1() {
            return this.key();
        }

        private final Object get$$anonfun$2() {
            return "wrong key used, must use contained key";
        }
    }

    public static interface Command<A extends ReplicatedData> {
        public Key<A> key();
    }

    public static final class DataDeleted<A extends ReplicatedData>
    extends RuntimeException
    implements NoStackTrace,
    DeleteResponse<A>,
    Product {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> DataDeleted<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$DataDeleted$.MODULE$.apply(key, option);
        }

        public static DataDeleted<?> fromProduct(Product product) {
            return Replicator$DataDeleted$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> DataDeleted<A> unapply(DataDeleted<A> dataDeleted) {
            return Replicator$DataDeleted$.MODULE$.unapply(dataDeleted);
        }

        public DataDeleted(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DataDeleted)) return false;
            DataDeleted dataDeleted = (DataDeleted)object;
            Key<A> key = this.key();
            Key<A> key2 = dataDeleted.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = dataDeleted.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof DataDeleted;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DataDeleted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        @Override
        public String toString() {
            return new StringBuilder(14).append("DataDeleted [").append(this.key()).append("]").toString();
        }

        public <A extends ReplicatedData> DataDeleted<A> copy(Key<A> key, Option<Object> request) {
            return new DataDeleted<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class Delete<A extends ReplicatedData>
    implements Command<A>,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Key key;
        private final WriteConsistency consistency;
        private final Option request;

        public static <A extends ReplicatedData> Delete<A> apply(Key<A> key, WriteConsistency writeConsistency, Option<Object> option) {
            return Replicator$Delete$.MODULE$.apply(key, writeConsistency, option);
        }

        public static Delete<?> fromProduct(Product product) {
            return Replicator$Delete$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> Delete<A> unapply(Delete<A> delete) {
            return Replicator$Delete$.MODULE$.unapply(delete);
        }

        public static <A extends ReplicatedData> Option<Object> $lessinit$greater$default$3() {
            return Replicator$Delete$.MODULE$.$lessinit$greater$default$3();
        }

        public Delete(Key<A> key, WriteConsistency consistency, Option<Object> request) {
            this.key = key;
            this.consistency = consistency;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Delete)) return false;
            Delete delete = (Delete)object;
            Key<A> key = this.key();
            Key<A> key2 = delete.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            WriteConsistency writeConsistency = this.consistency();
            WriteConsistency writeConsistency2 = delete.consistency();
            if (writeConsistency == null) {
                if (writeConsistency2 != null) {
                    return false;
                }
            } else if (!writeConsistency.equals(writeConsistency2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = delete.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Delete;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Delete";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "consistency";
                }
                case 2: {
                    return "request";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        public WriteConsistency consistency() {
            return this.consistency;
        }

        public Option<Object> request() {
            return this.request;
        }

        public Delete(Key<A> key, WriteConsistency consistency) {
            this(key, consistency, (Option<Object>)None$.MODULE$);
        }

        public Delete(Key<A> key, WriteConsistency consistency, Optional<Object> request) {
            this(key, consistency, (Option<Object>)Option$.MODULE$.apply(request.orElse(null)));
        }

        public <A extends ReplicatedData> Delete<A> copy(Key<A> key, WriteConsistency consistency, Option<Object> request) {
            return new Delete<A>(key, consistency, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> WriteConsistency copy$default$2() {
            return this.consistency();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$3() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public WriteConsistency _2() {
            return this.consistency();
        }

        public Option<Object> _3() {
            return this.request();
        }
    }

    public static interface DeleteResponse<A extends ReplicatedData>
    extends NoSerializationVerificationNeeded {
        public Key<A> key();

        public Option<Object> request();

        public static Optional getRequest$(DeleteResponse $this) {
            return $this.getRequest();
        }

        default public Optional<Object> getRequest() {
            return Optional.ofNullable(this.request().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
    }

    public static final class DeleteSuccess<A extends ReplicatedData>
    implements DeleteResponse<A>,
    Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> DeleteSuccess<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$DeleteSuccess$.MODULE$.apply(key, option);
        }

        public static DeleteSuccess<?> fromProduct(Product product) {
            return Replicator$DeleteSuccess$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> DeleteSuccess<A> unapply(DeleteSuccess<A> deleteSuccess) {
            return Replicator$DeleteSuccess$.MODULE$.unapply(deleteSuccess);
        }

        public DeleteSuccess(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeleteSuccess)) return false;
            DeleteSuccess deleteSuccess = (DeleteSuccess)object;
            Key<A> key = this.key();
            Key<A> key2 = deleteSuccess.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = deleteSuccess.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DeleteSuccess;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DeleteSuccess";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> DeleteSuccess<A> copy(Key<A> key, Option<Object> request) {
            return new DeleteSuccess<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class Deleted<A extends ReplicatedData>
    implements SubscribeResponse<A>,
    Product,
    Serializable {
        private final Key key;

        public static <A extends ReplicatedData> Deleted<A> apply(Key<A> key) {
            return Replicator$Deleted$.MODULE$.apply(key);
        }

        public static Deleted<?> fromProduct(Product product) {
            return Replicator$Deleted$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> Deleted<A> unapply(Deleted<A> deleted) {
            return Replicator$Deleted$.MODULE$.unapply(deleted);
        }

        public Deleted(Key<A> key) {
            this.key = key;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Deleted)) return false;
            Deleted deleted = (Deleted)object;
            Key<A> key = this.key();
            Key<A> key2 = deleted.key();
            if (key != null) {
                if (!((Object)key).equals(key2)) return false;
                return true;
            }
            if (key2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Deleted;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Deleted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        public <A extends ReplicatedData> Deleted<A> copy(Key<A> key) {
            return new Deleted<A>(key);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public Key<A> _1() {
            return this.key();
        }
    }

    public static final class Get<A extends ReplicatedData>
    implements Command<A>,
    ReplicatorMessage,
    Product {
        private final Key key;
        private final ReadConsistency consistency;
        private final Option request;

        public static <A extends ReplicatedData> Get<A> apply(Key<A> key, ReadConsistency readConsistency, Option<Object> option) {
            return Replicator$Get$.MODULE$.apply(key, readConsistency, option);
        }

        public static Get<?> fromProduct(Product product) {
            return Replicator$Get$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> Get<A> unapply(Get<A> get) {
            return Replicator$Get$.MODULE$.unapply(get);
        }

        public static <A extends ReplicatedData> Option<Object> $lessinit$greater$default$3() {
            return Replicator$Get$.MODULE$.$lessinit$greater$default$3();
        }

        public Get(Key<A> key, ReadConsistency consistency, Option<Object> request) {
            this.key = key;
            this.consistency = consistency;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Get)) return false;
            Get get = (Get)object;
            Key<A> key = this.key();
            Key<A> key2 = get.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            ReadConsistency readConsistency = this.consistency();
            ReadConsistency readConsistency2 = get.consistency();
            if (readConsistency == null) {
                if (readConsistency2 != null) {
                    return false;
                }
            } else if (!readConsistency.equals(readConsistency2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = get.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Get;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Get";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "consistency";
                }
                case 2: {
                    return "request";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        public ReadConsistency consistency() {
            return this.consistency;
        }

        public Option<Object> request() {
            return this.request;
        }

        public Get(Key<A> key, ReadConsistency consistency) {
            this(key, consistency, (Option<Object>)None$.MODULE$);
        }

        public Get(Key<A> key, ReadConsistency consistency, Optional<Object> request) {
            this(key, consistency, (Option<Object>)Option$.MODULE$.apply(request.orElse(null)));
        }

        public <A extends ReplicatedData> Get<A> copy(Key<A> key, ReadConsistency consistency, Option<Object> request) {
            return new Get<A>(key, consistency, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> ReadConsistency copy$default$2() {
            return this.consistency();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$3() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public ReadConsistency _2() {
            return this.consistency();
        }

        public Option<Object> _3() {
            return this.request();
        }
    }

    public static final class GetDataDeleted<A extends ReplicatedData>
    extends GetResponse<A>
    implements Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> GetDataDeleted<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$GetDataDeleted$.MODULE$.apply(key, option);
        }

        public static GetDataDeleted<?> fromProduct(Product product) {
            return Replicator$GetDataDeleted$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> GetDataDeleted<A> unapply(GetDataDeleted<A> getDataDeleted) {
            return Replicator$GetDataDeleted$.MODULE$.unapply(getDataDeleted);
        }

        public GetDataDeleted(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetDataDeleted)) return false;
            GetDataDeleted getDataDeleted = (GetDataDeleted)object;
            Key<A> key = this.key();
            Key<A> key2 = getDataDeleted.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = getDataDeleted.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetDataDeleted;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GetDataDeleted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> GetDataDeleted<A> copy(Key<A> key, Option<Object> request) {
            return new GetDataDeleted<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class GetFailure<A extends ReplicatedData>
    extends GetResponse<A>
    implements ReplicatorMessage,
    Product {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> GetFailure<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$GetFailure$.MODULE$.apply(key, option);
        }

        public static GetFailure<?> fromProduct(Product product) {
            return Replicator$GetFailure$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> GetFailure<A> unapply(GetFailure<A> getFailure) {
            return Replicator$GetFailure$.MODULE$.unapply(getFailure);
        }

        public GetFailure(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetFailure)) return false;
            GetFailure getFailure = (GetFailure)object;
            Key<A> key = this.key();
            Key<A> key2 = getFailure.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = getFailure.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetFailure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GetFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> GetFailure<A> copy(Key<A> key, Option<Object> request) {
            return new GetFailure<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    @InternalApi
    public static final class GetKeyIdsResult
    implements Product,
    Serializable {
        private final scala.collection.immutable.Set keyIds;

        public static GetKeyIdsResult apply(scala.collection.immutable.Set<String> set) {
            return Replicator$GetKeyIdsResult$.MODULE$.apply(set);
        }

        public static GetKeyIdsResult fromProduct(Product product) {
            return Replicator$GetKeyIdsResult$.MODULE$.fromProduct(product);
        }

        public static GetKeyIdsResult unapply(GetKeyIdsResult getKeyIdsResult) {
            return Replicator$GetKeyIdsResult$.MODULE$.unapply(getKeyIdsResult);
        }

        public GetKeyIdsResult(scala.collection.immutable.Set<String> keyIds) {
            this.keyIds = keyIds;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetKeyIdsResult)) return false;
            GetKeyIdsResult getKeyIdsResult = (GetKeyIdsResult)object;
            scala.collection.immutable.Set<String> set = this.keyIds();
            scala.collection.immutable.Set<String> set2 = getKeyIdsResult.keyIds();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetKeyIdsResult;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "GetKeyIdsResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "keyIds";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public scala.collection.immutable.Set<String> keyIds() {
            return this.keyIds;
        }

        public java.util.Set<String> getKeyIds() {
            return package.JavaConverters$.MODULE$.SetHasAsJava(this.keyIds()).asJava();
        }

        public GetKeyIdsResult copy(scala.collection.immutable.Set<String> keyIds) {
            return new GetKeyIdsResult(keyIds);
        }

        public scala.collection.immutable.Set<String> copy$default$1() {
            return this.keyIds();
        }

        public scala.collection.immutable.Set<String> _1() {
            return this.keyIds();
        }
    }

    public static abstract class GetResponse<A extends ReplicatedData>
    implements NoSerializationVerificationNeeded {
        public abstract Key<A> key();

        public abstract Option<Object> request();

        public Optional<Object> getRequest() {
            return Optional.ofNullable(this.request().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
    }

    public static final class GetSuccess<A extends ReplicatedData>
    extends GetResponse<A>
    implements ReplicatorMessage,
    Product {
        private final Key key;
        private final Option request;
        private final A data;

        public static <A extends ReplicatedData> GetSuccess<A> apply(Key<A> key, Option<Object> option, A a) {
            return Replicator$GetSuccess$.MODULE$.apply(key, option, a);
        }

        public static <A extends ReplicatedData> GetSuccess<A> unapply(GetSuccess<A> getSuccess) {
            return Replicator$GetSuccess$.MODULE$.unapply(getSuccess);
        }

        public GetSuccess(Key<A> key, Option<Object> request, A data) {
            this.key = key;
            this.request = request;
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetSuccess)) return false;
            GetSuccess getSuccess = (GetSuccess)object;
            Key<A> key = this.key();
            Key<A> key2 = getSuccess.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = getSuccess.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GetSuccess;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GetSuccess";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <T extends ReplicatedData> T get(Key<T> key) {
            Key<T> key2 = key;
            Key<A> key3 = this.key();
            Predef$.MODULE$.require(!(key2 != null ? !((Object)key2).equals(key3) : key3 != null), this::get$$anonfun$1);
            return (T)this.data;
        }

        public A dataValue() {
            return this.data;
        }

        public <A extends ReplicatedData> GetSuccess<A> copy(Key<A> key, Option<Object> request, A data) {
            return new GetSuccess<A>(key, request, data);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }

        private final Object get$$anonfun$1() {
            return "wrong key used, must use contained key";
        }
    }

    public static final class ModifyFailure<A extends ReplicatedData>
    extends UpdateFailure<A>
    implements Product,
    Serializable {
        private final Key key;
        private final String errorMessage;
        private final Throwable cause;
        private final Option request;

        public static <A extends ReplicatedData> ModifyFailure<A> apply(Key<A> key, String string, Throwable throwable, Option<Object> option) {
            return Replicator$ModifyFailure$.MODULE$.apply(key, string, throwable, option);
        }

        public static ModifyFailure<?> fromProduct(Product product) {
            return Replicator$ModifyFailure$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> ModifyFailure<A> unapply(ModifyFailure<A> modifyFailure) {
            return Replicator$ModifyFailure$.MODULE$.unapply(modifyFailure);
        }

        public ModifyFailure(Key<A> key, String errorMessage, Throwable cause, Option<Object> request) {
            this.key = key;
            this.errorMessage = errorMessage;
            this.cause = cause;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ModifyFailure)) return false;
            ModifyFailure modifyFailure = (ModifyFailure)object;
            Key<A> key = this.key();
            Key<A> key2 = modifyFailure.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            String string = this.errorMessage();
            String string2 = modifyFailure.errorMessage();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = modifyFailure.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = modifyFailure.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public boolean canEqual(Object that) {
            return that instanceof ModifyFailure;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ModifyFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "errorMessage";
                }
                case 2: {
                    return "cause";
                }
                case 3: {
                    return "request";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public String toString() {
            return new StringBuilder(18).append("ModifyFailure [").append(this.key()).append("]: ").append(this.errorMessage()).toString();
        }

        public <A extends ReplicatedData> ModifyFailure<A> copy(Key<A> key, String errorMessage, Throwable cause, Option<Object> request) {
            return new ModifyFailure<A>(key, errorMessage, cause, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> String copy$default$2() {
            return this.errorMessage();
        }

        public <A extends ReplicatedData> Throwable copy$default$3() {
            return this.cause();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$4() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public String _2() {
            return this.errorMessage();
        }

        public Throwable _3() {
            return this.cause();
        }

        public Option<Object> _4() {
            return this.request();
        }
    }

    public static final class NotFound<A extends ReplicatedData>
    extends GetResponse<A>
    implements ReplicatorMessage,
    Product {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> NotFound<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$NotFound$.MODULE$.apply(key, option);
        }

        public static NotFound<?> fromProduct(Product product) {
            return Replicator$NotFound$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> NotFound<A> unapply(NotFound<A> notFound) {
            return Replicator$NotFound$.MODULE$.unapply(notFound);
        }

        public NotFound(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotFound)) return false;
            NotFound notFound = (NotFound)object;
            Key<A> key = this.key();
            Key<A> key2 = notFound.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = notFound.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NotFound;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "NotFound";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> NotFound<A> copy(Key<A> key, Option<Object> request) {
            return new NotFound<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class ReadAll
    implements ReadConsistency,
    Product,
    Serializable {
        private final FiniteDuration timeout;

        public static ReadAll apply(FiniteDuration finiteDuration) {
            return Replicator$ReadAll$.MODULE$.apply(finiteDuration);
        }

        public static ReadAll fromProduct(Product product) {
            return Replicator$ReadAll$.MODULE$.fromProduct(product);
        }

        public static ReadAll unapply(ReadAll readAll) {
            return Replicator$ReadAll$.MODULE$.unapply(readAll);
        }

        public ReadAll(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReadAll)) return false;
            ReadAll readAll = (ReadAll)object;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = readAll.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReadAll;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReadAll";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public ReadAll(Duration timeout) {
            this(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
        }

        public ReadAll copy(FiniteDuration timeout) {
            return new ReadAll(timeout);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }
    }

    public static interface ReadConsistency {
        public FiniteDuration timeout();
    }

    public static final class ReadFrom
    implements ReadConsistency,
    Product,
    Serializable {
        private final int n;
        private final FiniteDuration timeout;

        public static ReadFrom apply(int n, FiniteDuration finiteDuration) {
            return Replicator$ReadFrom$.MODULE$.apply(n, finiteDuration);
        }

        public static ReadFrom fromProduct(Product product) {
            return Replicator$ReadFrom$.MODULE$.fromProduct(product);
        }

        public static ReadFrom unapply(ReadFrom readFrom) {
            return Replicator$ReadFrom$.MODULE$.unapply(readFrom);
        }

        public ReadFrom(int n, FiniteDuration timeout) {
            this.n = n;
            this.timeout = timeout;
            Predef$.MODULE$.require(n >= 2, this::$init$$$anonfun$4);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.n());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReadFrom)) return false;
            ReadFrom readFrom = (ReadFrom)object;
            if (this.n() != readFrom.n()) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = readFrom.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReadFrom;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ReadFrom";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "n";
            }
            if (1 == n2) {
                return "timeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int n() {
            return this.n;
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public ReadFrom(int n, Duration timeout) {
            this(n, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
        }

        public ReadFrom copy(int n, FiniteDuration timeout) {
            return new ReadFrom(n, timeout);
        }

        public int copy$default$1() {
            return this.n();
        }

        public FiniteDuration copy$default$2() {
            return this.timeout();
        }

        public int _1() {
            return this.n();
        }

        public FiniteDuration _2() {
            return this.timeout();
        }

        private final Object $init$$$anonfun$4() {
            return "ReadFrom n must be >= 2, use ReadLocal for n=1";
        }
    }

    public static final class ReadMajority
    implements ReadConsistency,
    Product,
    Serializable {
        private final FiniteDuration timeout;
        private final int minCap;

        public static ReadMajority apply(FiniteDuration finiteDuration, int n) {
            return Replicator$ReadMajority$.MODULE$.apply(finiteDuration, n);
        }

        public static ReadMajority fromProduct(Product product) {
            return Replicator$ReadMajority$.MODULE$.fromProduct(product);
        }

        public static ReadMajority unapply(ReadMajority readMajority) {
            return Replicator$ReadMajority$.MODULE$.unapply(readMajority);
        }

        public static int $lessinit$greater$default$2() {
            return Replicator$ReadMajority$.MODULE$.$lessinit$greater$default$2();
        }

        public ReadMajority(FiniteDuration timeout, int minCap) {
            this.timeout = timeout;
            this.minCap = minCap;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            n = Statics.mix((int)n, (int)this.minCap());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReadMajority)) return false;
            ReadMajority readMajority = (ReadMajority)object;
            if (this.minCap() != readMajority.minCap()) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = readMajority.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReadMajority;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ReadMajority";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeout";
            }
            if (1 == n2) {
                return "minCap";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public int minCap() {
            return this.minCap;
        }

        public ReadMajority(FiniteDuration timeout) {
            this(timeout, Replicator$.MODULE$.DefaultMajorityMinCap());
        }

        public ReadMajority(Duration timeout) {
            this(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)), Replicator$.MODULE$.DefaultMajorityMinCap());
        }

        public ReadMajority copy(FiniteDuration timeout, int minCap) {
            return new ReadMajority(timeout, minCap);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public int copy$default$2() {
            return this.minCap();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }

        public int _2() {
            return this.minCap();
        }
    }

    public static final class ReadMajorityPlus
    implements ReadConsistency,
    Product,
    Serializable {
        private final FiniteDuration timeout;
        private final int additional;
        private final int minCap;

        public static ReadMajorityPlus apply(FiniteDuration finiteDuration, int n, int n2) {
            return Replicator$ReadMajorityPlus$.MODULE$.apply(finiteDuration, n, n2);
        }

        public static ReadMajorityPlus fromProduct(Product product) {
            return Replicator$ReadMajorityPlus$.MODULE$.fromProduct(product);
        }

        public static ReadMajorityPlus unapply(ReadMajorityPlus readMajorityPlus) {
            return Replicator$ReadMajorityPlus$.MODULE$.unapply(readMajorityPlus);
        }

        public static int $lessinit$greater$default$3() {
            return Replicator$ReadMajorityPlus$.MODULE$.$lessinit$greater$default$3();
        }

        public ReadMajorityPlus(FiniteDuration timeout, int additional, int minCap) {
            this.timeout = timeout;
            this.additional = additional;
            this.minCap = minCap;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            n = Statics.mix((int)n, (int)this.additional());
            n = Statics.mix((int)n, (int)this.minCap());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReadMajorityPlus)) return false;
            ReadMajorityPlus readMajorityPlus = (ReadMajorityPlus)object;
            if (this.additional() != readMajorityPlus.additional()) return false;
            if (this.minCap() != readMajorityPlus.minCap()) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = readMajorityPlus.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReadMajorityPlus;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ReadMajorityPlus";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "timeout";
                }
                case 1: {
                    return "additional";
                }
                case 2: {
                    return "minCap";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public int additional() {
            return this.additional;
        }

        public int minCap() {
            return this.minCap;
        }

        public ReadMajorityPlus(Duration timeout, int additional) {
            this(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)), additional, Replicator$.MODULE$.DefaultMajorityMinCap());
        }

        public ReadMajorityPlus copy(FiniteDuration timeout, int additional, int minCap) {
            return new ReadMajorityPlus(timeout, additional, minCap);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public int copy$default$2() {
            return this.additional();
        }

        public int copy$default$3() {
            return this.minCap();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }

        public int _2() {
            return this.additional();
        }

        public int _3() {
            return this.minCap();
        }
    }

    public static final class ReplicaCount
    implements Product,
    Serializable {
        private final int n;

        public static ReplicaCount apply(int n) {
            return Replicator$ReplicaCount$.MODULE$.apply(n);
        }

        public static ReplicaCount fromProduct(Product product) {
            return Replicator$ReplicaCount$.MODULE$.fromProduct(product);
        }

        public static ReplicaCount unapply(ReplicaCount replicaCount) {
            return Replicator$ReplicaCount$.MODULE$.unapply(replicaCount);
        }

        public ReplicaCount(int n) {
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.n());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReplicaCount)) return false;
            ReplicaCount replicaCount = (ReplicaCount)object;
            if (this.n() != replicaCount.n()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReplicaCount;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "ReplicaCount";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "n";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int n() {
            return this.n;
        }

        public ReplicaCount copy(int n) {
            return new ReplicaCount(n);
        }

        public int copy$default$1() {
            return this.n();
        }

        public int _1() {
            return this.n();
        }
    }

    public static final class ReplicationDeleteFailure<A extends ReplicatedData>
    implements DeleteResponse<A>,
    Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> ReplicationDeleteFailure<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$ReplicationDeleteFailure$.MODULE$.apply(key, option);
        }

        public static ReplicationDeleteFailure<?> fromProduct(Product product) {
            return Replicator$ReplicationDeleteFailure$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> ReplicationDeleteFailure<A> unapply(ReplicationDeleteFailure<A> replicationDeleteFailure) {
            return Replicator$ReplicationDeleteFailure$.MODULE$.unapply(replicationDeleteFailure);
        }

        public ReplicationDeleteFailure(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ReplicationDeleteFailure)) return false;
            ReplicationDeleteFailure replicationDeleteFailure = (ReplicationDeleteFailure)object;
            Key<A> key = this.key();
            Key<A> key2 = replicationDeleteFailure.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = replicationDeleteFailure.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ReplicationDeleteFailure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ReplicationDeleteFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> ReplicationDeleteFailure<A> copy(Key<A> key, Option<Object> request) {
            return new ReplicationDeleteFailure<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static interface ReplicatorMessage
    extends Serializable {
    }

    public static final class StoreFailure<A extends ReplicatedData>
    extends UpdateFailure<A>
    implements DeleteResponse<A>,
    Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> StoreFailure<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$StoreFailure$.MODULE$.apply(key, option);
        }

        public static StoreFailure<?> fromProduct(Product product) {
            return Replicator$StoreFailure$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> StoreFailure<A> unapply(StoreFailure<A> storeFailure) {
            return Replicator$StoreFailure$.MODULE$.unapply(storeFailure);
        }

        public StoreFailure(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreFailure)) return false;
            StoreFailure storeFailure = (StoreFailure)object;
            Key<A> key = this.key();
            Key<A> key2 = storeFailure.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = storeFailure.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoreFailure;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "StoreFailure";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        @Override
        public Optional<Object> getRequest() {
            return Optional.ofNullable(this.request().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        public <A extends ReplicatedData> StoreFailure<A> copy(Key<A> key, Option<Object> request) {
            return new StoreFailure<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class Subscribe<A extends ReplicatedData>
    implements ReplicatorMessage,
    Product {
        private final Key key;
        private final ActorRef subscriber;

        public static <A extends ReplicatedData> Subscribe<A> apply(Key<A> key, ActorRef actorRef) {
            return Replicator$Subscribe$.MODULE$.apply(key, actorRef);
        }

        public static Subscribe<?> fromProduct(Product product) {
            return Replicator$Subscribe$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> Subscribe<A> unapply(Subscribe<A> subscribe) {
            return Replicator$Subscribe$.MODULE$.unapply(subscribe);
        }

        public Subscribe(Key<A> key, ActorRef subscriber) {
            this.key = key;
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Subscribe)) return false;
            Subscribe subscribe = (Subscribe)object;
            Key<A> key = this.key();
            Key<A> key2 = subscribe.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            ActorRef actorRef = this.subscriber();
            ActorRef actorRef2 = subscribe.subscriber();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Subscribe;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Subscribe";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Key<A> key() {
            return this.key;
        }

        public ActorRef subscriber() {
            return this.subscriber;
        }

        public <A extends ReplicatedData> Subscribe<A> copy(Key<A> key, ActorRef subscriber) {
            return new Subscribe<A>(key, subscriber);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> ActorRef copy$default$2() {
            return this.subscriber();
        }

        public Key<A> _1() {
            return this.key();
        }

        public ActorRef _2() {
            return this.subscriber();
        }
    }

    public static interface SubscribeResponse<A extends ReplicatedData>
    extends NoSerializationVerificationNeeded {
        public Key<A> key();
    }

    public static final class Unsubscribe<A extends ReplicatedData>
    implements ReplicatorMessage,
    Product {
        private final Key key;
        private final ActorRef subscriber;

        public static <A extends ReplicatedData> Unsubscribe<A> apply(Key<A> key, ActorRef actorRef) {
            return Replicator$Unsubscribe$.MODULE$.apply(key, actorRef);
        }

        public static Unsubscribe<?> fromProduct(Product product) {
            return Replicator$Unsubscribe$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> Unsubscribe<A> unapply(Unsubscribe<A> unsubscribe) {
            return Replicator$Unsubscribe$.MODULE$.unapply(unsubscribe);
        }

        public Unsubscribe(Key<A> key, ActorRef subscriber) {
            this.key = key;
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unsubscribe)) return false;
            Unsubscribe unsubscribe = (Unsubscribe)object;
            Key<A> key = this.key();
            Key<A> key2 = unsubscribe.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            ActorRef actorRef = this.subscriber();
            ActorRef actorRef2 = unsubscribe.subscriber();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Unsubscribe;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Unsubscribe";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Key<A> key() {
            return this.key;
        }

        public ActorRef subscriber() {
            return this.subscriber;
        }

        public <A extends ReplicatedData> Unsubscribe<A> copy(Key<A> key, ActorRef subscriber) {
            return new Unsubscribe<A>(key, subscriber);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> ActorRef copy$default$2() {
            return this.subscriber();
        }

        public Key<A> _1() {
            return this.key();
        }

        public ActorRef _2() {
            return this.subscriber();
        }
    }

    public static final class Update<A extends ReplicatedData>
    implements Command<A>,
    NoSerializationVerificationNeeded,
    Product,
    Serializable {
        private final Key key;
        private final WriteConsistency writeConsistency;
        private final Option request;
        private final Function1 modify;

        public static <A extends ReplicatedData> Update<A> apply(Key<A> key, A a, WriteConsistency writeConsistency, Option<Object> option, Function1<A, A> function1) {
            return Replicator$Update$.MODULE$.apply(key, a, writeConsistency, option, function1);
        }

        public static <A extends ReplicatedData> Update<A> apply(Key<A> key, WriteConsistency writeConsistency, Option<Object> option, Function1<Option<A>, A> function1) {
            return Replicator$Update$.MODULE$.apply(key, writeConsistency, option, function1);
        }

        public static <A extends ReplicatedData> Update<A> unapply(Update<A> update) {
            return Replicator$Update$.MODULE$.unapply(update);
        }

        public static <A extends ReplicatedData> Option<Object> apply$default$4() {
            return Replicator$Update$.MODULE$.apply$default$4();
        }

        public Update(Key<A> key, WriteConsistency writeConsistency, Option<Object> request, Function1<Option<A>, A> modify) {
            this.key = key;
            this.writeConsistency = writeConsistency;
            this.request = request;
            this.modify = modify;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Update)) return false;
            Update update = (Update)object;
            Key<A> key = this.key();
            Key<A> key2 = update.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            WriteConsistency writeConsistency = this.writeConsistency();
            WriteConsistency writeConsistency2 = update.writeConsistency();
            if (writeConsistency == null) {
                if (writeConsistency2 != null) {
                    return false;
                }
            } else if (!writeConsistency.equals(writeConsistency2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = update.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Update;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Update";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "writeConsistency";
                }
                case 2: {
                    return "request";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        public WriteConsistency writeConsistency() {
            return this.writeConsistency;
        }

        public Option<Object> request() {
            return this.request;
        }

        public Function1<Option<A>, A> modify() {
            return this.modify;
        }

        public Update(Key<A> key, A initial, WriteConsistency writeConsistency, Function<A, A> modify) {
            this(key, writeConsistency, (Option<Object>)None$.MODULE$, Replicator$.MODULE$.org$apache$pekko$cluster$ddata$Replicator$$$Update$superArg$1(key, initial, writeConsistency, modify));
        }

        public Update(Key<A> key, A initial, WriteConsistency writeConsistency, Optional<Object> request, Function<A, A> modify) {
            this(key, writeConsistency, (Option<Object>)Option$.MODULE$.apply(request.orElse(null)), Replicator$.MODULE$.org$apache$pekko$cluster$ddata$Replicator$$$Update$superArg$2(key, initial, writeConsistency, request, modify));
        }

        public <A extends ReplicatedData> Update<A> copy(Key<A> key, WriteConsistency writeConsistency, Option<Object> request, Function1<Option<A>, A> modify) {
            return new Update<A>(key, writeConsistency, request, modify);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> WriteConsistency copy$default$2() {
            return this.writeConsistency();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$3() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public WriteConsistency _2() {
            return this.writeConsistency();
        }

        public Option<Object> _3() {
            return this.request();
        }
    }

    public static final class UpdateDataDeleted<A extends ReplicatedData>
    extends UpdateResponse<A>
    implements Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> UpdateDataDeleted<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$UpdateDataDeleted$.MODULE$.apply(key, option);
        }

        public static UpdateDataDeleted<?> fromProduct(Product product) {
            return Replicator$UpdateDataDeleted$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> UpdateDataDeleted<A> unapply(UpdateDataDeleted<A> updateDataDeleted) {
            return Replicator$UpdateDataDeleted$.MODULE$.unapply(updateDataDeleted);
        }

        public UpdateDataDeleted(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpdateDataDeleted)) return false;
            UpdateDataDeleted updateDataDeleted = (UpdateDataDeleted)object;
            Key<A> key = this.key();
            Key<A> key2 = updateDataDeleted.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = updateDataDeleted.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UpdateDataDeleted;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UpdateDataDeleted";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> UpdateDataDeleted<A> copy(Key<A> key, Option<Object> request) {
            return new UpdateDataDeleted<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static abstract class UpdateFailure<A extends ReplicatedData>
    extends UpdateResponse<A> {
    }

    public static abstract class UpdateResponse<A extends ReplicatedData>
    implements NoSerializationVerificationNeeded {
        public abstract Key<A> key();

        public abstract Option<Object> request();

        public Optional<Object> getRequest() {
            return Optional.ofNullable(this.request().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }
    }

    public static final class UpdateSuccess<A extends ReplicatedData>
    extends UpdateResponse<A>
    implements DeadLetterSuppression,
    Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> UpdateSuccess<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$UpdateSuccess$.MODULE$.apply(key, option);
        }

        public static UpdateSuccess<?> fromProduct(Product product) {
            return Replicator$UpdateSuccess$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> UpdateSuccess<A> unapply(UpdateSuccess<A> updateSuccess) {
            return Replicator$UpdateSuccess$.MODULE$.unapply(updateSuccess);
        }

        public UpdateSuccess(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpdateSuccess)) return false;
            UpdateSuccess updateSuccess = (UpdateSuccess)object;
            Key<A> key = this.key();
            Key<A> key2 = updateSuccess.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = updateSuccess.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UpdateSuccess;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UpdateSuccess";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> UpdateSuccess<A> copy(Key<A> key, Option<Object> request) {
            return new UpdateSuccess<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class UpdateTimeout<A extends ReplicatedData>
    extends UpdateFailure<A>
    implements Product,
    Serializable {
        private final Key key;
        private final Option request;

        public static <A extends ReplicatedData> UpdateTimeout<A> apply(Key<A> key, Option<Object> option) {
            return Replicator$UpdateTimeout$.MODULE$.apply(key, option);
        }

        public static UpdateTimeout<?> fromProduct(Product product) {
            return Replicator$UpdateTimeout$.MODULE$.fromProduct(product);
        }

        public static <A extends ReplicatedData> UpdateTimeout<A> unapply(UpdateTimeout<A> updateTimeout) {
            return Replicator$UpdateTimeout$.MODULE$.unapply(updateTimeout);
        }

        public UpdateTimeout(Key<A> key, Option<Object> request) {
            this.key = key;
            this.request = request;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof UpdateTimeout)) return false;
            UpdateTimeout updateTimeout = (UpdateTimeout)object;
            Key<A> key = this.key();
            Key<A> key2 = updateTimeout.key();
            if (key == null) {
                if (key2 != null) {
                    return false;
                }
            } else if (!((Object)key).equals(key2)) return false;
            Option<Object> option = this.request();
            Option<Object> option2 = updateTimeout.request();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof UpdateTimeout;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "UpdateTimeout";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "key";
            }
            if (1 == n2) {
                return "request";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Key<A> key() {
            return this.key;
        }

        @Override
        public Option<Object> request() {
            return this.request;
        }

        public <A extends ReplicatedData> UpdateTimeout<A> copy(Key<A> key, Option<Object> request) {
            return new UpdateTimeout<A>(key, request);
        }

        public <A extends ReplicatedData> Key<A> copy$default$1() {
            return this.key();
        }

        public <A extends ReplicatedData> Option<Object> copy$default$2() {
            return this.request();
        }

        public Key<A> _1() {
            return this.key();
        }

        public Option<Object> _2() {
            return this.request();
        }
    }

    public static final class WriteAll
    implements WriteConsistency,
    Product,
    Serializable {
        private final FiniteDuration timeout;

        public static WriteAll apply(FiniteDuration finiteDuration) {
            return Replicator$WriteAll$.MODULE$.apply(finiteDuration);
        }

        public static WriteAll fromProduct(Product product) {
            return Replicator$WriteAll$.MODULE$.fromProduct(product);
        }

        public static WriteAll unapply(WriteAll writeAll) {
            return Replicator$WriteAll$.MODULE$.unapply(writeAll);
        }

        public WriteAll(FiniteDuration timeout) {
            this.timeout = timeout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteAll)) return false;
            WriteAll writeAll = (WriteAll)object;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = writeAll.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteAll;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "WriteAll";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public WriteAll(Duration timeout) {
            this(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
        }

        public WriteAll copy(FiniteDuration timeout) {
            return new WriteAll(timeout);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }
    }

    public static interface WriteConsistency {
        public FiniteDuration timeout();
    }

    public static final class WriteMajority
    implements WriteConsistency,
    Product,
    Serializable {
        private final FiniteDuration timeout;
        private final int minCap;

        public static WriteMajority apply(FiniteDuration finiteDuration, int n) {
            return Replicator$WriteMajority$.MODULE$.apply(finiteDuration, n);
        }

        public static WriteMajority fromProduct(Product product) {
            return Replicator$WriteMajority$.MODULE$.fromProduct(product);
        }

        public static WriteMajority unapply(WriteMajority writeMajority) {
            return Replicator$WriteMajority$.MODULE$.unapply(writeMajority);
        }

        public static int $lessinit$greater$default$2() {
            return Replicator$WriteMajority$.MODULE$.$lessinit$greater$default$2();
        }

        public WriteMajority(FiniteDuration timeout, int minCap) {
            this.timeout = timeout;
            this.minCap = minCap;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            n = Statics.mix((int)n, (int)this.minCap());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteMajority)) return false;
            WriteMajority writeMajority = (WriteMajority)object;
            if (this.minCap() != writeMajority.minCap()) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = writeMajority.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteMajority;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WriteMajority";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger((int)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeout";
            }
            if (1 == n2) {
                return "minCap";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public int minCap() {
            return this.minCap;
        }

        public WriteMajority(FiniteDuration timeout) {
            this(timeout, Replicator$.MODULE$.DefaultMajorityMinCap());
        }

        public WriteMajority(Duration timeout) {
            this(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)), Replicator$.MODULE$.DefaultMajorityMinCap());
        }

        public WriteMajority copy(FiniteDuration timeout, int minCap) {
            return new WriteMajority(timeout, minCap);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public int copy$default$2() {
            return this.minCap();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }

        public int _2() {
            return this.minCap();
        }
    }

    public static final class WriteMajorityPlus
    implements WriteConsistency,
    Product,
    Serializable {
        private final FiniteDuration timeout;
        private final int additional;
        private final int minCap;

        public static WriteMajorityPlus apply(FiniteDuration finiteDuration, int n, int n2) {
            return Replicator$WriteMajorityPlus$.MODULE$.apply(finiteDuration, n, n2);
        }

        public static WriteMajorityPlus fromProduct(Product product) {
            return Replicator$WriteMajorityPlus$.MODULE$.fromProduct(product);
        }

        public static WriteMajorityPlus unapply(WriteMajorityPlus writeMajorityPlus) {
            return Replicator$WriteMajorityPlus$.MODULE$.unapply(writeMajorityPlus);
        }

        public static int $lessinit$greater$default$3() {
            return Replicator$WriteMajorityPlus$.MODULE$.$lessinit$greater$default$3();
        }

        public WriteMajorityPlus(FiniteDuration timeout, int additional, int minCap) {
            this.timeout = timeout;
            this.additional = additional;
            this.minCap = minCap;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            n = Statics.mix((int)n, (int)this.additional());
            n = Statics.mix((int)n, (int)this.minCap());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteMajorityPlus)) return false;
            WriteMajorityPlus writeMajorityPlus = (WriteMajorityPlus)object;
            if (this.additional() != writeMajorityPlus.additional()) return false;
            if (this.minCap() != writeMajorityPlus.minCap()) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = writeMajorityPlus.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteMajorityPlus;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "WriteMajorityPlus";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "timeout";
                }
                case 1: {
                    return "additional";
                }
                case 2: {
                    return "minCap";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public int additional() {
            return this.additional;
        }

        public int minCap() {
            return this.minCap;
        }

        public WriteMajorityPlus(Duration timeout, int additional) {
            this(JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)), additional, Replicator$.MODULE$.DefaultMajorityMinCap());
        }

        public WriteMajorityPlus copy(FiniteDuration timeout, int additional, int minCap) {
            return new WriteMajorityPlus(timeout, additional, minCap);
        }

        public FiniteDuration copy$default$1() {
            return this.timeout();
        }

        public int copy$default$2() {
            return this.additional();
        }

        public int copy$default$3() {
            return this.minCap();
        }

        public FiniteDuration _1() {
            return this.timeout();
        }

        public int _2() {
            return this.additional();
        }

        public int _3() {
            return this.minCap();
        }
    }

    public static final class WriteTo
    implements WriteConsistency,
    Product,
    Serializable {
        private final int n;
        private final FiniteDuration timeout;

        public static WriteTo apply(int n, FiniteDuration finiteDuration) {
            return Replicator$WriteTo$.MODULE$.apply(n, finiteDuration);
        }

        public static WriteTo fromProduct(Product product) {
            return Replicator$WriteTo$.MODULE$.fromProduct(product);
        }

        public static WriteTo unapply(WriteTo writeTo) {
            return Replicator$WriteTo$.MODULE$.unapply(writeTo);
        }

        public WriteTo(int n, FiniteDuration timeout) {
            this.n = n;
            this.timeout = timeout;
            Predef$.MODULE$.require(n >= 2, this::$init$$$anonfun$5);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.n());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.timeout()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WriteTo)) return false;
            WriteTo writeTo = (WriteTo)object;
            if (this.n() != writeTo.n()) return false;
            FiniteDuration finiteDuration = this.timeout();
            FiniteDuration finiteDuration2 = writeTo.timeout();
            if (finiteDuration != null) {
                if (!finiteDuration.equals(finiteDuration2)) return false;
                return true;
            }
            if (finiteDuration2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof WriteTo;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "WriteTo";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToInteger((int)this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "n";
            }
            if (1 == n2) {
                return "timeout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int n() {
            return this.n;
        }

        @Override
        public FiniteDuration timeout() {
            return this.timeout;
        }

        public WriteTo(int n, Duration timeout) {
            this(n, JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
        }

        public WriteTo copy(int n, FiniteDuration timeout) {
            return new WriteTo(n, timeout);
        }

        public int copy$default$1() {
            return this.n();
        }

        public FiniteDuration copy$default$2() {
            return this.timeout();
        }

        public int _1() {
            return this.n();
        }

        public FiniteDuration _2() {
            return this.timeout();
        }

        private final Object $init$$$anonfun$5() {
            return "WriteTo n must be >= 2, use WriteLocal for n=1";
        }
    }
}

