/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import com.typesafe.config.Config;
import java.util.Set;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Props$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.ddata.ReplicatorSettings$;
import org.apache.pekko.util.ccompat.package;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;

public final class ReplicatorSettings {
    private final scala.collection.immutable.Set roles;
    private final FiniteDuration gossipInterval;
    private final FiniteDuration notifySubscribersInterval;
    private final int maxDeltaElements;
    private final String dispatcher;
    private final FiniteDuration pruningInterval;
    private final FiniteDuration maxPruningDissemination;
    private final Either durableStoreProps;
    private final scala.collection.immutable.Set durableKeys;
    private final FiniteDuration pruningMarkerTimeToLive;
    private final FiniteDuration durablePruningMarkerTimeToLive;
    private final boolean deltaCrdtEnabled;
    private final int maxDeltaSize;
    private final boolean preferOldest;
    private final Option logDataSizeExceeding;

    public static ReplicatorSettings apply(ActorSystem actorSystem) {
        return ReplicatorSettings$.MODULE$.apply(actorSystem);
    }

    public static ReplicatorSettings apply(Config config) {
        return ReplicatorSettings$.MODULE$.apply(config);
    }

    @InternalApi
    public static String name(ActorSystem actorSystem, Option<String> option) {
        return ReplicatorSettings$.MODULE$.name(actorSystem, option);
    }

    @InternalApi
    public static Option<String> roleOption(String string) {
        return ReplicatorSettings$.MODULE$.roleOption(string);
    }

    public ReplicatorSettings(scala.collection.immutable.Set<String> roles, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys, FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive, boolean deltaCrdtEnabled, int maxDeltaSize, boolean preferOldest, Option<Object> logDataSizeExceeding) {
        this.roles = roles;
        this.gossipInterval = gossipInterval;
        this.notifySubscribersInterval = notifySubscribersInterval;
        this.maxDeltaElements = maxDeltaElements;
        this.dispatcher = dispatcher;
        this.pruningInterval = pruningInterval;
        this.maxPruningDissemination = maxPruningDissemination;
        this.durableStoreProps = durableStoreProps;
        this.durableKeys = durableKeys;
        this.pruningMarkerTimeToLive = pruningMarkerTimeToLive;
        this.durablePruningMarkerTimeToLive = durablePruningMarkerTimeToLive;
        this.deltaCrdtEnabled = deltaCrdtEnabled;
        this.maxDeltaSize = maxDeltaSize;
        this.preferOldest = preferOldest;
        this.logDataSizeExceeding = logDataSizeExceeding;
    }

    public scala.collection.immutable.Set<String> roles() {
        return this.roles;
    }

    public FiniteDuration gossipInterval() {
        return this.gossipInterval;
    }

    public FiniteDuration notifySubscribersInterval() {
        return this.notifySubscribersInterval;
    }

    public int maxDeltaElements() {
        return this.maxDeltaElements;
    }

    public String dispatcher() {
        return this.dispatcher;
    }

    public FiniteDuration pruningInterval() {
        return this.pruningInterval;
    }

    public FiniteDuration maxPruningDissemination() {
        return this.maxPruningDissemination;
    }

    public Either<Tuple2<String, Config>, Props> durableStoreProps() {
        return this.durableStoreProps;
    }

    public scala.collection.immutable.Set<String> durableKeys() {
        return this.durableKeys;
    }

    public FiniteDuration pruningMarkerTimeToLive() {
        return this.pruningMarkerTimeToLive;
    }

    public FiniteDuration durablePruningMarkerTimeToLive() {
        return this.durablePruningMarkerTimeToLive;
    }

    public boolean deltaCrdtEnabled() {
        return this.deltaCrdtEnabled;
    }

    public int maxDeltaSize() {
        return this.maxDeltaSize;
    }

    public boolean preferOldest() {
        return this.preferOldest;
    }

    public Option<Object> logDataSizeExceeding() {
        return this.logDataSizeExceeding;
    }

    public ReplicatorSettings(scala.collection.immutable.Set<String> roles, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys, FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive, boolean deltaCrdtEnabled, int maxDeltaSize, boolean preferOldest) {
        this(roles, gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, durableStoreProps, durableKeys, pruningMarkerTimeToLive, durablePruningMarkerTimeToLive, deltaCrdtEnabled, maxDeltaSize, preferOldest, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10240)));
    }

    public ReplicatorSettings(scala.collection.immutable.Set<String> roles, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys, FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive, boolean deltaCrdtEnabled, int maxDeltaSize) {
        this(roles, gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, durableStoreProps, durableKeys, pruningMarkerTimeToLive, durablePruningMarkerTimeToLive, deltaCrdtEnabled, maxDeltaSize, false);
    }

    public ReplicatorSettings(Option<String> role, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys, FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive, boolean deltaCrdtEnabled, int maxDeltaSize) {
        this((scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(role).toSet(), gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, durableStoreProps, durableKeys, pruningMarkerTimeToLive, durablePruningMarkerTimeToLive, deltaCrdtEnabled, maxDeltaSize);
    }

    public ReplicatorSettings(Option<String> role, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination) {
        this((scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(role).toSet(), gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, (Either<Tuple2<String, Config>, Props>)package$.MODULE$.Right().apply((Object)Props$.MODULE$.empty()), (scala.collection.immutable.Set<String>)Predef$.MODULE$.Set().empty(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(6)).hours(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).days(), true, 200);
    }

    public ReplicatorSettings(Option<String> role, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys) {
        this(role, gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, durableStoreProps, durableKeys, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(6)).hours(), new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).days(), true, 200);
    }

    public ReplicatorSettings(Option<String> role, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys, FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive, boolean deltaCrdtEnabled) {
        this(role, gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, durableStoreProps, durableKeys, pruningMarkerTimeToLive, durablePruningMarkerTimeToLive, deltaCrdtEnabled, 200);
    }

    public ReplicatorSettings withRole(String role) {
        return this.copy((scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(ReplicatorSettings$.MODULE$.roleOption(role)).toSet(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withRole(Option<String> role) {
        return this.copy((scala.collection.immutable.Set<String>)Option$.MODULE$.option2Iterable(role).toSet(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withRoles(Seq<String> roles) {
        return this.copy((scala.collection.immutable.Set<String>)roles.toSet(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withRoles(String ... roles) {
        return this.withRoles((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])roles));
    }

    @InternalApi
    public ReplicatorSettings withRoles(scala.collection.immutable.Set<String> roles) {
        return this.copy(roles, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public Option<String> role() {
        return this.roles().headOption();
    }

    public ReplicatorSettings withGossipInterval(FiniteDuration gossipInterval) {
        return this.copy(this.copy$default$1(), gossipInterval, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withNotifySubscribersInterval(FiniteDuration notifySubscribersInterval) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), notifySubscribersInterval, this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withMaxDeltaElements(int maxDeltaElements) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), maxDeltaElements, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withDispatcher(String dispatcher) {
        String id;
        String string = dispatcher;
        String d = "".equals(string) ? "pekko.actor.internal-dispatcher" : (id = string);
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), d, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withPruning(FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), pruningInterval, maxPruningDissemination, this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withPruningMarkerTimeToLive(FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), pruningMarkerTimeToLive, durablePruningMarkerTimeToLive, this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withDurableStoreProps(Props durableStoreProps) {
        Right right = package$.MODULE$.Right().apply((Object)durableStoreProps);
        scala.collection.immutable.Set<String> set = this.copy$default$1();
        FiniteDuration finiteDuration = this.copy$default$2();
        FiniteDuration finiteDuration2 = this.copy$default$3();
        int n = this.copy$default$4();
        String string = this.copy$default$5();
        FiniteDuration finiteDuration3 = this.copy$default$6();
        FiniteDuration finiteDuration4 = this.copy$default$7();
        scala.collection.immutable.Set<String> set2 = this.copy$default$9();
        FiniteDuration finiteDuration5 = this.copy$default$10();
        FiniteDuration finiteDuration6 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        int n2 = this.copy$default$13();
        boolean bl2 = this.copy$default$14();
        Option<Object> option = this.copy$default$15();
        return this.copy(set, finiteDuration, finiteDuration2, n, string, finiteDuration3, finiteDuration4, (Either<Tuple2<String, Config>, Props>)right, set2, finiteDuration5, finiteDuration6, bl, n2, bl2, option);
    }

    public ReplicatorSettings withDurableKeys(scala.collection.immutable.Set<String> durableKeys) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), durableKeys, this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withDurableKeys(Set<String> durableKeys) {
        return this.withDurableKeys((scala.collection.immutable.Set<String>)package.JavaConverters$.MODULE$.SetHasAsScala(durableKeys).asScala().toSet());
    }

    public ReplicatorSettings withDeltaCrdtEnabled(boolean deltaCrdtEnabled) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), deltaCrdtEnabled, this.copy$default$13(), this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withMaxDeltaSize(int maxDeltaSize) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), maxDeltaSize, this.copy$default$14(), this.copy$default$15());
    }

    public ReplicatorSettings withPreferOldest(boolean preferOldest) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), preferOldest, this.copy$default$15());
    }

    public ReplicatorSettings withLogDataSizeExceeding(int logDataSizeExceeding) {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)logDataSizeExceeding));
        scala.collection.immutable.Set<String> set = this.copy$default$1();
        FiniteDuration finiteDuration = this.copy$default$2();
        FiniteDuration finiteDuration2 = this.copy$default$3();
        int n = this.copy$default$4();
        String string = this.copy$default$5();
        FiniteDuration finiteDuration3 = this.copy$default$6();
        FiniteDuration finiteDuration4 = this.copy$default$7();
        Either<Tuple2<String, Config>, Props> either = this.copy$default$8();
        scala.collection.immutable.Set<String> set2 = this.copy$default$9();
        FiniteDuration finiteDuration5 = this.copy$default$10();
        FiniteDuration finiteDuration6 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        int n2 = this.copy$default$13();
        boolean bl2 = this.copy$default$14();
        return this.copy(set, finiteDuration, finiteDuration2, n, string, finiteDuration3, finiteDuration4, either, set2, finiteDuration5, finiteDuration6, bl, n2, bl2, (Option<Object>)some);
    }

    private ReplicatorSettings copy(scala.collection.immutable.Set<String> roles, FiniteDuration gossipInterval, FiniteDuration notifySubscribersInterval, int maxDeltaElements, String dispatcher, FiniteDuration pruningInterval, FiniteDuration maxPruningDissemination, Either<Tuple2<String, Config>, Props> durableStoreProps, scala.collection.immutable.Set<String> durableKeys, FiniteDuration pruningMarkerTimeToLive, FiniteDuration durablePruningMarkerTimeToLive, boolean deltaCrdtEnabled, int maxDeltaSize, boolean preferOldest, Option<Object> logDataSizeExceeding) {
        return new ReplicatorSettings(roles, gossipInterval, notifySubscribersInterval, maxDeltaElements, dispatcher, pruningInterval, maxPruningDissemination, durableStoreProps, durableKeys, pruningMarkerTimeToLive, durablePruningMarkerTimeToLive, deltaCrdtEnabled, maxDeltaSize, preferOldest, logDataSizeExceeding);
    }

    private scala.collection.immutable.Set<String> copy$default$1() {
        return this.roles();
    }

    private FiniteDuration copy$default$2() {
        return this.gossipInterval();
    }

    private FiniteDuration copy$default$3() {
        return this.notifySubscribersInterval();
    }

    private int copy$default$4() {
        return this.maxDeltaElements();
    }

    private String copy$default$5() {
        return this.dispatcher();
    }

    private FiniteDuration copy$default$6() {
        return this.pruningInterval();
    }

    private FiniteDuration copy$default$7() {
        return this.maxPruningDissemination();
    }

    private Either<Tuple2<String, Config>, Props> copy$default$8() {
        return this.durableStoreProps();
    }

    private scala.collection.immutable.Set<String> copy$default$9() {
        return this.durableKeys();
    }

    private FiniteDuration copy$default$10() {
        return this.pruningMarkerTimeToLive();
    }

    private FiniteDuration copy$default$11() {
        return this.durablePruningMarkerTimeToLive();
    }

    private boolean copy$default$12() {
        return this.deltaCrdtEnabled();
    }

    private int copy$default$13() {
        return this.maxDeltaSize();
    }

    private boolean copy$default$14() {
        return this.preferOldest();
    }

    private Option<Object> copy$default$15() {
        return this.logDataSizeExceeding();
    }
}

