/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.ReceiveTimeout$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.Key;
import org.apache.pekko.cluster.ddata.ReadWriteAggregator;
import org.apache.pekko.cluster.ddata.ReadWriteAggregator$;
import org.apache.pekko.cluster.ddata.ReadWriteAggregator$SendToSecondary$;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.Replicator;
import org.apache.pekko.cluster.ddata.Replicator$DeleteSuccess$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeletedData$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeltaNack$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeltaPropagation$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$Write$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$WriteAck$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$WriteNack$;
import org.apache.pekko.cluster.ddata.Replicator$ReplicationDeleteFailure$;
import org.apache.pekko.cluster.ddata.Replicator$StoreFailure$;
import org.apache.pekko.cluster.ddata.Replicator$UpdateSuccess$;
import org.apache.pekko.cluster.ddata.Replicator$UpdateTimeout$;
import org.apache.pekko.cluster.ddata.Replicator$WriteLocal$;
import org.apache.pekko.cluster.ddata.Replicator$WriteMajority$;
import org.apache.pekko.cluster.ddata.Replicator$WriteMajorityPlus$;
import org.apache.pekko.cluster.ddata.Replicator$WriteTo$;
import org.apache.pekko.cluster.ddata.WriteAggregator$;
import org.apache.pekko.event.LoggingAdapter;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

@InternalApi
public class WriteAggregator
extends ReadWriteAggregator
implements ActorLogging {
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final Key<ReplicatedData> key;
    private final Replicator.Internal.DataEnvelope envelope;
    private final Replicator.WriteConsistency consistency;
    private final Option<Object> req;
    public final UniqueAddress org$apache$pekko$cluster$ddata$WriteAggregator$$selfUniqueAddress;
    private final Vector nodes;
    private final Set unreachable;
    private final boolean shuffle;
    private final ActorRef replyTo;
    private final boolean durable;
    private final int doneWhenRemainingSize;
    private final Replicator.Internal.Write writeMsg;
    private final Option deltaMsg;
    private boolean gotLocalStoreReply;
    private Set gotWriteNackFrom;
    public final Vector<UniqueAddress> org$apache$pekko$cluster$ddata$WriteAggregator$$primaryNodes;
    public final Vector<UniqueAddress> org$apache$pekko$cluster$ddata$WriteAggregator$$secondaryNodes;

    public static Props props(Key<ReplicatedData> key, Replicator.Internal.DataEnvelope dataEnvelope, Option<Replicator.Internal.Delta> option, Replicator.WriteConsistency writeConsistency, Option<Object> option2, UniqueAddress uniqueAddress, Vector<UniqueAddress> vector, Set<UniqueAddress> set, boolean bl, ActorRef actorRef, boolean bl2) {
        return WriteAggregator$.MODULE$.props(key, dataEnvelope, option, writeConsistency, option2, uniqueAddress, vector, set, bl, actorRef, bl2);
    }

    public WriteAggregator(Key<ReplicatedData> key, Replicator.Internal.DataEnvelope envelope, Option<Replicator.Internal.Delta> delta, Replicator.WriteConsistency consistency, Option<Object> req, UniqueAddress selfUniqueAddress, Vector<UniqueAddress> nodes, Set<UniqueAddress> unreachable, boolean shuffle, ActorRef replyTo, boolean durable) {
        None$ none$;
        int n;
        this.key = key;
        this.envelope = envelope;
        this.consistency = consistency;
        this.req = req;
        this.org$apache$pekko$cluster$ddata$WriteAggregator$$selfUniqueAddress = selfUniqueAddress;
        this.nodes = nodes;
        this.unreachable = unreachable;
        this.shuffle = shuffle;
        this.replyTo = replyTo;
        this.durable = durable;
        ActorLogging.$init$((ActorLogging)this);
        Replicator.WriteConsistency writeConsistency = consistency;
        if (writeConsistency instanceof Replicator.WriteTo) {
            Replicator.WriteTo writeTo = Replicator$WriteTo$.MODULE$.unapply((Replicator.WriteTo)writeConsistency);
            int n2 = writeTo._1();
            FiniteDuration finiteDuration = writeTo._2();
            int n3 = n2;
            n = nodes.size() - (n3 - 1);
        } else if (writeConsistency instanceof Replicator.WriteAll) {
            n = 0;
        } else if (writeConsistency instanceof Replicator.WriteMajority) {
            int n4;
            Replicator.WriteMajority writeMajority = Replicator$WriteMajority$.MODULE$.unapply((Replicator.WriteMajority)writeConsistency);
            FiniteDuration finiteDuration = writeMajority._1();
            int minCap = n4 = writeMajority._2();
            int N = nodes.size() + 1;
            int w = ReadWriteAggregator$.MODULE$.calculateMajority(minCap, N, 0);
            this.log().debug("WriteMajority [{}] [{}] of [{}].", key, (Object)BoxesRunTime.boxToInteger((int)w), (Object)BoxesRunTime.boxToInteger((int)N));
            n = N - w;
        } else if (writeConsistency instanceof Replicator.WriteMajorityPlus) {
            Replicator.WriteMajorityPlus writeMajorityPlus = Replicator$WriteMajorityPlus$.MODULE$.unapply((Replicator.WriteMajorityPlus)writeConsistency);
            FiniteDuration finiteDuration = writeMajorityPlus._1();
            int n5 = writeMajorityPlus._2();
            int n6 = writeMajorityPlus._3();
            int additional = n5;
            int minCap = n6;
            int N = nodes.size() + 1;
            int w = ReadWriteAggregator$.MODULE$.calculateMajority(minCap, N, additional);
            this.log().debug("WriteMajorityPlus [{}] [{}] of [{}].", key, (Object)BoxesRunTime.boxToInteger((int)w), (Object)BoxesRunTime.boxToInteger((int)N));
            n = N - w;
        } else {
            if (Replicator$WriteLocal$.MODULE$.equals(writeConsistency)) {
                throw new IllegalArgumentException("WriteLocal not supported by WriteAggregator");
            }
            throw new MatchError((Object)writeConsistency);
        }
        this.doneWhenRemainingSize = n;
        this.writeMsg = Replicator$Internal$Write$.MODULE$.apply(key.id(), envelope, (Option<UniqueAddress>)Some$.MODULE$.apply((Object)selfUniqueAddress));
        Option<Replicator.Internal.Delta> option = delta;
        if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else if (option instanceof Some) {
            Replicator.Internal.Delta d = (Replicator.Internal.Delta)((Some)option).value();
            Object[] objectArray = new Tuple2[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key.id());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)d);
            none$ = Some$.MODULE$.apply((Object)Replicator$Internal$DeltaPropagation$.MODULE$.apply(selfUniqueAddress, true, (Map<String, Replicator.Internal.Delta>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))));
        } else {
            throw new MatchError(option);
        }
        this.deltaMsg = none$;
        this.gotLocalStoreReply = !durable;
        this.gotWriteNackFrom = Predef$.MODULE$.Set().empty();
        Tuple2<Vector<UniqueAddress>, Vector<UniqueAddress>> tuple2 = this.primaryAndSecondaryNodes();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector primaryNodes = (Vector)tuple2._1();
        Vector secondaryNodes = (Vector)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)primaryNodes, (Object)secondaryNodes);
        this.org$apache$pekko$cluster$ddata$WriteAggregator$$primaryNodes = (Vector)tuple22._1();
        this.org$apache$pekko$cluster$ddata$WriteAggregator$$secondaryNodes = (Vector)tuple22._2();
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public Vector<UniqueAddress> nodes() {
        return this.nodes;
    }

    @Override
    public Set<UniqueAddress> unreachable() {
        return this.unreachable;
    }

    @Override
    public boolean shuffle() {
        return this.shuffle;
    }

    @Override
    public FiniteDuration timeout() {
        return this.consistency.timeout();
    }

    @Override
    public int doneWhenRemainingSize() {
        return this.doneWhenRemainingSize;
    }

    public Replicator.Internal.Write writeMsg() {
        return this.writeMsg;
    }

    public Option<Replicator.Internal.DeltaPropagation> deltaMsg() {
        return this.deltaMsg;
    }

    public boolean gotLocalStoreReply() {
        return this.gotLocalStoreReply;
    }

    public void gotLocalStoreReply_$eq(boolean x$1) {
        this.gotLocalStoreReply = x$1;
    }

    public Set<Address> gotWriteNackFrom() {
        return this.gotWriteNackFrom;
    }

    public void gotWriteNackFrom_$eq(Set<Address> x$1) {
        this.gotWriteNackFrom = x$1;
    }

    @Override
    public void preStart() {
        Replicator.Internal.SendingSystemUid sendingSystemUid;
        Option<Replicator.Internal.DeltaPropagation> option = this.deltaMsg();
        if (option instanceof Some) {
            Replicator.Internal.DeltaPropagation d;
            sendingSystemUid = d = (Replicator.Internal.DeltaPropagation)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            sendingSystemUid = this.writeMsg();
        } else {
            throw new MatchError(option);
        }
        Replicator.Internal.SendingSystemUid msg = sendingSystemUid;
        this.org$apache$pekko$cluster$ddata$WriteAggregator$$primaryNodes.foreach((Function1)(JProcedure1 & Serializable)_$12 -> ActorSelection$.MODULE$.toScala(this.replica((UniqueAddress)_$12)).$bang((Object)msg, this.self()));
        if (this.isDone()) {
            this.reply(false);
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ WriteAggregator $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (Replicator$Internal$WriteAck$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$Internal$WriteNack$.MODULE$.equals(object)) {
                    return true;
                }
                if (Replicator$Internal$DeltaNack$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Replicator.UpdateSuccess) {
                    return true;
                }
                if (object instanceof Replicator.StoreFailure) {
                    return true;
                }
                if (ReadWriteAggregator$SendToSecondary$.MODULE$.equals(object)) {
                    return true;
                }
                return ReceiveTimeout$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (Replicator$Internal$WriteAck$.MODULE$.equals(object)) {
                    this.$outer.remaining_$eq((Set<Address>)((Set)this.$outer.remaining().$minus((Object)this.$outer.senderAddress())));
                    if (this.$outer.isDone()) {
                        this.$outer.reply(false);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (Replicator$Internal$WriteNack$.MODULE$.equals(object)) {
                    this.$outer.gotWriteNackFrom_$eq((Set<Address>)((Set)this.$outer.gotWriteNackFrom().$plus((Object)this.$outer.senderAddress())));
                    if (this.$outer.isDone()) {
                        this.$outer.reply(false);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (Replicator$Internal$DeltaNack$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang((Object)this.$outer.writeMsg(), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Replicator.UpdateSuccess) {
                    this.$outer.gotLocalStoreReply_$eq(true);
                    if (this.$outer.isDone()) {
                        this.$outer.reply(false);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Replicator.StoreFailure) {
                    this.$outer.gotLocalStoreReply_$eq(true);
                    this.$outer.gotWriteNackFrom_$eq((Set<Address>)((Set)this.$outer.gotWriteNackFrom().$plus((Object)this.$outer.org$apache$pekko$cluster$ddata$WriteAggregator$$selfUniqueAddress.address())));
                    if (this.$outer.isDone()) {
                        this.$outer.reply(false);
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ReadWriteAggregator$SendToSecondary$.MODULE$.equals(object)) {
                    if (this.$outer.deltaMsg().isDefined()) {
                        this.$outer.org$apache$pekko$cluster$ddata$WriteAggregator$$primaryNodes.foreach((Function1)(JProcedure1 & Serializable)to -> {
                            if (this.$outer.remaining().apply((Object)to.address())) {
                                ActorSelection$.MODULE$.toScala(this.$outer.replica((UniqueAddress)to)).$bang((Object)this.$outer.writeMsg(), this.$outer.self());
                                return;
                            }
                        });
                    }
                    this.$outer.org$apache$pekko$cluster$ddata$WriteAggregator$$secondaryNodes.foreach((Function1)(JProcedure1 & Serializable)_$13 -> ActorSelection$.MODULE$.toScala(this.$outer.replica((UniqueAddress)_$13)).$bang((Object)this.$outer.writeMsg(), this.$outer.self()));
                    return BoxedUnit.UNIT;
                }
                if (ReceiveTimeout$.MODULE$.equals(object)) {
                    this.$outer.reply(true);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(org.apache.pekko.cluster.UniqueAddress ), applyOrElse$$anonfun$4(org.apache.pekko.cluster.UniqueAddress )}, serializedLambda);
            }
        };
    }

    public Address senderAddress() {
        return this.sender().path().address();
    }

    public boolean isDone() {
        return this.gotLocalStoreReply() && (this.remaining().size() <= this.doneWhenRemainingSize() || this.remaining().diff(this.gotWriteNackFrom()).isEmpty() || this.notEnoughNodes());
    }

    public boolean notEnoughNodes() {
        return this.doneWhenRemainingSize() < 0 || this.nodes().size() < this.doneWhenRemainingSize();
    }

    public void reply(boolean isTimeout) {
        boolean isTimeoutOrNotEnoughNodes;
        ReplicatedData replicatedData = this.envelope.data();
        Replicator$Internal$DeletedData$ replicator$Internal$DeletedData$ = Replicator$Internal$DeletedData$.MODULE$;
        boolean isDelete = !(replicatedData != null ? !replicatedData.equals(replicator$Internal$DeletedData$) : replicator$Internal$DeletedData$ != null);
        boolean isSuccess = this.remaining().size() <= this.doneWhenRemainingSize() && !this.notEnoughNodes();
        boolean bl = isTimeoutOrNotEnoughNodes = isTimeout || this.notEnoughNodes() || this.gotWriteNackFrom().isEmpty();
        NoSerializationVerificationNeeded replyMsg = isSuccess && isDelete ? Replicator$DeleteSuccess$.MODULE$.apply(this.key, this.req) : (isSuccess ? Replicator$UpdateSuccess$.MODULE$.apply(this.key, this.req) : (isTimeoutOrNotEnoughNodes && isDelete ? Replicator$ReplicationDeleteFailure$.MODULE$.apply(this.key, this.req) : (NoSerializationVerificationNeeded)(isTimeoutOrNotEnoughNodes || !this.durable ? Replicator$UpdateTimeout$.MODULE$.apply(this.key, this.req) : Replicator$StoreFailure$.MODULE$.apply(this.key, this.req))));
        this.replyTo.tell(replyMsg, this.context().parent());
        this.context().stop(this.self());
    }
}

