/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata.protobuf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.UniqueAddress$;
import org.apache.pekko.cluster.ddata.VersionVector;
import org.apache.pekko.cluster.ddata.VersionVector$;
import org.apache.pekko.cluster.ddata.protobuf.msg.ReplicatorMessages;
import org.apache.pekko.protobufv3.internal.ByteString;
import org.apache.pekko.protobufv3.internal.MessageLite;
import org.apache.pekko.remote.ByteStringUtils$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;

public interface SerializationSupport {
    public static void $init$(SerializationSupport $this) {
    }

    public static int org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$BufferSize$(SerializationSupport $this) {
        return $this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$BufferSize();
    }

    default public int org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$BufferSize() {
        return 4096;
    }

    public ExtendedActorSystem system();

    public Serialization org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$ser();

    public void org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$ser_$eq(Serialization var1);

    public static Serialization serialization$(SerializationSupport $this) {
        return $this.serialization();
    }

    default public Serialization serialization() {
        if (this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$ser() == null) {
            this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$ser_$eq((Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system()));
        }
        return this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$ser();
    }

    public String org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$protocol();

    public void org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$protocol_$eq(String var1);

    public static String addressProtocol$(SerializationSupport $this) {
        return $this.addressProtocol();
    }

    default public String addressProtocol() {
        if (this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$protocol() == null) {
            this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$protocol_$eq(this.system().provider().getDefaultAddress().protocol());
        }
        return this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$protocol();
    }

    public Serialization.Information org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$transportInfo();

    public void org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$transportInfo_$eq(Serialization.Information var1);

    public static Serialization.Information transportInformation$(SerializationSupport $this) {
        return $this.transportInformation();
    }

    default public Serialization.Information transportInformation() {
        if (this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$transportInfo() == null) {
            Address address = this.system().provider().getDefaultAddress();
            this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$transportInfo_$eq(Serialization.Information$.MODULE$.apply(address, (ActorSystem)this.system()));
        }
        return this.org$apache$pekko$cluster$ddata$protobuf$SerializationSupport$$transportInfo();
    }

    public static byte[] compress$(SerializationSupport $this, MessageLite msg) {
        return $this.compress(msg);
    }

    default public byte[] compress(MessageLite msg) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        try (GZIPOutputStream zip = new GZIPOutputStream(bos);){
            msg.writeTo((OutputStream)zip);
        }
        return bos.toByteArray();
    }

    public static byte[] decompress$(SerializationSupport $this, byte[] bytes) {
        return $this.decompress(bytes);
    }

    default public byte[] decompress(byte[] bytes) {
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(bytes));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            SerializationSupport.readChunk$1(in, out, buffer);
        }
        finally {
            in.close();
        }
        return out.toByteArray();
    }

    public static ReplicatorMessages.Address.Builder addressToProto$(SerializationSupport $this, Address address) {
        return $this.addressToProto(address);
    }

    default public ReplicatorMessages.Address.Builder addressToProto(Address address) {
        Address address2 = address;
        if (address2 != null) {
            Address address3 = Address$.MODULE$.unapply(address2);
            String string = address3._1();
            String string2 = address3._2();
            Option option = address3._3();
            Option option2 = address3._4();
            if (option instanceof Some) {
                String host = (String)((Some)option).value();
                if (option2 instanceof Some) {
                    int port = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return ReplicatorMessages.Address.newBuilder().setHostname(host).setPort(port);
                }
            }
        }
        throw new IllegalArgumentException(new StringBuilder(57).append("Address [").append(address).append("] could not be serialized: host or port missing.").toString());
    }

    public static Address addressFromProto$(SerializationSupport $this, ReplicatorMessages.Address address) {
        return $this.addressFromProto(address);
    }

    default public Address addressFromProto(ReplicatorMessages.Address address) {
        return Address$.MODULE$.apply(this.addressProtocol(), this.system().name(), address.getHostname(), address.getPort());
    }

    public static ReplicatorMessages.UniqueAddress.Builder uniqueAddressToProto$(SerializationSupport $this, UniqueAddress uniqueAddress) {
        return $this.uniqueAddressToProto(uniqueAddress);
    }

    default public ReplicatorMessages.UniqueAddress.Builder uniqueAddressToProto(UniqueAddress uniqueAddress) {
        return ReplicatorMessages.UniqueAddress.newBuilder().setAddress(this.addressToProto(uniqueAddress.address())).setUid((int)uniqueAddress.longUid()).setUid2((int)(uniqueAddress.longUid() >> 32));
    }

    public static UniqueAddress uniqueAddressFromProto$(SerializationSupport $this, ReplicatorMessages.UniqueAddress uniqueAddress) {
        return $this.uniqueAddressFromProto(uniqueAddress);
    }

    default public UniqueAddress uniqueAddressFromProto(ReplicatorMessages.UniqueAddress uniqueAddress) {
        return UniqueAddress$.MODULE$.apply(this.addressFromProto(uniqueAddress.getAddress()), uniqueAddress.hasUid2() ? (long)uniqueAddress.getUid2() << 32 | (long)uniqueAddress.getUid() & 0xFFFFFFFFL : (long)uniqueAddress.getUid());
    }

    public static ReplicatorMessages.VersionVector versionVectorToProto$(SerializationSupport $this, VersionVector versionVector) {
        return $this.versionVectorToProto(versionVector);
    }

    default public ReplicatorMessages.VersionVector versionVectorToProto(VersionVector versionVector) {
        ReplicatorMessages.VersionVector.Builder b = ReplicatorMessages.VersionVector.newBuilder();
        versionVector.versionsIterator().foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress node = (UniqueAddress)tuple2._1();
                long value = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return b.addEntries(ReplicatorMessages.VersionVector.Entry.newBuilder().setNode(this.uniqueAddressToProto(node)).setVersion(value));
            }
            throw new MatchError((Object)tuple2);
        });
        return b.build();
    }

    public static VersionVector versionVectorFromBinary$(SerializationSupport $this, byte[] bytes) {
        return $this.versionVectorFromBinary(bytes);
    }

    default public VersionVector versionVectorFromBinary(byte[] bytes) {
        return this.versionVectorFromProto(ReplicatorMessages.VersionVector.parseFrom(bytes));
    }

    public static VersionVector versionVectorFromProto$(SerializationSupport $this, ReplicatorMessages.VersionVector versionVector) {
        return $this.versionVectorFromProto(versionVector);
    }

    default public VersionVector versionVectorFromProto(ReplicatorMessages.VersionVector versionVector) {
        List<ReplicatorMessages.VersionVector.Entry> entries = versionVector.getEntriesList();
        if (entries.isEmpty()) {
            return VersionVector$.MODULE$.empty();
        }
        if (entries.size() == 1) {
            return VersionVector$.MODULE$.apply(this.uniqueAddressFromProto(entries.get(0).getNode()), entries.get(0).getVersion());
        }
        TreeMap versions = TreeMap$.MODULE$.from((IterableOnce)package.JavaConverters$.MODULE$.ListHasAsScala(versionVector.getEntriesList()).asScala().iterator().map((Function1 & Serializable)entry -> {
            UniqueAddress uniqueAddress = (UniqueAddress)Predef$.MODULE$.ArrowAssoc((Object)this.uniqueAddressFromProto(entry.getNode()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)uniqueAddress, (Object)BoxesRunTime.boxToLong((long)entry.getVersion()));
        }), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        return VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)versions);
    }

    public static ActorRef resolveActorRef$(SerializationSupport $this, String path) {
        return $this.resolveActorRef(path);
    }

    default public ActorRef resolveActorRef(String path) {
        return this.system().provider().resolveActorRef(path);
    }

    public static ReplicatorMessages.OtherMessage otherMessageToProto$(SerializationSupport $this, Object msg) {
        return $this.otherMessageToProto(msg);
    }

    default public ReplicatorMessages.OtherMessage otherMessageToProto(Object msg) {
        ReplicatorMessages.OtherMessage otherMessage;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            otherMessage = this.buildOther$1(msg);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return otherMessage;
    }

    public static Object otherMessageFromBinary$(SerializationSupport $this, byte[] bytes) {
        return $this.otherMessageFromBinary(bytes);
    }

    default public Object otherMessageFromBinary(byte[] bytes) {
        return this.otherMessageFromProto(ReplicatorMessages.OtherMessage.parseFrom(bytes));
    }

    public static Object otherMessageFromProto$(SerializationSupport $this, ReplicatorMessages.OtherMessage other) {
        return $this.otherMessageFromProto(other);
    }

    default public Object otherMessageFromProto(ReplicatorMessages.OtherMessage other) {
        String manifest = other.hasMessageManifest() ? other.getMessageManifest().toStringUtf8() : "";
        return this.serialization().deserialize(other.getEnclosedMessage().toByteArray(), other.getSerializerId(), manifest).get();
    }

    private static void readChunk$1(GZIPInputStream in$1, ByteArrayOutputStream out$1, byte[] buffer$1) {
        int n;
        while (-1 != (n = in$1.read(buffer$1))) {
            int n2 = n;
            out$1.write(buffer$1, 0, n2);
        }
        return;
    }

    private ReplicatorMessages.OtherMessage buildOther$1(Object msg$1) {
        Object m = msg$1;
        Serializer msgSerializer = this.serialization().findSerializerFor(m);
        ReplicatorMessages.OtherMessage.Builder builder = ReplicatorMessages.OtherMessage.newBuilder().setEnclosedMessage(ByteStringUtils$.MODULE$.toProtoByteStringUnsafe(msgSerializer.toBinary(m))).setSerializerId(msgSerializer.identifier());
        String ms = Serializers$.MODULE$.manifestFor(msgSerializer, m);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(ms))) {
            builder.setMessageManifest(ByteString.copyFromUtf8((String)ms));
        }
        return builder.build();
    }
}

