/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.DeltaReplicatedData;
import org.apache.pekko.cluster.ddata.LWWMap$;
import org.apache.pekko.cluster.ddata.LWWRegister;
import org.apache.pekko.cluster.ddata.LWWRegister$;
import org.apache.pekko.cluster.ddata.ORMap;
import org.apache.pekko.cluster.ddata.RemovedNodePruning;
import org.apache.pekko.cluster.ddata.ReplicatedDataSerialization;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.util.ccompat.package;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;

public final class LWWMap<A, B>
implements DeltaReplicatedData,
ReplicatedDataSerialization,
RemovedNodePruning {
    private static final long serialVersionUID = 1L;
    private final ORMap underlying;

    public static LWWMap<Object, Object> apply() {
        return LWWMap$.MODULE$.apply();
    }

    public static <A, B> LWWMap<A, B> create() {
        return LWWMap$.MODULE$.create();
    }

    public static <A, B> LWWMap<A, B> empty() {
        return LWWMap$.MODULE$.empty();
    }

    public static <A, B> Option<Map<A, B>> unapply(LWWMap<A, B> lWWMap) {
        return LWWMap$.MODULE$.unapply(lWWMap);
    }

    public LWWMap(ORMap<A, LWWRegister<B>> underlying) {
        this.underlying = underlying;
    }

    public ORMap<A, LWWRegister<B>> underlying() {
        return this.underlying;
    }

    public Map<A, B> entries() {
        return (Map)this.underlying().entries().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                LWWRegister r = (LWWRegister)tuple2._2();
                Object object = Predef$.MODULE$.ArrowAssoc(k);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, r.value());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public java.util.Map<A, B> getEntries() {
        return package.JavaConverters$.MODULE$.MapHasAsJava(this.entries()).asJava();
    }

    public Option<B> get(A key) {
        return this.underlying().get(key).map((Function1 & Serializable)_$1 -> _$1.value());
    }

    public boolean contains(A key) {
        return this.underlying().contains(key);
    }

    public boolean isEmpty() {
        return this.underlying().isEmpty();
    }

    public int size() {
        return this.underlying().size();
    }

    public LWWMap<A, B> $colon$plus(Tuple2<A, B> entry, SelfUniqueAddress node) {
        Tuple2<A, B> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, value);
        Object key2 = tuple22._1();
        Object value2 = tuple22._2();
        return this.put(node, key2, value2);
    }

    public LWWMap<A, B> $plus(Tuple2<A, B> entry, Cluster node) {
        Tuple2<A, B> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, value);
        Object key2 = tuple22._1();
        Object value2 = tuple22._2();
        return this.put(node, key2, value2);
    }

    public LWWMap<A, B> put(SelfUniqueAddress node, A key, B value) {
        return this.put(node.uniqueAddress(), key, value, LWWRegister$.MODULE$.defaultClock());
    }

    public LWWMap<A, B> put(Cluster node, A key, B value) {
        return this.put(node.selfUniqueAddress(), key, value, LWWRegister$.MODULE$.defaultClock());
    }

    public LWWMap<A, B> put(SelfUniqueAddress node, A key, B value, LWWRegister.Clock<B> clock) {
        return this.put(node.uniqueAddress(), key, value, clock);
    }

    public LWWMap<A, B> put(Cluster node, A key, B value, LWWRegister.Clock<B> clock) {
        return this.put(node.selfUniqueAddress(), key, value, clock);
    }

    public LWWMap<A, B> put(A key, B value, Cluster node, LWWRegister.Clock<B> clock) {
        return this.put(node.selfUniqueAddress(), key, value, clock);
    }

    public LWWRegister.Clock<B> put$default$4(A key, B value) {
        return LWWRegister$.MODULE$.defaultClock();
    }

    @InternalApi
    public LWWMap<A, B> put(UniqueAddress node, A key, B value, LWWRegister.Clock<B> clock) {
        LWWRegister<B> lWWRegister;
        Option<LWWRegister<B>> option = this.underlying().get(key);
        if (option instanceof Some) {
            LWWRegister r = (LWWRegister)((Some)option).value();
            lWWRegister = r.withValue(node, value, clock);
        } else if (None$.MODULE$.equals(option)) {
            lWWRegister = LWWRegister$.MODULE$.apply(node, value, clock);
        } else {
            throw new MatchError(option);
        }
        LWWRegister<B> newRegister = lWWRegister;
        return new LWWMap<A, B>(this.underlying().put(node, key, newRegister));
    }

    public LWWMap<A, B> $minus(A key, Cluster node) {
        return this.remove(node, key);
    }

    public LWWMap<A, B> remove(SelfUniqueAddress node, A key) {
        return this.remove(node.uniqueAddress(), key);
    }

    public LWWMap<A, B> remove(Cluster node, A key) {
        return this.remove(node.selfUniqueAddress(), key);
    }

    @InternalApi
    public LWWMap<A, B> remove(UniqueAddress node, A key) {
        return new LWWMap<A, B>(this.underlying().remove(node, key));
    }

    @Override
    public LWWMap<A, B> resetDelta() {
        return new LWWMap<A, B>(this.underlying().resetDelta());
    }

    public Option<ORMap.DeltaOp> delta() {
        return this.underlying().delta();
    }

    public LWWMap<A, B> mergeDelta(ORMap.DeltaOp thatDelta) {
        return new LWWMap<A, B>(this.underlying().mergeDelta(thatDelta));
    }

    public LWWMap<A, B> merge(LWWMap<A, B> that) {
        return new LWWMap<A, B>(this.underlying().merge(that.underlying()));
    }

    @Override
    public Set<UniqueAddress> modifiedByNodes() {
        return this.underlying().modifiedByNodes();
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        return this.underlying().needPruningFrom(removedNode);
    }

    @Override
    public LWWMap<A, B> prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        return new LWWMap<A, B>(this.underlying().prune(removedNode, collapseInto));
    }

    @Override
    public LWWMap<A, B> pruningCleanup(UniqueAddress removedNode) {
        return new LWWMap<A, B>(this.underlying().pruningCleanup(removedNode));
    }

    public String toString() {
        return new StringBuilder(3).append("LWW").append(this.entries()).toString();
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof LWWMap) {
            LWWMap other = (LWWMap)object;
            ORMap<A, LWWRegister<B>> oRMap = this.underlying();
            ORMap<A, LWWRegister<B>> oRMap2 = other.underlying();
            return !(oRMap != null ? !((Object)oRMap).equals(oRMap2) : oRMap2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.underlying().hashCode();
    }
}

