/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.LWWRegister$;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.ReplicatedDataSerialization;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.util.HashCode$;
import scala.Option;
import scala.runtime.BoxesRunTime;

public final class LWWRegister<A>
implements ReplicatedData,
ReplicatedDataSerialization {
    private static final long serialVersionUID = 1L;
    private final UniqueAddress node;
    private final Object value;
    private final long timestamp;

    public static <A> LWWRegister<A> apply(A a, Cluster cluster, Clock<A> clock) {
        return LWWRegister$.MODULE$.apply(a, cluster, clock);
    }

    public static <A> LWWRegister<A> apply(SelfUniqueAddress selfUniqueAddress, A a) {
        return LWWRegister$.MODULE$.apply(selfUniqueAddress, a);
    }

    public static <A> LWWRegister<A> apply(SelfUniqueAddress selfUniqueAddress, A a, Clock<A> clock) {
        return LWWRegister$.MODULE$.apply(selfUniqueAddress, a, clock);
    }

    @InternalApi
    public static <A> LWWRegister<A> apply(UniqueAddress uniqueAddress, A a, Clock<A> clock) {
        return LWWRegister$.MODULE$.apply(uniqueAddress, a, clock);
    }

    public static <A> LWWRegister<A> create(Cluster cluster, A a) {
        return LWWRegister$.MODULE$.create(cluster, a);
    }

    public static <A> LWWRegister<A> create(Cluster cluster, A a, Clock<A> clock) {
        return LWWRegister$.MODULE$.create(cluster, a, clock);
    }

    public static <A> LWWRegister<A> create(A a, SelfUniqueAddress selfUniqueAddress, Clock<A> clock) {
        return LWWRegister$.MODULE$.create(a, selfUniqueAddress, clock);
    }

    public static <A> LWWRegister<A> create(SelfUniqueAddress selfUniqueAddress, A a) {
        return LWWRegister$.MODULE$.create(selfUniqueAddress, a);
    }

    public static <A> LWWRegister<A> create(SelfUniqueAddress selfUniqueAddress, A a, Clock<A> clock) {
        return LWWRegister$.MODULE$.create(selfUniqueAddress, a, clock);
    }

    public static <A> Clock<A> defaultClock() {
        return LWWRegister$.MODULE$.defaultClock();
    }

    public static <A> Clock<A> reverseClock() {
        return LWWRegister$.MODULE$.reverseClock();
    }

    public static <A> Option<A> unapply(LWWRegister<A> lWWRegister) {
        return LWWRegister$.MODULE$.unapply(lWWRegister);
    }

    public static <A> Clock<A> apply$default$3(A a) {
        return LWWRegister$.MODULE$.apply$default$3(a);
    }

    public static <A> Clock<A> create$default$3(A a) {
        return LWWRegister$.MODULE$.create$default$3(a);
    }

    public LWWRegister(UniqueAddress node, A value, long timestamp) {
        this.node = node;
        this.value = value;
        this.timestamp = timestamp;
    }

    public UniqueAddress node() {
        return this.node;
    }

    public A value() {
        return (A)this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public A getValue() {
        return this.value();
    }

    public LWWRegister<A> withValue(SelfUniqueAddress node, A value, Clock<A> clock) {
        return this.withValue(node.uniqueAddress(), value, clock);
    }

    public LWWRegister<A> withValue(SelfUniqueAddress node, A value) {
        return this.withValue(node, value, LWWRegister$.MODULE$.defaultClock());
    }

    public LWWRegister<A> withValueOf(A value, SelfUniqueAddress node, Clock<A> clock) {
        return this.withValue(node, value, clock);
    }

    public Clock<A> withValueOf$default$3(A value) {
        return LWWRegister$.MODULE$.defaultClock();
    }

    public LWWRegister<A> withValue(A value, Cluster node, Clock<A> clock) {
        return this.withValue(node, value, clock);
    }

    public Clock<A> withValue$default$3(A value) {
        return LWWRegister$.MODULE$.defaultClock();
    }

    public LWWRegister<A> withValue(Cluster node, A value) {
        return this.withValue(node, value, LWWRegister$.MODULE$.defaultClock());
    }

    public LWWRegister<A> withValue(Cluster node, A value, Clock<A> clock) {
        return this.withValue(node.selfUniqueAddress(), value, clock);
    }

    public UniqueAddress updatedBy() {
        return this.node();
    }

    @InternalApi
    public LWWRegister<A> withValue(UniqueAddress node, A value, Clock<A> clock) {
        return new LWWRegister<A>(node, value, clock.apply(this.timestamp(), value));
    }

    public LWWRegister<A> merge(LWWRegister<A> that) {
        if (that.timestamp() > this.timestamp()) {
            return that;
        }
        if (that.timestamp() < this.timestamp()) {
            return this;
        }
        if (that.node().$less((Object)this.node())) {
            return that;
        }
        return this;
    }

    public String toString() {
        return new StringBuilder(13).append("LWWRegister(").append(this.value()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof LWWRegister)) return false;
        LWWRegister other = (LWWRegister)object;
        if (this.timestamp() != other.timestamp()) return false;
        if (!BoxesRunTime.equals(this.value(), other.value())) return false;
        UniqueAddress uniqueAddress = this.node();
        UniqueAddress uniqueAddress2 = other.node();
        if (uniqueAddress != null) {
            if (!uniqueAddress.equals(uniqueAddress2)) return false;
            return true;
        }
        if (uniqueAddress2 == null) return true;
        return false;
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.timestamp());
        result = HashCode$.MODULE$.hash(result, (Object)this.node());
        result = HashCode$.MODULE$.hash(result, this.value());
        return result;
    }

    public static interface Clock<A> {
        public long apply(long var1, A var3);
    }
}

