/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import com.typesafe.config.Config;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.ddata.DurableStore;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAll$;
import org.apache.pekko.cluster.ddata.DurableStore$LoadAllCompleted$;
import org.apache.pekko.cluster.ddata.DurableStore$LoadData$;
import org.apache.pekko.cluster.ddata.DurableStore$Store$;
import org.apache.pekko.cluster.ddata.DurableStore$StoreReply$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$Lmdb$;
import org.apache.pekko.cluster.ddata.LmdbDurableStore$WriteBehind$;
import org.apache.pekko.cluster.ddata.Replicator$Internal$DeletedData$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.DirectByteBufferPool$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.SerializerWithStringManifest;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.ccompat.package;
import org.lmdbjava.CursorIterable;
import org.lmdbjava.Dbi;
import org.lmdbjava.DbiFlags;
import org.lmdbjava.Env;
import org.lmdbjava.EnvFlags;
import org.lmdbjava.PutFlags;
import org.lmdbjava.Txn;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class LmdbDurableStore
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final Config config;
    private final Serialization serialization;
    private final SerializerWithStringManifest serializer;
    private final String manifest;
    private final FiniteDuration writeBehindInterval;
    private final File dir;
    private Lmdb _lmdb;
    private final HashMap pending;

    public static Props props(Config config) {
        return LmdbDurableStore$.MODULE$.props(config);
    }

    public LmdbDurableStore(Config config) {
        File file;
        String string;
        this.config = config;
        Actor.$init$((Actor)this);
        ActorLogging.$init$((ActorLogging)this);
        this.serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context().system());
        this.serializer = (SerializerWithStringManifest)this.serialization().serializerFor(DurableStore.DurableDataEnvelope.class);
        this.manifest = this.serializer().manifest((Object)new DurableStore.DurableDataEnvelope(Replicator$Internal$DeletedData$.MODULE$));
        String string2 = config.getString("lmdb.write-behind-interval").toLowerCase();
        this.writeBehindInterval = "off".equals(string2) ? Duration$.MODULE$.Zero() : new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("lmdb.write-behind-interval", package$.MODULE$.MILLISECONDS()))).millis();
        String path = string = config.getString("lmdb.dir");
        if (path.endsWith("ddata")) {
            file = new File(new StringBuilder(3).append(path).append("-").append(this.context().system().name()).append("-").append(this.self().path().parent().name()).append("-").append(((Cluster)Cluster$.MODULE$.apply(this.context().system())).selfAddress().port().get()).toString());
        } else {
            String path2 = string;
            file = new File(path2);
        }
        this.dir = file;
        OptionVal$.MODULE$.None();
        this._lmdb = null;
        this.pending = new HashMap();
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Serialization serialization() {
        return this.serialization;
    }

    public SerializerWithStringManifest serializer() {
        return this.serializer;
    }

    public String manifest() {
        return this.manifest;
    }

    public FiniteDuration writeBehindInterval() {
        return this.writeBehindInterval;
    }

    public File dir() {
        return this.dir;
    }

    public Lmdb org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb() {
        Lmdb lmdb = this._lmdb;
        Lmdb lmdb2 = (Lmdb)OptionVal.Some$.MODULE$.unapply((Object)lmdb);
        if (!OptionVal$.MODULE$.isEmpty$extension((Object)lmdb2)) {
            Lmdb lmdb3;
            Lmdb l = lmdb3 = (Lmdb)OptionVal$.MODULE$.get$extension((Object)lmdb2);
            return l;
        }
        long t0 = System.nanoTime();
        this.log().info("Using durable data in LMDB directory [{}]", (Object)this.dir().getCanonicalPath());
        Long mapSize = this.config.getBytes("lmdb.map-size");
        this.dir().mkdirs();
        Env env = Env.create().setMapSize(Predef$.MODULE$.Long2long(mapSize)).setMaxDbs(1).open(this.dir(), new EnvFlags[]{EnvFlags.MDB_NOLOCK});
        Dbi db = env.openDbi("ddata", new DbiFlags[]{DbiFlags.MDB_CREATE});
        ByteBuffer keyBuffer = ByteBuffer.allocateDirect(env.getMaxKeySize());
        ByteBuffer valueBuffer = ByteBuffer.allocateDirect(102400);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Init of LMDB in directory [{}] took [{} ms]", (Object)this.dir().getCanonicalPath(), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
        }
        Lmdb l = LmdbDurableStore$Lmdb$.MODULE$.apply((Env<ByteBuffer>)env, (Dbi<ByteBuffer>)db, keyBuffer, valueBuffer);
        this._lmdb = (Lmdb)OptionVal.Some$.MODULE$.apply((Object)l);
        return l;
    }

    public boolean isDbInitialized() {
        Lmdb lmdb = this._lmdb;
        return OptionVal$.MODULE$.isDefined$extension((Object)lmdb);
    }

    public void ensureValueBufferSize(int size) {
        ByteBuffer valueBuffer = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb().valueBuffer();
        if (valueBuffer.remaining() < size) {
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(valueBuffer);
            Lmdb lmdb = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size * 2);
            Env<ByteBuffer> env = lmdb.copy$default$1();
            Dbi<ByteBuffer> dbi = lmdb.copy$default$2();
            ByteBuffer byteBuffer2 = lmdb.copy$default$3();
            this._lmdb = (Lmdb)OptionVal.Some$.MODULE$.apply((Object)lmdb.copy(env, dbi, byteBuffer2, byteBuffer));
            return;
        }
    }

    public HashMap<String, DurableStore.DurableDataEnvelope> pending() {
        return this.pending;
    }

    public void postRestart(Throwable reason) {
        Actor.postRestart$((Actor)this, (Throwable)reason);
        this.context().become(this.active());
    }

    public void postStop() {
        Actor.postStop$((Actor)this);
        this.writeBehind();
        if (this.isDbInitialized()) {
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                LmdbDurableStore.postStop$$anonfun$1(l);
                return BoxedUnit.UNIT;
            });
            Try$.MODULE$.apply((Function0 & Serializable)() -> {
                LmdbDurableStore.postStop$$anonfun$2(l);
                return BoxedUnit.UNIT;
            });
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.keyBuffer());
            DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(l.valueBuffer());
            return;
        }
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return this.init();
    }

    public PartialFunction<Object, BoxedUnit> init() {
        return new Serializable(this){
            private final /* synthetic */ LmdbDurableStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                return DurableStore$LoadAll$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (DurableStore$LoadAll$.MODULE$.equals(object)) {
                    if (this.$outer.dir().exists() && this.$outer.dir().list().length > 0) {
                        BoxedUnit boxedUnit;
                        Lmdb l = this.$outer.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
                        long t0 = System.nanoTime();
                        Txn tx = l.env().txnRead();
                        try {
                            try {
                                CursorIterable iter = l.db().iterate(tx);
                                try {
                                    IntRef n = IntRef.create((int)0);
                                    DurableStore.LoadData loadData = DurableStore$LoadData$.MODULE$.apply((Map<String, DurableStore.DurableDataEnvelope>)((IterableOnceOps)package.JavaConverters$.MODULE$.IterableHasAsScala((Iterable)iter).asScala().map((Function1 & Serializable)entry -> {
                                        int n;
                                        n$1.elem = n = n$1.elem + 1;
                                        byte[] keyArray = new byte[((Buffer)entry.key()).remaining()];
                                        ((ByteBuffer)entry.key()).get(keyArray);
                                        String key = new String(keyArray, ByteString$.MODULE$.UTF_8());
                                        byte[] valArray = new byte[((Buffer)entry.val()).remaining()];
                                        ((ByteBuffer)entry.val()).get(valArray);
                                        DurableStore.DurableDataEnvelope envelope = (DurableStore.DurableDataEnvelope)this.$outer.serializer().fromBinary(valArray, this.$outer.manifest());
                                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)envelope);
                                    })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                                    if (loadData.data().nonEmpty()) {
                                        this.$outer.sender().$bang((Object)loadData, this.$outer.self());
                                    }
                                    this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                                    if (this.$outer.log().isDebugEnabled()) {
                                        this.$outer.log().debug("load all of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)n.elem), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                                    }
                                    this.$outer.context().become(this.$outer.active());
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                finally {
                                    Try$.MODULE$.apply(() -> LmdbDurableStore.org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$1(iter));
                                }
                            }
                            catch (Throwable throwable) {
                                Option option;
                                Throwable throwable2 = throwable;
                                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                                    Throwable throwable3;
                                    Throwable e = throwable3 = (Throwable)option.get();
                                    throw new DurableStore.LoadFailed("failed to load durable distributed-data", e);
                                }
                                throw throwable;
                            }
                        }
                        finally {
                            Try$.MODULE$.apply(() -> LmdbDurableStore.org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$2(tx));
                        }
                        return boxedUnit;
                    }
                    this.$outer.sender().$bang((Object)DurableStore$LoadAllCompleted$.MODULE$, this.$outer.self());
                    this.$outer.context().become(this.$outer.active());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$1(scala.runtime.IntRef org.lmdbjava.CursorIterable$KeyVal ), org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$1(org.lmdbjava.CursorIterable ), org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$1(org.lmdbjava.CursorIterable ), org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$2(org.lmdbjava.Txn ), org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$2(org.lmdbjava.Txn )}, serializedLambda);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> active() {
        return new Serializable(this){
            private final /* synthetic */ LmdbDurableStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof DurableStore.Store) {
                    DurableStore.Store store = DurableStore$Store$.MODULE$.unapply((DurableStore.Store)object);
                    String string = store._1();
                    DurableStore.DurableDataEnvelope durableDataEnvelope = store._2();
                    Option<DurableStore.StoreReply> option = store._3();
                    String key = string;
                    DurableStore.DurableDataEnvelope data = durableDataEnvelope;
                    Option<DurableStore.StoreReply> reply = option;
                    return true;
                }
                return LmdbDurableStore$WriteBehind$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof DurableStore.Store) {
                    BoxedUnit boxedUnit;
                    DurableStore.Store store = DurableStore$Store$.MODULE$.unapply((DurableStore.Store)object);
                    String string = store._1();
                    DurableStore.DurableDataEnvelope durableDataEnvelope = store._2();
                    Option<DurableStore.StoreReply> option = store._3();
                    String key = string;
                    DurableStore.DurableDataEnvelope data = durableDataEnvelope;
                    Option<DurableStore.StoreReply> reply = option;
                    try {
                        DurableStore.StoreReply storeReply;
                        Object object2;
                        this.$outer.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
                        if (this.$outer.writeBehindInterval().length() == 0L) {
                            OptionVal$.MODULE$.None();
                            this.$outer.dbPut(null, key, data);
                            object2 = BoxedUnit.UNIT;
                        } else {
                            if (this.$outer.pending().isEmpty()) {
                                Scheduler scheduler = this.$outer.context().system().scheduler();
                                scheduler.scheduleOnce(this.$outer.writeBehindInterval(), this.$outer.self(), (Object)LmdbDurableStore$WriteBehind$.MODULE$, (ExecutionContext)this.$outer.context().dispatcher(), scheduler.scheduleOnce$default$5(this.$outer.writeBehindInterval(), this.$outer.self(), (Object)LmdbDurableStore$WriteBehind$.MODULE$));
                            }
                            object2 = this.$outer.pending().put(key, data);
                        }
                        Option<DurableStore.StoreReply> option2 = reply;
                        if (option2 instanceof Some && (storeReply = (DurableStore.StoreReply)((Some)option2).value()) != null) {
                            DurableStore.StoreReply storeReply2 = DurableStore$StoreReply$.MODULE$.unapply(storeReply);
                            Object object3 = storeReply2._1();
                            Object object4 = storeReply2._2();
                            ActorRef actorRef = storeReply2._3();
                            Object successMsg = object3;
                            ActorRef replyTo = actorRef;
                            replyTo.$bang(successMsg, this.$outer.self());
                        } else if (!None$.MODULE$.equals(option2)) {
                            throw new MatchError(option2);
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Option option3;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option3 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            DurableStore.StoreReply storeReply;
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option3.get();
                            this.$outer.log().error(e, "failed to store [{}]", (Object)key);
                            Option<DurableStore.StoreReply> option4 = reply;
                            if (option4 instanceof Some && (storeReply = (DurableStore.StoreReply)((Some)option4).value()) != null) {
                                DurableStore.StoreReply storeReply3 = DurableStore$StoreReply$.MODULE$.unapply(storeReply);
                                Object object5 = storeReply3._1();
                                Object object6 = storeReply3._2();
                                ActorRef actorRef = storeReply3._3();
                                Object failureMsg = object6;
                                ActorRef replyTo = actorRef;
                                replyTo.$bang(failureMsg, this.$outer.self());
                            } else if (!None$.MODULE$.equals(option4)) {
                                throw new MatchError(option4);
                            }
                        } else {
                            throw throwable;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                if (LmdbDurableStore$WriteBehind$.MODULE$.equals(object)) {
                    this.$outer.writeBehind();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public void dbPut(Txn tx, String key, DurableStore.DurableDataEnvelope data) {
        try {
            byte[] value = this.serializer().toBinary((Object)data);
            this.ensureValueBufferSize(value.length);
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().put(key.getBytes(ByteString$.MODULE$.UTF_8())).flip();
            l.valueBuffer().put(value).flip();
            Txn txn = tx;
            Txn txn2 = (Txn)OptionVal.Some$.MODULE$.unapply((Object)txn);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)txn2)) {
                Txn txn3;
                Txn t = txn3 = (Txn)OptionVal$.MODULE$.get$extension((Object)txn2);
                l.db().put(t, (Object)l.keyBuffer(), (Object)l.valueBuffer(), new PutFlags[0]);
            } else {
                l.db().put((Object)l.keyBuffer(), (Object)l.valueBuffer());
            }
        }
        finally {
            Lmdb l = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb();
            l.keyBuffer().clear();
            l.valueBuffer().clear();
        }
    }

    public void writeBehind() {
        if (!this.pending().isEmpty()) {
            block9: {
                long t0 = System.nanoTime();
                Txn tx = this.org$apache$pekko$cluster$ddata$LmdbDurableStore$$lmdb().env().txnWrite();
                try {
                    try {
                        for (Map.Entry<String, DurableStore.DurableDataEnvelope> entry : this.pending().entrySet()) {
                            this.dbPut((Txn)OptionVal.Some$.MODULE$.apply((Object)tx), entry.getKey(), entry.getValue());
                        }
                        tx.commit();
                        if (this.log().isDebugEnabled()) {
                            this.log().debug("store and commit of [{}] entries took [{} ms]", (Object)BoxesRunTime.boxToInteger((int)this.pending().size()), (Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t0)));
                        }
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable e = throwable3 = (Throwable)option.get();
                            this.log().error(e, "failed to store [{}]", (Object)package.JavaConverters$.MODULE$.SetHasAsScala(this.pending().keySet()).asScala().mkString(","));
                            tx.abort();
                            break block9;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.pending().clear();
                }
            }
            return;
        }
    }

    private static final void postStop$$anonfun$1(Lmdb l$1) {
        l$1.db().close();
    }

    private static final void postStop$$anonfun$2(Lmdb l$2) {
        l$2.env().close();
    }

    private static final void applyOrElse$$anonfun$1(CursorIterable iter$1) {
        iter$1.close();
    }

    public static /* bridge */ /* synthetic */ Object org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$1(CursorIterable iter$2) {
        LmdbDurableStore.applyOrElse$$anonfun$1(iter$2);
        return BoxedUnit.UNIT;
    }

    private static final void applyOrElse$$anonfun$2(Txn tx$1) {
        tx$1.close();
    }

    public static /* bridge */ /* synthetic */ Object org$apache$pekko$cluster$ddata$LmdbDurableStore$$anon$1$$_$applyOrElse$$anonfun$adapted$2(Txn tx$2) {
        LmdbDurableStore.applyOrElse$$anonfun$2(tx$2);
        return BoxedUnit.UNIT;
    }

    public static final class Lmdb
    implements Product,
    Serializable {
        private final Env env;
        private final Dbi db;
        private final ByteBuffer keyBuffer;
        private final ByteBuffer valueBuffer;

        public static Lmdb apply(Env<ByteBuffer> env, Dbi<ByteBuffer> dbi, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            return LmdbDurableStore$Lmdb$.MODULE$.apply(env, dbi, byteBuffer, byteBuffer2);
        }

        public static Lmdb fromProduct(Product product) {
            return LmdbDurableStore$Lmdb$.MODULE$.fromProduct(product);
        }

        public static Lmdb unapply(Lmdb lmdb) {
            return LmdbDurableStore$Lmdb$.MODULE$.unapply(lmdb);
        }

        public Lmdb(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            this.env = env;
            this.db = db;
            this.keyBuffer = keyBuffer;
            this.valueBuffer = valueBuffer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Lmdb)) return false;
            Lmdb lmdb = (Lmdb)object;
            Env<ByteBuffer> env = this.env();
            Env<ByteBuffer> env2 = lmdb.env();
            if (env == null) {
                if (env2 != null) {
                    return false;
                }
            } else if (!env.equals(env2)) return false;
            Dbi<ByteBuffer> dbi = this.db();
            Dbi<ByteBuffer> dbi2 = lmdb.db();
            if (dbi == null) {
                if (dbi2 != null) {
                    return false;
                }
            } else if (!dbi.equals(dbi2)) return false;
            ByteBuffer byteBuffer = this.keyBuffer();
            ByteBuffer byteBuffer2 = lmdb.keyBuffer();
            if (byteBuffer == null) {
                if (byteBuffer2 != null) {
                    return false;
                }
            } else if (!((Object)byteBuffer).equals(byteBuffer2)) return false;
            ByteBuffer byteBuffer3 = this.valueBuffer();
            ByteBuffer byteBuffer4 = lmdb.valueBuffer();
            if (byteBuffer3 == null) {
                if (byteBuffer4 == null) return true;
                return false;
            } else {
                if (!((Object)byteBuffer3).equals(byteBuffer4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Lmdb;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Lmdb";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "env";
                }
                case 1: {
                    return "db";
                }
                case 2: {
                    return "keyBuffer";
                }
                case 3: {
                    return "valueBuffer";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Env<ByteBuffer> env() {
            return this.env;
        }

        public Dbi<ByteBuffer> db() {
            return this.db;
        }

        public ByteBuffer keyBuffer() {
            return this.keyBuffer;
        }

        public ByteBuffer valueBuffer() {
            return this.valueBuffer;
        }

        public Lmdb copy(Env<ByteBuffer> env, Dbi<ByteBuffer> db, ByteBuffer keyBuffer, ByteBuffer valueBuffer) {
            return new Lmdb(env, db, keyBuffer, valueBuffer);
        }

        public Env<ByteBuffer> copy$default$1() {
            return this.env();
        }

        public Dbi<ByteBuffer> copy$default$2() {
            return this.db();
        }

        public ByteBuffer copy$default$3() {
            return this.keyBuffer();
        }

        public ByteBuffer copy$default$4() {
            return this.valueBuffer();
        }

        public Env<ByteBuffer> _1() {
            return this.env();
        }

        public Dbi<ByteBuffer> _2() {
            return this.db();
        }

        public ByteBuffer _3() {
            return this.keyBuffer();
        }

        public ByteBuffer _4() {
            return this.valueBuffer();
        }
    }
}

