/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.EstimatedSize$;
import org.apache.pekko.cluster.ddata.ManyVersionVector$;
import org.apache.pekko.cluster.ddata.OneVersionVector;
import org.apache.pekko.cluster.ddata.OneVersionVector$;
import org.apache.pekko.cluster.ddata.VersionVector;
import org.apache.pekko.cluster.ddata.VersionVector$;
import org.apache.pekko.cluster.ddata.VersionVector$Timestamp$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.collection.immutable.TreeMap;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class ManyVersionVector
extends VersionVector
implements Product {
    private final TreeMap versions;

    public static ManyVersionVector apply(TreeMap<UniqueAddress, Object> treeMap) {
        return ManyVersionVector$.MODULE$.apply(treeMap);
    }

    public static ManyVersionVector fromProduct(Product product) {
        return ManyVersionVector$.MODULE$.fromProduct(product);
    }

    public static ManyVersionVector unapply(ManyVersionVector manyVersionVector) {
        return ManyVersionVector$.MODULE$.unapply(manyVersionVector);
    }

    public ManyVersionVector(TreeMap<UniqueAddress, Object> versions) {
        this.versions = versions;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ManyVersionVector)) return false;
        ManyVersionVector manyVersionVector = (ManyVersionVector)object;
        TreeMap<UniqueAddress, Object> treeMap = this.versions();
        TreeMap<UniqueAddress, Object> treeMap2 = manyVersionVector.versions();
        if (treeMap != null) {
            if (!treeMap.equals(treeMap2)) return false;
            return true;
        }
        if (treeMap2 == null) return true;
        return false;
    }

    public boolean canEqual(Object that) {
        return that instanceof ManyVersionVector;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "ManyVersionVector";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "versions";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public TreeMap<UniqueAddress, Object> versions() {
        return this.versions;
    }

    @Override
    public boolean isEmpty() {
        return this.versions().isEmpty();
    }

    @Override
    @InternalApi
    public int size() {
        return this.versions().size();
    }

    @Override
    @InternalApi
    public VersionVector increment(UniqueAddress node) {
        long v = VersionVector$Timestamp$.MODULE$.counter().getAndIncrement();
        return VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)this.versions().updated((Object)node, (Object)BoxesRunTime.boxToLong((long)v)));
    }

    @Override
    @InternalApi
    public long versionAt(UniqueAddress node) {
        Option option = this.versions().get((Object)node);
        if (option instanceof Some) {
            long v = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return v;
        }
        if (None$.MODULE$.equals(option)) {
            return 0L;
        }
        throw new MatchError((Object)option);
    }

    @Override
    @InternalApi
    public boolean contains(UniqueAddress node) {
        return this.versions().contains((Object)node);
    }

    @Override
    @InternalApi
    public Iterator<Tuple2<UniqueAddress, Object>> versionsIterator() {
        return this.versions().iterator();
    }

    @Override
    public VersionVector merge(VersionVector that) {
        if (that.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return that;
        }
        VersionVector versionVector = that;
        if (versionVector instanceof ManyVersionVector) {
            TreeMap<UniqueAddress, Object> treeMap;
            ManyVersionVector manyVersionVector = ManyVersionVector$.MODULE$.unapply((ManyVersionVector)versionVector);
            TreeMap<UniqueAddress, Object> vs2 = treeMap = manyVersionVector._1();
            ObjectRef mergedVersions = ObjectRef.create(vs2);
            this.versions().withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    UniqueAddress node = (UniqueAddress)tuple2._1();
                    long time = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    return true;
                }
                return false;
            }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    long mergedVersionsCurrentTime;
                    UniqueAddress node = (UniqueAddress)tuple2._1();
                    long time = BoxesRunTime.unboxToLong((Object)tuple2._2());
                    if (time > (mergedVersionsCurrentTime = BoxesRunTime.unboxToLong((Object)((TreeMap)mergedVersions$1.elem).getOrElse((Object)node, ManyVersionVector::$anonfun$2)))) {
                        TreeMap treeMap = ((TreeMap)mergedVersions$1.elem).updated((Object)node, (Object)BoxesRunTime.boxToLong((long)time));
                        mergedVersions$1.elem = treeMap;
                        treeMap = null;
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)((TreeMap)mergedVersions.elem));
        }
        if (versionVector instanceof OneVersionVector) {
            OneVersionVector oneVersionVector = OneVersionVector$.MODULE$.unapply((OneVersionVector)versionVector);
            UniqueAddress uniqueAddress = oneVersionVector._1();
            long l = oneVersionVector._2();
            UniqueAddress n2 = uniqueAddress;
            long v2 = l;
            long v1 = BoxesRunTime.unboxToLong((Object)this.versions().getOrElse((Object)n2, ManyVersionVector::$anonfun$3));
            TreeMap mergedVersions = v1 >= v2 ? this.versions() : this.versions().updated((Object)n2, (Object)BoxesRunTime.boxToLong((long)v2));
            return VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)mergedVersions);
        }
        throw new MatchError((Object)versionVector);
    }

    @Override
    public Set<UniqueAddress> modifiedByNodes() {
        return this.versions().keySet();
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        return this.versions().contains((Object)removedNode);
    }

    @Override
    public VersionVector prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        return VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)((TreeMap)this.versions().$minus((Object)removedNode))).$plus(collapseInto);
    }

    @Override
    public VersionVector pruningCleanup(UniqueAddress removedNode) {
        if (this.versions().contains((Object)removedNode)) {
            return VersionVector$.MODULE$.apply((TreeMap<UniqueAddress, Object>)((TreeMap)this.versions().$minus((Object)removedNode)));
        }
        return this;
    }

    public String toString() {
        return ((IterableOnceOps)this.versions().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                UniqueAddress n = (UniqueAddress)tuple2._1();
                long v = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return new StringBuilder(4).append(n.toString()).append(" -> ").append(v).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("VersionVector(", ", ", ")");
    }

    @Override
    @InternalApi
    public int estimatedSize() {
        return this.versions().size() * (EstimatedSize$.MODULE$.UniqueAddress() + EstimatedSize$.MODULE$.LongValue());
    }

    public ManyVersionVector copy(TreeMap<UniqueAddress, Object> versions) {
        return new ManyVersionVector(versions);
    }

    public TreeMap<UniqueAddress, Object> copy$default$1() {
        return this.versions();
    }

    public TreeMap<UniqueAddress, Object> _1() {
        return this.versions();
    }

    private static final long $anonfun$2() {
        return 0L;
    }

    private static final long $anonfun$3() {
        return 0L;
    }
}

