/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.DeltaReplicatedData;
import org.apache.pekko.cluster.ddata.ORMap;
import org.apache.pekko.cluster.ddata.ORMultiMap$;
import org.apache.pekko.cluster.ddata.ORSet;
import org.apache.pekko.cluster.ddata.ORSet$;
import org.apache.pekko.cluster.ddata.RemovedNodePruning;
import org.apache.pekko.cluster.ddata.ReplicatedData;
import org.apache.pekko.cluster.ddata.ReplicatedDataSerialization;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public final class ORMultiMap<A, B>
implements DeltaReplicatedData,
ReplicatedDataSerialization,
RemovedNodePruning {
    private static final long serialVersionUID = 1L;
    private final ORMap underlying;
    private final boolean withValueDeltas;

    public static ORMultiMap<Object, Object> _empty() {
        return ORMultiMap$.MODULE$._empty();
    }

    public static ORMultiMap<Object, Object> _emptyWithValueDeltas() {
        return ORMultiMap$.MODULE$._emptyWithValueDeltas();
    }

    public static ORMultiMap<Object, Object> apply() {
        return ORMultiMap$.MODULE$.apply();
    }

    public static <A, B> ORMultiMap<A, B> create() {
        return ORMultiMap$.MODULE$.create();
    }

    public static <A, B> ORMultiMap<A, B> empty() {
        return ORMultiMap$.MODULE$.empty();
    }

    public static <A, B> ORMultiMap<A, B> emptyWithValueDeltas() {
        return ORMultiMap$.MODULE$.emptyWithValueDeltas();
    }

    public static <A, B> Option<Map<A, scala.collection.immutable.Set<B>>> unapply(ORMultiMap<A, B> oRMultiMap) {
        return ORMultiMap$.MODULE$.unapply(oRMultiMap);
    }

    public static <A, B extends ReplicatedData> Option<Map<A, scala.collection.immutable.Set<B>>> unapply(Object object) {
        return ORMultiMap$.MODULE$.unapply(object);
    }

    public ORMultiMap(ORMap<A, ORSet<B>> underlying, boolean withValueDeltas) {
        this.underlying = underlying;
        this.withValueDeltas = withValueDeltas;
    }

    public ORMap<A, ORSet<B>> underlying() {
        return this.underlying;
    }

    public boolean withValueDeltas() {
        return this.withValueDeltas;
    }

    public ORMultiMap<A, B> merge(ORMultiMap<A, B> that) {
        if (this.withValueDeltas() == that.withValueDeltas()) {
            if (this.withValueDeltas()) {
                ORMap newUnderlying = this.underlying().mergeRetainingDeletedValues(that.underlying());
                Map newValues = (Map)newUnderlying.values().filterNot((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        ORSet value = (ORSet)tuple2._2();
                        return !newUnderlying.keys().contains(key) && value.isEmpty();
                    }
                    throw new MatchError((Object)tuple2);
                });
                return new ORMultiMap<A, B>(new ORMap(newUnderlying.keys(), newValues, newUnderlying.zeroTag(), newUnderlying.delta()), this.withValueDeltas());
            }
            return new ORMultiMap<A, B>(this.underlying().merge(that.underlying()), this.withValueDeltas());
        }
        throw new IllegalArgumentException("Trying to merge two ORMultiMaps of different map sub-type");
    }

    public Map<A, scala.collection.immutable.Set<B>> entries() {
        if (this.withValueDeltas()) {
            return (Map)this.underlying().entries().collect((PartialFunction)new Serializable(this){
                private final /* synthetic */ ORMultiMap $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Tuple2 x) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        ORSet v = (ORSet)tuple2._2();
                        if (this.$outer.underlying().keys().elements().contains(k)) {
                            return true;
                        }
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Tuple2 tuple2 = x;
                    if (tuple2 != null) {
                        Object k = tuple2._1();
                        ORSet v = (ORSet)tuple2._2();
                        if (this.$outer.underlying().keys().elements().contains(k)) {
                            Object object = Predef$.MODULE$.ArrowAssoc(k);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, v.elements());
                        }
                    }
                    return function1.apply((Object)x);
                }
            });
        }
        return (Map)this.underlying().entries().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                ORSet v = (ORSet)tuple2._2();
                Object object = Predef$.MODULE$.ArrowAssoc(k);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, v.elements());
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public java.util.Map<A, Set<B>> getEntries() {
        HashMap result = new HashMap();
        if (this.withValueDeltas()) {
            this.underlying().entries().foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    ORSet v = (ORSet)tuple2._2();
                    if (this.underlying().keys().elements().contains(k)) {
                        result.put(k, package.JavaConverters$.MODULE$.SetHasAsJava(v.elements()).asJava());
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        } else {
            this.underlying().entries().foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object k = tuple2._1();
                    ORSet v = (ORSet)tuple2._2();
                    return result.put(k, package.JavaConverters$.MODULE$.SetHasAsJava(v.elements()).asJava());
                }
                throw new MatchError((Object)tuple2);
            });
        }
        return result;
    }

    public Option<scala.collection.immutable.Set<B>> get(A key) {
        if (this.withValueDeltas() && !this.underlying().keys().elements().contains(key)) {
            return None$.MODULE$;
        }
        return this.underlying().get(key).map((Function1 & Serializable)_$1 -> _$1.elements());
    }

    public scala.collection.immutable.Set<B> getOrElse(A key, Function0<scala.collection.immutable.Set<B>> function0) {
        return (scala.collection.immutable.Set)this.get(key).getOrElse(function0);
    }

    public boolean contains(A key) {
        return this.underlying().keys().elements().contains(key);
    }

    public boolean isEmpty() {
        return this.underlying().keys().elements().isEmpty();
    }

    public int size() {
        return this.underlying().keys().elements().size();
    }

    public ORMultiMap<A, B> $colon$plus(Tuple2<A, scala.collection.immutable.Set<B>> entry, SelfUniqueAddress node) {
        Tuple2<A, scala.collection.immutable.Set<B>> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        scala.collection.immutable.Set value = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, (Object)value);
        Object key2 = tuple22._1();
        scala.collection.immutable.Set value2 = (scala.collection.immutable.Set)tuple22._2();
        return this.put(node.uniqueAddress(), key2, value2);
    }

    public ORMultiMap<A, B> $plus(Tuple2<A, scala.collection.immutable.Set<B>> entry, Cluster node) {
        Tuple2<A, scala.collection.immutable.Set<B>> tuple2 = entry;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Object key = tuple2._1();
        scala.collection.immutable.Set value = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(key, (Object)value);
        Object key2 = tuple22._1();
        scala.collection.immutable.Set value2 = (scala.collection.immutable.Set)tuple22._2();
        return this.put(node.selfUniqueAddress(), key2, value2);
    }

    public ORMultiMap<A, B> put(SelfUniqueAddress node, A key, scala.collection.immutable.Set<B> value) {
        return this.put(node.uniqueAddress(), key, value);
    }

    public ORMultiMap<A, B> put(Cluster node, A key, scala.collection.immutable.Set<B> value) {
        return this.put(node.selfUniqueAddress(), key, value);
    }

    public ORMultiMap<A, B> put(SelfUniqueAddress node, A key, Set<B> value) {
        return this.put(node.uniqueAddress(), key, package.JavaConverters$.MODULE$.SetHasAsScala(value).asScala().toSet());
    }

    public ORMultiMap<A, B> put(Cluster node, A key, Set<B> value) {
        return this.put(node.selfUniqueAddress(), key, package.JavaConverters$.MODULE$.SetHasAsScala(value).asScala().toSet());
    }

    @InternalApi
    public ORMultiMap<A, B> put(UniqueAddress node, A key, scala.collection.immutable.Set<B> value) {
        ORMap newUnderlying = this.underlying().updated(node, key, ORSet$.MODULE$.empty(), this.withValueDeltas(), (Function1 & Serializable)existing -> (ORSet)value.foldLeft(existing.clear(), (Function2 & Serializable)(s, element) -> s.add(node, element)));
        return new ORMultiMap(newUnderlying, this.withValueDeltas());
    }

    public ORMultiMap<A, B> remove(A key, SelfUniqueAddress node) {
        return this.remove(node.uniqueAddress(), key);
    }

    public ORMultiMap<A, B> $minus(A key, Cluster node) {
        return this.remove(node.selfUniqueAddress(), key);
    }

    public ORMultiMap<A, B> remove(SelfUniqueAddress node, A key) {
        return this.remove(node.uniqueAddress(), key);
    }

    public ORMultiMap<A, B> remove(Cluster node, A key) {
        return this.remove(node.selfUniqueAddress(), key);
    }

    @InternalApi
    public ORMultiMap<A, B> remove(UniqueAddress node, A key) {
        if (this.withValueDeltas()) {
            ORMap<A, ORSet<A>> u = this.underlying().updated(node, key, ORSet$.MODULE$.empty(), true, (Function1 & Serializable)existing -> existing.clear());
            return new ORMultiMap(u.removeKey(node, key), this.withValueDeltas());
        }
        return new ORMultiMap<A, B>(this.underlying().remove(node, key), this.withValueDeltas());
    }

    public ORMultiMap<A, B> addBinding(SelfUniqueAddress node, A key, B element) {
        return this.addBinding(node.uniqueAddress(), key, element);
    }

    public ORMultiMap<A, B> addBindingBy(A key, B element, SelfUniqueAddress node) {
        return this.addBinding(node, key, element);
    }

    public ORMultiMap<A, B> addBinding(A key, B element, Cluster node) {
        return this.addBinding(node.selfUniqueAddress(), key, element);
    }

    public ORMultiMap<A, B> addBinding(Cluster node, A key, B element) {
        return this.addBinding(node.selfUniqueAddress(), key, element);
    }

    @InternalApi
    public ORMultiMap<A, B> addBinding(UniqueAddress node, A key, B element) {
        ORMap newUnderlying = this.underlying().updated(node, key, ORSet$.MODULE$.empty(), this.withValueDeltas(), (Function1 & Serializable)_$2 -> _$2.add(node, element));
        return new ORMultiMap(newUnderlying, this.withValueDeltas());
    }

    public ORMultiMap<A, B> removeBinding(SelfUniqueAddress node, A key, B element) {
        return this.removeBinding(node.uniqueAddress(), key, element);
    }

    public ORMultiMap<A, B> removeBindingBy(A key, B element, SelfUniqueAddress node) {
        return this.removeBinding(node, key, element);
    }

    public ORMultiMap<A, B> removeBinding(A key, B element, Cluster node) {
        return this.removeBinding(node.selfUniqueAddress(), key, element);
    }

    public ORMultiMap<A, B> removeBinding(Cluster node, A key, B element) {
        return this.removeBinding(node.selfUniqueAddress(), key, element);
    }

    @InternalApi
    public ORMultiMap<A, B> removeBinding(UniqueAddress node, A key, B element) {
        ORSet s;
        ORMap<A, ORSet<A>> u = this.underlying().updated(node, key, ORSet$.MODULE$.empty(), this.withValueDeltas(), (Function1 & Serializable)_$3 -> _$3.remove(node, element));
        Option option = u.get(key);
        ORMap<A, ORSet<A>> newUnderlying = option instanceof Some && (s = (ORSet)((Some)option).value()).isEmpty() ? (this.withValueDeltas() ? u.removeKey(node, key) : u.remove(node, key)) : u;
        return new ORMultiMap(newUnderlying, this.withValueDeltas());
    }

    public ORMultiMap<A, B> replaceBinding(SelfUniqueAddress node, A key, B oldElement, B newElement) {
        return this.replaceBinding(node.uniqueAddress(), key, oldElement, newElement);
    }

    public ORMultiMap<A, B> replaceBindingBy(A key, B oldElement, B newElement, SelfUniqueAddress node) {
        return this.replaceBinding(node, key, oldElement, newElement);
    }

    public ORMultiMap<A, B> replaceBinding(A key, B oldElement, B newElement, Cluster node) {
        return this.replaceBinding(node.selfUniqueAddress(), key, oldElement, newElement);
    }

    @InternalApi
    public ORMultiMap<A, B> replaceBinding(UniqueAddress node, A key, B oldElement, B newElement) {
        if (!BoxesRunTime.equals(newElement, oldElement)) {
            return this.addBinding(node, key, newElement).removeBinding(node, key, oldElement);
        }
        return this;
    }

    @Override
    public ORMultiMap<A, B> resetDelta() {
        return new ORMultiMap<A, B>(this.underlying().resetDelta(), this.withValueDeltas());
    }

    public Option<ORMap.DeltaOp> delta() {
        return this.underlying().delta();
    }

    public ORMultiMap<A, B> mergeDelta(ORMap.DeltaOp thatDelta) {
        if (this.withValueDeltas()) {
            ORMap newUnderlying = this.underlying().mergeDeltaRetainingDeletedValues(thatDelta);
            Map newValues = (Map)newUnderlying.values().filterNot((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object key = tuple2._1();
                    ORSet value = (ORSet)tuple2._2();
                    return !newUnderlying.keys().contains(key) && value.isEmpty();
                }
                throw new MatchError((Object)tuple2);
            });
            return new ORMultiMap<A, B>(new ORMap(newUnderlying.keys(), newValues, newUnderlying.zeroTag(), newUnderlying.delta()), this.withValueDeltas());
        }
        return new ORMultiMap<A, B>(this.underlying().mergeDelta(thatDelta), this.withValueDeltas());
    }

    @Override
    public scala.collection.immutable.Set<UniqueAddress> modifiedByNodes() {
        return this.underlying().modifiedByNodes();
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        return this.underlying().needPruningFrom(removedNode);
    }

    @Override
    public ORMultiMap<A, B> pruningCleanup(UniqueAddress removedNode) {
        return new ORMultiMap<A, B>(this.underlying().pruningCleanup(removedNode), this.withValueDeltas());
    }

    @Override
    public ORMultiMap<A, B> prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        return new ORMultiMap<A, B>(this.underlying().prune(removedNode, collapseInto), this.withValueDeltas());
    }

    public String toString() {
        return new StringBuilder(7).append("ORMulti").append(this.entries()).toString();
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof ORMultiMap) {
            ORMultiMap other = (ORMultiMap)object;
            ORMap<A, ORSet<B>> oRMap = this.underlying();
            ORMap<A, ORSet<B>> oRMap2 = other.underlying();
            return !(oRMap != null ? !((Object)oRMap).equals(oRMap2) : oRMap2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.underlying().hashCode();
    }
}

