/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.ddata;

import java.math.BigInteger;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.UniqueAddress;
import org.apache.pekko.cluster.ddata.DeltaReplicatedData;
import org.apache.pekko.cluster.ddata.GCounter;
import org.apache.pekko.cluster.ddata.GCounter$;
import org.apache.pekko.cluster.ddata.PNCounter$;
import org.apache.pekko.cluster.ddata.RemovedNodePruning;
import org.apache.pekko.cluster.ddata.ReplicatedDataSerialization;
import org.apache.pekko.cluster.ddata.ReplicatedDelta;
import org.apache.pekko.cluster.ddata.SelfUniqueAddress;
import org.apache.pekko.util.HashCode$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Set;
import scala.math.BigInt;
import scala.math.BigInt$;

public final class PNCounter
implements DeltaReplicatedData,
ReplicatedDelta,
ReplicatedDataSerialization,
RemovedNodePruning {
    private static final long serialVersionUID = 1L;
    private final GCounter increments;
    private final GCounter decrements;

    public static PNCounter apply() {
        return PNCounter$.MODULE$.apply();
    }

    public static PNCounter create() {
        return PNCounter$.MODULE$.create();
    }

    public static PNCounter empty() {
        return PNCounter$.MODULE$.empty();
    }

    public static Option<BigInt> unapply(PNCounter pNCounter) {
        return PNCounter$.MODULE$.unapply(pNCounter);
    }

    public PNCounter(GCounter increments, GCounter decrements) {
        this.increments = increments;
        this.decrements = decrements;
    }

    public GCounter increments() {
        return this.increments;
    }

    public GCounter decrements() {
        return this.decrements;
    }

    public BigInt value() {
        return this.increments().value().$minus(this.decrements().value());
    }

    public BigInteger getValue() {
        return this.value().bigInteger();
    }

    public PNCounter $colon$plus(long n, SelfUniqueAddress node) {
        return this.increment(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter $plus(long n, Cluster node) {
        return this.increment(node.selfUniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter $colon$plus(BigInt n, SelfUniqueAddress node) {
        return this.increment(node.uniqueAddress(), n);
    }

    public PNCounter $plus(BigInt n, Cluster node) {
        return this.increment(node.selfUniqueAddress(), n);
    }

    public PNCounter increment(long n, SelfUniqueAddress node) {
        return this.increment(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter increment(Cluster node, long n) {
        return this.increment(node.selfUniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public long increment$default$2() {
        return 1L;
    }

    public PNCounter increment(BigInt n, SelfUniqueAddress node) {
        return this.increment(node.uniqueAddress(), n);
    }

    public PNCounter increment(Cluster node, BigInt n) {
        return this.increment(node.selfUniqueAddress(), n);
    }

    public PNCounter increment(SelfUniqueAddress node, BigInteger n) {
        return this.increment(node.uniqueAddress(), BigInt$.MODULE$.javaBigInteger2bigInt(n));
    }

    public PNCounter increment(SelfUniqueAddress node, long n) {
        return this.increment(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter increment(Cluster node, BigInteger n) {
        return this.increment(node.selfUniqueAddress(), BigInt$.MODULE$.javaBigInteger2bigInt(n));
    }

    public PNCounter decrement(long n, SelfUniqueAddress node) {
        return this.decrement(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter $minus(long n, Cluster node) {
        return this.decrement(node.selfUniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter decrement(BigInt n, SelfUniqueAddress node) {
        return this.decrement(node.uniqueAddress(), n);
    }

    public PNCounter $minus(BigInt n, Cluster node) {
        return this.decrement(node.selfUniqueAddress(), n);
    }

    public PNCounter decrement(SelfUniqueAddress node, long n) {
        return this.decrement(node.uniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public PNCounter decrement(Cluster node, long n) {
        return this.decrement(node.selfUniqueAddress(), BigInt$.MODULE$.long2bigInt(n));
    }

    public long decrement$default$2() {
        return 1L;
    }

    public PNCounter decrement(SelfUniqueAddress node, BigInt n) {
        return this.decrement(node.uniqueAddress(), n);
    }

    public PNCounter decrement(Cluster node, BigInt n) {
        return this.decrement(node.selfUniqueAddress(), n);
    }

    public PNCounter decrement(SelfUniqueAddress node, BigInteger n) {
        return this.decrement(node.uniqueAddress(), BigInt$.MODULE$.javaBigInteger2bigInt(n));
    }

    public PNCounter decrement(Cluster node, BigInteger n) {
        return this.decrement(node.selfUniqueAddress(), BigInt$.MODULE$.javaBigInteger2bigInt(n));
    }

    @InternalApi
    public PNCounter increment(UniqueAddress key, BigInt n) {
        return this.change(key, n);
    }

    @InternalApi
    public PNCounter increment(UniqueAddress key) {
        return this.increment(key, BigInt$.MODULE$.int2bigInt(1));
    }

    @InternalApi
    public PNCounter decrement(UniqueAddress key, BigInt n) {
        return this.change(key, n.unary_$minus());
    }

    @InternalApi
    public PNCounter decrement(UniqueAddress key) {
        return this.decrement(key, BigInt$.MODULE$.int2bigInt(1));
    }

    @InternalApi
    public PNCounter change(UniqueAddress key, BigInt n) {
        if (n.$greater((Object)BigInt$.MODULE$.int2bigInt(0))) {
            return this.copy(this.increments().increment(key, n), this.copy$default$2());
        }
        if (n.$less((Object)BigInt$.MODULE$.int2bigInt(0))) {
            GCounter gCounter = this.decrements().increment(key, n.unary_$minus());
            GCounter gCounter2 = this.copy$default$1();
            return this.copy(gCounter2, gCounter);
        }
        return this;
    }

    public PNCounter merge(PNCounter that) {
        return this.copy(that.increments().merge(this.increments()), that.decrements().merge(this.decrements()));
    }

    public Option<PNCounter> delta() {
        GCounter gCounter;
        GCounter gCounter2;
        Option<GCounter> option = this.increments().delta();
        if (option instanceof Some) {
            GCounter d;
            gCounter2 = d = (GCounter)((Some)option).value();
        } else if (None$.MODULE$.equals(option)) {
            gCounter2 = GCounter$.MODULE$.empty();
        } else {
            throw new MatchError(option);
        }
        GCounter incrementsDelta = gCounter2;
        Option<GCounter> option2 = this.decrements().delta();
        if (option2 instanceof Some) {
            GCounter d;
            gCounter = d = (GCounter)((Some)option2).value();
        } else if (None$.MODULE$.equals(option2)) {
            gCounter = GCounter$.MODULE$.empty();
        } else {
            throw new MatchError(option2);
        }
        GCounter decrementsDelta = gCounter;
        return Some$.MODULE$.apply((Object)new PNCounter(incrementsDelta, decrementsDelta));
    }

    public PNCounter mergeDelta(PNCounter thatDelta) {
        return this.merge(thatDelta);
    }

    @Override
    public PNCounter zero() {
        return PNCounter$.MODULE$.empty();
    }

    @Override
    public PNCounter resetDelta() {
        if (this.increments().delta().isEmpty() && this.decrements().delta().isEmpty()) {
            return this;
        }
        return new PNCounter(this.increments().resetDelta(), this.decrements().resetDelta());
    }

    @Override
    public Set<UniqueAddress> modifiedByNodes() {
        return (Set)this.increments().modifiedByNodes().union(this.decrements().modifiedByNodes());
    }

    @Override
    public boolean needPruningFrom(UniqueAddress removedNode) {
        return this.increments().needPruningFrom(removedNode) || this.decrements().needPruningFrom(removedNode);
    }

    @Override
    public PNCounter prune(UniqueAddress removedNode, UniqueAddress collapseInto) {
        return this.copy(this.increments().prune(removedNode, collapseInto), this.decrements().prune(removedNode, collapseInto));
    }

    @Override
    public PNCounter pruningCleanup(UniqueAddress removedNode) {
        return this.copy(this.increments().pruningCleanup(removedNode), this.decrements().pruningCleanup(removedNode));
    }

    private PNCounter copy(GCounter increments, GCounter decrements) {
        return new PNCounter(increments, decrements);
    }

    private GCounter copy$default$1() {
        return this.increments();
    }

    private GCounter copy$default$2() {
        return this.decrements();
    }

    public String toString() {
        return new StringBuilder(11).append("PNCounter(").append(this.value()).append(")").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof PNCounter)) return false;
        PNCounter other = (PNCounter)object;
        GCounter gCounter = this.increments();
        GCounter gCounter2 = other.increments();
        if (gCounter == null) {
            if (gCounter2 != null) {
                return false;
            }
        } else if (!((Object)gCounter).equals(gCounter2)) return false;
        GCounter gCounter3 = this.decrements();
        GCounter gCounter4 = other.decrements();
        if (gCounter3 == null) {
            if (gCounter4 == null) return true;
            return false;
        } else {
            if (!((Object)gCounter3).equals(gCounter4)) return false;
            return true;
        }
    }

    public int hashCode() {
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, (Object)this.increments());
        result = HashCode$.MODULE$.hash(result, (Object)this.decrements());
        return result;
    }
}

