/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.io.Serializable;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.internal.ClientConnectionException;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.NettyClientUtils$;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class ChannelUtils$ {
    public static ChannelUtils$ MODULE$;

    static {
        new ChannelUtils$();
    }

    @InternalApi
    public InternalChannel create(GrpcClientSettings settings, LoggingAdapter log, ClassicActorSystemProvider sys) {
        String string = settings.backend();
        if ("netty".equals(string)) {
            return NettyClientUtils$.MODULE$.createChannel(settings, log, (ExecutionContext)sys.classicSystem().dispatcher());
        }
        if ("pekko-http".equals(string)) {
            return PekkoHttpClientUtils$.MODULE$.createChannel(settings, log, sys);
        }
        throw new IllegalArgumentException(new StringBuilder(21).append("Unexpected backend [").append(settings.backend()).append("]").toString());
    }

    @InternalApi
    public Future<Done> close(InternalChannel internalChannel) {
        internalChannel.shutdown();
        return internalChannel.done();
    }

    @InternalApi
    public void monitorChannel(Promise<BoxedUnit> ready, Promise<Done> done, ManagedChannel channel, Option<Object> maxConnectionAttempts, LoggingAdapter log) {
        ChannelUtils$.monitor$1(channel.getState(false), 0, log, maxConnectionAttempts, ready, done, channel);
    }

    private static final void monitor$1(ConnectivityState currentState, int connectionAttempts, LoggingAdapter log$1, Option maxConnectionAttempts$1, Promise ready$1, Promise done$1, ManagedChannel channel$1) {
        Some some;
        log$1.debug(new StringBuilder(46).append("monitoring with state ").append(currentState).append(" and connectionAttempts ").append(connectionAttempts).toString());
        ConnectivityState connectivityState = currentState;
        if (ConnectivityState.TRANSIENT_FAILURE.equals(connectivityState)) {
            if (maxConnectionAttempts$1.contains((Object)BoxesRunTime.boxToInteger((int)(connectionAttempts + 1)))) {
                ClientConnectionException ex = new ClientConnectionException(new StringBuilder(39).append("Unable to establish connection after [").append(maxConnectionAttempts$1).append("]").toString());
                boolean bl = ready$1.tryFailure((Throwable)ex) || done$1.tryFailure((Throwable)ex);
                some = None$.MODULE$;
            } else {
                some = new Some((Object)BoxesRunTime.boxToInteger((int)(connectionAttempts + 1)));
            }
        } else if (ConnectivityState.READY.equals(connectivityState)) {
            ready$1.trySuccess((Object)BoxedUnit.UNIT);
            some = new Some((Object)BoxesRunTime.boxToInteger((int)0));
        } else if (ConnectivityState.SHUTDOWN.equals(connectivityState)) {
            done$1.trySuccess((Object)Done$.MODULE$);
            some = None$.MODULE$;
        } else if (ConnectivityState.IDLE.equals(connectivityState) ? true : ConnectivityState.CONNECTING.equals(connectivityState)) {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)connectionAttempts));
        } else {
            throw new MatchError((Object)connectivityState);
        }
        Some newAttemptOpt = some;
        newAttemptOpt.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)attempts -> channel$1.notifyWhenStateChanged(currentState, () -> ChannelUtils$.monitor$1(channel$1.getState(false), attempts, log$1, maxConnectionAttempts$1, ready$1, done$1, channel$1)));
    }

    private ChannelUtils$() {
        MODULE$ = this;
    }
}

