/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.reflect.ClassTag$;

public final class Gzip$
extends Codec {
    public static Gzip$ MODULE$;
    private final String name;

    static {
        new Gzip$();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ByteString compress(ByteString uncompressed) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(uncompressed.size());
        try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            gzos.write((byte[])uncompressed.toArray(ClassTag$.MODULE$.Byte()));
        }
        return ByteString$.MODULE$.fromArrayUnsafe(baos.toByteArray());
    }

    @Override
    public ByteString uncompress(ByteString compressed) {
        GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream((byte[])compressed.toArray(ClassTag$.MODULE$.Byte())));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(compressed.size());
        byte[] buffer = new byte[32768];
        try {
            int read = gzis.read(buffer);
            while (read != -1) {
                baos.write(buffer, 0, read);
                read = gzis.read(buffer);
            }
        }
        finally {
            gzis.close();
        }
        return ByteString$.MODULE$.fromArrayUnsafe(baos.toByteArray());
    }

    @Override
    public ByteString uncompress(boolean compressedBitSet, ByteString bytes) {
        if (compressedBitSet) {
            return this.uncompress(bytes);
        }
        return bytes;
    }

    private Gzip$() {
        MODULE$ = this;
        this.name = "gzip";
    }
}

