/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.GrpcProtocol;
import org.apache.pekko.grpc.GrpcResponseMetadata;
import org.apache.pekko.grpc.GrpcSingleResponse;
import org.apache.pekko.grpc.ProtobufSerializer;
import org.apache.pekko.grpc.internal.CancellationBarrierGraphStage;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.grpc.internal.Codecs$;
import org.apache.pekko.grpc.internal.GrpcEntityHelpers$;
import org.apache.pekko.grpc.internal.GrpcProtocolNative$;
import org.apache.pekko.grpc.internal.GrpcRequestHelpers$;
import org.apache.pekko.grpc.internal.HeaderMetadataImpl;
import org.apache.pekko.grpc.internal.Identity$;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.JavaMetadataImpl;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils$ResponsePromise$;
import org.apache.pekko.grpc.internal.WithProtobufSerializer;
import org.apache.pekko.grpc.scaladsl.Metadata;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.javadsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.ClientTransport$;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.FlowOpsMat;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.SourceQueueWithComplete;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.FutureConverters;
import org.apache.pekko.util.FutureConverters$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class PekkoHttpClientUtils$ {
    public static PekkoHttpClientUtils$ MODULE$;

    static {
        new PekkoHttpClientUtils$();
    }

    @InternalApi
    public InternalChannel createChannel(GrpcClientSettings settings, LoggingAdapter log, ClassicActorSystemProvider sys) {
        Flow flow;
        ExecutionContextExecutor ec = sys.classicSystem().dispatcher();
        log.debug("Creating gRPC client channel");
        GrpcProtocol.GrpcProtocolWriter writer = GrpcProtocolNative$.MODULE$.newWriter(Identity$.MODULE$);
        IntRef roundRobin = IntRef.create((int)0);
        ClientConnectionSettings clientConnectionSettings = ((ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(sys)).withTransport(ClientTransport$.MODULE$.withCustomResolver((Function2 & Serializable & scala.Serializable)(host, x$1) -> PekkoHttpClientUtils$.$anonfun$createChannel$1(settings, roundRobin, ec, host, BoxesRunTime.unboxToInt((Object)x$1))));
        OutgoingConnectionBuilder builder = Http$.MODULE$.apply(sys).connectionTo((String)settings.overrideAuthority().getOrElse((Function0 & Serializable & scala.Serializable)() -> settings.serviceName())).withClientConnectionSettings(clientConnectionSettings);
        if (settings.useTls()) {
            HttpsConnectionContext connectionContext = ConnectionContext$.MODULE$.httpsClient((SSLContext)settings.sslContext().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Option<TrustManager> option = settings.trustManager();
                if (None$.MODULE$.equals(option)) {
                    return SSLContext.getDefault();
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    TrustManager trustManager = (TrustManager)some.value();
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init((KeyManager[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(KeyManager.class)), (TrustManager[])((Object[])new TrustManager[]{trustManager}), new SecureRandom());
                    return sslContext;
                }
                throw new MatchError(option);
            }));
            flow = builder.withCustomHttpsConnectionContext(connectionContext).managedPersistentHttp2();
        } else {
            flow = builder.managedPersistentHttp2WithPriorKnowledge();
        }
        Flow http2client = flow;
        Tuple2 tuple2 = (Tuple2)Source$.MODULE$.queue(4242, OverflowStrategy$.MODULE$.fail()).via((Graph)http2client).toMat((Graph)Sink$.MODULE$.foreach((Function1 & Serializable & scala.Serializable)res -> {
            PekkoHttpClientUtils$.$anonfun$createChannel$8(res);
            return BoxedUnit.UNIT;
        }), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem(sys));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        SourceQueueWithComplete queue = (SourceQueueWithComplete)tuple2._1();
        Future doneFuture = (Future)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)queue, (Object)doneFuture);
        SourceQueueWithComplete queue2 = (SourceQueueWithComplete)tuple22._1();
        Future doneFuture2 = (Future)tuple22._2();
        return new InternalChannel(queue2, doneFuture2, ec, sys, settings, writer){
            private final SourceQueueWithComplete queue$1;
            private final Future doneFuture$1;
            private final ExecutionContextExecutor ec$1;
            private final ClassicActorSystemProvider sys$1;
            private final GrpcClientSettings settings$1;
            private final GrpcProtocol.GrpcProtocolWriter writer$1;

            public void shutdown() {
                this.queue$1.complete();
            }

            public Future<Done> done() {
                return this.doneFuture$1;
            }

            public <I, O> Future<O> invoke(I request, MetadataImpl headers, MethodDescriptor<I, O> descriptor, CallOptions options) {
                return this.invokeWithMetadata(request, headers, descriptor, options).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.value(), (ExecutionContext)this.ec$1);
            }

            public <I, O> Future<GrpcSingleResponse<O>> invokeWithMetadata(I request, MetadataImpl headers, MethodDescriptor<I, O> descriptor, CallOptions options) {
                Source<O, Future<GrpcResponseMetadata>> src = this.invokeWithMetadata(Source$.MODULE$.single(request), headers, descriptor, false, options);
                Tuple2 tuple2 = (Tuple2)src.toMat((Graph)Sink$.MODULE$.head(), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem(this.sys$1));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Future metadataFuture = (Future)tuple2._1();
                Future resultFuture = (Future)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)metadataFuture, (Object)resultFuture);
                Future metadataFuture2 = (Future)tuple22._1();
                Future resultFuture2 = (Future)tuple22._2();
                return metadataFuture2.zip(resultFuture2).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        GrpcResponseMetadata metadata = (GrpcResponseMetadata)tuple2._1();
                        Object result = tuple2._2();
                        return new GrpcSingleResponse<O>(null, result, metadata){
                            private final Object result$1;
                            private final GrpcResponseMetadata metadata$1;

                            public O value() {
                                return (O)this.result$1;
                            }

                            public O getValue() {
                                return (O)this.result$1;
                            }

                            public Metadata headers() {
                                return this.metadata$1.headers();
                            }

                            public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                                return this.metadata$1.getHeaders();
                            }

                            public Future<Metadata> trailers() {
                                return this.metadata$1.trailers();
                            }

                            public CompletionStage<org.apache.pekko.grpc.javadsl.Metadata> getTrailers() {
                                return this.metadata$1.getTrailers();
                            }
                            {
                                this.result$1 = result$1;
                                this.metadata$1 = metadata$1;
                            }
                        };
                    }
                    throw new MatchError((Object)tuple2);
                }, (ExecutionContext)this.ec$1);
            }

            public <I, O> Source<O, Future<GrpcResponseMetadata>> invokeWithMetadata(Source<I, NotUsed> source, MetadataImpl headers, MethodDescriptor<I, O> descriptor, boolean streamingResponse, CallOptions options) {
                ProtobufSerializer serializer = PekkoHttpClientUtils$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$serializerFromMethodDescriptor$1(descriptor);
                ProtobufSerializer deserializer = PekkoHttpClientUtils$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$deserializerFromMethodDescriptor$1(descriptor);
                String scheme = this.settings$1.useTls() ? "https" : "http";
                HttpRequest httpRequest = GrpcRequestHelpers$.MODULE$.apply(Uri$.MODULE$.apply(new StringBuilder(4).append(scheme).append("://").append(this.settings$1.overrideAuthority().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.settings$1.serviceName())).append("/").append(descriptor.getFullMethodName()).toString()), (scala.collection.immutable.Seq<HttpHeader>)GrpcEntityHelpers$.MODULE$.metadataHeaders(headers.entries()), source, GrpcRequestHelpers$.MODULE$.apply$default$4(), serializer, this.writer$1, this.sys$1);
                return PekkoHttpClientUtils$.MODULE$.responseToSource((Future<HttpResponse>)PekkoHttpClientUtils$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$singleRequest$1(httpRequest, this.queue$1, this.ec$1), deserializer, (ExecutionContext)this.ec$1, Materializer$.MODULE$.matFromSystem(this.sys$1));
            }
            {
                this.queue$1 = queue$1;
                this.doneFuture$1 = doneFuture$1;
                this.ec$1 = ec$1;
                this.sys$1 = sys$1;
                this.settings$1 = settings$1;
                this.writer$1 = writer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$invoke$1(org.apache.pekko.grpc.GrpcSingleResponse ), $anonfun$invokeWithMetadata$1(scala.Tuple2 ), $anonfun$invokeWithMetadata$2(org.apache.pekko.grpc.internal.PekkoHttpClientUtils$$anon$1 )}, serializedLambda);
            }
        };
    }

    @InternalApi
    public <O> Source<O, Future<GrpcResponseMetadata>> responseToSource(Future<HttpResponse> response, ProtobufSerializer<O> deserializer, ExecutionContext ec, Materializer mat) {
        return Source$.MODULE$.lazyFutureSource((Function0 & Serializable & scala.Serializable)() -> response.map((Function1 & Serializable & scala.Serializable)response -> {
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (statusCode == null ? success != null : !statusCode.equals(success)) {
                HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()), mat);
                StatusRuntimeException failure = MODULE$.mapToStatusException((HttpResponse)response, (Seq<HttpHeader>)((Seq)Nil$.MODULE$));
                return Source$.MODULE$.failed((Throwable)failure).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$6 -> Future$.MODULE$.failed((Throwable)failure));
            }
            Try<Codec> try_ = Codecs$.MODULE$.detect((HttpMessage)response);
            if (try_ instanceof Success) {
                Source source;
                Success success2 = (Success)try_;
                Codec codec = (Codec)success2.value();
                GrpcProtocol.GrpcProtocolReader reader = GrpcProtocolNative$.MODULE$.newReader(codec);
                Promise trailerPromise = Promise$.MODULE$.apply();
                Future completionFuture = trailerPromise.future().flatMap((Function1 & Serializable & scala.Serializable)trailers -> MODULE$.parseResponseStatus((HttpResponse)response, (Seq<HttpHeader>)trailers), ec);
                ResponseEntity responseEntity = response.entity();
                if (responseEntity instanceof HttpEntity.Chunked) {
                    HttpEntity.Chunked chunked = (HttpEntity.Chunked)responseEntity;
                    Source chunks = chunked.chunks();
                    source = (Source)((FlowOpsMat)chunks.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        HttpEntity.ChunkStreamPart chunkStreamPart = x0$1;
                        if (chunkStreamPart instanceof HttpEntity.Chunk) {
                            HttpEntity.Chunk chunk = (HttpEntity.Chunk)chunkStreamPart;
                            ByteString data = chunk.data();
                            return data;
                        }
                        if (chunkStreamPart instanceof HttpEntity.LastChunk) {
                            HttpEntity.LastChunk lastChunk = (HttpEntity.LastChunk)chunkStreamPart;
                            scala.collection.immutable.Seq trailer = lastChunk.trailer();
                            trailerPromise.success((Object)trailer);
                            return ByteString$.MODULE$.empty();
                        }
                        throw new MatchError((Object)chunkStreamPart);
                    })).watchTermination((Function2 & Serializable & scala.Serializable)(x$7, done) -> {
                        done.onComplete((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)trailerPromise$1.trySuccess((Object)Nil$.MODULE$)), ec);
                        return BoxedUnit.UNIT;
                    });
                } else if (responseEntity instanceof HttpEntity.Strict) {
                    HttpEntity.Strict strict = (HttpEntity.Strict)responseEntity;
                    ByteString data = strict.data();
                    trailerPromise.success((Object)Nil$.MODULE$);
                    source = Source$.MODULE$.single((Object)data);
                } else {
                    HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()), mat);
                    throw MODULE$.mapToStatusException((HttpResponse)response, (Seq<HttpHeader>)((Seq)Nil$.MODULE$));
                }
                Source responseData = source;
                return ((Source)((Source)responseData.concat((Graph)Source$.MODULE$.maybe().mapMaterializedValue((Function1 & Serializable & scala.Serializable)promise -> promise.completeWith(completionFuture.map((Function1 & Serializable & scala.Serializable)x$9 -> None$.MODULE$, ec))))).via(new CancellationBarrierGraphStage()).via(reader.dataFrameDecoder()).map((Function1 & Serializable & scala.Serializable)bytes -> deserializer.deserialize((ByteString)bytes))).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$10 -> Future$.MODULE$.successful((Object)new GrpcResponseMetadata((HttpResponse)response, trailerPromise, ec){
                    private final HttpResponse response$2;
                    private final Promise trailerPromise$1;
                    private final ExecutionContext ec$2;

                    public Metadata headers() {
                        return new HeaderMetadataImpl((scala.collection.immutable.Seq<HttpHeader>)this.response$2.headers());
                    }

                    public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                        return new JavaMetadataImpl(new HeaderMetadataImpl((scala.collection.immutable.Seq<HttpHeader>)this.response$2.headers()));
                    }

                    public Future<Metadata> trailers() {
                        return this.trailerPromise$1.future().map((Function1 & Serializable & scala.Serializable)x$11 -> new HeaderMetadataImpl((scala.collection.immutable.Seq<HttpHeader>)x$11), this.ec$2);
                    }

                    public CompletionStage<org.apache.pekko.grpc.javadsl.Metadata> getTrailers() {
                        return FutureConverters.FutureOps$.MODULE$.asJava$extension(FutureConverters$.MODULE$.FutureOps(this.trailerPromise$1.future().map((Function1 & Serializable & scala.Serializable)h -> new JavaMetadataImpl(new HeaderMetadataImpl((scala.collection.immutable.Seq<HttpHeader>)h)), this.ec$2)));
                    }
                    {
                        this.response$2 = response$2;
                        this.trailerPromise$1 = trailerPromise$1;
                        this.ec$2 = ec$2;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$trailers$1(scala.collection.immutable.Seq ), $anonfun$getTrailers$1(scala.collection.immutable.Seq )}, serializedLambda);
                    }
                }));
            }
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                return Source$.MODULE$.failed(e).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$12 -> Future$.MODULE$.failed(e));
            }
            throw new MatchError(try_);
        }, ec)).mapMaterializedValue((Function1 & Serializable & scala.Serializable)x$13 -> x$13.flatten(Predef$.MODULE$.$conforms()));
    }

    private Future<BoxedUnit> parseResponseStatus(HttpResponse response, Seq<HttpHeader> trailers) {
        Some some;
        String string;
        scala.collection.immutable.Seq allHeaders = (scala.collection.immutable.Seq)response.headers().$plus$plus(trailers, Seq$.MODULE$.canBuildFrom());
        Option option = allHeaders.find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)PekkoHttpClientUtils$.$anonfun$parseResponseStatus$1(x$14))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.value());
        if (option instanceof Some && "0".equals(string = (String)(some = (Some)option).value())) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return Future$.MODULE$.failed((Throwable)this.mapToStatusException(response, trailers));
    }

    private StatusRuntimeException mapToStatusException(HttpResponse response, Seq<HttpHeader> trailers) {
        scala.collection.immutable.Seq allHeaders = (scala.collection.immutable.Seq)response.headers().$plus$plus(trailers, Seq$.MODULE$.canBuildFrom());
        Option option = allHeaders.find((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)PekkoHttpClientUtils$.$anonfun$mapToStatusException$1(x$16))).map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.value());
        if (None$.MODULE$.equals(option)) {
            return new StatusRuntimeException(this.mapHttpStatus(response).withDescription("No grpc-status found"));
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            String statusCode = (String)some.value();
            Option description = allHeaders.find((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)PekkoHttpClientUtils$.$anonfun$mapToStatusException$3(x$18))).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.value());
            return new StatusRuntimeException(Status.fromCodeValue((int)new StringOps(Predef$.MODULE$.augmentString(statusCode)).toInt()).withDescription((String)description.orNull(Predef$.MODULE$.$conforms())));
        }
        throw new MatchError((Object)option);
    }

    private Status mapHttpStatus(HttpResponse response) {
        StatusCode statusCode = response.status();
        StatusCodes.ClientError clientError = StatusCodes$.MODULE$.BadRequest();
        StatusCode statusCode2 = statusCode;
        if (!(clientError != null ? !clientError.equals(statusCode2) : statusCode2 != null)) {
            return Status.INTERNAL;
        }
        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
        StatusCode statusCode3 = statusCode;
        if (!(clientError2 != null ? !clientError2.equals(statusCode3) : statusCode3 != null)) {
            return Status.UNAUTHENTICATED;
        }
        StatusCodes.ClientError clientError3 = StatusCodes$.MODULE$.Forbidden();
        StatusCode statusCode4 = statusCode;
        if (!(clientError3 != null ? !clientError3.equals(statusCode4) : statusCode4 != null)) {
            return Status.PERMISSION_DENIED;
        }
        StatusCodes.ClientError clientError4 = StatusCodes$.MODULE$.NotFound();
        StatusCode statusCode5 = statusCode;
        if (!(clientError4 != null ? !clientError4.equals(statusCode5) : statusCode5 != null)) {
            return Status.UNIMPLEMENTED;
        }
        StatusCodes.ClientError clientError5 = StatusCodes$.MODULE$.TooManyRequests();
        StatusCode statusCode6 = statusCode;
        if (!(clientError5 != null ? !clientError5.equals(statusCode6) : statusCode6 != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError = StatusCodes$.MODULE$.BadGateway();
        StatusCode statusCode7 = statusCode;
        if (!(serverError != null ? !serverError.equals(statusCode7) : statusCode7 != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError2 = StatusCodes$.MODULE$.ServiceUnavailable();
        StatusCode statusCode8 = statusCode;
        if (!(serverError2 != null ? !serverError2.equals(statusCode8) : statusCode8 != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError3 = StatusCodes$.MODULE$.GatewayTimeout();
        StatusCode statusCode9 = statusCode;
        if (!(serverError3 != null ? !serverError3.equals(statusCode9) : statusCode9 != null)) {
            return Status.UNAVAILABLE;
        }
        return Status.UNKNOWN;
    }

    public static final /* synthetic */ void $anonfun$createChannel$2(String host$1, String authority) {
        String string = host$1;
        String string2 = authority;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null));
    }

    public static final /* synthetic */ Future $anonfun$createChannel$1(GrpcClientSettings settings$1, IntRef roundRobin$1, ExecutionContextExecutor ec$1, String host, int x$1) {
        settings$1.overrideAuthority().foreach((Function1 & Serializable & scala.Serializable)authority -> {
            PekkoHttpClientUtils$.$anonfun$createChannel$2(host, authority);
            return BoxedUnit.UNIT;
        });
        return settings$1.serviceDiscovery().lookup(settings$1.serviceName(), new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()).map((Function1 & Serializable & scala.Serializable)resolved -> {
            ++roundRobin$1.elem;
            ServiceDiscovery.ResolvedTarget target = (ServiceDiscovery.ResolvedTarget)resolved.addresses().apply(roundRobin$1.elem % resolved.addresses().size());
            Option option = target.address();
            if (option instanceof Some) {
                Some some = (Some)option;
                InetAddress address = (InetAddress)some.value();
                return new InetSocketAddress(address, BoxesRunTime.unboxToInt((Object)target.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> settings$1.defaultPort())));
            }
            if (None$.MODULE$.equals(option)) {
                return new InetSocketAddress(target.host(), BoxesRunTime.unboxToInt((Object)target.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> settings$1.defaultPort())));
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)ec$1);
    }

    public static final /* synthetic */ void $anonfun$createChannel$8(HttpResponse res) {
        ((PekkoHttpClientUtils.ResponsePromise)res.attribute(PekkoHttpClientUtils$ResponsePromise$.MODULE$.Key(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).get()).promise().trySuccess((Object)res);
    }

    public static final Future org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$singleRequest$1(HttpRequest request, SourceQueueWithComplete queue$1, ExecutionContextExecutor ec$1) {
        Promise p = Promise$.MODULE$.apply();
        return queue$1.offer((Object)request.addAttribute(PekkoHttpClientUtils$ResponsePromise$.MODULE$.Key(), (Object)new PekkoHttpClientUtils.ResponsePromise((Promise<HttpResponse>)p))).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> p.future(), (ExecutionContext)ec$1);
    }

    public static final ProtobufSerializer org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$serializerFromMethodDescriptor$1(MethodDescriptor descriptor) {
        return ((WithProtobufSerializer)descriptor.getRequestMarshaller()).protobufSerializer();
    }

    public static final ProtobufSerializer org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$deserializerFromMethodDescriptor$1(MethodDescriptor descriptor) {
        return ((WithProtobufSerializer)descriptor.getResponseMarshaller()).protobufSerializer();
    }

    public static final /* synthetic */ boolean $anonfun$parseResponseStatus$1(HttpHeader x$14) {
        String string = x$14.name();
        String string2 = "grpc-status";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mapToStatusException$1(HttpHeader x$16) {
        String string = x$16.name();
        String string2 = "grpc-status";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mapToStatusException$3(HttpHeader x$18) {
        String string = x$18.name();
        String string2 = "grpc-message";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private PekkoHttpClientUtils$() {
        MODULE$ = this;
    }
}

