/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import io.grpc.CallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.Discovery;
import org.apache.pekko.discovery.Discovery$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.SSLContextUtils$;
import org.apache.pekko.grpc.internal.HardcodedServiceDiscovery;
import org.apache.pekko.util.Helpers$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

public final class GrpcClientSettings$ {
    public static final GrpcClientSettings$ MODULE$ = new GrpcClientSettings$();

    private Function1<NettyChannelBuilder, NettyChannelBuilder> $lessinit$greater$default$18() {
        return (Function1 & Serializable)x -> (NettyChannelBuilder)Predef$.MODULE$.identity(x);
    }

    public GrpcClientSettings connectToServiceAt(String host, int port, ClassicActorSystemProvider actorSystem) {
        Config defaultServiceConfig = actorSystem.classicSystem().settings().config().getConfig("pekko.grpc.client").getConfig("\"*\"").withValue("host", ConfigValueFactory.fromAnyRef((Object)host)).withValue("port", ConfigValueFactory.fromAnyRef((Object)BoxesRunTime.boxToInteger((int)port)));
        return this.fromConfig(defaultServiceConfig, actorSystem);
    }

    public GrpcClientSettings fromConfig(String clientName, ClassicActorSystemProvider actorSystem) {
        Config pekkoGrpcClientConfig = actorSystem.classicSystem().settings().config().getConfig("pekko.grpc.client");
        Config defaultServiceConfig = pekkoGrpcClientConfig.getConfig("\"*\"");
        Predef$.MODULE$.require(pekkoGrpcClientConfig.hasPath(new StringBuilder(2).append("\"").append(clientName).append("\"").toString()), (Function0 & Serializable)() -> new StringBuilder(47).append("Config path `pekko.grpc.client.").append(clientName).append("` does not exist").toString());
        Config clientConfig = pekkoGrpcClientConfig.getConfig(new StringBuilder(2).append("\"").append(clientName).append("\"").toString()).withFallback((ConfigMergeable)defaultServiceConfig);
        return this.fromConfig(clientConfig, actorSystem);
    }

    public GrpcClientSettings usingServiceDiscovery(String serviceName, ClassicActorSystemProvider actorSystem) {
        Config clientConfiguration = actorSystem.classicSystem().settings().config().getConfig("pekko.grpc.client").getConfig("\"*\"");
        java.time.Duration JavaDurationOps_self = clientConfiguration.getDuration("service-discovery.resolve-timeout");
        Object var7_4 = null;
        java.time.Duration asScala$extension_$this = JavaDurationOps_self;
        Object var6_5 = null;
        FiniteDuration resolveTimeout = Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos());
        ServiceDiscovery discovery = Discovery$.MODULE$.get(actorSystem).discovery();
        return this.withConfigDefaults(serviceName, discovery, -1, resolveTimeout, clientConfiguration);
    }

    public GrpcClientSettings usingServiceDiscovery(String serviceName, ServiceDiscovery discovery, ClassicActorSystemProvider actorSystem) {
        Config clientConfiguration = actorSystem.classicSystem().settings().config().getConfig("pekko.grpc.client").getConfig("\"*\"");
        java.time.Duration JavaDurationOps_self = clientConfiguration.getDuration("service-discovery.resolve-timeout");
        Object var7_5 = null;
        java.time.Duration asScala$extension_$this = JavaDurationOps_self;
        Object var6_6 = null;
        FiniteDuration resolveTimeout = Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos());
        return this.withConfigDefaults(serviceName, discovery, -1, resolveTimeout, clientConfiguration);
    }

    public GrpcClientSettings fromConfig(Config clientConfiguration, ClassicActorSystemProvider sys) {
        ServiceDiscovery serviceDiscovery;
        FiniteDuration resolveTimeout;
        int port;
        String serviceName;
        block7: {
            String serviceDiscoveryMechanism;
            block6: {
                serviceDiscoveryMechanism = clientConfiguration.getString("service-discovery.mechanism");
                serviceName = clientConfiguration.getString("service-discovery.service-name");
                port = clientConfiguration.getInt("port");
                java.time.Duration JavaDurationOps_self = clientConfiguration.getDuration("service-discovery.resolve-timeout");
                Object var10_6 = null;
                java.time.Duration asScala$extension_$this = JavaDurationOps_self;
                Object var9_7 = null;
                resolveTimeout = Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos());
                switch (serviceDiscoveryMechanism == null ? 0 : serviceDiscoveryMechanism.hashCode()) {
                    case -892481938: {
                        if ("static".equals(serviceDiscoveryMechanism)) {
                            break;
                        }
                        break block6;
                    }
                    case 516376314: {
                        if ("grpc-dns".equals(serviceDiscoveryMechanism)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                String host = clientConfiguration.getString("host");
                Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(host)), (Function0 & Serializable)() -> "host can't be empty when service-discovery-mechanism is set to static or grpc-dns");
                serviceName = host;
                serviceDiscovery = this.staticServiceDiscovery(host, port);
                break block7;
            }
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(serviceName)), (Function0 & Serializable)() -> "Configuration must contain a service-name");
            serviceDiscovery = ((Discovery)Discovery$.MODULE$.apply(sys)).loadServiceDiscovery(serviceDiscoveryMechanism);
        }
        ServiceDiscovery sd = serviceDiscovery;
        return this.withConfigDefaults(serviceName, sd, port, resolveTimeout, clientConfiguration);
    }

    private GrpcClientSettings withConfigDefaults(String serviceName, ServiceDiscovery serviceDiscovery, int defaultPort, FiniteDuration resolveTimeout, Config clientConfiguration) {
        return new GrpcClientSettings(serviceName, serviceDiscovery, defaultPort, resolveTimeout, this.getOptionalString(clientConfiguration, "service-discovery.port-name"), this.getOptionalString(clientConfiguration, "service-discovery.protocol"), this.getOptionalInt(clientConfiguration, "connection-attempts"), (Option<CallCredentials>)None$.MODULE$, this.getOptionalString(clientConfiguration, "override-authority"), (Option<SslProvider>)this.getOptionalString(clientConfiguration, "ssl-provider").map((Function1 & Serializable)x0$1 -> {
            switch (x0$1 == null ? 0 : x0$1.hashCode()) {
                case -1263174782: {
                    if (!"openssl".equals(x0$1)) break;
                    return SslProvider.OPENSSL;
                }
                case -531986605: {
                    if (!"openssl_refcnt".equals(x0$1)) break;
                    return SslProvider.OPENSSL_REFCNT;
                }
                case 105073: {
                    if (!"jdk".equals(x0$1)) break;
                    return SslProvider.JDK;
                }
            }
            throw new IllegalArgumentException(new StringBuilder(78).append("ssl-provider: expected empty, 'jdk', 'openssl' or 'openssl_refcnt', but got [").append((String)x0$1).append("]").toString());
        }), (Option<SSLContext>)None$.MODULE$, (Option<TrustManager>)this.getOptionalString(clientConfiguration, "trusted").map((Function1 & Serializable)certificateResourcePath -> SSLContextUtils$.MODULE$.trustManagerFromResource((String)certificateResourcePath)), this.getPotentiallyInfiniteDuration(clientConfiguration, "deadline"), this.getOptionalString(clientConfiguration, "user-agent"), clientConfiguration.getBoolean("use-tls"), this.getOptionalString(clientConfiguration, "load-balancing-policy"), clientConfiguration.getString("backend"), this.$lessinit$greater$default$18());
    }

    private Option<String> getOptionalString(Config config, String path) {
        String string = config.getString(path);
        switch (string == null ? 0 : string.hashCode()) {
            case 0: {
                if (!"".equals(string)) break;
                return None$.MODULE$;
            }
        }
        return new Some((Object)string);
    }

    private Option<Object> getOptionalInt(Config config, String path) {
        int n = config.getInt(path);
        switch (n) {
            case -1: {
                return None$.MODULE$;
            }
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private Duration getPotentiallyInfiniteDuration(Config underlying, String path) {
        String string = Helpers$.MODULE$.toRootLowerCase(underlying.getString(path));
        switch (string == null ? 0 : string.hashCode()) {
            case 173173268: {
                if (!"infinite".equals(string)) break;
                return Duration$.MODULE$.Inf();
            }
        }
        return Duration$.MODULE$.fromNanos(underlying.getDuration(path).toNanos());
    }

    @InternalApi
    public HardcodedServiceDiscovery staticServiceDiscovery(String host, int port) {
        return new HardcodedServiceDiscovery(ServiceDiscovery.Resolved$.MODULE$.apply(host, (Seq)new .colon.colon((Object)ServiceDiscovery.ResolvedTarget$.MODULE$.apply(host, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)port)), (Option)None$.MODULE$), (List)Nil$.MODULE$)));
    }

    private GrpcClientSettings$() {
    }
}

