/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.GrpcResponseMetadata;
import org.apache.pekko.grpc.GrpcSingleResponse;
import org.apache.pekko.grpc.internal.ChannelUtils$;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.PekkoDiscoveryNameResolverProvider;
import org.apache.pekko.grpc.internal.PekkoNettyGrpcClientGraphStage;
import org.apache.pekko.grpc.internal.UnaryCallAdapter;
import org.apache.pekko.grpc.internal.UnaryCallWithMetadataAdapter;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;

@InternalApi
public final class NettyClientUtils$ {
    public static final NettyClientUtils$ MODULE$ = new NettyClientUtils$();

    @InternalApi
    public InternalChannel createChannel(GrpcClientSettings settings, LoggingAdapter log, ExecutionContext ec) {
        String string;
        ObjectRef builder = ObjectRef.create((Object)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)new StringBuilder(2).append("//").append(settings.serviceName()).toString()).flowControlWindow(0x100000).nameResolverFactory((NameResolver.Factory)new PekkoDiscoveryNameResolverProvider(settings.serviceDiscovery(), settings.defaultPort(), settings.serviceName(), settings.servicePortName(), settings.serviceProtocol(), settings.resolveTimeout(), ec))));
        if (!settings.useTls()) {
            builder.elem = ((NettyChannelBuilder)builder.elem).usePlaintext();
        } else {
            NettyChannelBuilder nettyChannelBuilder;
            builder.elem = ((NettyChannelBuilder)builder.elem).negotiationType(NegotiationType.TLS);
            Option<SSLContext> option = settings.sslContext();
            if (option instanceof Some) {
                SSLContext sslContext = (SSLContext)((Some)option).value();
                nettyChannelBuilder = ((NettyChannelBuilder)builder.elem).sslContext(this.createNettySslContext(sslContext));
            } else if (None$.MODULE$.equals(option)) {
                Option<SslProvider> option2 = settings.sslProvider();
                Option<TrustManager> option3 = settings.trustManager();
                if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option2)) {
                    nettyChannelBuilder = (NettyChannelBuilder)builder.elem;
                } else {
                    SslContextBuilder sslContextBuilder;
                    SslContextBuilder sslContextBuilder2;
                    if (None$.MODULE$.equals(option2)) {
                        sslContextBuilder2 = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient());
                    } else if (option2 instanceof Some) {
                        SslProvider sslProvider = (SslProvider)((Some)option2).value();
                        sslContextBuilder2 = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient(), (SslProvider)sslProvider);
                    } else {
                        throw new MatchError(option2);
                    }
                    SslContextBuilder context = sslContextBuilder2;
                    NettyChannelBuilder nettyChannelBuilder2 = (NettyChannelBuilder)builder.elem;
                    if (None$.MODULE$.equals(option3)) {
                        sslContextBuilder = context;
                    } else if (option3 instanceof Some) {
                        TrustManager trustManager = (TrustManager)((Some)option3).value();
                        sslContextBuilder = context.trustManager(trustManager);
                    } else {
                        throw new MatchError(option3);
                    }
                    nettyChannelBuilder = nettyChannelBuilder2.sslContext(sslContextBuilder.build());
                }
            } else {
                throw new MatchError(option);
            }
            builder.elem = nettyChannelBuilder;
        }
        builder.elem = (NettyChannelBuilder)settings.loadBalancingPolicy().map((Function1 & Serializable)x$1 -> (NettyChannelBuilder)((NettyChannelBuilder)builder$1.elem).defaultLoadBalancingPolicy(x$1)).getOrElse((Function0 & Serializable)() -> (NettyChannelBuilder)builder$1.elem);
        builder.elem = (NettyChannelBuilder)settings.overrideAuthority().map((Function1 & Serializable)x$2 -> (NettyChannelBuilder)((NettyChannelBuilder)builder$1.elem).overrideAuthority(x$2)).getOrElse((Function0 & Serializable)() -> (NettyChannelBuilder)builder$1.elem);
        builder.elem = (NettyChannelBuilder)settings.userAgent().map((Function1 & Serializable)x$3 -> (NettyChannelBuilder)((NettyChannelBuilder)builder$1.elem).userAgent(x$3)).getOrElse((Function0 & Serializable)() -> (NettyChannelBuilder)builder$1.elem);
        builder.elem = (NettyChannelBuilder)settings.channelBuilderOverrides().apply((Object)((NettyChannelBuilder)builder.elem));
        Option<String> option = settings.loadBalancingPolicy();
        Option connectionAttempts = (None$.MODULE$.equals(option) ? true : option instanceof Some && "pick_first".equals(string = (String)((Some)option).value())) ? settings.connectionAttempts() : settings.connectionAttempts().flatMap((Function1 & Serializable)x0$1 -> NettyClientUtils$.$anonfun$createChannel$7(BoxesRunTime.unboxToInt((Object)x0$1)));
        ManagedChannel channel = ((NettyChannelBuilder)builder.elem).build();
        Promise channelReadyPromise = Promise$.MODULE$.apply();
        Promise channelClosedPromise = Promise$.MODULE$.apply();
        ChannelUtils$.MODULE$.monitorChannel((Promise<BoxedUnit>)channelReadyPromise, (Promise<Done>)channelClosedPromise, channel, (Option<Object>)connectionAttempts, log);
        channelReadyPromise.future().onComplete((Function1 & Serializable)x0$2 -> {
            if (x0$2 instanceof Success) {
                BoxedUnit boxedUnit = (BoxedUnit)((Success)x0$2).value();
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit) : boxedUnit != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (x0$2 instanceof Failure) {
                Throwable e = ((Failure)x0$2).exception();
                channel.shutdown();
                return BoxesRunTime.boxToBoolean((boolean)channelClosedPromise.tryFailure(e));
            }
            throw new MatchError(x0$2);
        }, ec);
        return new InternalChannel(channel, channelClosedPromise, settings){
            private final ManagedChannel channel$1;
            private final Promise channelClosedPromise$1;
            private final GrpcClientSettings settings$1;

            public void shutdown() {
                this.channel$1.shutdown();
            }

            public Future<Done> done() {
                return this.channelClosedPromise$1.future();
            }

            public <I, O> Future<O> invoke(I request, MetadataImpl headers, MethodDescriptor<I, O> descriptor, CallOptions options) {
                UnaryCallAdapter<Res> listener = new UnaryCallAdapter<Res>();
                ClientCall call = this.channel$1.newCall(descriptor, NettyClientUtils$.MODULE$.callOptionsWithDeadline(options, this.settings$1));
                call.start(listener, headers.toGoogleGrpcMetadata());
                call.sendMessage(request);
                call.halfClose();
                call.request(2);
                return listener.future();
            }

            public <I, O> Future<GrpcSingleResponse<O>> invokeWithMetadata(I request, MetadataImpl headers, MethodDescriptor<I, O> descriptor, CallOptions options) {
                UnaryCallWithMetadataAdapter<Res> listener = new UnaryCallWithMetadataAdapter<Res>();
                ClientCall call = this.channel$1.newCall(descriptor, NettyClientUtils$.MODULE$.callOptionsWithDeadline(options, this.settings$1));
                call.start(listener, headers.toGoogleGrpcMetadata());
                call.sendMessage(request);
                call.halfClose();
                call.request(2);
                return listener.future();
            }

            public <I, O> Source<O, Future<GrpcResponseMetadata>> invokeWithMetadata(Source<I, NotUsed> source, MetadataImpl headers, MethodDescriptor<I, O> descriptor, boolean streamingResponse, CallOptions options) {
                Flow<I, O, Future<GrpcResponseMetadata>> flow = this.createFlow(headers, descriptor, streamingResponse, NettyClientUtils$.MODULE$.callOptionsWithDeadline(options, this.settings$1));
                return source.viaMat(flow, Keep$.MODULE$.right());
            }

            private <I, O> Flow<I, O, Future<GrpcResponseMetadata>> createFlow(MetadataImpl headers, MethodDescriptor<I, O> descriptor, boolean streamingResponse, CallOptions options) {
                return Flow$.MODULE$.fromGraph(new PekkoNettyGrpcClientGraphStage<I, O>(descriptor, (Channel)this.channel$1, options, streamingResponse, headers));
            }
            {
                this.channel$1 = channel$1;
                this.channelClosedPromise$1 = channelClosedPromise$1;
                this.settings$1 = settings$1;
            }
        };
    }

    @InternalApi
    private SslContext createNettySslContext(SSLContext javaSslContext) {
        JdkSslContext nettySslContext = (JdkSslContext)GrpcSslContexts.configure((SslContextBuilder)GrpcSslContexts.forClient(), (SslProvider)SslProvider.JDK).build();
        Field nettySslContextField = JdkSslContext.class.getDeclaredField("sslContext");
        nettySslContextField.setAccessible(true);
        nettySslContextField.set(nettySslContext, javaSslContext);
        return nettySslContext;
    }

    @InternalApi
    public CallOptions callOptions(GrpcClientSettings settings) {
        return (CallOptions)settings.callCredentials().map((Function1 & Serializable)x$1 -> CallOptions.DEFAULT.withCallCredentials(x$1)).getOrElse((Function0 & Serializable)() -> CallOptions.DEFAULT);
    }

    @InternalApi
    public CallOptions callOptionsWithDeadline(CallOptions defaultOptions, GrpcClientSettings settings) {
        Duration duration = settings.deadline();
        if (duration instanceof FiniteDuration) {
            FiniteDuration finiteDuration = (FiniteDuration)duration;
            return defaultOptions.withDeadlineAfter(finiteDuration.toMillis(), TimeUnit.MILLISECONDS);
        }
        return defaultOptions;
    }

    public static final /* synthetic */ Option $anonfun$createChannel$7(int x0$1) {
        switch (x0$1) {
            case 1: {
                return new Some((Object)BoxesRunTime.boxToInteger((int)1));
            }
        }
        return None$.MODULE$;
    }

    private NettyClientUtils$() {
    }
}

