/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.pekko.discovery.Lookup$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.internal.PekkoDiscoveryNameResolver$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Uf\u0001\u0002\f\u0018\u0001\tB\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aq\u0007\u0001B\u0001B\u0003%\u0001\b\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011!9\u0005A!A!\u0002\u0013!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011E\u0003!Q1A\u0005\u0004IC\u0001b\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u00061\u0002!\t!\u0017\u0005\u0006I\u0002!\t%\u001a\u0005\bM\u0002\u0011\r\u0011\"\u0001h\u0011\u00191\b\u0001)A\u0005Q\")q\u000f\u0001C!q\")a\u0010\u0001C!\u007f\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0004\u0001\u0011%\u0011\u0011\u0002\u0005\u0007\u0003#\u0003A\u0011I@\b\u000f\u0005Mu\u0003#\u0001\u0002\u0016\u001a1ac\u0006E\u0001\u0003/Ca\u0001W\n\u0005\u0002\u0005}\u0005bBAQ'\u0011\u0005\u00111\u0015\u0002\u001b!\u0016\\7n\u001c#jg\u000e|g/\u001a:z\u001d\u0006lWMU3t_24XM\u001d\u0006\u00031e\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u00035m\tAa\u001a:qG*\u0011A$H\u0001\u0006a\u0016\\7n\u001c\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0019\u0003C\u0001\u0013)\u001b\u0005)#B\u0001\u000e'\u0015\u00059\u0013AA5p\u0013\tISE\u0001\u0007OC6,'+Z:pYZ,'/A\u0005eSN\u001cwN^3ssB\u0011AFL\u0007\u0002[)\u0011!fG\u0005\u0003_5\u0012\u0001cU3sm&\u001cW\rR5tG>4XM]=\u0002\u0017\u0011,g-Y;miB{'\u000f\u001e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0004\u0013:$\u0018aC:feZL7-\u001a(b[\u0016\u0004\"!\u000f!\u000f\u0005ir\u0004CA\u001e4\u001b\u0005a$BA\u001f\"\u0003\u0019a$o\\8u}%\u0011qhM\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@g\u0005A\u0001o\u001c:u\u001d\u0006lW\rE\u00023\u000bbJ!AR\u001a\u0003\r=\u0003H/[8o\u0003!\u0001(o\u001c;pG>d\u0017A\u0004:fg>dg/\u001a+j[\u0016|W\u000f\u001e\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\u001dN\n!bY8oGV\u0014(/\u001a8u\u0013\t\u00016J\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002\u0005\u0015\u001cW#A*\u0011\u0005Q+V\"A'\n\u0005Yk%\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0003\r)7\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fisv\fY1cGR\u00111,\u0018\t\u00039\u0002i\u0011a\u0006\u0005\u0006#&\u0001\u001da\u0015\u0005\u0006U%\u0001\ra\u000b\u0005\u0006a%\u0001\r!\r\u0005\u0006o%\u0001\r\u0001\u000f\u0005\u0006\u0007&\u0001\r\u0001\u0012\u0005\u0006\u000f&\u0001\r\u0001\u0012\u0005\u0006\u0011&\u0001\r!S\u0001\u0014O\u0016$8+\u001a:wS\u000e,\u0017)\u001e;i_JLG/\u001f\u000b\u0002q\u0005AA.[:uK:,'/F\u0001i!\r!\u0016n[\u0005\u0003U6\u0013q\u0001\u0015:p[&\u001cX\r\u0005\u0002mg:\u0011Q.\u001d\b\u0003]Bt!aO8\n\u0003\u001dJ!A\u0007\u0014\n\u0005I,\u0013\u0001\u0004(b[\u0016\u0014Vm]8mm\u0016\u0014\u0018B\u0001;v\u0005!a\u0015n\u001d;f]\u0016\u0014(B\u0001:&\u0003%a\u0017n\u001d;f]\u0016\u0014\b%A\u0003ti\u0006\u0014H\u000f\u0006\u0002zyB\u0011!G_\u0005\u0003wN\u0012A!\u00168ji\")Q0\u0004a\u0001W\u0006\tA.A\u0004sK\u001a\u0014Xm\u001d5\u0015\u0003e\fa\u0001\\8pWV\u0004HcA=\u0002\u0006!)am\u0004a\u0001W\u0006I\u0011\r\u001a3sKN\u001cXm\u001d\u000b\u0005\u0003\u0017\t\t\u0003\u0005\u0004\u0002\u000e\u0005]\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005!Q\u000f^5m\u0015\t\t)\"\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003\u001f\u0011A\u0001T5tiB\u0019A%!\b\n\u0007\u0005}QE\u0001\fFcVLg/\u00197f]R\fE\r\u001a:fgN<%o\\;q\u0011\u001d\t9\u0001\u0005a\u0001\u0003G\u0001b!!\n\u00020\u0005Ub\u0002BA\u0014\u0003Wq1aOA\u0015\u0013\u0005!\u0014bAA\u0017g\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0019\u0003g\u00111aU3r\u0015\r\tic\r\t\u0005\u0003o\t9E\u0004\u0003\u0002:\u0005\rc\u0002BA\u001e\u0003\u0003rA!!\u0010\u0002@5\tQ$\u0003\u0002\u001d;%\u0011!fG\u0005\u0004\u0003\u000bj\u0013\u0001E*feZL7-\u001a#jg\u000e|g/\u001a:z\u0013\u0011\tI%a\u0013\u0003\u001dI+7o\u001c7wK\u0012$\u0016M]4fi*\u0019\u0011QI\u0017)\u000bA\ty%!\u0019\u0011\u000bI\n\t&!\u0016\n\u0007\u0005M3G\u0001\u0004uQJ|wo\u001d\t\u0005\u0003/\ni&\u0004\u0002\u0002Z)!\u00111LA\n\u0003\rqW\r^\u0005\u0005\u0003?\nIF\u0001\u000bV].twn\u001e8I_N$X\t_2faRLwN\\\u0019\u0007=a\n\u0019'a$2\u0013\r\n)'!\u001c\u0002\u0006\u0006=T\u0003BA4\u0003S*\u0012\u0001\u000f\u0003\b\u0003W\n#\u0019AA;\u0005\u0005!\u0016\u0002BA8\u0003c\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA:g\u00051A\u000f\u001b:poN\fB!a\u001e\u0002~A\u0019!'!\u001f\n\u0007\u0005m4GA\u0004O_RD\u0017N\\4\u0011\t\u0005}\u0014\u0011\u0011\b\u0004e\u0005-\u0012\u0002BAB\u0003g\u0011\u0011\u0002\u00165s_^\f'\r\\32\u0013\r\n9)!#\u0002\f\u0006Mdb\u0001\u001a\u0002\n&\u0019\u00111O\u001a2\u000b\t\u00124'!$\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n)&\u0001\u0005tQV$Hm\\<o\u0003i\u0001Vm[6p\t&\u001c8m\u001c<feft\u0015-\\3SKN|GN^3s!\ta6cE\u0002\u0014\u00033\u00032AMAN\u0013\r\tij\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005U\u0015!B1qa2LH\u0003BAS\u0003S#2aWAT\u0011\u0015\tV\u0003q\u0001T\u0011\u001d\tY+\u0006a\u0001\u0003[\u000b\u0001b]3ui&twm\u001d\t\u0005\u0003_\u000b\t,D\u0001\u001a\u0013\r\t\u0019,\u0007\u0002\u0013\u000fJ\u00048m\u00117jK:$8+\u001a;uS:<7\u000f")
public class PekkoDiscoveryNameResolver
extends NameResolver {
    private final ServiceDiscovery discovery;
    private final int defaultPort;
    private final String serviceName;
    private final Option<String> portName;
    private final Option<String> protocol;
    private final FiniteDuration resolveTimeout;
    private final ExecutionContext ec;
    private final Promise<NameResolver.Listener> listener;

    public static PekkoDiscoveryNameResolver apply(GrpcClientSettings settings, ExecutionContext ec) {
        return PekkoDiscoveryNameResolver$.MODULE$.apply(settings, ec);
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public String getServiceAuthority() {
        return this.serviceName;
    }

    public Promise<NameResolver.Listener> listener() {
        return this.listener;
    }

    public void start(NameResolver.Listener l) {
        this.listener().trySuccess((Object)l);
        this.lookup(l);
    }

    public void refresh() {
        this.listener().future().onComplete((Function1 & Serializable)x0$1 -> {
            PekkoDiscoveryNameResolver.$anonfun$refresh$1(this, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public void lookup(NameResolver.Listener listener) {
        this.discovery.lookup(Lookup$.MODULE$.apply(this.serviceName, this.portName, this.protocol), this.resolveTimeout).onComplete((Function1 & Serializable)x0$1 -> {
            PekkoDiscoveryNameResolver.$anonfun$lookup$1(this, listener, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    private List<EquivalentAddressGroup> addresses(scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget> addresses) throws UnknownHostException {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)addresses.map((Function1 & Serializable)target -> {
            int port = BoxesRunTime.unboxToInt((Object)target.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> $this.defaultPort));
            InetAddress address = (InetAddress)target.address().getOrElse((Function0 & Serializable)() -> InetAddress.getByName(target.host()));
            return new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(address, port));
        })).asJava();
    }

    public void shutdown() {
    }

    public static final /* synthetic */ void $anonfun$refresh$1(PekkoDiscoveryNameResolver $this, Try x0$1) {
        if (x0$1 instanceof Success) {
            NameResolver.Listener l = (NameResolver.Listener)((Success)x0$1).value();
            $this.lookup(l);
            return;
        }
        if (x0$1 instanceof Failure) {
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$lookup$1(PekkoDiscoveryNameResolver $this, NameResolver.Listener listener$1, Try x0$1) {
        if (x0$1 instanceof Success) {
            ServiceDiscovery.Resolved result = (ServiceDiscovery.Resolved)((Success)x0$1).value();
            try {
                listener$1.onAddresses($this.addresses((scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget>)result.addresses()), Attributes.EMPTY);
                return;
            }
            catch (UnknownHostException e) {
                listener$1.onError(Status.UNKNOWN.withDescription(e.getMessage()));
                return;
            }
        }
        if (x0$1 instanceof Failure) {
            Throwable e = ((Failure)x0$1).exception();
            listener$1.onError(Status.UNKNOWN.withDescription(e.getMessage()));
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public PekkoDiscoveryNameResolver(ServiceDiscovery discovery, int defaultPort, String serviceName, Option<String> portName, Option<String> protocol, FiniteDuration resolveTimeout, ExecutionContext ec) {
        this.discovery = discovery;
        this.defaultPort = defaultPort;
        this.serviceName = serviceName;
        this.portName = portName;
        this.protocol = protocol;
        this.resolveTimeout = resolveTimeout;
        this.ec = ec;
        this.listener = Promise$.MODULE$.apply();
    }
}

