/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.concurrent.CompletionStage;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.Done;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.GrpcProtocol;
import org.apache.pekko.grpc.GrpcResponseMetadata;
import org.apache.pekko.grpc.GrpcSingleResponse;
import org.apache.pekko.grpc.ProtobufSerializer;
import org.apache.pekko.grpc.internal.CancellationBarrierGraphStage;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.grpc.internal.Codecs$;
import org.apache.pekko.grpc.internal.GrpcEntityHelpers$;
import org.apache.pekko.grpc.internal.GrpcProtocolNative$;
import org.apache.pekko.grpc.internal.GrpcRequestHelpers$;
import org.apache.pekko.grpc.internal.HeaderMetadataImpl;
import org.apache.pekko.grpc.internal.Identity$;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.JavaMetadataImpl;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils$ResponsePromise$;
import org.apache.pekko.grpc.internal.WithProtobufSerializer;
import org.apache.pekko.grpc.scaladsl.Metadata;
import org.apache.pekko.http.impl.util.JavaMapping;
import org.apache.pekko.http.impl.util.JavaMapping$;
import org.apache.pekko.http.javadsl.model.AttributeKey;
import org.apache.pekko.http.javadsl.model.HttpMessage;
import org.apache.pekko.http.scaladsl.ClientTransport$;
import org.apache.pekko.http.scaladsl.ConnectionContext$;
import org.apache.pekko.http.scaladsl.Http$;
import org.apache.pekko.http.scaladsl.HttpsConnectionContext;
import org.apache.pekko.http.scaladsl.OutgoingConnectionBuilder;
import org.apache.pekko.http.scaladsl.model.AttributeKeys$;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.RawHeader;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings;
import org.apache.pekko.http.scaladsl.settings.ClientConnectionSettings$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import org.apache.pekko.stream.OverflowStrategy$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.FlowOpsMat;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.scaladsl.SourceQueueWithComplete;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.jdk.javaapi.FutureConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class PekkoHttpClientUtils$ {
    public static final PekkoHttpClientUtils$ MODULE$ = new PekkoHttpClientUtils$();

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public InternalChannel createChannel(GrpcClientSettings settings, LoggingAdapter log, ClassicActorSystemProvider sys) {
        void var13_13;
        void var12_12;
        Flow flow;
        ExecutionContextExecutor ec = sys.classicSystem().dispatcher();
        log.debug("Creating gRPC client channel");
        GrpcProtocol.GrpcProtocolWriter writer = GrpcProtocolNative$.MODULE$.newWriter(Identity$.MODULE$);
        IntRef roundRobin = IntRef.create((int)0);
        ClientConnectionSettings clientConnectionSettings = ((ClientConnectionSettings)ClientConnectionSettings$.MODULE$.apply(sys)).withTransport(ClientTransport$.MODULE$.withCustomResolver((Function2 & Serializable)(host, x$1) -> PekkoHttpClientUtils$.$anonfun$createChannel$1(settings, roundRobin, ec, host, BoxesRunTime.unboxToInt((Object)x$1))));
        OutgoingConnectionBuilder builder = Http$.MODULE$.apply(sys).connectionTo((String)settings.overrideAuthority().getOrElse((Function0 & Serializable)() -> settings.serviceName())).withClientConnectionSettings(clientConnectionSettings);
        if (settings.useTls()) {
            HttpsConnectionContext connectionContext = ConnectionContext$.MODULE$.httpsClient((SSLContext)settings.sslContext().getOrElse((Function0 & Serializable)() -> {
                Option<TrustManager> option = settings.trustManager();
                if (None$.MODULE$.equals(option)) {
                    return SSLContext.getDefault();
                }
                if (option instanceof Some) {
                    TrustManager trustManager = (TrustManager)((Some)option).value();
                    SSLContext sslContext = SSLContext.getInstance("TLS");
                    sslContext.init((KeyManager[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(KeyManager.class)), new TrustManager[]{trustManager}, new SecureRandom());
                    return sslContext;
                }
                throw new MatchError(option);
            }));
            flow = builder.withCustomHttpsConnectionContext(connectionContext).managedPersistentHttp2();
        } else {
            flow = builder.managedPersistentHttp2WithPriorKnowledge();
        }
        Flow http2client = flow;
        Tuple2 tuple2 = (Tuple2)Source$.MODULE$.queue(4242, OverflowStrategy$.MODULE$.fail()).via((Graph)http2client).toMat((Graph)Sink$.MODULE$.foreach((Function1 & Serializable)res -> {
            PekkoHttpClientUtils$.$anonfun$createChannel$8(res);
            return BoxedUnit.UNIT;
        }), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem(sys));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        SourceQueueWithComplete queue = (SourceQueueWithComplete)tuple2._1();
        Future doneFuture = (Future)tuple2._2();
        return new InternalChannel((SourceQueueWithComplete)var12_12, (Future)var13_13, ec, sys, settings, writer){
            private final SourceQueueWithComplete queue$1;
            private final Future doneFuture$1;
            private final ExecutionContextExecutor ec$1;
            private final ClassicActorSystemProvider sys$1;
            private final GrpcClientSettings settings$1;
            private final GrpcProtocol.GrpcProtocolWriter writer$1;

            public void shutdown() {
                this.queue$1.complete();
            }

            public Future<Done> done() {
                return this.doneFuture$1;
            }

            public <I, O> Future<O> invoke(I request, MetadataImpl headers, MethodDescriptor<I, O> descriptor, CallOptions options) {
                return this.invokeWithMetadata(request, headers, descriptor, options).map((Function1 & Serializable)x$4 -> x$4.value(), (ExecutionContext)this.ec$1);
            }

            /*
             * WARNING - void declaration
             */
            public <I, O> Future<GrpcSingleResponse<O>> invokeWithMetadata(I request, MetadataImpl headers, MethodDescriptor<I, O> descriptor, CallOptions options) {
                void var7_7;
                void var6_6;
                Tuple2 tuple2 = (Tuple2)this.invokeWithMetadata(Source$.MODULE$.single(request), headers, descriptor, false, options).toMat((Graph)Sink$.MODULE$.head(), Keep$.MODULE$.both()).run(Materializer$.MODULE$.matFromSystem(this.sys$1));
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                Future metadataFuture = (Future)tuple2._1();
                Future resultFuture = (Future)tuple2._2();
                return var6_6.zip((Future)var7_7).map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        GrpcResponseMetadata metadata = (GrpcResponseMetadata)x0$1._1();
                        Object result = x0$1._2();
                        return new GrpcSingleResponse<O>(null, result, metadata){
                            private final Object result$1;
                            private final GrpcResponseMetadata metadata$1;

                            public O value() {
                                return (O)this.result$1;
                            }

                            public O getValue() {
                                return (O)this.result$1;
                            }

                            public Metadata headers() {
                                return this.metadata$1.headers();
                            }

                            public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                                return this.metadata$1.getHeaders();
                            }

                            public Future<Metadata> trailers() {
                                return this.metadata$1.trailers();
                            }

                            public CompletionStage<org.apache.pekko.grpc.javadsl.Metadata> getTrailers() {
                                return this.metadata$1.getTrailers();
                            }
                            {
                                this.result$1 = result$1;
                                this.metadata$1 = metadata$1;
                            }
                        };
                    }
                    throw new MatchError(null);
                }, (ExecutionContext)this.ec$1);
            }

            public <I, O> Source<O, Future<GrpcResponseMetadata>> invokeWithMetadata(Source<I, NotUsed> source, MetadataImpl headers, MethodDescriptor<I, O> descriptor, boolean streamingResponse, CallOptions options) {
                ProtobufSerializer serializer = PekkoHttpClientUtils$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$serializerFromMethodDescriptor$1(descriptor);
                ProtobufSerializer deserializer = PekkoHttpClientUtils$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$deserializerFromMethodDescriptor$1(descriptor);
                String scheme = this.settings$1.useTls() ? "https" : "http";
                HttpRequest httpRequest = GrpcRequestHelpers$.MODULE$.apply(Uri$.MODULE$.apply(new StringBuilder(4).append(scheme).append("://").append(this.settings$1.overrideAuthority().getOrElse((Function0 & Serializable)() -> $this.settings$1.serviceName())).append("/").append(descriptor.getFullMethodName()).toString()), (Seq<HttpHeader>)GrpcEntityHelpers$.MODULE$.metadataHeaders(headers.entries()), source, GrpcRequestHelpers$.MODULE$.apply$default$4(), serializer, this.writer$1, this.sys$1);
                return PekkoHttpClientUtils$.MODULE$.responseToSource((Future<HttpResponse>)PekkoHttpClientUtils$.org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$singleRequest$1(httpRequest, this.queue$1, this.ec$1), deserializer, (ExecutionContext)this.ec$1, Materializer$.MODULE$.matFromSystem(this.sys$1));
            }
            {
                this.queue$1 = queue$1;
                this.doneFuture$1 = doneFuture$1;
                this.ec$1 = ec$1;
                this.sys$1 = sys$1;
                this.settings$1 = settings$1;
                this.writer$1 = writer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$invoke$1(org.apache.pekko.grpc.GrpcSingleResponse ), $anonfun$invokeWithMetadata$1(scala.Tuple2 ), $anonfun$invokeWithMetadata$2(org.apache.pekko.grpc.internal.PekkoHttpClientUtils$$anon$1 )}, serializedLambda);
            }
        };
    }

    @InternalApi
    public <O> Source<O, Future<GrpcResponseMetadata>> responseToSource(Future<HttpResponse> response, ProtobufSerializer<O> deserializer, ExecutionContext ec, Materializer mat) {
        return Source$.MODULE$.lazyFutureSource((Function0 & Serializable)() -> response.map((Function1 & Serializable)response -> {
            StatusCode statusCode = response.status();
            StatusCodes.Success success = StatusCodes$.MODULE$.OK();
            if (statusCode == null ? success != null : !statusCode.equals(success)) {
                HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()), mat);
                StatusRuntimeException failure = MODULE$.mapToStatusException((HttpResponse)response, (Seq<HttpHeader>)((Seq)Seq$.MODULE$.empty()));
                return Source$.MODULE$.failed((Throwable)failure).mapMaterializedValue((Function1 & Serializable)x$6 -> Future$.MODULE$.failed((Throwable)failure));
            }
            Try<Codec> try_ = Codecs$.MODULE$.detect((HttpMessage)response);
            if (try_ instanceof Success) {
                Source source;
                Codec codec = (Codec)((Success)try_).value();
                GrpcProtocol.GrpcProtocolReader reader = GrpcProtocolNative$.MODULE$.newReader(codec);
                Promise trailerPromise = Promise$.MODULE$.apply();
                Future completionFuture = trailerPromise.future().flatMap((Function1 & Serializable)trailers -> MODULE$.parseResponseStatus((HttpResponse)response, (Seq<HttpHeader>)trailers), ec);
                ResponseEntity responseEntity = response.entity();
                if (responseEntity instanceof HttpEntity.Chunked) {
                    source = (Source)((FlowOpsMat)((HttpEntity.Chunked)responseEntity).chunks().map((Function1 & Serializable)x0$1 -> {
                        if (x0$1 instanceof HttpEntity.Chunk) {
                            return ((HttpEntity.Chunk)x0$1).data();
                        }
                        if (x0$1 instanceof HttpEntity.LastChunk) {
                            Seq trailer = ((HttpEntity.LastChunk)x0$1).trailer();
                            trailerPromise.success((Object)trailer);
                            return ByteString$.MODULE$.empty();
                        }
                        throw new MatchError(x0$1);
                    })).watchTermination((Function2 & Serializable)(x$7, done) -> {
                        done.onComplete((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)trailerPromise$1.trySuccess((Object)Seq$.MODULE$.empty())), ec);
                        return BoxedUnit.UNIT;
                    });
                } else if (responseEntity instanceof HttpEntity.Strict) {
                    ByteString data = ((HttpEntity.Strict)responseEntity).data();
                    Seq trailers2 = (Seq)((Seq)response.attribute((AttributeKey)AttributeKeys$.MODULE$.trailer(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).map((Function1 & Serializable)x$9 -> x$9.headers()).getOrElse((Function0 & Serializable)() -> (Seq)Seq$.MODULE$.empty())).map((Function1 & Serializable)h -> new RawHeader((String)h._1(), (String)h._2()));
                    trailerPromise.success((Object)trailers2);
                    source = Source$.MODULE$.single((Object)data);
                } else {
                    HttpEntity.HttpEntityScalaDSLSugar$.MODULE$.discardBytes$extension(HttpEntity$.MODULE$.HttpEntityScalaDSLSugar((HttpEntity)response.entity()), mat);
                    throw MODULE$.mapToStatusException((HttpResponse)response, (Seq<HttpHeader>)((Seq)scala.package$.MODULE$.Seq().empty()));
                }
                return ((Source)((Source)source.concat((Graph)Source$.MODULE$.maybe().mapMaterializedValue((Function1 & Serializable)promise -> promise.completeWith(completionFuture.map((Function1 & Serializable)x$10 -> None$.MODULE$, ec))))).via(new CancellationBarrierGraphStage()).via(reader.dataFrameDecoder()).map((Function1 & Serializable)bytes -> deserializer.deserialize((ByteString)bytes))).mapMaterializedValue((Function1 & Serializable)x$11 -> Future$.MODULE$.successful((Object)new GrpcResponseMetadata((HttpResponse)response, trailerPromise, ec){
                    private final HttpResponse response$2;
                    private final Promise trailerPromise$1;
                    private final ExecutionContext ec$2;

                    public Metadata headers() {
                        return new HeaderMetadataImpl((Seq<HttpHeader>)this.response$2.headers());
                    }

                    public org.apache.pekko.grpc.javadsl.Metadata getHeaders() {
                        return new JavaMetadataImpl(new HeaderMetadataImpl((Seq<HttpHeader>)this.response$2.headers()));
                    }

                    public Future<Metadata> trailers() {
                        return this.trailerPromise$1.future().map((Function1 & Serializable)x$12 -> new HeaderMetadataImpl((Seq<HttpHeader>)x$12), this.ec$2);
                    }

                    public CompletionStage<org.apache.pekko.grpc.javadsl.Metadata> getTrailers() {
                        Object var2_1;
                        Future FutureOps_f = this.trailerPromise$1.future().map((Function1 & Serializable)h -> new JavaMetadataImpl(new HeaderMetadataImpl((Seq<HttpHeader>)h)), this.ec$2);
                        void v0 = var2_1;
                        var2_1 = null;
                        void asJava$extension_$this = v0;
                        return FutureConverters$.MODULE$.asJava((Future)asJava$extension_$this);
                    }
                    {
                        this.response$2 = response$2;
                        this.trailerPromise$1 = trailerPromise$1;
                        this.ec$2 = ec$2;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$getTrailers$1(scala.collection.immutable.Seq ), $anonfun$trailers$1(scala.collection.immutable.Seq )}, serializedLambda);
                    }
                }));
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                return Source$.MODULE$.failed(e).mapMaterializedValue((Function1 & Serializable)x$13 -> Future$.MODULE$.failed(e));
            }
            throw new MatchError(try_);
        }, ec)).mapMaterializedValue((Function1 & Serializable)x$14 -> x$14.flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    private Future<BoxedUnit> parseResponseStatus(HttpResponse response, Seq<HttpHeader> trailers) {
        String string;
        Option option = ((Seq)response.headers().$plus$plus(trailers)).find((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)PekkoHttpClientUtils$.$anonfun$parseResponseStatus$1(x$15))).map((Function1 & Serializable)x$16 -> x$16.value());
        if (option instanceof Some && "0".equals(string = (String)((Some)option).value())) {
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return Future$.MODULE$.failed((Throwable)this.mapToStatusException(response, trailers));
    }

    private StatusRuntimeException mapToStatusException(HttpResponse response, Seq<HttpHeader> trailers) {
        Seq allHeaders = (Seq)response.headers().$plus$plus(trailers);
        io.grpc.Metadata metadata = new MetadataImpl(new HeaderMetadataImpl((Seq<HttpHeader>)allHeaders).asList()).toGoogleGrpcMetadata();
        Option option = allHeaders.find((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)PekkoHttpClientUtils$.$anonfun$mapToStatusException$1(x$17))).map((Function1 & Serializable)x$18 -> x$18.value());
        if (None$.MODULE$.equals(option)) {
            return new StatusRuntimeException(this.mapHttpStatus(response).withDescription("No grpc-status found"), metadata);
        }
        if (option instanceof Some) {
            String statusCode = (String)((Some)option).value();
            Option description = allHeaders.find((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)PekkoHttpClientUtils$.$anonfun$mapToStatusException$3(x$19))).map((Function1 & Serializable)x$20 -> x$20.value());
            return new StatusRuntimeException(Status.fromCodeValue((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(statusCode))).withDescription((String)description.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), metadata);
        }
        throw new MatchError((Object)option);
    }

    private Status mapHttpStatus(HttpResponse response) {
        StatusCode statusCode = response.status();
        StatusCodes.ClientError clientError = StatusCodes$.MODULE$.BadRequest();
        if (!(clientError != null ? !clientError.equals(statusCode) : statusCode != null)) {
            return Status.INTERNAL;
        }
        StatusCodes.ClientError clientError2 = StatusCodes$.MODULE$.Unauthorized();
        if (!(clientError2 != null ? !clientError2.equals(statusCode) : statusCode != null)) {
            return Status.UNAUTHENTICATED;
        }
        StatusCodes.ClientError clientError3 = StatusCodes$.MODULE$.Forbidden();
        if (!(clientError3 != null ? !clientError3.equals(statusCode) : statusCode != null)) {
            return Status.PERMISSION_DENIED;
        }
        StatusCodes.ClientError clientError4 = StatusCodes$.MODULE$.NotFound();
        if (!(clientError4 != null ? !clientError4.equals(statusCode) : statusCode != null)) {
            return Status.UNIMPLEMENTED;
        }
        StatusCodes.ClientError clientError5 = StatusCodes$.MODULE$.TooManyRequests();
        if (!(clientError5 != null ? !clientError5.equals(statusCode) : statusCode != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError = StatusCodes$.MODULE$.BadGateway();
        if (!(serverError != null ? !serverError.equals(statusCode) : statusCode != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError2 = StatusCodes$.MODULE$.ServiceUnavailable();
        if (!(serverError2 != null ? !serverError2.equals(statusCode) : statusCode != null)) {
            return Status.UNAVAILABLE;
        }
        StatusCodes.ServerError serverError3 = StatusCodes$.MODULE$.GatewayTimeout();
        if (!(serverError3 != null ? !serverError3.equals(statusCode) : statusCode != null)) {
            return Status.UNAVAILABLE;
        }
        return Status.UNKNOWN;
    }

    public static final /* synthetic */ void $anonfun$createChannel$2(String host$1, String authority) {
        String string = host$1;
        Predef$.MODULE$.assert(!(string != null ? !string.equals(authority) : authority != null));
    }

    public static final /* synthetic */ Future $anonfun$createChannel$1(GrpcClientSettings settings$1, IntRef roundRobin$1, ExecutionContextExecutor ec$1, String host, int x$1) {
        settings$1.overrideAuthority().foreach((Function1 & Serializable)authority -> {
            PekkoHttpClientUtils$.$anonfun$createChannel$2(host, authority);
            return BoxedUnit.UNIT;
        });
        return settings$1.serviceDiscovery().lookup(settings$1.serviceName(), new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds()).map((Function1 & Serializable)resolved -> {
            ++roundRobin$1.elem;
            ServiceDiscovery.ResolvedTarget target = (ServiceDiscovery.ResolvedTarget)resolved.addresses().apply(roundRobin$1.elem % resolved.addresses().size());
            Option option = target.address();
            if (option instanceof Some) {
                InetAddress address = (InetAddress)((Some)option).value();
                return new InetSocketAddress(address, BoxesRunTime.unboxToInt((Object)target.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> settings$1.defaultPort())));
            }
            if (None$.MODULE$.equals(option)) {
                return new InetSocketAddress(target.host(), BoxesRunTime.unboxToInt((Object)target.port().getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> settings$1.defaultPort())));
            }
            throw new MatchError((Object)option);
        }, (ExecutionContext)ec$1);
    }

    public static final /* synthetic */ void $anonfun$createChannel$8(HttpResponse res) {
        ((PekkoHttpClientUtils.ResponsePromise)res.attribute(PekkoHttpClientUtils$ResponsePromise$.MODULE$.Key(), (JavaMapping)JavaMapping$.MODULE$.attributeKey()).get()).promise().trySuccess((Object)res);
    }

    public static final Future org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$singleRequest$1(HttpRequest request, SourceQueueWithComplete queue$1, ExecutionContextExecutor ec$1) {
        Promise p = Promise$.MODULE$.apply();
        return queue$1.offer((Object)request.addAttribute(PekkoHttpClientUtils$ResponsePromise$.MODULE$.Key(), (Object)new PekkoHttpClientUtils.ResponsePromise((Promise<HttpResponse>)p))).flatMap((Function1 & Serializable)x$3 -> p.future(), (ExecutionContext)ec$1);
    }

    public static final ProtobufSerializer org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$serializerFromMethodDescriptor$1(MethodDescriptor descriptor) {
        return ((WithProtobufSerializer)descriptor.getRequestMarshaller()).protobufSerializer();
    }

    public static final ProtobufSerializer org$apache$pekko$grpc$internal$PekkoHttpClientUtils$$deserializerFromMethodDescriptor$1(MethodDescriptor descriptor) {
        return ((WithProtobufSerializer)descriptor.getResponseMarshaller()).protobufSerializer();
    }

    public static final /* synthetic */ boolean $anonfun$parseResponseStatus$1(HttpHeader x$15) {
        String string = x$15.name();
        String string2 = "grpc-status";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$mapToStatusException$1(HttpHeader x$17) {
        String string = x$17.name();
        String string2 = "grpc-status";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$mapToStatusException$3(HttpHeader x$19) {
        String string = x$19.name();
        String string2 = "grpc-message";
        return string != null && string.equals(string2);
    }

    private PekkoHttpClientUtils$() {
    }
}

