/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import java.io.Serializable;
import java.nio.ByteOrder;
import org.apache.pekko.NotUsed;
import org.apache.pekko.grpc.GrpcProtocol;
import org.apache.pekko.grpc.GrpcProtocol$GrpcProtocolReader$;
import org.apache.pekko.grpc.GrpcProtocol$GrpcProtocolWriter$;
import org.apache.pekko.grpc.internal.AbstractGrpcProtocol;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.grpc.internal.Identity$;
import org.apache.pekko.grpc.internal.MissingParameterException;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.MediaType;
import org.apache.pekko.http.scaladsl.model.Trailer;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.impl.io.ByteStringParser;
import org.apache.pekko.stream.impl.io.ByteStringParser$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class AbstractGrpcProtocol$
implements Serializable {
    private static final ByteString notCompressed;
    private static final ByteString compressed;
    public static final AbstractGrpcProtocol$ MODULE$;

    private AbstractGrpcProtocol$() {
    }

    static {
        MODULE$ = new AbstractGrpcProtocol$();
        notCompressed = ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}), (Integral)Numeric.IntIsIntegral$.MODULE$);
        compressed = ByteString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}), (Integral)Numeric.IntIsIntegral$.MODULE$);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AbstractGrpcProtocol$.class);
    }

    public ByteString fieldType(Codec codec) {
        Codec codec2 = codec;
        Identity$ identity$ = Identity$.MODULE$;
        if (!(codec2 != null ? !codec2.equals(identity$) : identity$ != null)) {
            return notCompressed;
        }
        return compressed;
    }

    private ContentType.Binary adjustCompressibility(ContentType.Binary contentType, Codec codec) {
        Codec codec2;
        return contentType.mediaType().withComp((MediaType.Compressibility)(Identity$.MODULE$.equals(codec2 = codec) ? MediaType.Compressible$.MODULE$ : MediaType.NotCompressible$.MODULE$)).toContentType();
    }

    public ByteString encodeFrameData(ByteString frameType, ByteString data) {
        int length = data.length();
        ByteString encodedLength = ByteString$.MODULE$.fromArrayUnsafe(new byte[]{(byte)(length >> 24), (byte)(length >> 16), (byte)(length >> 8), (byte)length});
        return frameType.$plus$plus(encodedLength).$plus$plus(data);
    }

    public ByteString encodeFrameData(ByteString data, boolean isCompressed, boolean isTrailer) {
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        int length = data.length();
        ByteStringBuilder builder = new ByteStringBuilder();
        builder.sizeHint(5);
        int flags = (isCompressed ? 1 : 0) | (isTrailer ? 128 : 0);
        return builder.putByte((byte)flags).putInt(length, byteOrder).$plus$plus$eq(data).result();
    }

    public GrpcProtocol.GrpcProtocolWriter writer(GrpcProtocol protocol, Codec codec, Function1<GrpcProtocol.Frame, HttpEntity.ChunkStreamPart> encodeFrame, Function3<ByteString, Seq<HttpHeader>, Trailer, HttpResponse> encodeDataToResponse) {
        return GrpcProtocol$GrpcProtocolWriter$.MODULE$.apply((ContentType)this.adjustCompressibility(protocol.contentType(), codec), codec, encodeFrame, encodeDataToResponse, (Flow<GrpcProtocol.Frame, HttpEntity.ChunkStreamPart, NotUsed>)((Flow)Flow$.MODULE$.apply().map(encodeFrame)));
    }

    public GrpcProtocol.GrpcProtocolReader reader(Codec codec, Function2<Object, ByteString, GrpcProtocol.Frame> decodeFrame, Function1<ByteString, ByteString> preDecodeStrict, Flow<ByteString, ByteString, NotUsed> preDecodeFlow) {
        Function1 & Serializable strictAdapter = preDecodeStrict == null ? (Function1 & Serializable)x -> (ByteString)Predef$.MODULE$.identity(x) : preDecodeStrict;
        Function1 & Serializable adapter = preDecodeFlow == null ? (Function1 & Serializable)x -> (Flow)Predef$.MODULE$.identity(x) : (Function1 & Serializable)x -> Flow$.MODULE$.apply().via((Graph)preDecodeFlow).via((Graph)x);
        return GrpcProtocol$GrpcProtocolReader$.MODULE$.apply(codec, (Function1<ByteString, ByteString>)(Function1 & Serializable)bs -> this.decoder$1(codec, strictAdapter, (ByteString)bs), (Flow<ByteString, GrpcProtocol.Frame, NotUsed>)((Flow)adapter.apply((Object)Flow$.MODULE$.fromGraph((Graph)new AbstractGrpcProtocol.GrpcFramingDecoderStage(codec, decodeFrame)))));
    }

    public Function1<ByteString, ByteString> reader$default$3() {
        return null;
    }

    public Flow<ByteString, ByteString, NotUsed> reader$default$4() {
        return null;
    }

    private final ByteString decoder$1(Codec codec$1, Function1 strictAdapter$1, ByteString bs) {
        ByteString byteString;
        try {
            ByteStringParser.ByteReader reader = new ByteStringParser.ByteReader((ByteString)strictAdapter$1.apply((Object)bs));
            int frameType = reader.readByte();
            int length = reader.readIntBE();
            ByteString data = reader.take(length);
            if (reader.hasRemaining()) {
                throw new IllegalStateException("Unexpected data");
            }
            if ((frameType & 0x80) != 0) {
                throw new IllegalStateException("Cannot read unknown frame");
            }
            byteString = codec$1.uncompress((frameType & 1) == 1, data);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Exception exception = ByteStringParser$.MODULE$.NeedMoreData();
            Throwable throwable3 = throwable2;
            if (!(exception != null ? !exception.equals(throwable3) : throwable3 != null)) {
                throw new MissingParameterException();
            }
            throw throwable;
        }
        return byteString;
    }
}

