/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.NameResolver;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.JdkSslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.Done;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.internal.ChannelUtils$;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.PekkoDiscoveryNameResolverProvider;
import org.apache.pekko.grpc.internal.PekkoNettyGrpcClientGraphStage;
import org.apache.pekko.grpc.internal.UnaryCallAdapter;
import org.apache.pekko.grpc.internal.UnaryCallWithMetadataAdapter;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Keep$;
import org.apache.pekko.stream.scaladsl.Source;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public final class NettyClientUtils$
implements Serializable {
    public static final NettyClientUtils$ MODULE$ = new NettyClientUtils$();

    private NettyClientUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NettyClientUtils$.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InternalApi
    public InternalChannel createChannel(GrpcClientSettings settings, LoggingAdapter log, ExecutionContext ec) {
        ObjectRef builder = ObjectRef.create((Object)((NettyChannelBuilder)NettyChannelBuilder.forTarget((String)new StringBuilder(2).append("//").append(settings.serviceName()).toString()).flowControlWindow(0x100000).nameResolverFactory((NameResolver.Factory)new PekkoDiscoveryNameResolverProvider(settings.serviceDiscovery(), settings.defaultPort(), settings.servicePortName(), settings.serviceProtocol(), settings.resolveTimeout(), ec))));
        if (!settings.useTls()) {
            NettyChannelBuilder nettyChannelBuilder = ((NettyChannelBuilder)builder.elem).usePlaintext();
            builder.elem = nettyChannelBuilder;
            nettyChannelBuilder = null;
        } else {
            NettyChannelBuilder nettyChannelBuilder;
            NettyChannelBuilder nettyChannelBuilder2 = ((NettyChannelBuilder)builder.elem).negotiationType(NegotiationType.TLS);
            builder.elem = nettyChannelBuilder2;
            nettyChannelBuilder2 = null;
            Option<SSLContext> option = settings.sslContext();
            if (option instanceof Some) {
                SSLContext sslContext = (SSLContext)((Some)option).value();
                nettyChannelBuilder = ((NettyChannelBuilder)builder.elem).sslContext(this.createNettySslContext(sslContext));
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(settings.trustManager(), settings.sslProvider());
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Option option2 = (Option)tuple2._1();
                Option option3 = (Option)tuple2._2();
                if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3)) {
                    nettyChannelBuilder = (NettyChannelBuilder)builder.elem;
                } else {
                    SslContextBuilder sslContextBuilder;
                    SslContextBuilder sslContextBuilder2;
                    Option tm = option2;
                    Option provider = option3;
                    Option option4 = provider;
                    if (None$.MODULE$.equals(option4)) {
                        sslContextBuilder2 = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient());
                    } else {
                        if (!(option4 instanceof Some)) throw new MatchError((Object)option4);
                        SslProvider sslProvider = (SslProvider)((Some)option4).value();
                        sslContextBuilder2 = GrpcSslContexts.configure((SslContextBuilder)SslContextBuilder.forClient(), (SslProvider)sslProvider);
                    }
                    SslContextBuilder context = sslContextBuilder2;
                    NettyChannelBuilder nettyChannelBuilder3 = (NettyChannelBuilder)builder.elem;
                    Option option5 = tm;
                    if (None$.MODULE$.equals(option5)) {
                        sslContextBuilder = context;
                    } else {
                        if (!(option5 instanceof Some)) throw new MatchError((Object)option5);
                        TrustManager trustManager = (TrustManager)((Some)option5).value();
                        sslContextBuilder = context.trustManager(trustManager);
                    }
                    nettyChannelBuilder = nettyChannelBuilder3.sslContext(sslContextBuilder.build());
                }
            }
            NettyChannelBuilder nettyChannelBuilder4 = nettyChannelBuilder;
            builder.elem = nettyChannelBuilder4;
            nettyChannelBuilder4 = null;
        }
        NettyChannelBuilder nettyChannelBuilder = (NettyChannelBuilder)settings.loadBalancingPolicy().map((Function1 & Serializable)_$1 -> (NettyChannelBuilder)((NettyChannelBuilder)builder$1.elem).defaultLoadBalancingPolicy(_$1)).getOrElse(() -> this.createChannel$$anonfun$2(builder));
        builder.elem = nettyChannelBuilder;
        nettyChannelBuilder = null;
        NettyChannelBuilder nettyChannelBuilder5 = (NettyChannelBuilder)settings.overrideAuthority().map((Function1 & Serializable)_$2 -> (NettyChannelBuilder)((NettyChannelBuilder)builder$3.elem).overrideAuthority(_$2)).getOrElse(() -> this.createChannel$$anonfun$4(builder));
        builder.elem = nettyChannelBuilder5;
        nettyChannelBuilder5 = null;
        NettyChannelBuilder nettyChannelBuilder6 = (NettyChannelBuilder)settings.userAgent().map((Function1 & Serializable)_$3 -> (NettyChannelBuilder)((NettyChannelBuilder)builder$5.elem).userAgent(_$3)).getOrElse(() -> this.createChannel$$anonfun$6(builder));
        builder.elem = nettyChannelBuilder6;
        nettyChannelBuilder6 = null;
        NettyChannelBuilder nettyChannelBuilder7 = (NettyChannelBuilder)settings.channelBuilderOverrides().apply((Object)((NettyChannelBuilder)builder.elem));
        builder.elem = nettyChannelBuilder7;
        nettyChannelBuilder7 = null;
        Option<String> option = settings.loadBalancingPolicy();
        Option connectionAttempts = None$.MODULE$.equals(option) || option instanceof Some && "pick_first".equals(((Some)option).value()) ? settings.connectionAttempts() : settings.connectionAttempts().flatMap((Function1 & Serializable)x$1 -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)x$1)));
        ManagedChannel channel = ((NettyChannelBuilder)builder.elem).build();
        Promise channelReadyPromise = Promise$.MODULE$.apply();
        Promise channelClosedPromise = Promise$.MODULE$.apply();
        ChannelUtils$.MODULE$.monitorChannel((Promise<BoxedUnit>)channelReadyPromise, (Promise<Done>)channelClosedPromise, channel, (Option<Object>)connectionAttempts, log);
        channelReadyPromise.future().onComplete((Function1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Object object = ((Success)try_).value();
                if (!(boxedUnit != null ? !boxedUnit.equals(object) : object != null)) {
                    return BoxedUnit.UNIT;
                }
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                channel.shutdown();
                return BoxesRunTime.boxToBoolean((boolean)channelClosedPromise.tryFailure(e));
            }
            throw new MatchError((Object)try_);
        }, ec);
        return new InternalChannel(settings, channel, channelClosedPromise, this){
            private final GrpcClientSettings settings$1;
            private final ManagedChannel channel$2;
            private final Promise channelClosedPromise$2;
            {
                this.settings$1 = settings$2;
                this.channel$2 = channel$3;
                this.channelClosedPromise$2 = channelClosedPromise$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public void shutdown() {
                this.channel$2.shutdown();
            }

            public Future done() {
                return this.channelClosedPromise$2.future();
            }

            public Future invoke(Object request, MetadataImpl headers, MethodDescriptor descriptor, CallOptions options) {
                UnaryCallAdapter<Res> listener = new UnaryCallAdapter<Res>();
                ClientCall call = this.channel$2.newCall(descriptor, NettyClientUtils$.MODULE$.callOptionsWithDeadline(options, this.settings$1));
                call.start(listener, headers.toGoogleGrpcMetadata());
                call.sendMessage(request);
                call.halfClose();
                call.request(2);
                return listener.future();
            }

            public Future invokeWithMetadata(Object request, MetadataImpl headers, MethodDescriptor descriptor, CallOptions options) {
                UnaryCallWithMetadataAdapter<Res> listener = new UnaryCallWithMetadataAdapter<Res>();
                ClientCall call = this.channel$2.newCall(descriptor, NettyClientUtils$.MODULE$.callOptionsWithDeadline(options, this.settings$1));
                call.start(listener, headers.toGoogleGrpcMetadata());
                call.sendMessage(request);
                call.halfClose();
                call.request(2);
                return listener.future();
            }

            public Source invokeWithMetadata(Source source, MetadataImpl headers, MethodDescriptor descriptor, boolean streamingResponse, CallOptions options) {
                Flow flow = this.createFlow(headers, descriptor, streamingResponse, NettyClientUtils$.MODULE$.callOptionsWithDeadline(options, this.settings$1));
                return source.viaMat((Graph)flow, Keep$.MODULE$.right());
            }

            private Flow createFlow(MetadataImpl headers, MethodDescriptor descriptor, boolean streamingResponse, CallOptions options) {
                return Flow$.MODULE$.fromGraph(new PekkoNettyGrpcClientGraphStage<I, O>(descriptor, (Channel)this.channel$2, options, streamingResponse, headers));
            }
        };
    }

    @InternalApi
    private SslContext createNettySslContext(SSLContext javaSslContext) {
        JdkSslContext nettySslContext = (JdkSslContext)GrpcSslContexts.configure((SslContextBuilder)GrpcSslContexts.forClient(), (SslProvider)SslProvider.JDK).build();
        Field nettySslContextField = JdkSslContext.class.getDeclaredField("sslContext");
        nettySslContextField.setAccessible(true);
        nettySslContextField.set(nettySslContext, javaSslContext);
        return nettySslContext;
    }

    @InternalApi
    public CallOptions callOptions(GrpcClientSettings settings) {
        return (CallOptions)settings.callCredentials().map((Function1 & Serializable)x$0 -> CallOptions.DEFAULT.withCallCredentials(x$0)).getOrElse(this::callOptions$$anonfun$2);
    }

    @InternalApi
    public CallOptions callOptionsWithDeadline(CallOptions defaultOptions, GrpcClientSettings settings) {
        Duration duration = settings.deadline();
        if (duration instanceof FiniteDuration) {
            FiniteDuration d = (FiniteDuration)duration;
            return defaultOptions.withDeadlineAfter(d.toMillis(), TimeUnit.MILLISECONDS);
        }
        return defaultOptions;
    }

    private final NettyChannelBuilder createChannel$$anonfun$2(ObjectRef builder$2) {
        return (NettyChannelBuilder)builder$2.elem;
    }

    private final NettyChannelBuilder createChannel$$anonfun$4(ObjectRef builder$4) {
        return (NettyChannelBuilder)builder$4.elem;
    }

    private final NettyChannelBuilder createChannel$$anonfun$6(ObjectRef builder$6) {
        return (NettyChannelBuilder)builder$6.elem;
    }

    private final /* synthetic */ Option $anonfun$1(int x$1) {
        int n = x$1;
        if (1 == n) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1));
        }
        return None$.MODULE$;
    }

    private final CallOptions callOptions$$anonfun$2() {
        return CallOptions.DEFAULT;
    }
}

