/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.CallOptions;
import io.grpc.MethodDescriptor;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.GrpcSingleResponse;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.MetadataImpl;
import org.apache.pekko.grpc.internal.MetadataImpl$;
import org.apache.pekko.grpc.internal.MetadataOperations;
import org.apache.pekko.grpc.internal.NettyClientUtils$;
import org.apache.pekko.grpc.scaladsl.SingleResponseRequestBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

@InternalApi
public final class ScalaUnaryRequestBuilder<I, O>
implements SingleResponseRequestBuilder<I, O>,
MetadataOperations<ScalaUnaryRequestBuilder<I, O>> {
    private final MethodDescriptor<I, O> descriptor;
    private final InternalChannel channel;
    private final CallOptions defaultOptions;
    private final GrpcClientSettings settings;
    private final MetadataImpl headers;
    private final ExecutionContext ec;

    public ScalaUnaryRequestBuilder(MethodDescriptor<I, O> descriptor, InternalChannel channel, CallOptions defaultOptions, GrpcClientSettings settings, MetadataImpl headers, ExecutionContext ec) {
        this.descriptor = descriptor;
        this.channel = channel;
        this.defaultOptions = defaultOptions;
        this.settings = settings;
        this.headers = headers;
        this.ec = ec;
    }

    @Override
    public MetadataImpl headers() {
        return this.headers;
    }

    @InternalStableApi
    public ScalaUnaryRequestBuilder(MethodDescriptor<I, O> descriptor, InternalChannel channel, CallOptions defaultOptions, GrpcClientSettings settings, ExecutionContext ec) {
        this(descriptor, channel, defaultOptions, settings, MetadataImpl$.MODULE$.empty(), ec);
    }

    private CallOptions callOptionsWithDeadline() {
        return NettyClientUtils$.MODULE$.callOptionsWithDeadline(this.defaultOptions, this.settings);
    }

    @Override
    public Future<O> invoke(I request) {
        return this.channel.invoke(request, this.headers(), this.descriptor, this.defaultOptions);
    }

    @Override
    public Future<GrpcSingleResponse<O>> invokeWithMetadata(I request) {
        return this.channel.invokeWithMetadata(request, this.headers(), this.descriptor, this.callOptionsWithDeadline());
    }

    @Override
    public ScalaUnaryRequestBuilder<I, O> withHeaders(MetadataImpl headers) {
        return new ScalaUnaryRequestBuilder<I, O>(this.descriptor, this.channel, this.defaultOptions, this.settings, headers, this.ec);
    }
}

