/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import io.grpc.CallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.Discovery;
import org.apache.pekko.discovery.Discovery$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.SSLContextUtils$;
import org.apache.pekko.grpc.internal.HardcodedServiceDiscovery;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class GrpcClientSettings$
implements Serializable {
    public static final GrpcClientSettings$ MODULE$ = new GrpcClientSettings$();

    private GrpcClientSettings$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GrpcClientSettings$.class);
    }

    private Function1<NettyChannelBuilder, NettyChannelBuilder> $lessinit$greater$default$18() {
        return (Function1 & Serializable)x -> (NettyChannelBuilder)Predef$.MODULE$.identity(x);
    }

    public GrpcClientSettings connectToServiceAt(String host, int port, ClassicActorSystemProvider actorSystem) {
        ActorSystem system = actorSystem.classicSystem();
        Config defaultServiceConfig = system.settings().config().getConfig("pekko.grpc.client").getConfig("\"*\"").withValue("host", ConfigValueFactory.fromAnyRef((Object)host)).withValue("port", ConfigValueFactory.fromAnyRef((Object)BoxesRunTime.boxToInteger((int)port)));
        return this.fromConfig(defaultServiceConfig, actorSystem);
    }

    public GrpcClientSettings fromConfig(String clientName, ClassicActorSystemProvider actorSystem) {
        ActorSystem system = actorSystem.classicSystem();
        Config pekkoGrpcClientConfig = system.settings().config().getConfig("pekko.grpc.client");
        Config defaultServiceConfig = pekkoGrpcClientConfig.getConfig("\"*\"");
        Predef$.MODULE$.require(pekkoGrpcClientConfig.hasPath(new StringBuilder(2).append("\"").append(clientName).append("\"").toString()), () -> GrpcClientSettings$.$anonfun$1(clientName));
        Config clientConfig = pekkoGrpcClientConfig.getConfig(new StringBuilder(2).append("\"").append(clientName).append("\"").toString()).withFallback((ConfigMergeable)defaultServiceConfig);
        return this.fromConfig(clientConfig, actorSystem);
    }

    public GrpcClientSettings usingServiceDiscovery(String serviceName, ClassicActorSystemProvider actorSystem) {
        Config clientConfiguration = actorSystem.classicSystem().settings().config().getConfig("pekko.grpc.client").getConfig("\"*\"");
        FiniteDuration resolveTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(clientConfiguration.getDuration("service-discovery.resolve-timeout")));
        ServiceDiscovery discovery = Discovery$.MODULE$.get(actorSystem).discovery();
        return this.withConfigDefaults(serviceName, discovery, -1, resolveTimeout, clientConfiguration);
    }

    public GrpcClientSettings usingServiceDiscovery(String serviceName, ServiceDiscovery discovery, ClassicActorSystemProvider actorSystem) {
        Config clientConfiguration = actorSystem.classicSystem().settings().config().getConfig("pekko.grpc.client").getConfig("\"*\"");
        FiniteDuration resolveTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(clientConfiguration.getDuration("service-discovery.resolve-timeout")));
        return this.withConfigDefaults(serviceName, discovery, -1, resolveTimeout, clientConfiguration);
    }

    public GrpcClientSettings fromConfig(Config clientConfiguration, ClassicActorSystemProvider sys) {
        HardcodedServiceDiscovery hardcodedServiceDiscovery;
        String serviceDiscoveryMechanism = clientConfiguration.getString("service-discovery.mechanism");
        String serviceName = clientConfiguration.getString("service-discovery.service-name");
        int port = clientConfiguration.getInt("port");
        FiniteDuration resolveTimeout = JavaDurationConverters.JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(clientConfiguration.getDuration("service-discovery.resolve-timeout")));
        String string = serviceDiscoveryMechanism;
        if ("static".equals(string) || "grpc-dns".equals(string)) {
            String host = clientConfiguration.getString("host");
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(host)), GrpcClientSettings$::$anonfun$2);
            serviceName = host;
            hardcodedServiceDiscovery = this.staticServiceDiscovery(host, port);
        } else {
            String other = string;
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(serviceName)), GrpcClientSettings$::$anonfun$3);
            hardcodedServiceDiscovery = ((Discovery)Discovery$.MODULE$.apply(sys)).loadServiceDiscovery(other);
        }
        HardcodedServiceDiscovery sd = hardcodedServiceDiscovery;
        return this.withConfigDefaults(serviceName, sd, port, resolveTimeout, clientConfiguration);
    }

    private GrpcClientSettings withConfigDefaults(String serviceName, ServiceDiscovery serviceDiscovery, int defaultPort, FiniteDuration resolveTimeout, Config clientConfiguration) {
        return new GrpcClientSettings(serviceName, serviceDiscovery, defaultPort, resolveTimeout, this.getOptionalString(clientConfiguration, "service-discovery.port-name"), this.getOptionalString(clientConfiguration, "service-discovery.protocol"), this.getOptionalInt(clientConfiguration, "connection-attempts"), (Option<CallCredentials>)None$.MODULE$, this.getOptionalString(clientConfiguration, "override-authority"), (Option<SslProvider>)this.getOptionalString(clientConfiguration, "ssl-provider").map((Function1 & Serializable)x$1 -> {
            String string = x$1;
            switch (string == null ? 0 : string.hashCode()) {
                case -1263174782: {
                    if (!"openssl".equals(string)) break;
                    return SslProvider.OPENSSL;
                }
                case -531986605: {
                    if (!"openssl_refcnt".equals(string)) break;
                    return SslProvider.OPENSSL_REFCNT;
                }
                case 105073: {
                    if (!"jdk".equals(string)) break;
                    return SslProvider.JDK;
                }
            }
            String other = string;
            throw new IllegalArgumentException(new StringBuilder(78).append("ssl-provider: expected empty, 'jdk', 'openssl' or 'openssl_refcnt', but got [").append(other).append("]").toString());
        }), (Option<SSLContext>)None$.MODULE$, (Option<TrustManager>)this.getOptionalString(clientConfiguration, "trusted").map((Function1 & Serializable)certificateResourcePath -> SSLContextUtils$.MODULE$.trustManagerFromResource((String)certificateResourcePath)), this.getPotentiallyInfiniteDuration(clientConfiguration, "deadline"), this.getOptionalString(clientConfiguration, "user-agent"), clientConfiguration.getBoolean("use-tls"), this.getOptionalString(clientConfiguration, "load-balancing-policy"), clientConfiguration.getString("backend"), this.$lessinit$greater$default$18());
    }

    private Option<String> getOptionalString(Config config, String path) {
        String string = config.getString(path);
        if ("".equals(string)) {
            return None$.MODULE$;
        }
        String other = string;
        return Some$.MODULE$.apply((Object)other);
    }

    private Option<Object> getOptionalInt(Config config, String path) {
        int n = config.getInt(path);
        if (-1 == n) {
            return None$.MODULE$;
        }
        int other = n;
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)other));
    }

    private Duration getPotentiallyInfiniteDuration(Config underlying, String path) {
        String string = Helpers$.MODULE$.toRootLowerCase(underlying.getString(path));
        if ("infinite".equals(string)) {
            return Duration$.MODULE$.Inf();
        }
        return Duration$.MODULE$.fromNanos(underlying.getDuration(path).toNanos());
    }

    @InternalApi
    public HardcodedServiceDiscovery staticServiceDiscovery(String host, int port) {
        return new HardcodedServiceDiscovery(ServiceDiscovery.Resolved$.MODULE$.apply(host, (Seq)((SeqOps)new .colon.colon((Object)ServiceDiscovery.ResolvedTarget$.MODULE$.apply(host, (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)port)), (Option)None$.MODULE$), (List)Nil$.MODULE$))));
    }

    private static final Object $anonfun$1(String clientName$1) {
        return new StringBuilder(47).append("Config path `pekko.grpc.client.").append(clientName$1).append("` does not exist").toString();
    }

    private static final Object $anonfun$2() {
        return "host can't be empty when service-discovery-mechanism is set to static or grpc-dns";
    }

    private static final Object $anonfun$3() {
        return "Configuration must contain a service-name";
    }
}

