/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc;

import com.typesafe.config.Config;
import io.grpc.CallCredentials;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.grpc.GrpcClientSettings$;
import org.apache.pekko.grpc.internal.HardcodedServiceDiscovery;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

@ApiMayChange
public final class GrpcClientSettings {
    private final String serviceName;
    private final ServiceDiscovery serviceDiscovery;
    private final int defaultPort;
    private final FiniteDuration resolveTimeout;
    private final Option servicePortName;
    private final Option serviceProtocol;
    private final Option connectionAttempts;
    private final Option callCredentials;
    private final Option overrideAuthority;
    private final Option sslProvider;
    private final Option sslContext;
    private final Option trustManager;
    private final Duration deadline;
    private final Option userAgent;
    private final boolean useTls;
    private final Option loadBalancingPolicy;
    private final String backend;
    private final Function1 channelBuilderOverrides;

    public static GrpcClientSettings connectToServiceAt(String string, int n, ClassicActorSystemProvider classicActorSystemProvider) {
        return GrpcClientSettings$.MODULE$.connectToServiceAt(string, n, classicActorSystemProvider);
    }

    public static GrpcClientSettings fromConfig(Config config, ClassicActorSystemProvider classicActorSystemProvider) {
        return GrpcClientSettings$.MODULE$.fromConfig(config, classicActorSystemProvider);
    }

    public static GrpcClientSettings fromConfig(String string, ClassicActorSystemProvider classicActorSystemProvider) {
        return GrpcClientSettings$.MODULE$.fromConfig(string, classicActorSystemProvider);
    }

    @InternalApi
    public static HardcodedServiceDiscovery staticServiceDiscovery(String string, int n) {
        return GrpcClientSettings$.MODULE$.staticServiceDiscovery(string, n);
    }

    public static GrpcClientSettings usingServiceDiscovery(String string, ClassicActorSystemProvider classicActorSystemProvider) {
        return GrpcClientSettings$.MODULE$.usingServiceDiscovery(string, classicActorSystemProvider);
    }

    public static GrpcClientSettings usingServiceDiscovery(String string, ServiceDiscovery serviceDiscovery, ClassicActorSystemProvider classicActorSystemProvider) {
        return GrpcClientSettings$.MODULE$.usingServiceDiscovery(string, serviceDiscovery, classicActorSystemProvider);
    }

    /*
     * Unable to fully structure code
     */
    public GrpcClientSettings(String serviceName, ServiceDiscovery serviceDiscovery, int defaultPort, FiniteDuration resolveTimeout, Option<String> servicePortName, Option<String> serviceProtocol, Option<Object> connectionAttempts, Option<CallCredentials> callCredentials, Option<String> overrideAuthority, Option<SslProvider> sslProvider, Option<SSLContext> sslContext, Option<TrustManager> trustManager, Duration deadline, Option<String> userAgent, boolean useTls, Option<String> loadBalancingPolicy, String backend, Function1<NettyChannelBuilder, NettyChannelBuilder> channelBuilderOverrides) {
        this.serviceName = serviceName;
        this.serviceDiscovery = serviceDiscovery;
        this.defaultPort = defaultPort;
        this.resolveTimeout = resolveTimeout;
        this.servicePortName = servicePortName;
        this.serviceProtocol = serviceProtocol;
        this.connectionAttempts = connectionAttempts;
        this.callCredentials = callCredentials;
        this.overrideAuthority = overrideAuthority;
        this.sslProvider = sslProvider;
        this.sslContext = sslContext;
        this.trustManager = trustManager;
        this.deadline = deadline;
        this.userAgent = userAgent;
        this.useTls = useTls;
        this.loadBalancingPolicy = loadBalancingPolicy;
        this.backend = backend;
        this.channelBuilderOverrides = channelBuilderOverrides;
        super();
        Predef$.MODULE$.require(sslContext.isEmpty() != false || trustManager.isEmpty() != false, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$1(), ()Ljava/lang/Object;)());
        Predef$.MODULE$.require(sslContext.isDefined() != false ? sslProvider.forall((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$2(io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider ), (Lio/grpc/netty/shaded/io/netty/handler/ssl/SslProvider;)Z)()) : true, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$3(), ()Ljava/lang/Object;)());
        v0 = backend;
        var19_19 = "netty";
        if (!(v0 == null ? var19_19 != null : v0.equals(var19_19) == false)) ** GOTO lbl-1000
        v1 = backend;
        var20_20 = "pekko-http";
        if (!(v1 != null ? v1.equals(var20_20) == false : var20_20 != null)) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        Predef$.MODULE$.require(v2, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$4(), ()Ljava/lang/Object;)());
    }

    public String serviceName() {
        return this.serviceName;
    }

    public ServiceDiscovery serviceDiscovery() {
        return this.serviceDiscovery;
    }

    public int defaultPort() {
        return this.defaultPort;
    }

    public FiniteDuration resolveTimeout() {
        return this.resolveTimeout;
    }

    public Option<String> servicePortName() {
        return this.servicePortName;
    }

    public Option<String> serviceProtocol() {
        return this.serviceProtocol;
    }

    public Option<Object> connectionAttempts() {
        return this.connectionAttempts;
    }

    public Option<CallCredentials> callCredentials() {
        return this.callCredentials;
    }

    public Option<String> overrideAuthority() {
        return this.overrideAuthority;
    }

    public Option<SslProvider> sslProvider() {
        return this.sslProvider;
    }

    public Option<SSLContext> sslContext() {
        return this.sslContext;
    }

    public Option<TrustManager> trustManager() {
        return this.trustManager;
    }

    public Duration deadline() {
        return this.deadline;
    }

    public Option<String> userAgent() {
        return this.userAgent;
    }

    public boolean useTls() {
        return this.useTls;
    }

    public Option<String> loadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public String backend() {
        return this.backend;
    }

    public Function1<NettyChannelBuilder, NettyChannelBuilder> channelBuilderOverrides() {
        return this.channelBuilderOverrides;
    }

    public GrpcClientSettings withDefaultPort(int value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), value, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17());
    }

    public GrpcClientSettings withCallCredentials(CallCredentials value) {
        Option option = Option$.MODULE$.apply((Object)value);
        String string = this.copy$default$1();
        Option<String> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        int n = this.copy$default$4();
        Option<String> option4 = this.copy$default$6();
        Option<SslProvider> option5 = this.copy$default$7();
        Option<SSLContext> option6 = this.copy$default$8();
        Option<TrustManager> option7 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        Option<String> option8 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<Object> option9 = this.copy$default$14();
        Option<String> option10 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option2, option3, n, (Option<CallCredentials>)option, option4, option5, option6, option7, duration, option8, bl, finiteDuration, option9, option10, string2, function1);
    }

    public GrpcClientSettings withOverrideAuthority(String value) {
        Option option = Option$.MODULE$.apply((Object)value);
        String string = this.copy$default$1();
        Option<String> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        int n = this.copy$default$4();
        Option<CallCredentials> option4 = this.copy$default$5();
        Option<SslProvider> option5 = this.copy$default$7();
        Option<SSLContext> option6 = this.copy$default$8();
        Option<TrustManager> option7 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        Option<String> option8 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<Object> option9 = this.copy$default$14();
        Option<String> option10 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option2, option3, n, option4, (Option<String>)option, option5, option6, option7, duration, option8, bl, finiteDuration, option9, option10, string2, function1);
    }

    public GrpcClientSettings withSslProvider(SslProvider sslProvider2) {
        return (GrpcClientSettings)Option$.MODULE$.apply((Object)sslProvider2).fold(this::withSslProvider$$anonfun$1, (Function1 & Serializable)sslProvider -> {
            Some some = Some$.MODULE$.apply(sslProvider);
            String string = this.copy$default$1();
            Option<String> option = this.copy$default$2();
            Option<String> option2 = this.copy$default$3();
            int n = this.copy$default$4();
            Option<CallCredentials> option3 = this.copy$default$5();
            Option<String> option4 = this.copy$default$6();
            Option<SSLContext> option5 = this.copy$default$8();
            Option<TrustManager> option6 = this.copy$default$9();
            Duration duration = this.copy$default$10();
            Option<String> option7 = this.copy$default$11();
            FiniteDuration finiteDuration = this.copy$default$13();
            Option<Object> option8 = this.copy$default$14();
            Option<String> option9 = this.copy$default$15();
            String string2 = this.copy$default$16();
            Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
            return this.copy(string, option, option2, n, option3, option4, (Option<SslProvider>)some, option5, option6, duration, option7, true, finiteDuration, option8, option9, string2, function1);
        });
    }

    public GrpcClientSettings withSslContext(SSLContext sslContext2) {
        return (GrpcClientSettings)Option$.MODULE$.apply((Object)sslContext2).fold(this::withSslContext$$anonfun$1, (Function1 & Serializable)sslContext -> {
            Option option = Option$.MODULE$.apply(sslContext);
            String string = this.copy$default$1();
            Option<String> option2 = this.copy$default$2();
            Option<String> option3 = this.copy$default$3();
            int n = this.copy$default$4();
            Option<CallCredentials> option4 = this.copy$default$5();
            Option<String> option5 = this.copy$default$6();
            Option<SslProvider> option6 = this.copy$default$7();
            Option<TrustManager> option7 = this.copy$default$9();
            Duration duration = this.copy$default$10();
            Option<String> option8 = this.copy$default$11();
            FiniteDuration finiteDuration = this.copy$default$13();
            Option<Object> option9 = this.copy$default$14();
            Option<String> option10 = this.copy$default$15();
            String string2 = this.copy$default$16();
            Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
            return this.copy(string, option2, option3, n, option4, option5, option6, (Option<SSLContext>)option, option7, duration, option8, true, finiteDuration, option9, option10, string2, function1);
        });
    }

    public GrpcClientSettings withTrustManager(TrustManager trustManager2) {
        return (GrpcClientSettings)Option$.MODULE$.apply((Object)trustManager2).fold(this::withTrustManager$$anonfun$1, (Function1 & Serializable)trustManager -> {
            Option option = Option$.MODULE$.apply(trustManager);
            String string = this.copy$default$1();
            Option<String> option2 = this.copy$default$2();
            Option<String> option3 = this.copy$default$3();
            int n = this.copy$default$4();
            Option<CallCredentials> option4 = this.copy$default$5();
            Option<String> option5 = this.copy$default$6();
            Option<SslProvider> option6 = this.copy$default$7();
            Option<SSLContext> option7 = this.copy$default$8();
            Duration duration = this.copy$default$10();
            Option<String> option8 = this.copy$default$11();
            FiniteDuration finiteDuration = this.copy$default$13();
            Option<Object> option9 = this.copy$default$14();
            Option<String> option10 = this.copy$default$15();
            String string2 = this.copy$default$16();
            Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
            return this.copy(string, option2, option3, n, option4, option5, option6, option7, (Option<TrustManager>)option, duration, option8, true, finiteDuration, option9, option10, string2, function1);
        });
    }

    public GrpcClientSettings withResolveTimeout(FiniteDuration value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), value, this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17());
    }

    public GrpcClientSettings withServicePortName(String servicePortName) {
        Some some = Some$.MODULE$.apply((Object)servicePortName);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$3();
        int n = this.copy$default$4();
        Option<CallCredentials> option2 = this.copy$default$5();
        Option<String> option3 = this.copy$default$6();
        Option<SslProvider> option4 = this.copy$default$7();
        Option<SSLContext> option5 = this.copy$default$8();
        Option<TrustManager> option6 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        Option<String> option7 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<Object> option8 = this.copy$default$14();
        Option<String> option9 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, (Option<String>)some, option, n, option2, option3, option4, option5, option6, duration, option7, bl, finiteDuration, option8, option9, string2, function1);
    }

    public GrpcClientSettings withServiceProtocol(String serviceProtocol) {
        Some some = Some$.MODULE$.apply((Object)serviceProtocol);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        int n = this.copy$default$4();
        Option<CallCredentials> option2 = this.copy$default$5();
        Option<String> option3 = this.copy$default$6();
        Option<SslProvider> option4 = this.copy$default$7();
        Option<SSLContext> option5 = this.copy$default$8();
        Option<TrustManager> option6 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        Option<String> option7 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<Object> option8 = this.copy$default$14();
        Option<String> option9 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option, (Option<String>)some, n, option2, option3, option4, option5, option6, duration, option7, bl, finiteDuration, option8, option9, string2, function1);
    }

    public GrpcClientSettings withDeadline(Duration value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), value, this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17());
    }

    public GrpcClientSettings withDeadline(java.time.Duration value) {
        FiniteDuration finiteDuration = Duration$.MODULE$.fromNanos(value.toNanos());
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Option<String> option2 = this.copy$default$3();
        int n = this.copy$default$4();
        Option<CallCredentials> option3 = this.copy$default$5();
        Option<String> option4 = this.copy$default$6();
        Option<SslProvider> option5 = this.copy$default$7();
        Option<SSLContext> option6 = this.copy$default$8();
        Option<TrustManager> option7 = this.copy$default$9();
        Option<String> option8 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration2 = this.copy$default$13();
        Option<Object> option9 = this.copy$default$14();
        Option<String> option10 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option, option2, n, option3, option4, option5, option6, option7, (Duration)finiteDuration, option8, bl, finiteDuration2, option9, option10, string2, function1);
    }

    public GrpcClientSettings withUserAgent(String value) {
        Option option = Option$.MODULE$.apply((Object)value);
        String string = this.copy$default$1();
        Option<String> option2 = this.copy$default$2();
        Option<String> option3 = this.copy$default$3();
        int n = this.copy$default$4();
        Option<CallCredentials> option4 = this.copy$default$5();
        Option<String> option5 = this.copy$default$6();
        Option<SslProvider> option6 = this.copy$default$7();
        Option<SSLContext> option7 = this.copy$default$8();
        Option<TrustManager> option8 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<Object> option9 = this.copy$default$14();
        Option<String> option10 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option2, option3, n, option4, option5, option6, option7, option8, duration, (Option<String>)option, bl, finiteDuration, option9, option10, string2, function1);
    }

    public GrpcClientSettings withTls(boolean enabled) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), enabled, this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), this.copy$default$17());
    }

    public GrpcClientSettings withLoadBalancingPolicy(String loadBalancingPolicy) {
        Some some = Some$.MODULE$.apply((Object)loadBalancingPolicy);
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Option<String> option2 = this.copy$default$3();
        int n = this.copy$default$4();
        Option<CallCredentials> option3 = this.copy$default$5();
        Option<String> option4 = this.copy$default$6();
        Option<SslProvider> option5 = this.copy$default$7();
        Option<SSLContext> option6 = this.copy$default$8();
        Option<TrustManager> option7 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        Option<String> option8 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<Object> option9 = this.copy$default$14();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option, option2, n, option3, option4, option5, option6, option7, duration, option8, bl, finiteDuration, option9, (Option<String>)some, string2, function1);
    }

    public GrpcClientSettings withGrpcLoadBalancingType(String loadBalancingType) {
        return this.withLoadBalancingPolicy(loadBalancingType);
    }

    public GrpcClientSettings withConnectionAttempts(int value) {
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)value));
        String string = this.copy$default$1();
        Option<String> option = this.copy$default$2();
        Option<String> option2 = this.copy$default$3();
        int n = this.copy$default$4();
        Option<CallCredentials> option3 = this.copy$default$5();
        Option<String> option4 = this.copy$default$6();
        Option<SslProvider> option5 = this.copy$default$7();
        Option<SSLContext> option6 = this.copy$default$8();
        Option<TrustManager> option7 = this.copy$default$9();
        Duration duration = this.copy$default$10();
        Option<String> option8 = this.copy$default$11();
        boolean bl = this.copy$default$12();
        FiniteDuration finiteDuration = this.copy$default$13();
        Option<String> option9 = this.copy$default$15();
        String string2 = this.copy$default$16();
        Function1<NettyChannelBuilder, NettyChannelBuilder> function1 = this.copy$default$17();
        return this.copy(string, option, option2, n, option3, option4, option5, option6, option7, duration, option8, bl, finiteDuration, (Option<Object>)some, option9, string2, function1);
    }

    @ApiMayChange
    public GrpcClientSettings withChannelBuilderOverrides(Function1<NettyChannelBuilder, NettyChannelBuilder> builderOverrides) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), this.copy$default$16(), builderOverrides);
    }

    @ApiMayChange
    public GrpcClientSettings withBackend(String value) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11(), this.copy$default$12(), this.copy$default$13(), this.copy$default$14(), this.copy$default$15(), value, this.copy$default$17());
    }

    private GrpcClientSettings copy(String serviceName, Option<String> servicePortName, Option<String> serviceProtocol, int defaultPort, Option<CallCredentials> callCredentials, Option<String> overrideAuthority, Option<SslProvider> sslProvider, Option<SSLContext> sslContext, Option<TrustManager> trustManager, Duration deadline, Option<String> userAgent, boolean useTls, FiniteDuration resolveTimeout, Option<Object> connectionAttempts, Option<String> loadBalancingPolicy, String backend, Function1<NettyChannelBuilder, NettyChannelBuilder> channelBuilderOverrides) {
        return new GrpcClientSettings(serviceName, this.serviceDiscovery(), defaultPort, resolveTimeout, servicePortName, serviceProtocol, connectionAttempts, callCredentials, overrideAuthority, sslProvider, sslContext, trustManager, deadline, userAgent, useTls, loadBalancingPolicy, backend, channelBuilderOverrides);
    }

    private String copy$default$1() {
        return this.serviceName();
    }

    private Option<String> copy$default$2() {
        return this.servicePortName();
    }

    private Option<String> copy$default$3() {
        return this.serviceProtocol();
    }

    private int copy$default$4() {
        return this.defaultPort();
    }

    private Option<CallCredentials> copy$default$5() {
        return this.callCredentials();
    }

    private Option<String> copy$default$6() {
        return this.overrideAuthority();
    }

    private Option<SslProvider> copy$default$7() {
        return this.sslProvider();
    }

    private Option<SSLContext> copy$default$8() {
        return this.sslContext();
    }

    private Option<TrustManager> copy$default$9() {
        return this.trustManager();
    }

    private Duration copy$default$10() {
        return this.deadline();
    }

    private Option<String> copy$default$11() {
        return this.userAgent();
    }

    private boolean copy$default$12() {
        return this.useTls();
    }

    private FiniteDuration copy$default$13() {
        return this.resolveTimeout();
    }

    private Option<Object> copy$default$14() {
        return this.connectionAttempts();
    }

    private Option<String> copy$default$15() {
        return this.loadBalancingPolicy();
    }

    private String copy$default$16() {
        return this.backend();
    }

    private Function1<NettyChannelBuilder, NettyChannelBuilder> copy$default$17() {
        return this.channelBuilderOverrides();
    }

    private static final Object $init$$$anonfun$1() {
        return "Configuring the sslContext or the trustManager is mutually exclusive";
    }

    private static final /* synthetic */ boolean $init$$$anonfun$2(SslProvider _$1) {
        SslProvider sslProvider = _$1;
        SslProvider sslProvider2 = SslProvider.JDK;
        return !(sslProvider != null ? !sslProvider.equals(sslProvider2) : sslProvider2 != null);
    }

    private static final Object $init$$$anonfun$3() {
        return "When sslContext is configured, sslProvider must not set to something different than JDK";
    }

    private static final Object $init$$$anonfun$4() {
        return "backend should be 'netty' or 'pekko-http'";
    }

    private final GrpcClientSettings withSslProvider$$anonfun$1() {
        return this;
    }

    private final GrpcClientSettings withSslContext$$anonfun$1() {
        return this;
    }

    private final GrpcClientSettings withTrustManager$$anonfun$1() {
        return this;
    }
}

