/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.ConnectivityState;
import io.grpc.ManagedChannel;
import java.io.Serializable;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.internal.ClientConnectionException;
import org.apache.pekko.grpc.internal.InternalChannel;
import org.apache.pekko.grpc.internal.NettyClientUtils$;
import org.apache.pekko.grpc.internal.PekkoHttpClientUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

@InternalApi
public final class ChannelUtils$
implements Serializable {
    public static final ChannelUtils$ MODULE$ = new ChannelUtils$();

    private ChannelUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ChannelUtils$.class);
    }

    @InternalApi
    public InternalChannel create(GrpcClientSettings settings, LoggingAdapter log, ClassicActorSystemProvider sys) {
        String string = settings.backend();
        if ("netty".equals(string)) {
            return NettyClientUtils$.MODULE$.createChannel(settings, log, (ExecutionContext)sys.classicSystem().dispatcher());
        }
        if ("pekko-http".equals(string)) {
            return PekkoHttpClientUtils$.MODULE$.createChannel(settings, log, sys);
        }
        throw new IllegalArgumentException(new StringBuilder(21).append("Unexpected backend [").append(settings.backend()).append("]").toString());
    }

    @InternalApi
    public Future<Done> close(InternalChannel internalChannel) {
        internalChannel.shutdown();
        return internalChannel.done();
    }

    @InternalApi
    public void monitorChannel(Promise<BoxedUnit> ready, Promise<Done> done, ManagedChannel channel, Option<Object> maxConnectionAttempts, LoggingAdapter log) {
        this.monitor$1(log, maxConnectionAttempts, ready, done, channel, channel.getState(false), 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void monitor$1(LoggingAdapter log$1, Option maxConnectionAttempts$1, Promise ready$1, Promise done$1, ManagedChannel channel$1, ConnectivityState currentState, int connectionAttempts) {
        Some some;
        block8: {
            block12: {
                ConnectivityState connectivityState;
                block13: {
                    ConnectivityState connectivityState2;
                    ConnectivityState connectivityState3;
                    block11: {
                        block10: {
                            block9: {
                                block7: {
                                    log$1.debug(new StringBuilder(46).append("monitoring with state ").append(currentState).append(" and connectionAttempts ").append(connectionAttempts).toString());
                                    connectivityState = currentState;
                                    ConnectivityState connectivityState4 = ConnectivityState.TRANSIENT_FAILURE;
                                    ConnectivityState connectivityState5 = connectivityState;
                                    if (connectivityState4 != null ? !connectivityState4.equals(connectivityState5) : connectivityState5 != null) break block7;
                                    if (maxConnectionAttempts$1.contains((Object)BoxesRunTime.boxToInteger((int)(connectionAttempts + 1)))) {
                                        ClientConnectionException ex = new ClientConnectionException(new StringBuilder(39).append("Unable to establish connection after [").append(maxConnectionAttempts$1).append("]").toString());
                                        boolean bl = ready$1.tryFailure((Throwable)ex) || done$1.tryFailure((Throwable)ex);
                                        some = None$.MODULE$;
                                    } else {
                                        some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(connectionAttempts + 1)));
                                    }
                                    break block8;
                                }
                                ConnectivityState connectivityState6 = ConnectivityState.READY;
                                ConnectivityState connectivityState7 = connectivityState;
                                if (connectivityState6 != null ? !connectivityState6.equals(connectivityState7) : connectivityState7 != null) break block9;
                                ready$1.trySuccess((Object)BoxedUnit.UNIT);
                                some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
                                break block8;
                            }
                            ConnectivityState connectivityState8 = ConnectivityState.SHUTDOWN;
                            ConnectivityState connectivityState9 = connectivityState;
                            if (connectivityState8 != null ? !connectivityState8.equals(connectivityState9) : connectivityState9 != null) break block10;
                            done$1.trySuccess((Object)Done$.MODULE$);
                            some = None$.MODULE$;
                            break block8;
                        }
                        connectivityState3 = ConnectivityState.IDLE;
                        connectivityState2 = connectivityState;
                        if (connectivityState3 != null) break block11;
                        if (connectivityState2 == null) break block12;
                        break block13;
                    }
                    if (connectivityState3.equals(connectivityState2)) break block12;
                }
                ConnectivityState connectivityState10 = ConnectivityState.CONNECTING;
                ConnectivityState connectivityState11 = connectivityState;
                if (connectivityState10 == null) {
                    if (connectivityState11 != null) {
                        throw new MatchError((Object)connectivityState);
                    }
                } else if (!connectivityState10.equals(connectivityState11)) throw new MatchError((Object)connectivityState);
            }
            some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)connectionAttempts));
        }
        Some newAttemptOpt = some;
        newAttemptOpt.foreach((Function1)(JFunction1.mcVI.sp & Serializable)attempts -> channel$1.notifyWhenStateChanged(currentState, () -> this.monitor$1(log$1, maxConnectionAttempts$1, ready$1, done$1, channel$1, channel$1.getState(false), attempts)));
    }
}

