/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.Status;
import io.grpc.StatusException;
import java.io.Serializable;
import org.apache.pekko.NotUsed;
import org.apache.pekko.grpc.GrpcProtocol;
import org.apache.pekko.grpc.GrpcProtocol$DataFrame$;
import org.apache.pekko.grpc.GrpcProtocol$TrailerFrame$;
import org.apache.pekko.grpc.internal.AbstractGrpcProtocol;
import org.apache.pekko.grpc.internal.AbstractGrpcProtocol$;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.http.scaladsl.model.ContentType;
import org.apache.pekko.http.scaladsl.model.HttpEntity;
import org.apache.pekko.http.scaladsl.model.HttpEntity$;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpProtocols$;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.StatusCode;
import org.apache.pekko.http.scaladsl.model.StatusCodes$;
import org.apache.pekko.http.scaladsl.model.Trailer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public abstract class GrpcProtocolWebBase
extends AbstractGrpcProtocol {
    public GrpcProtocolWebBase(String subType) {
        super(subType);
    }

    public abstract ByteString postEncode(ByteString var1);

    public abstract ByteString preDecodeStrict(ByteString var1);

    public abstract Flow<ByteString, ByteString, NotUsed> preDecodeFlow();

    @Override
    public GrpcProtocol.GrpcProtocolWriter writer(Codec codec) {
        return AbstractGrpcProtocol$.MODULE$.writer(this, codec, (Function1<GrpcProtocol.Frame, HttpEntity.ChunkStreamPart>)(Function1 & Serializable)frame -> this.encodeFrame(codec, (GrpcProtocol.Frame)frame), (Function3<ByteString, Seq<HttpHeader>, Trailer, HttpResponse>)(Function3 & Serializable)(data, headers, trailer) -> this.encodeDataToResponse(codec, (ByteString)data, (Seq<HttpHeader>)headers, (Trailer)trailer));
    }

    @Override
    public GrpcProtocol.GrpcProtocolReader reader(Codec codec) {
        return AbstractGrpcProtocol$.MODULE$.reader(codec, (Function2<Object, ByteString, GrpcProtocol.Frame>)(Function2 & Serializable)(frameHeader, data) -> this.reader$$anonfun$1(BoxesRunTime.unboxToInt((Object)frameHeader), (ByteString)data), (Function1<ByteString, ByteString>)(Function1 & Serializable)frame -> this.preDecodeStrict((ByteString)frame), this.preDecodeFlow());
    }

    private HttpEntity.ChunkStreamPart encodeFrame(Codec codec, GrpcProtocol.Frame frame) {
        return HttpEntity.Chunk$.MODULE$.apply(this.postEncode(this.encodeFrameToBytes(codec, frame)), HttpEntity.Chunk$.MODULE$.$lessinit$greater$default$2());
    }

    private HttpResponse encodeDataToResponse(Codec codec, ByteString data, Seq<HttpHeader> headers, Trailer trailer) {
        return HttpResponse$.MODULE$.apply((StatusCode)StatusCodes$.MODULE$.OK(), headers, (ResponseEntity)HttpEntity$.MODULE$.apply((ContentType)this.contentType(), this.encodeDataToFrameBytes(codec, data, trailer)), HttpProtocols$.MODULE$.HTTP$div1$u002E1());
    }

    private ByteString encodeDataToFrameBytes(Codec codec, ByteString data, Trailer trailer) {
        ByteString trailerData = this.encodeTrailerHeaders((Iterator<Tuple2<String, String>>)trailer.headers().iterator());
        ByteString trailerFrame = AbstractGrpcProtocol$.MODULE$.encodeFrameData(codec.compress(trailerData), codec.isCompressed(), true);
        return this.postEncode(this.encodeFrameToBytes(codec, GrpcProtocol$DataFrame$.MODULE$.apply(data)).$plus$plus(trailerFrame));
    }

    private ByteString encodeFrameToBytes(Codec codec, GrpcProtocol.Frame frame) {
        GrpcProtocol.Frame frame2 = frame;
        if (frame2 instanceof GrpcProtocol.DataFrame) {
            ByteString byteString;
            GrpcProtocol.DataFrame dataFrame = GrpcProtocol$DataFrame$.MODULE$.unapply((GrpcProtocol.DataFrame)frame2);
            ByteString data = byteString = dataFrame._1();
            return AbstractGrpcProtocol$.MODULE$.encodeFrameData(codec.compress(data), codec.isCompressed(), false);
        }
        if (frame2 instanceof GrpcProtocol.TrailerFrame) {
            List<HttpHeader> list;
            GrpcProtocol.TrailerFrame trailerFrame = GrpcProtocol$TrailerFrame$.MODULE$.unapply((GrpcProtocol.TrailerFrame)frame2);
            List<HttpHeader> trailer = list = trailerFrame._1();
            return AbstractGrpcProtocol$.MODULE$.encodeFrameData(codec.compress(this.encodeTrailerHeaders((Iterator<Tuple2<String, String>>)trailer.iterator().map((Function1 & Serializable)h -> {
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)h.lowercaseName());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)h.value());
            }))), codec.isCompressed(), true);
        }
        throw new MatchError((Object)frame2);
    }

    private final GrpcProtocol.Frame decodeFrame(int frameHeader, ByteString data) {
        Product product;
        int n = frameHeader & 0x50;
        if (0 == n) {
            product = GrpcProtocol$DataFrame$.MODULE$.apply(data);
        } else if (1 == n) {
            product = GrpcProtocol$TrailerFrame$.MODULE$.apply(this.decodeTrailer(data));
        } else {
            int f = n;
            throw new StatusException(Status.INTERNAL.withDescription(new StringBuilder(21).append("Unknown frame type [").append(f).append("]").toString()));
        }
        return product;
    }

    private final ByteString encodeTrailerHeaders(Iterator<Tuple2<String, String>> trailerHeaders) {
        ByteStringBuilder builder = new ByteStringBuilder();
        while (trailerHeaders.hasNext()) {
            Tuple2 tuple2 = (Tuple2)trailerHeaders.next();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String header = (String)tuple2._1();
            String value = (String)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)header, (Object)value);
            String header2 = (String)tuple22._1();
            String value2 = (String)tuple22._2();
            builder.append(ByteString$.MODULE$.apply(header2.toLowerCase())).putByte((byte)58).append(ByteString$.MODULE$.apply(value2)).putByte((byte)13).putByte((byte)10);
        }
        return builder.result();
    }

    private final List<HttpHeader> decodeTrailer(ByteString data) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private final /* synthetic */ GrpcProtocol.Frame reader$$anonfun$1(int frameHeader, ByteString data) {
        return this.decodeFrame(frameHeader, data);
    }
}

