/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.pekko.grpc.internal.ByteStringInputStream$;
import org.apache.pekko.grpc.internal.Codec;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.runtime.ModuleSerializationProxy;

public final class Gzip$
extends Codec
implements Serializable {
    private static final String name;
    public static final Gzip$ MODULE$;

    private Gzip$() {
    }

    static {
        MODULE$ = new Gzip$();
        name = "gzip";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Gzip$.class);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public ByteString compress(ByteString uncompressed) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(uncompressed.size());
        try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
            gzos.write(uncompressed.toArrayUnsafe());
        }
        return ByteString$.MODULE$.fromArrayUnsafe(baos.toByteArray());
    }

    @Override
    public ByteString uncompress(ByteString compressed) {
        GZIPInputStream gzis = new GZIPInputStream(ByteStringInputStream$.MODULE$.apply(compressed));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(compressed.size());
        byte[] buffer = new byte[32768];
        try {
            int read = gzis.read(buffer);
            while (read != -1) {
                baos.write(buffer, 0, read);
                read = gzis.read(buffer);
            }
        }
        finally {
            gzis.close();
        }
        return ByteString$.MODULE$.fromArrayUnsafe(baos.toByteArray());
    }

    @Override
    public ByteString uncompress(boolean compressedBitSet, ByteString bytes) {
        if (compressedBitSet) {
            return this.uncompress(bytes);
        }
        return bytes;
    }
}

