/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.Status;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.pekko.discovery.Lookup$;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.grpc.GrpcClientSettings;
import org.apache.pekko.grpc.internal.PekkoDiscoveryNameResolver$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class PekkoDiscoveryNameResolver
extends NameResolver {
    private final ServiceDiscovery discovery;
    private final int defaultPort;
    private final String serviceName;
    private final Option<String> portName;
    private final Option<String> protocol;
    private final FiniteDuration resolveTimeout;
    private final ExecutionContext ec;
    private final Promise listener;

    public static PekkoDiscoveryNameResolver apply(GrpcClientSettings grpcClientSettings, ExecutionContext executionContext) {
        return PekkoDiscoveryNameResolver$.MODULE$.apply(grpcClientSettings, executionContext);
    }

    public PekkoDiscoveryNameResolver(ServiceDiscovery discovery, int defaultPort, String serviceName, Option<String> portName, Option<String> protocol, FiniteDuration resolveTimeout, ExecutionContext ec) {
        this.discovery = discovery;
        this.defaultPort = defaultPort;
        this.serviceName = serviceName;
        this.portName = portName;
        this.protocol = protocol;
        this.resolveTimeout = resolveTimeout;
        this.ec = ec;
        this.listener = Promise$.MODULE$.apply();
    }

    public ExecutionContext ec() {
        return this.ec;
    }

    public String getServiceAuthority() {
        return this.serviceName;
    }

    public Promise<NameResolver.Listener> listener() {
        return this.listener;
    }

    public void start(NameResolver.Listener l) {
        this.listener().trySuccess((Object)l);
        this.lookup(l);
    }

    public void refresh() {
        this.listener().future().onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                NameResolver.Listener l = (NameResolver.Listener)((Success)try_).value();
                this.lookup(l);
                return;
            }
            if (try_ instanceof Failure) {
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
    }

    public void lookup(NameResolver.Listener listener) {
        this.discovery.lookup(Lookup$.MODULE$.apply(this.serviceName, this.portName, this.protocol), this.resolveTimeout).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                ServiceDiscovery.Resolved result = (ServiceDiscovery.Resolved)((Success)try_).value();
                try {
                    listener.onAddresses(this.addresses((scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget>)result.addresses()), Attributes.EMPTY);
                }
                catch (UnknownHostException e) {
                    listener.onError(Status.UNKNOWN.withDescription(e.getMessage()));
                }
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                listener.onError(Status.UNKNOWN.withDescription(e.getMessage()));
                return;
            }
            throw new MatchError((Object)try_);
        }, this.ec());
    }

    private List<EquivalentAddressGroup> addresses(scala.collection.immutable.Seq<ServiceDiscovery.ResolvedTarget> addresses) throws UnknownHostException {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)addresses.map((Function1 & Serializable)target -> {
            int port = BoxesRunTime.unboxToInt((Object)target.port().getOrElse(this::$anonfun$1));
            InetAddress address = (InetAddress)target.address().getOrElse(() -> PekkoDiscoveryNameResolver.$anonfun$2(target));
            return new EquivalentAddressGroup((SocketAddress)new InetSocketAddress(address, port));
        })).asJava();
    }

    public void shutdown() {
    }

    private final int $anonfun$1() {
        return this.defaultPort;
    }

    private static final InetAddress $anonfun$2(ServiceDiscovery.ResolvedTarget target$1) {
        return InetAddress.getByName(target$1.host());
    }
}

