/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.grpc.internal;

import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import java.net.URI;
import org.apache.pekko.discovery.ServiceDiscovery;
import org.apache.pekko.grpc.internal.PekkoDiscoveryNameResolver;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class PekkoDiscoveryNameResolverProvider
extends NameResolverProvider {
    private final ServiceDiscovery discovery;
    private final int defaultPort;
    private final String serviceName;
    private final Option<String> portName;
    private final Option<String> protocol;
    private final FiniteDuration resolveTimeout;
    private final ExecutionContext ec;

    public PekkoDiscoveryNameResolverProvider(ServiceDiscovery discovery, int defaultPort, String serviceName, Option<String> portName, Option<String> protocol, FiniteDuration resolveTimeout, ExecutionContext ec) {
        this.discovery = discovery;
        this.defaultPort = defaultPort;
        this.serviceName = serviceName;
        this.portName = portName;
        this.protocol = protocol;
        this.resolveTimeout = resolveTimeout;
        this.ec = ec;
    }

    public boolean isAvailable() {
        return true;
    }

    public int priority() {
        return 5;
    }

    public String getDefaultScheme() {
        return "http";
    }

    public PekkoDiscoveryNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        return new PekkoDiscoveryNameResolver(this.discovery, this.defaultPort, this.serviceName, this.portName, this.protocol, this.resolveTimeout, this.ec);
    }
}

